/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import org.apache.commons.lang.StringUtils;

public class MfgCostcenterAllocRptPlugin
extends AbstractReportFormPlugin {
    private static final String[] clearFileName = new String[]{"org", "account", "costdriver", "period", "manuorg", "costcenter", "costcentername", "expenseitem", "expenseitemnumber"};

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String appId = this.getView().getFormShowParameter().getAppId();
        filterInfo.addFilterItem("appnum", (Object)appId, "=");
        queryParam.setFilter(filterInfo);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map customParamMap = queryParam.getCustomParam();
        if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            customParamMap.put("isplandata", "true");
        } else {
            customParamMap.put("isplandata", "false");
        }
    }

    public void setExcelName(List<String> list) {
        super.setExcelName(list);
        String newName = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5206\u914d\u8868\uff08\u8ba1\u5212\uff09", (String)"MfgCostcenterAllocRptPlugin_15", (String)"macc-cad-report", (Object[])new Object[0]);
        list.add(newName);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountOrgBase = (BasedataEdit)this.getControl("accountorg");
        accountOrgBase.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
            filters.add(orgIdsFilter);
        });
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgCostcenterAllocRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEnableQfilterByOrg((Long)Long.valueOf(accountorg.getPkValue().toString()), null, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("pmanuorg");
        manuorg.addBeforeF7SelectListener(evt -> {
            List productOrgs;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgCostcenterAllocRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ArrayList orgIdList = new ArrayList();
            List useProOrg = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList((Long)accountorg.getPkValue()), (String)"04");
            if (!CollectionUtils.isEmpty((Collection)useProOrg)) {
                orgIdList.addAll(useProOrg);
            }
            if (!CollectionUtils.isEmpty((Collection)(productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)((Long)accountorg.getPkValue()), (boolean)false)))) {
                orgIdList.addAll(productOrgs);
            }
            qFilters.add(new QFilter("id", "in", orgIdList));
            qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
        });
        BasedataEdit beginperiod = (BasedataEdit)this.getControl("beginperiod");
        this.getaVoid(beginperiod);
        BasedataEdit endperiod = (BasedataEdit)this.getControl("endperiod");
        this.getaVoid(endperiod);
        BasedataEdit costCenter = (BasedataEdit)this.getControl("pcostcenter");
        costCenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgCostcenterAllocRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("pmanuorg");
            List manuOrgList = dynamicObjects.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
            QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
            qFilters.add(costCenterIdFilter);
            String allocMold = this.getModel().getDataEntity().getString("allocmold");
            if (CadEmptyUtils.isEmpty((String)allocMold)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u914d\u7c7b\u578b\u3002", (String)"MfgCostcenterAllocRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = this.getCostCenterFilter(allocMold);
            qFilters.add(qFilter);
        });
        DynamicObjectCollection costCenterType = this.getModel().getDataEntity().getDynamicObjectCollection("costcentertype");
        ArrayList<Long> costCenterTypes = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : costCenterType) {
            costCenterTypes.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
        }
        BasedataEdit syCostCenter = (BasedataEdit)this.getControl("sycostcenter");
        syCostCenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountOrg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgCostcenterAllocRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("accountorg", "=", (Object)accountOrg.getLong("id")));
            if (!costCenterTypes.isEmpty()) {
                qFilters.add(new QFilter("orgduty", "in", (Object)costCenterTypes));
            }
        });
        BasedataEdit planscheme = (BasedataEdit)this.getControl("planscheme");
        planscheme.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject costAccountDyn = (DynamicObject)this.getModel().getValue("costaccount");
            if (costAccountDyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgCostcenterAllocRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("costaccount", "=", (Object)costAccountDyn.getLong("id")));
        });
    }

    public void afterBindData(EventObject e) {
        Map customParams;
        Long accountorg;
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("accountorg");
        Long l = accountorg = org == null ? null : (Long)org.getPkValue();
        if (accountorg == null) {
            accountorg = RequestContext.get().getOrgId();
            if (!this.getHasPermAccountOrg(accountorg)) {
                return;
            }
            if (OrgUnitServiceHelper.checkOrgFunction((Long)accountorg, (String)"10")) {
                this.getModel().setValue("accountorg", (Object)accountorg);
                this.getView().updateView("accountorg");
            }
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()) != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"planscheme"});
            BasedataEdit planscheme = (BasedataEdit)this.getView().getControl("planscheme");
            planscheme.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"planscheme"});
        }
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount == null) {
            this.changeAccountOrg(accountorg);
        } else {
            boolean isMulFactory = CostAccountHelper.isEnableMulFactory((Long)((Long)costaccount.getPkValue()));
            this.getView().setVisible(Boolean.valueOf(isMulFactory), new String[]{"pmanuorg"});
        }
        this.setCostCenterVisible();
        this.setAllocMold();
    }

    private void setAllocMold() {
        Map customParams;
        ComboEdit allocMold = (ComboEdit)this.getControl("allocmold");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(5);
        if ("eca".equals(this.getView().getFormShowParameter().getAppId())) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d", (String)"MfgCostcenterAllocRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0])));
            item.setValue("A");
            comboItems.add(item);
            ComboItem item1 = new ComboItem();
            item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d", (String)"MfgCostcenterAllocRptPlugin_8", (String)"macc-cad-report", (Object[])new Object[0])));
            item1.setValue("C");
            comboItems.add(item1);
            ComboItem item2 = new ComboItem();
            item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d", (String)"MfgCostcenterAllocRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0])));
            item2.setValue("D");
            comboItems.add(item2);
            allocMold.setComboItems(comboItems);
        } else if ("sca".equals(this.getView().getFormShowParameter().getAppId()) && (customParams = this.getView().getFormShowParameter().getCustomParams()) != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            ComboItem item_A = new ComboItem();
            item_A.setCaption(new LocaleString(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d", (String)"MfgCostcenterAllocRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0])));
            item_A.setValue("A");
            comboItems.add(item_A);
            ComboItem item_B = new ComboItem();
            item_B.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d", (String)"MfgCostcenterAllocRptPlugin_12", (String)"macc-cad-report", (Object[])new Object[0])));
            item_B.setValue("B");
            comboItems.add(item_B);
            ComboItem item_C = new ComboItem();
            item_C.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d", (String)"MfgCostcenterAllocRptPlugin_8", (String)"macc-cad-report", (Object[])new Object[0])));
            item_C.setValue("C");
            comboItems.add(item_C);
            allocMold.setComboItems(comboItems);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "costaccount": {
                this.changeCostaccout((DynamicObject)newValue);
                break;
            }
            case "accountorg": {
                Long accountorgId = newValue == null ? null : (Long)((DynamicObject)newValue).getPkValue();
                this.changeAccountOrg(accountorgId);
                break;
            }
            case "beginperiod": {
                break;
            }
            case "endperiod": {
                break;
            }
            case "allocmold": {
                this.changeAllocMethod();
                break;
            }
            case "costcentersum": {
                if (!"true".equals(newValue.toString())) break;
                this.getModel().setValue("showbenefcostcenter", (Object)Boolean.FALSE);
                break;
            }
            case "showbenefcostcenter": {
                if ("true".equals(newValue.toString())) {
                    this.getModel().setValue("costcentersum", (Object)Boolean.FALSE);
                }
                this.setCostCenterVisible();
                break;
            }
            case "planscheme": {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (customParams == null || customParams.get("isplandata") == null || !"true".equals(customParams.get("isplandata").toString())) break;
                this.setPeriod();
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        String tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7", (String)"MfgCostcenterAllocRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("accountorg", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgCostcenterAllocRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("costaccount", tips)) {
            return false;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString()) && this.checkFileNameisNull("planscheme", tips = ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u65b9\u6848\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgCostcenterAllocRptPlugin_13", (String)"macc-cad-report", (Object[])new Object[0]))) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u201c\u6838\u7b97\u671f\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgCostcenterAllocRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("beginperiod", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5206\u914d\u7c7b\u578b", (String)"MfgCostcenterAllocRptPlugin_11", (String)"macc-cad-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("allocmold", tips)) {
            return false;
        }
        if (this.getModel().getValue("currency") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5e01\u79cd\u201d\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6210\u672c\u8d26\u7c3f\u662f\u5426\u5173\u8054\u5e01\u79cd\u3002", (String)"MfgCostcenterAllocRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject beginperiod = (DynamicObject)this.getModel().getValue("beginperiod");
        DynamicObject endperiod = (DynamicObject)this.getModel().getValue("endperiod");
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("entityId", (Object)this.getBillEntityId());
        return this.changePeriod(beginperiod, endperiod);
    }

    private boolean checkFileNameisNull(String fileName, String tips) {
        if (this.getModel().getValue(fileName) == null) {
            this.getView().showTipNotification(tips);
            return true;
        }
        return false;
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        DynamicObject org;
        DataSet ds;
        DataSet dataSet;
        boolean flag;
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        String appId = this.getView().getFormShowParameter().getAppId();
        Boolean sumByPeriod = this.getModel().getDataEntity().getBoolean("periodmerge");
        Boolean showbenefcostcenter = this.getModel().getDataEntity().getBoolean("showbenefcostcenter");
        Boolean costcentersum = this.getModel().getDataEntity().getBoolean("costcentersum");
        Boolean onlyUnDivide = this.getModel().getDataEntity().getBoolean("onlyundivide");
        DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        Boolean isMulFactory = CostAccountHelper.isEnableMulFactory(costaccount == null ? null : (Long)costaccount.getPkValue());
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        ArrayList<String> hiddenField = new ArrayList<String>(16);
        if (sumByPeriod.booleanValue()) {
            hiddenField.add("period");
        }
        if (!isMulFactory.booleanValue()) {
            hiddenField.add("manuorg");
            hiddenField.add("manuorgname");
        }
        if (!showbenefcostcenter.booleanValue()) {
            hiddenField.add("benefcostcenter");
            hiddenField.add("benefcostcentername");
            hiddenField.add("benefcostcenterduty");
        }
        if (!allocMold.contains("D")) {
            hiddenField.add("unabsorbeddiff");
            hiddenField.add("element");
            hiddenField.add("elementname");
            hiddenField.add("subelement");
            hiddenField.add("subelementname");
        } else if (!onlyUnDivide.booleanValue() && (flag = this.costCostExist()) && (dataSet = (ds = this.getCostCenterAllocHide()).copy().filter("allocstatus<>'2'")).isEmpty()) {
            hiddenField.add("unabsorbeddiff");
        }
        if (costcentersum.booleanValue()) {
            hiddenField.add("expenseitemnumber");
            hiddenField.add("expenseitem");
            hiddenField.add("targetexpenseitem");
            hiddenField.add("targetexpenseitemname");
            hiddenField.add("costdriver");
            hiddenField.add("qty");
            hiddenField.add("element");
            hiddenField.add("elementname");
            hiddenField.add("subelement");
            hiddenField.add("subelementname");
        }
        if (!"sca".equals(appId)) {
            hiddenField.add("unabsorbeddiff");
        }
        Long orgId = (org = this.getModel().getDataEntity().getDynamicObject("accountorg")) == null ? 0L : org.getLong("id");
        Long costAccountId = costaccount == null ? 0L : costaccount.getLong("id");
        boolean isMergeBill = SysParamHelper.isMergeBill((Long)orgId, (Long)costAccountId, (String)appId);
        if (allocMold.contains("D") && allocMold.length() == 3) {
            boolean showTargetExpense;
            boolean bl = showTargetExpense = !"sca".equals(appId) && !isMergeBill;
            if (!showTargetExpense) {
                hiddenField.add("targetexpenseitem");
                hiddenField.add("targetexpenseitemname");
            } else {
                hiddenField.add("element");
                hiddenField.add("elementname");
                hiddenField.add("subelement");
                hiddenField.add("subelementname");
            }
        }
        if ("aca".equals(appId) && !isMergeBill) {
            hiddenField.add("element");
            hiddenField.add("elementname");
            hiddenField.add("subelement");
            hiddenField.add("subelementname");
        }
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn column = (ReportColumn)obj;
                String key = column.getFieldKey();
                if (!hiddenField.contains(key)) continue;
                column.setHide(true);
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            List reportColumns = ((ReportColumnGroup)obj).getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                ReportColumn reportcolumn;
                String key;
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn) || !hiddenField.contains(key = (reportcolumn = (ReportColumn)column).getFieldKey())) continue;
                reportcolumn.setHide(true);
            }
        }
    }

    private boolean costCostExist() {
        DynamicObject beginPeriod = this.getModel().getDataEntity().getDynamicObject("beginperiod");
        QFilter filter = new QFilter("org", "=", (Object)this.getModel().getDataEntity().getLong("accountorg.id"));
        filter.and(new QFilter("costaccount", "=", (Object)this.getModel().getDataEntity().getLong("costaccount.id")));
        filter.and(new QFilter("period", "in", (Object)beginPeriod.getLong("id")));
        return QueryServiceHelper.exists((String)"cad_mfgfeeallocco", (QFilter[])new QFilter[]{filter});
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Boolean mergesame = (Boolean)this.getModel().getValue("mergesame");
        if (mergesame.booleanValue()) {
            ReportUtils.clearFileNameValue((String[])clearFileName, (DynamicObjectCollection)rowData, (String[])clearFileName);
        }
    }

    private void getaVoid(BasedataEdit beginperiod) {
        beginperiod.addBeforeF7SelectListener(evt -> {
            QFilter usePeriodFilter;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("accountorg");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgCostcenterAllocRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgCostcenterAllocRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
                DynamicObject planScheme = this.getModel().getDataEntity().getDynamicObject("planscheme");
                if (planScheme == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"MfgCostcenterAllocRptPlugin_14", (String)"macc-cad-report", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List ids = PlanFeeAllocHelper.getPlanStartAllPeriods((Long)planScheme.getLong("id"));
                usePeriodFilter = new QFilter("id", "in", (Object)ids);
            } else {
                usePeriodFilter = StartCostHelper.getUsePeriodFilter((Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue())));
            }
            qFilters.add(usePeriodFilter);
        });
    }

    private void changeAccountOrg(Long accountorg) {
        if (accountorg != null) {
            Long costaccountId = this.getCostAccountByAccoutOrg(accountorg);
            this.getModel().setValue("costaccount", (Object)(costaccountId == null ? null : costaccountId));
            this.changeCostaccout(costaccountId);
            this.getModel().setValue("pcostcenter", null);
            this.getModel().setValue("pmanuorg", null);
            this.getView().updateView("costaccount");
        } else {
            this.getModel().setValue("pcostcenter", null);
            this.getModel().setValue("pmanuorg", null);
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("currency", null);
        }
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter[] filters;
        DynamicObjectCollection result;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        if ((result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])(filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF = new QFilter("appnum", "=", (Object)appId)}), null)) == null || result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return null;
    }

    private Boolean changePeriod(DynamicObject beginperiod, DynamicObject endperiod) {
        if (beginperiod != null && endperiod != null && !beginperiod.getPkValue().equals(endperiod.getPkValue())) {
            Date begindate = beginperiod.getDate("begindate");
            Date enddate = beginperiod.getDate("enddate");
            Date begindatelate = endperiod.getDate("begindate");
            Date enddatelate = endperiod.getDate("enddate");
            if (begindate == null || begindatelate == null || enddate == null || enddatelate == null || begindate.compareTo(begindatelate) > 0 || enddate.compareTo(enddatelate) > 0) {
                this.getModel().setValue("endperiod", beginperiod.getPkValue());
                this.getView().updateView("endperiod");
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private void changeCostaccout(Long costaccountId) {
        if (costaccountId == null || costaccountId == 0L) {
            costaccountId = null;
        }
        this.setPlanScheme();
        this.setCurrency();
        this.setPeriod();
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory((Long)costaccountId);
        this.getView().setVisible(Boolean.valueOf(isMulFactory), new String[]{"pmanuorg"});
    }

    private void setPlanScheme() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
            if (costaccount == null) {
                this.getModel().setValue("planscheme", null);
                return;
            }
            List planSchemeIds = PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costaccount.getLong("id"));
            if (!CadEmptyUtils.isEmpty((List)planSchemeIds)) {
                this.getModel().setValue("planscheme", planSchemeIds.get(0));
                this.getView().updateView("planscheme");
            }
        }
    }

    private void changeCostaccout(DynamicObject costaccount) {
        Long costaccountId = costaccount == null ? Long.valueOf(0L) : (Long)costaccount.getPkValue();
        this.changeCostaccout(costaccountId);
    }

    private void changeAllocMethod() {
        this.getModel().setValue("pcostcenter", null);
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (allocMold != null) {
            boolean innerCenter;
            boolean nonProdMold = allocMold.length() == 3 && allocMold.contains("A");
            this.getView().setVisible(Boolean.valueOf(!nonProdMold), new String[]{"carrymtd"});
            ComboEdit carryMtdEdit = (ComboEdit)this.getControl("carrymtd");
            carryMtdEdit.setMustInput(!nonProdMold);
            if (nonProdMold) {
                this.getModel().setValue("carrymtd", null);
            } else if (StringUtils.isEmpty((String)this.getModel().getDataEntity().getString("carrymtd"))) {
                this.getModel().setValue("carrymtd", (Object)"A");
            }
            boolean bl = innerCenter = allocMold.length() == 3 && allocMold.contains("D");
            if (innerCenter) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"showbenefcostcenter"});
                this.getModel().setValue("showbenefcostcenter", (Object)false);
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showbenefcostcenter"});
            }
        }
    }

    protected void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("accountorg");
        if (org == null) {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("beginperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get("isplandata") != null && "true".equals(customParams.get("isplandata").toString())) {
            List periodIds;
            DynamicObject planScheme = dataEntity.getDynamicObject("planscheme");
            if (planScheme == null) {
                this.getModel().setValue("beginperiod", null);
                this.getModel().setValue("endperiod", null);
                return;
            }
            Long schemeId = 0L;
            if (planScheme != null) {
                schemeId = planScheme.getLong("id");
            }
            if (!CadEmptyUtils.isEmpty((List)(periodIds = PlanFeeAllocHelper.getPlanLastEnablePeriods((Long)schemeId)))) {
                this.getModel().setValue("beginperiod", periodIds.get(0));
                this.getModel().setValue("endperiod", periodIds.get(0));
                this.getView().updateView("beginperiod");
                this.getView().updateView("endperiod");
            }
        } else {
            QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
            QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
            DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
            if (res != null) {
                Long currentperiod = res.getLong("currentperiod");
                this.getModel().setValue("beginperiod", (Object)currentperiod);
                this.getModel().setValue("endperiod", (Object)currentperiod);
                this.getView().updateView("beginperiod");
                this.getView().updateView("endperiod");
            }
        }
    }

    private boolean getHasPermAccountOrg(Long orgId) {
        String entityid = this.getView().getEntityId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getView().getFormShowParameter().getAppId(), (String)entityid, (String)"47150e89000000ac");
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        return rs.getHasPermOrgs().contains(orgId);
    }

    private void setCostCenterVisible() {
        this.getModel().setValue("sycostcenter", null);
        this.getModel().setValue("costcentertype", null);
        boolean showBeneCostCenter = this.getModel().getDataEntity().getBoolean("showbenefcostcenter");
        this.getView().setVisible(Boolean.valueOf(showBeneCostCenter), new String[]{"sycostcenter"});
        this.getView().setVisible(Boolean.valueOf(showBeneCostCenter), new String[]{"costcentertype"});
    }

    private DataSet getCostCenterAllocHide() {
        boolean onlyUnDivide;
        DynamicObject beginPeriod = this.getModel().getDataEntity().getDynamicObject("beginperiod");
        DynamicObject endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod");
        List start2EndAllPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)beginPeriod, (DynamicObject)endPeriod);
        QFilter filter = new QFilter("org", "=", (Object)this.getModel().getDataEntity().getLong("accountorg.id"));
        filter.and(new QFilter("costaccount", "=", (Object)this.getModel().getDataEntity().getLong("costaccount.id")));
        filter.and(new QFilter("period", "in", (Object)start2EndAllPeriodIds));
        DynamicObjectCollection costCenter = this.getModel().getDataEntity().getDynamicObjectCollection("pcostcenter");
        ArrayList<Long> centerIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : costCenter) {
            centerIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
        }
        if (!centerIds.isEmpty()) {
            filter.and(new QFilter("benefcostcenter", "in", centerIds));
        }
        DynamicObjectCollection expenseItem = this.getModel().getDataEntity().getDynamicObjectCollection("pexpenseitem");
        ArrayList<Long> expenseItemIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : expenseItem) {
            expenseItemIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
        }
        if (!expenseItemIds.isEmpty()) {
            filter.and(new QFilter("srcexpentry.expenseitem", "in", expenseItemIds));
        }
        if (onlyUnDivide = this.getModel().getDataEntity().getBoolean("onlyundivide")) {
            filter.and(new QFilter("allocstatus", "=", (Object)"0"));
        }
        return QueryServiceHelper.queryDataSet((String)"getCostCenterAllocHide", (String)"cad_mfgfeeallocco", (String)"id,allocstatus", (QFilter[])new QFilter[]{filter}, null);
    }

    private QFilter getCostCenterFilter(String allocMold) {
        allocMold = allocMold.substring(1, allocMold.length() - 1);
        HashSet<Integer> orgDutySet = new HashSet<Integer>(16);
        for (String key : allocMold.split(",")) {
            if ("A".equals(key)) {
                orgDutySet.addAll(Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 6}));
                continue;
            }
            if ("B".equals(key)) {
                orgDutySet.add(5);
                continue;
            }
            orgDutySet.add(4);
        }
        QFilter filter = new QFilter("orgduty", "in", orgDutySet);
        return filter;
    }
}

