/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class MfgFeeBillLogarithmPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private long lastRowAccountId = 0L;

    protected String[] getAssistValueType() {
        return new String[]{"1", "2"};
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType type;
        super.getEntityType(e);
        try {
            MainEntityType t = e.getOriginalEntityType();
            type = (MainEntityType)t.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException(ex.getMessage());
        }
        EntryProp entry = (EntryProp)type.getProperty("entryentity");
        MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty("value");
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject assisType = (DynamicObject)model.getValue("fieldname", rowIndex);
        if (assisType == null) {
            return;
        }
        DynamicObject valueSource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("valuesource");
            entityId = valueSource.getString("id");
        } else if ("2".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("assistanttype");
            entityId = "bos_assistantdata_detail";
        }
        if (valueSource != null) {
            prop.setBaseEntityId(entityId);
            IDataEntityType entryType = prop.getItemType();
            BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            baseProp.setBaseEntityId(entityId);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            baseProp.setComplexType((IDataEntityType)dataEntityType);
            LongProp longProp = (LongProp)prop.getItemType().getProperties().get((Object)"fbasedataid_id");
            entryType.getProperties().remove((Object)longProp);
            if (!(dataEntityType.getPrimaryKey() instanceof VarcharProp)) {
                longProp = new LongProp();
            }
            longProp.setPrimaryKey(false);
            longProp.setName("fbasedataid_id");
            baseProp.setRefIdProp((IDataEntityProperty)longProp);
            entryType.getProperties().add((Object)longProp);
        }
        e.setNewEntityType(type);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(qfId);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeBillLogarithmPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getEnableQfilterByOrg((Long)Long.valueOf(org.getPkValue().toString()), null, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit mulperiod = (BasedataEdit)this.getControl("mulperiod");
        mulperiod.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeBillLogarithmPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccountObject = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgFeeBillLogarithmPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccountObject.getPkValue()))));
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeBillLogarithmPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long orgId = org.getLong("id");
            DynamicObject costAccountObject = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgFeeBillLogarithmPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter atF = new QFilter("accounttable", "=", (Object)this.getAccountAbles());
            atF.and("enddate", ">=", (Object)DateUtils.getDayStartTime((Date)DateUtils.getDeFaultExpDate()));
            List qFilters = filterParameter.getQFilters();
            qFilters.add(atF);
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        });
        this.addClickListeners(new String[]{"entryentity", "value"});
        this.addItemClickListeners(new String[]{"asstopr"});
        BasedataEdit ass = (BasedataEdit)this.getControl("value");
        ass.addBeforeF7SelectListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dyn = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            DynamicObject assisType = dyn.getDynamicObject("fieldname");
            if (assisType == null) {
                evt.setCancel(true);
                return;
            }
            String valuetype = assisType.getString("valuetype");
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            String entityName = null;
            if ("1".equals(valuetype)) {
                entityName = assisType.getDynamicObject("valuesource").getString("number");
            } else if ("2".equals(valuetype)) {
                entityName = "bos_assistantdata_detail";
                DynamicObject valueSource = assisType.getDynamicObject("assistanttype");
                String number = valueSource.getString("number");
                qFilters.add(new QFilter("group.number", "=", (Object)number));
            }
            if (entityName != null) {
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)Long.valueOf(String.valueOf(org.getPkValue())));
                if (orgFilter != null) {
                    qFilters.add(orgFilter);
                }
                filterParam.setQFilters(qFilters);
            }
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                ReportList rptList = (ReportList)e.getSource();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                String fieldName = e.getFieldName();
                String formId = "cad_mfgfeebill";
                String billnos = "";
                if ("billno".equals(fieldName)) {
                    billnos = row.getString(fieldName);
                    if (CadEmptyUtils.isEmpty((String)billnos)) {
                        return;
                    }
                    QFilter allocbillnoQF = new QFilter("billno", "in", (Object)billnos.split(","));
                    DynamicObjectCollection allocbill = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])new QFilter[]{allocbillnoQF});
                    if (allocbill.isEmpty()) {
                        return;
                    }
                    for (DynamicObject obj : allocbill) {
                        BaseShowParameter bsp = new BaseShowParameter();
                        bsp.setFormId(formId);
                        bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        bsp.setPkId((Object)obj.getLong("id"));
                        bsp.setBillStatusValue(Integer.valueOf(BillOperationStatus.VIEW.getValue()));
                        rptList.getView().showForm((FormShowParameter)bsp);
                    }
                } else if ("expenseitem".equals(fieldName)) {
                    long orgId = row.getLong("accountorg.id");
                    long costAccountId = row.getLong("costaccountfield.id");
                    long periodId = row.getLong("period.id");
                    long costCenterId = row.getLong("costcenter.id");
                    long expenseItemId = row.getLong("expenseitem.id");
                    long accountId = row.getLong("accountnumber.id");
                    QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                    qFilter.and("costaccount", "=", (Object)costAccountId);
                    qFilter.and("period", "=", (Object)periodId);
                    qFilter.and("costcenter", "=", (Object)costCenterId);
                    qFilter.and("expenseitem", "=", (Object)expenseItemId);
                    qFilter.and("account", "=", (Object)accountId);
                    List mfgBillIds = QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])qFilter.toArray(), null, (int)-1);
                    ListShowParameter showParameter = new ListShowParameter();
                    showParameter.setBillFormId(formId);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setShowFilter(false);
                    showParameter.setShowQuickFilter(false);
                    if (!CadEmptyUtils.isEmpty((List)mfgBillIds)) {
                        for (Object billId : mfgBillIds) {
                            showParameter.addLinkQueryPkId((Object)Long.parseLong(String.valueOf(billId)));
                        }
                    }
                    MfgFeeBillLogarithmPlugin.this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        if (evt.getRowData() != null && evt.getRowData().containsProperty("accountnumber")) {
            long account = evt.getRowData().getLong("accountnumber.id");
            long periodId = evt.getRowData().getLong("period.id");
            String fieldKey = ((ReportColumn)evt.getSource()).getFieldKey();
            if (CadEmptyUtils.isEmpty((Long)periodId) && ("accountnumber".equals(fieldKey) || "accountname".equals(fieldKey) || "biztotalamount".equals(fieldKey) || "diffamount".equals(fieldKey))) {
                evt.getNoMergeKey().add(((ReportColumn)evt.getSource()).getFieldKey());
            } else if ("diffamount".equals(fieldKey) || "biztotalamount".equals(fieldKey)) {
                if (this.lastRowAccountId != 0L && this.lastRowAccountId != account) {
                    evt.getNoMergeKey().add(((ReportColumn)evt.getSource()).getFieldKey());
                }
                this.lastRowAccountId = account;
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject rowDatum : rowData) {
            String periodName = rowDatum.getString("periodname");
            if ("0".equals(periodName)) {
                periodName = rowDatum.getString("period.name");
            } else if ("1".equals(periodName)) {
                periodName = ResManager.loadKDString((String)"\u79d1\u76ee\u5c0f\u8ba1", (String)"MfgFeeBillLogarithmPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]);
            } else if ("2".equals(periodName)) {
                periodName = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"MfgFeeBillLogarithmPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]);
            }
            rowDatum.set("periodname", (Object)periodName);
        }
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        super.preProcessExportData(exportColumns, data, numberFormatProvider);
        if (!data.isEmpty()) {
            ReportUtils.clearFileNameValue((String[])new String[]{"accountnumber", "periodname", "biztotalamount", "diffamount"}, (DynamicObjectCollection)data, (String[])new String[]{"biztotalamount", "diffamount"});
        }
    }

    public void setMergeColums(List<String> columns) {
        columns.add("accountnumber");
        columns.add("accountname");
        columns.add("biztotalamount");
        columns.add("diffamount");
        super.setMergeColums(columns);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrg();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
        }
        this.setMulPeriod();
        this.setCurrency();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"mulcostcenter", "mulexpenseitem"});
        if ("eca".equals(this.getView().getFormShowParameter().getAppId())) {
            MulComboEdit srcsys = (MulComboEdit)this.getControl("srcsys");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u603b\u8d26", (String)"MfgFeeBillLogarithmPlugin_8", (String)"macc-cad-report", (Object[])new Object[0])));
            comboItem.setValue("A");
            comboItems.add(comboItem);
            srcsys.setComboItems(comboItems);
        }
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        Long mainBookId = CostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setMulPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            this.getModel().setValue("mulperiod", null);
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("mulperiod", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("mulperiod", (Object)currentperiod);
        } else {
            this.getModel().setValue("mulperiod", null);
        }
        this.getView().updateView("mulperiod");
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject apInit;
        DynamicObjectCollection account;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject org = filterInfo.getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeBillLogarithmPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"MfgFeeBillLogarithmPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject mulperiod = filterInfo.getDynamicObject("mulperiod");
        if (mulperiod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u671f\u95f4\u3002", (String)"MfgFeeBillLogarithmPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        String srcsys = (String)this.getModel().getValue("srcsys");
        if (CadEmptyUtils.isEmpty((String)srcsys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u3002", (String)"MfgFeeBillLogarithmPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        if (srcsys.contains("A") && ((account = filterInfo.getDynamicObjectCollection("account")) == null || account.size() <= 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u3002", (String)"MfgFeeBillLogarithmPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        if (srcsys.contains("B") && (apInit = CostAccountHelper.getApInit((long)org.getLong("id"))) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u4e3a\u5e94\u4ed8\u65f6\uff0c\u6240\u9009\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u52a8\u5e94\u4ed8\u521d\u59cb\u5316\u3002", (String)"MfgFeeBillLogarithmPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        this.beforeQuerySetParam(queryParam);
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propertyName = e.getProperty().getName();
        Object propertyValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "org": {
                model.setValue("account", null);
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setMulPeriod();
                this.setCurrency();
                model.setValue("account", null);
                break;
            }
            case "srcsys": {
                if (propertyValue == null) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"account"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
                    break;
                }
                if (!(propertyValue instanceof String)) break;
                String value = (String)propertyValue;
                this.getModel().setValue("account", null);
                if (value.contains("A")) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"account"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"account"});
                break;
            }
            case "account": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObjectCollection accounts = dataEntity.getDynamicObjectCollection("account");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)accounts)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
                    this.getModel().setValue("mulcostcenter", null);
                    this.getModel().setValue("mulexpenseitem", null);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"mulcostcenter", "mulexpenseitem"});
                    break;
                }
                DynamicObjectCollection newAccounts = new DynamicObjectCollection();
                for (DynamicObject dy : accounts) {
                    newAccounts.add((Object)dy.getDynamicObject("fbasedataid"));
                }
                Long costCenterFlexId = LogarithmHelper.getCostCenterAccountId((DynamicObjectCollection)newAccounts);
                Long expenseitFlexId = LogarithmHelper.getExpenseitemeditAccountId((DynamicObjectCollection)newAccounts);
                long zeroValue = 0L;
                boolean isCostCenter = costCenterFlexId > zeroValue;
                boolean isExpense = expenseitFlexId > zeroValue;
                this.getView().setVisible(Boolean.valueOf(isCostCenter || isExpense), new String[]{"advconap"});
                this.getModel().setValue("mulcostcenter", null);
                this.getModel().setValue("mulexpenseitem", null);
                this.getView().setEnable(Boolean.valueOf(isCostCenter), new String[]{"mulcostcenter"});
                this.getView().setEnable(Boolean.valueOf(isExpense), new String[]{"mulexpenseitem"});
                this.setEntryEntity();
                break;
            }
            case "value": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                DynamicObject entity = (DynamicObject)entryEntity.get(rowIndex);
                MulBasedataDynamicObjectCollection mulCollection = (MulBasedataDynamicObjectCollection)entity.get("value");
                HashSet baseDataIds = new HashSet(16);
                mulCollection.forEach(s -> baseDataIds.add(s.getLong("fbasedataid_id")));
                DynamicObject fieldName = entity.getDynamicObject("fieldname");
                DynamicObject valueSource = fieldName.getDynamicObject("valuesource");
                if (valueSource == null) {
                    return;
                }
                String number = valueSource.getString("number");
                if ("bos_costcenter".equals(number)) {
                    this.getModel().setValue("mulcostcenter", (Object)baseDataIds.toArray());
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"mulcostcenter"});
                    break;
                }
                if (!"er_expenseitemedit".equals(number)) break;
                this.getModel().setValue("mulexpenseitem", (Object)baseDataIds.toArray());
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"mulexpenseitem"});
                break;
            }
        }
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setEntryEntity() {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        DynamicObject dataEntity = dataModel.getDataEntity();
        DynamicObjectCollection accounts = dataEntity.getDynamicObjectCollection("account");
        DynamicObjectCollection newAccounts = new DynamicObjectCollection();
        for (DynamicObject dy : accounts) {
            newAccounts.add((Object)dy.getDynamicObject("fbasedataid"));
        }
        Long costCenterFlexId = LogarithmHelper.getCostCenterAccountId((DynamicObjectCollection)newAccounts);
        Long expenseitemeditFlexId = LogarithmHelper.getExpenseitemeditAccountId((DynamicObjectCollection)newAccounts);
        int index = 0;
        if (costCenterFlexId > 0L) {
            dataModel.createNewEntryRow("entryentity");
            dataModel.setValue("fieldname", (Object)costCenterFlexId, index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"fieldname"});
            ++index;
        }
        if (expenseitemeditFlexId > 0L) {
            dataModel.createNewEntryRow("entryentity");
            dataModel.setValue("fieldname", (Object)expenseitemeditFlexId, index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"fieldname"});
        }
        this.getView().updateView("entryentity");
    }

    private void beforeQuerySetParam(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("entryentity");
        FilterInfo filterInfo = queryParam.getFilter();
        HashMap<String, FilterItemInfo> filterMap = new HashMap<String, FilterItemInfo>(filterInfo.getFlexFilterItems().size());
        for (FilterItemInfo item : filterInfo.getFlexFilterItems()) {
            filterMap.put(item.getPropName(), item);
        }
        block17: for (int i = 0; i < rowCount; ++i) {
            String valueType;
            String flexfield;
            FilterItemInfo item;
            DynamicObject assisType = (DynamicObject)model.getValue("fieldname", i);
            if (assisType == null || (item = (FilterItemInfo)filterMap.get(flexfield = assisType.getString("flexfield"))) == null) continue;
            switch (valueType = assisType.getString("valuetype")) {
                case "1": 
                case "2": {
                    String entityId;
                    Object value = item.getValue();
                    if (value == null) continue block17;
                    if ("2".equals(valueType)) {
                        entityId = "bos_assistantdata_detail";
                    } else {
                        DynamicObject valueSource = assisType.getDynamicObject("valuesource");
                        entityId = valueSource.getString("id");
                    }
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                    if (!(mainEntityType instanceof BasedataEntityType) || ((BasedataEntityType)mainEntityType).getMasteridType() == 0) continue block17;
                    String masterIdPropName = ((BasedataEntityType)mainEntityType).getMasteridPropName();
                    HashSet<Object> val = new HashSet<Object>();
                    try (DataSet set = QueryServiceHelper.queryDataSet((String)"gl assist report filter", (String)entityId, (String)"masterid", (QFilter[])new QFilter("id", "in", value).toArray(), null);){
                        while (set.hasNext()) {
                            val.add(set.next().get(masterIdPropName));
                        }
                    }
                    item.setValue(val);
                }
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String appnum = this.getView().getFormShowParameter().getAppId();
        FilterInfo filterInfo = queryParam.getFilter();
        if (CadEmptyUtils.isEmpty((String)filterInfo.getString("appnum"))) {
            filterInfo.addFilterItem("appnum", (Object)appnum, "=");
        }
        queryParam.setFilter(filterInfo);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String appnum = this.getView().getFormShowParameter().getAppId();
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"MfgFeeBillLogarithmPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u5b9e\u9645\u8d39\u7528\u79d1\u76ee\u5bf9\u6bd4\u8868", (String)"MfgFeeBillLogarithmPlugin_11", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_mfgfeebilllogarithm", (String)appnum);
    }

    private Long getAccountAbles() {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject accountBook = CostAccountHelper.getGlAccountBook((Long)org.getLong("id"), (Long)costaccount.getLong("id"));
        Long accounttable = 0L;
        if (accountBook != null) {
            accounttable = accountBook.getLong("accounttable");
        }
        return accounttable;
    }
}

