/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.ColumnHideHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.report.formplugin.BaseLogarithmPlugin;

public class ResourceUseLogarithmPlugin
extends BaseLogarithmPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mulbizorgInput = (BasedataEdit)this.getControl("mulbizorg");
        mulbizorgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ResourceUseLogarithmPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                List bizorgid = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter qfId = new QFilter("id", "in", (Object)bizorgid);
                List qFilters = filterParameter.getQFilters();
                qFilters.add(qfId);
            }
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                ReportList rptList = (ReportList)e.getSource();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                String fieldName = e.getFieldName();
                String formId = "";
                String billno = "";
                if ("bizbillno".equals(fieldName)) {
                    billno = row.getString(fieldName);
                    formId = row.getString("srcbilltype");
                } else if ("resourceusebillno".equals(fieldName)) {
                    billno = row.getString(fieldName);
                    formId = "sca_resourceuse";
                } else {
                    return;
                }
                if (CadEmptyUtils.isEmpty((String)billno)) {
                    return;
                }
                QFilter allocbillnoQF = new QFilter("billno", "=", (Object)billno);
                DynamicObjectCollection allocbill = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])new QFilter[]{allocbillnoQF});
                if (allocbill.isEmpty()) {
                    return;
                }
                Long billId = ((DynamicObject)allocbill.get(0)).getLong("id");
                BaseShowParameter bsp = new BaseShowParameter();
                bsp.setFormId(formId);
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setPkId((Object)billId);
                bsp.setBillStatusValue(Integer.valueOf(BillOperationStatus.VIEW.getValue()));
                rptList.getView().showForm((FormShowParameter)bsp);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "org": {
                this.getModel().setValue("mulbizorg", null);
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ResourceUseLogarithmPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u6570\u91cf\u5f52\u96c6\u5dee\u5f02\u8868", (String)"ResourceUseLogarithmPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_resourceuselogarithm", (String)this.getView().getFormShowParameter().getAppId());
        this.getModel().setValue("ishyperlink", (Object)Boolean.FALSE);
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        String appnum = showParameter.getAppId();
        List<String> hdieFields = Arrays.asList("completqty", "factuse", "factbatch");
        if ("aca".equalsIgnoreCase(appnum)) {
            List columns = e.getColumns();
            ColumnHideHelper.setColumnHide(hdieFields, (List)columns);
        }
    }
}

