/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.constants.StandardMacRptParam;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MacRptHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.lang3.StringUtils;

public class StandardMacQueryRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String[] clearFileName = new String[]{"productgroup", "material", "matvers", "auxproperty", "bom", "configuredcode", "tracknumber", "project", "lot"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mullot", "calcrecord"});
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                ReportList rptList = (ReportList)e.getSource();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                ReportQueryParam reportQueryParam = rptList.getReportModel().getReportQueryParam();
                StandardMacRptParam param = MacRptHelper.getRptParam((ReportQueryParam)reportQueryParam);
                ListShowParameter lsp = null;
                lsp = BomRouterHelper.isAnalogCostType((Long)Long.valueOf(param.getCostTypeId())) ? ShowFormHelper.createShowListForm((String)"cad_calcsimulationresult", (boolean)false, (int)1, (boolean)false) : ShowFormHelper.createShowListForm((String)"cad_calceffectiveresult", (boolean)false, (int)1, (boolean)false);
                ListFilterParameter filterParam = new ListFilterParameter();
                List filters = MacRptHelper.getCommonFiltersBy((StandardMacRptParam)param);
                DynamicObject rowMaterial = row.getDynamicObject("material");
                if (rowMaterial != null) {
                    filters.add(new QFilter("material", "=", rowMaterial.getPkValue()));
                }
                if (CadEmptyUtils.isEmpty((List)filters)) {
                    return;
                }
                filterParam.getQFilters().addAll(filters);
                lsp.setListFilterParameter(filterParam);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                rptList.getView().showForm((FormShowParameter)lsp);
            }
        });
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView());
            filter.and("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
            }
            filterParameter.setFilter(filter);
        });
        BasedataEdit mat = (BasedataEdit)this.getControl("mulmaterial");
        mat.addBeforeF7SelectListener(evt -> {
            DynamicObject ct = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (ct == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"StandardMacQueryRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            DynamicObject matVer = this.getModel().getDataEntity().getDynamicObject("version");
            List filters = ElementRelationHelper.getMatFiltersBy((DynamicObject)ct, (DynamicObject)matVer);
            DynamicObjectCollection mulProductGroup = (DynamicObjectCollection)this.getModel().getValue("mulproductgroup");
            if (!CollectionUtils.isEmpty((Collection)mulProductGroup)) {
                DynamicObject productGrpStd = (DynamicObject)this.getModel().getValue("productgrpstd");
                QFilter classifiedMaterialIdFilter = InFilterHelper.getQFilterByBachSize((String)"id", new ArrayList(MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulProductGroup, (boolean)false, (DynamicObject)productGrpStd)), (String)"in", (int)20000);
                filters.add(classifiedMaterialIdFilter);
            }
            filterParameter.getQFilters().addAll(filters);
        });
        BasedataEdit matVer = (BasedataEdit)this.getControl("version");
        matVer.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
            ArrayList matIds = new ArrayList(10);
            for (DynamicObject material : materials) {
                DynamicObject matObj = (DynamicObject)material.get("fbasedataid");
                materials.forEach(p -> matIds.add(matObj.getLong("masterid")));
            }
            if (!CadEmptyUtils.isEmpty(matIds)) {
                filters.add(new QFilter("material", "in", matIds));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            DynamicObject dyCostType = (DynamicObject)this.getModel().getValue("costtype");
            if (dyCostType == null) {
                evt.setCancel(true);
                return;
            }
            filterParameter.getQFilters().add(new QFilter("isadjustperiod", "=", (Object)false));
            filterParameter.getQFilters().add(CostUpdateHelper.getRptPeriodQFilter((Long)dyCostType.getLong("id")));
        });
        BasedataEdit productGrpStd = (BasedataEdit)this.getControl("productgrpstd");
        productGrpStd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"StandardMacQueryRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulProductGroup = (MulBasedataEdit)this.getControl("mulproductgroup");
        mulProductGroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("productgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"StandardMacQueryRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"StandardMacQueryRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"StandardMacQueryRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"StandardMacQueryRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"StandardMacQueryRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit products = (BasedataEdit)this.getControl("mulgroupmaterial");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"StandardMacQueryRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(costtype.getLong("createorg.id"));
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (!CollectionUtils.isEmpty((Collection)mulmaterialGroup) || materialgrpstd != null && materialGroupStandard.getLong("id") != 730148448254487552L) {
                QFilter classifiedMaterialIdFilter = InFilterHelper.getQFilterByBachSize((String)"id", new ArrayList(MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulmaterialGroup, (boolean)false, (DynamicObject)materialGroupStandard)), (String)"in", (int)20000);
                qFilters.add(classifiedMaterialIdFilter);
            }
        });
        BasedataEdit configuredCodeEdit = (BasedataEdit)this.getControl("mulconfiguredcode");
        configuredCodeEdit.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
            HashSet<Long> matIds = new HashSet<Long>(16);
            for (DynamicObject material : materials) {
                DynamicObject matObj = (DynamicObject)material.get("fbasedataid");
                matIds.add(matObj.getLong("masterid"));
            }
            if (!CadEmptyUtils.isEmpty(matIds)) {
                List configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(matIds);
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                if (!CadEmptyUtils.isEmpty((List)configCodeIds)) {
                    qFilters.add(new QFilter("id", "in", (Object)configCodeIds));
                }
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String key = textEdit.getKey();
            if ("mullot".equalsIgnoreCase(key)) {
                this.showStoragebillnos(key);
            } else if ("calcrecord".equalsIgnoreCase(key)) {
                this.showSelectPage(key);
            }
        }
    }

    private void showSelectPage(String actionId) {
        List materialIds;
        DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
        if (costtype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"StandardMacQueryRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
            return;
        }
        ArrayList mulmaterial = Lists.newArrayList();
        DynamicObjectCollection mulMaterial = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
        if (mulMaterial != null && mulMaterial.size() > 0 && !CadEmptyUtils.isEmpty(materialIds = mulMaterial.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            mulmaterial.addAll(materialIds);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_stdcalcrecord_text");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costTypeId", costtype.get("id"));
        fsp.setCustomParam("materialIds", (Object)mulmaterial);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    private void showStoragebillnos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sca_billnos");
        parameter.setCaption(ResManager.loadKDString((String)"\u6279\u53f7", (String)"StandardMacQueryRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        } else if (returnDataObj instanceof String) {
            String value = (String)returnDataObj;
            this.getModel().setValue(actionId, (Object)value);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("costtype");
        if (costType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u7c7b\u578b\u3002", (String)"StandardMacQueryRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String matIds = (String)fsp.getCustomParam("matIds");
        if (matIds == null) {
            DynamicObject materialgrpstd = this.getModel().getDataEntity().getDynamicObject("materialgrpstd");
            DynamicObject productgrpstd = this.getModel().getDataEntity().getDynamicObject("productgrpstd");
            if (materialgrpstd == null && productgrpstd == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7269\u6599\u5206\u7c7b\u6807\u51c6-\u7ec4\u4ef6\u201d\u3001\u201c\u7269\u6599\u5206\u7c7b\u6807\u51c6-\u4ea7\u54c1\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandardMacQueryRptPlugin_12", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
            if (materialgrpstd == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7269\u6599\u5206\u7c7b\u6807\u51c6-\u7ec4\u4ef6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandardMacQueryRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
            if (productgrpstd == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7269\u6599\u5206\u7c7b\u6807\u51c6-\u4ea7\u54c1\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandardMacQueryRptPlugin_13", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection mulMaterial = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
            DynamicObjectCollection mulProductGroup = this.getModel().getDataEntity().getDynamicObjectCollection("mulproductgroup");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulMaterial) && CadEmptyUtils.isEmpty((DynamicObjectCollection)mulProductGroup)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7269\u6599\u5206\u7c7b-\u4ea7\u54c1\u201d\u548c\u201c\u4ea7\u54c1\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"StandardMacQueryRptPlugin_14", (String)"macc-cad-report", (Object[])new Object[0]));
                return false;
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterItemInfo auxPropFilterItem = queryParam.getFilter().getFilterItem("auxprop");
        if (this.getModel().getDataEntity().getDynamicObject("auxprop") != null) {
            DynamicObject auxProp = this.getModel().getDataEntity().getDynamicObject("auxprop");
            auxPropFilterItem.setValue(auxProp.getPkValue());
        }
        this.updateCurrency();
        this.cleanQueryDate(queryParam);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        queryParam.getFilter().addFilterItem("matIds", fsp.getCustomParam("matIds"));
    }

    private void cleanQueryDate(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject costType = filter.getDynamicObject("costtype");
        if (costType == null) {
            return;
        }
        boolean isAnalog = BomRouterHelper.isAnalogCostType((Long)Long.valueOf(costType.getString("id")));
        if (isAnalog) {
            this.getModel().setValue("querydate", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "costtype": {
                this.updateCurrency();
                this.getModel().setValue("calcrecord", null);
                this.dealQueryPeriod();
                break;
            }
            case "version": {
                DynamicObject version = (DynamicObject)newValue;
                DynamicObject mat = Optional.ofNullable(version).map(s -> s.getDynamicObject("material")).orElse(null);
                DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)materials)) break;
                this.getModel().setValue("mulmaterial", (Object)mat);
                break;
            }
            case "mulproductgroup": {
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
            case "showgroup": {
                Boolean showgroup = (Boolean)this.getModel().getValue("showgroup");
                if (!showgroup.booleanValue()) break;
                this.getModel().setValue("isdetail", (Object)true);
                this.getModel().setValue("showsum", (Object)false);
                break;
            }
            case "isdetail": {
                Boolean isdetail = (Boolean)this.getModel().getValue("isdetail");
                if (!isdetail.booleanValue()) {
                    this.getModel().setValue("showgroup", (Object)false);
                    break;
                }
                this.getModel().setValue("showsum", (Object)false);
                break;
            }
            case "mulmaterial": {
                DynamicObjectCollection mulmaterials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterials)) break;
                this.getModel().setValue("mulconfiguredcode", null);
                this.getModel().setValue("multracknumber", null);
                break;
            }
            case "productgrpstd": {
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String matIds = (String)fsp.getCustomParam("matIds");
                if (matIds != null) break;
                this.getModel().setValue("mulproductgroup", null);
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "showsum": {
                boolean enable = (Boolean)this.getModel().getValue("showsum");
                if (!enable) break;
                this.getModel().setValue("isdetail", (Object)false);
                this.getModel().setValue("showgroup", (Object)false);
                break;
            }
        }
    }

    private void updateCurrency() {
        DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("costtype");
        DynamicObject currency = Optional.ofNullable(costType).map(s -> s.getDynamicObject("currency")).orElse(null);
        this.getModel().setValue("currency", (Object)currency);
    }

    private void dealQueryPeriod() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        boolean isSimulated = costType == null || CostTypePtyEnum.SIMULATED.getValue().equals(costType.getString("type"));
        this.getView().setVisible(Boolean.valueOf(isSimulated), new String[]{"calcrecord"});
        if (isSimulated) {
            this.setQueryVisible(Boolean.FALSE, Boolean.FALSE, null);
            return;
        }
        Long costTypeId = costType.getLong("id");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)costTypeId);
        this.setQueryVisible(isUpdateByPeriod == false, isUpdateByPeriod, costTypeId);
    }

    private void setQueryVisible(Boolean isDateShow, Boolean isPeriodShow, Long costTypeId) {
        this.getView().setVisible(isPeriodShow, new String[]{"queryperiod"});
        if (Boolean.TRUE.equals(isPeriodShow)) {
            this.getModel().setValue("queryperiod", (Object)CostUpdateHelper.getCurPeriodId((Long)costTypeId));
        } else {
            this.getModel().setValue("queryperiod", null);
        }
        this.getView().setVisible(isDateShow, new String[]{"querydate"});
        this.getModel().setValue("querydate", (Object)(Boolean.TRUE.equals(isDateShow) ? TimeServiceHelper.now() : null));
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        List<String> hdieDetailFields = Arrays.asList("matandres", "matandrestype", "submaterial", "submatname", "submatvers", "subauxproperty", "datatype", "resource", "resourcename", "qty", "price", "matandresname", "productgroup", "productgroupname", "materialgroup", "materialgroupname", "subconfiguredcode", "subtracknumber", "subproject", "sublot");
        HashSet<String> hideDetailFieldSet = new HashSet<String>(Arrays.asList("matandres", "matandresname", "submatvers", "subauxproperty", "qty", "price", "subconfiguredcode", "subtracknumber", "subproject", "sublot"));
        HashSet<String> hideDateFieldSet = new HashSet<String>(Arrays.asList("effectdate", "expdate"));
        HashSet<String> hideRouteFieldSet = new HashSet<String>(Arrays.asList("routenumber", "routename", "processseq", "operationno"));
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        Boolean isShowDate = CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type")) && this.getModel().getValue("queryperiod") == null && this.getModel().getValue("querydate") != null;
        boolean isAca = "aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()));
        HashSet<String> hideFieldSetInAca = new HashSet<String>(Arrays.asList("configuredcode", "tracknumber"));
        boolean isDetail = this.getModel().getDataEntity().getBoolean("isdetail");
        boolean showgroup = this.getModel().getDataEntity().getBoolean("showgroup");
        boolean isHsCostType = CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type"));
        while (it.hasNext()) {
            ReportColumn reportColumn = (ReportColumn)it.next();
            String key = reportColumn.getFieldKey();
            boolean isRemove = false;
            if (!isDetail && hdieDetailFields.contains(key)) {
                isRemove = true;
            } else if (showgroup && hideDetailFieldSet.contains(key)) {
                isRemove = true;
            } else if (!isShowDate.booleanValue() && hideDateFieldSet.contains(key)) {
                isRemove = true;
            } else if (isAca && hideFieldSetInAca.contains(key)) {
                isRemove = true;
            } else if ((isHsCostType || !isDetail || isDetail && showgroup) && hideRouteFieldSet.contains(key)) {
                isRemove = true;
            }
            if (!isRemove) continue;
            it.remove();
        }
        super.afterCreateColumn(e);
    }

    public void afterBindData(EventObject e) {
        Object materialgrpstd;
        super.afterBindData(e);
        this.updateCurrency();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (fsp.getCustomParam("matIds") != null) {
            Set materialIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("matIds")), Set.class);
            this.getModel().setValue("mulmaterial", (Object)materialIds.toArray());
        }
        if (fsp.getCustomParam("configuredCodeIds") != null) {
            Set configuredCodeIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("configuredCodeIds")), Set.class);
            this.getModel().setValue("mulconfiguredcode", (Object)configuredCodeIds.toArray());
        }
        if (fsp.getCustomParam("trackNumberIds") != null) {
            Set trackNumberIds = (Set)SerializationUtils.fromJsonString((String)((String)fsp.getCustomParam("trackNumberIds")), Set.class);
            this.getModel().setValue("multracknumber", (Object)trackNumberIds.toArray());
        }
        if (fsp.getCustomParam("calcrecord") != null) {
            String calcRecord = (String)fsp.getCustomParam("calcrecord");
            this.getModel().setValue("calcrecord", (Object)calcRecord);
        }
        this.dealQueryPeriod();
        Object productgrpstd = this.getModel().getValue("productgrpstd");
        if (productgrpstd == null) {
            productgrpstd = BusinessDataServiceHelper.loadSingleFromCache((Object)730148448254487552L, (String)"bd_materialgroupstandard");
            this.getModel().setValue("productgrpstd", productgrpstd);
            this.getView().updateView("productgrpstd");
        }
        if ((materialgrpstd = this.getModel().getValue("materialgrpstd")) == null) {
            materialgrpstd = BusinessDataServiceHelper.loadSingleFromCache((Object)730148448254487552L, (String)"bd_materialgroupstandard");
            this.getModel().setValue("materialgrpstd", materialgrpstd);
            this.getView().updateView("materialgrpstd");
        }
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulconfiguredcode", "multracknumber"});
            this.getModel().setValue("mulconfiguredcode", null);
            this.getModel().setValue("multracknumber", null);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"StandardMacQueryRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]);
        String caption = this.getView().getFormShowParameter().getCaption();
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"StandardMacQueryRptPlugin_15", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Boolean mergesame = (Boolean)this.getModel().getValue("mergesame");
        Boolean showsum = (Boolean)this.getModel().getValue("showsum");
        Boolean isShowDetail = (Boolean)this.getModel().getValue("isdetail");
        if (mergesame.booleanValue() && !showsum.booleanValue()) {
            ReportUtils.clearFileNameValue((String[])clearFileName, (DynamicObjectCollection)rowData, (String[])clearFileName);
        }
        for (DynamicObject rowDatum : rowData) {
            DynamicObject material;
            if (isShowDetail.booleanValue()) {
                DynamicObject submaterial = rowDatum.getDynamicObject("submaterial");
                if (submaterial != null) {
                    rowDatum.set("baseunit", submaterial.get("baseunit.name"));
                } else {
                    material = rowDatum.getDynamicObject("material");
                    if (material != null) {
                        rowDatum.set("baseunit", material.get("baseunit.name"));
                    }
                }
                Object resource = rowDatum.get("resource");
                if (resource == null) {
                    rowDatum.set("datatype", null);
                    continue;
                }
                String calcbasis = rowDatum.getString("calcbasis");
                if ("001".equals(calcbasis)) {
                    rowDatum.set("baseunit", (Object)ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"StandardMacQueryRptPlugin_16", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue;
                }
                if (!"002".equals(calcbasis) && !"003".equals(calcbasis)) continue;
                rowDatum.set("baseunit", (Object)ResManager.loadKDString((String)"\u4e2a", (String)"StandardMacQueryRptPlugin_17", (String)"macc-cad-report", (Object[])new Object[0]));
                continue;
            }
            Object element = rowDatum.get("element");
            if (element == null || !StringUtils.equals((CharSequence)String.valueOf(element), (CharSequence)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StandardMacQueryRptPlugin_18", (String)"macc-cad-report", (Object[])new Object[0])) || (material = rowDatum.getDynamicObject("material")) == null) continue;
            rowDatum.set("baseunit", material.get("baseunit.name"));
        }
    }
}

