/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.formplugin;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class StdCalcRecordPlugin
extends AbstractFormPlugin {
    private static final String STD_CALC_RECORD_LIST = "stdCalcRecordlist";

    public void afterBindData(EventObject e) {
        DynamicObjectCollection stdCalcRecords;
        int entrySize;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long costTypeId = Long.valueOf(fsp.getCustomParam("costTypeId") + "");
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        List materialIds = (List)fsp.getCustomParam("materialIds");
        if (!CadEmptyUtils.isEmpty((List)materialIds)) {
            filter.and(new QFilter("material", "in", (Object)materialIds));
        }
        if ((entrySize = (stdCalcRecords = this.getStdCalcRecords(filter)).size()) <= 0) {
            return;
        }
        if (model.getEntryRowCount(STD_CALC_RECORD_LIST) > 0) {
            model.deleteEntryData(STD_CALC_RECORD_LIST);
        }
        int currIndex = 0;
        HashSet nameSet = Sets.newHashSet();
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject obj = (DynamicObject)stdCalcRecords.get(i);
            String name = obj.getString("name");
            if (CadEmptyUtils.isEmpty((String)name) || !nameSet.add(name)) continue;
            model.createNewEntryRow(STD_CALC_RECORD_LIST);
            model.setValue("name", (Object)name, currIndex);
            ++currIndex;
        }
        this.getView().updateView(STD_CALC_RECORD_LIST);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "confirm": {
                DynamicObject row;
                String rowValue;
                EntryGrid entrygrid = (EntryGrid)this.getControl(STD_CALC_RECORD_LIST);
                int[] selectRows = entrygrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u540e\u518d\u786e\u5b9a\u3002", (String)"StdCalcRecordPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    return;
                }
                Integer selectRow = selectRows[0];
                String returnData = "";
                DynamicObjectCollection rows = this.getModel().getEntryEntity(STD_CALC_RECORD_LIST);
                if (rows != null && rows.size() > 0 && !CadEmptyUtils.isEmpty((String)(rowValue = (row = (DynamicObject)rows.get(selectRow.intValue())).getString("name")))) {
                    returnData = rowValue;
                }
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
            }
        }
    }

    private DynamicObjectCollection getStdCalcRecords(QFilter filter) {
        String selectFields = "name";
        String orderby = "name ASC";
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cad_stdcalcrecord", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)orderby);
        return result;
    }
}

