/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.function.TimeConverter;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import org.apache.commons.lang.StringUtils;

public class ActualRateAnalyRptQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ActualRateAnalyRptQuery.class);
    private Long currencyId = 0L;
    private Boolean enableMulFactory = Boolean.FALSE;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.init(filterInfo);
        Set<Long> costCenters = this.getCostCenters(filterInfo);
        DataSet manuOrgAndCostTypeDataSet = this.getManuOrgAndCostTypeDataSet(filterInfo, new Date());
        Set<Long> costTypeIds = this.getCostTypeIds(manuOrgAndCostTypeDataSet.copy());
        DataSet actRateDataSet = this.getActRateDataSet(filterInfo, costCenters);
        DataSet stdRateDataSet = this.getStdRateDataSet(filterInfo, costTypeIds, manuOrgAndCostTypeDataSet, actRateDataSet);
        boolean showPeriodSum = filterInfo.getBoolean("showperiodsum");
        String actPeriodSum = filterInfo.getString("actperiodsum");
        DataSet resultDataSet = this.joinActAtdRateDataSet(actRateDataSet, stdRateDataSet, showPeriodSum, actPeriodSum);
        if (showPeriodSum) {
            DataSet sumDataSet = this.dealShowPeriodTotalSumDataSet(resultDataSet);
            resultDataSet = DataSetUtils.union((DataSet)resultDataSet, (DataSet)sumDataSet);
            if (this.enableMulFactory.booleanValue()) {
                return resultDataSet.orderBy(new String[]{"top", "costcenter", "entryprodorg", "workcenter", "elementnum asc", "subelementnum asc"});
            }
            return resultDataSet.orderBy(new String[]{"top", "costcenter", "workcenter", "elementnum asc", "subelementnum asc"});
        }
        DataSet subSumDataSet = this.dealSubSumDataSet(resultDataSet);
        DataSet sumDataSet = this.dealTotalSumDataSet(resultDataSet);
        DataSet result = DataSetUtils.union((DataSet)DataSetUtils.union((DataSet)resultDataSet, (DataSet)subSumDataSet), (DataSet)sumDataSet);
        if (this.enableMulFactory.booleanValue()) {
            return result.orderBy(new String[]{"top", "periodid", "costcenter", "entryprodorg", "workcenter", "elementnum asc", "subelementnum asc"});
        }
        return result.orderBy(new String[]{"top", "periodid", "costcenter", "workcenter", "elementnum asc", "subelementnum asc"});
    }

    private DataSet joinActAtdRateDataSet(DataSet actRateDataSet, DataSet stdRateDataSet, boolean showPeriodSum, String actPeriodSum) {
        if (actRateDataSet == null || stdRateDataSet == null) {
            return actRateDataSet;
        }
        actRateDataSet = !this.enableMulFactory.booleanValue() ? (showPeriodSum ? actRateDataSet.join(stdRateDataSet, JoinType.LEFT).on("org", "org").on("costcenterid", "costcenterid").on("workcenter", "workcenter").on("costdriver", "costdriver").on("resource", "resource").on("subelement", "subelement").select(actRateDataSet.getRowMeta().getFieldNames(), new String[]{"qty"}).finish() : actRateDataSet.join(stdRateDataSet, JoinType.LEFT).on("periodid", "period").on("org", "org").on("costcenterid", "costcenterid").on("workcenter", "workcenter").on("costdriver", "costdriver").on("resource", "resource").on("subelement", "subelement").select(actRateDataSet.getRowMeta().getFieldNames(), new String[]{"qty"}).finish()) : (showPeriodSum ? actRateDataSet.join(stdRateDataSet, JoinType.LEFT).on("entryprodorg", "org").on("costcenterid", "costcenterid").on("workcenter", "workcenter").on("costdriver", "costdriver").on("resource", "resource").on("subelement", "subelement").select(actRateDataSet.getRowMeta().getFieldNames(), new String[]{"qty"}).finish() : actRateDataSet.join(stdRateDataSet, JoinType.LEFT).on("periodid", "period").on("entryprodorg", "org").on("costcenterid", "costcenterid").on("workcenter", "workcenter").on("costdriver", "costdriver").on("resource", "resource").on("subelement", "subelement").select(actRateDataSet.getRowMeta().getFieldNames(), new String[]{"qty"}).finish());
        actRateDataSet = actRateDataSet.groupBy(actRateDataSet.getRowMeta().getFieldNames()).finish().filter("costdriver != null").filter("((resource=null or resource=0) and (resourcetype=null or resourcetype='')) or (resource>0 and (resourcetype=null or resourcetype='')) or (resourcetype!=null and resourcetype!='' and qty !=null and qty>0)");
        ArrayList groupFields = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "periodid", "period", "costcenterid", "costcenter", "costcentername", "workcenter", "costdriver", "element", "elementnum", "subelement", "subelementnum", "resource", "resourcetype", "costdriverunit", "entrycurrency", "allocstdamt"});
        String manuorgField = "";
        if (this.enableMulFactory.booleanValue()) {
            groupFields.add("entryprodorg");
            manuorgField = "entryprodorg,";
        }
        actRateDataSet = actRateDataSet.groupBy(groupFields.toArray(new String[0])).sum("collectamt").sum("actualrate").sum("qty", "standardrate").finish();
        DataSet resoureMpdm = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid,number as resourcenum, name as resourcename", null, null);
        actRateDataSet = actRateDataSet.join(resoureMpdm, JoinType.LEFT).on("resource", "resourceid").select(actRateDataSet.getRowMeta().getFieldNames(), new String[]{"resourceid", "resourcenum", "resourcename"}).finish().select("org," + manuorgField + "costaccount,periodid,period,costcenter,costcentername,workcenter,costdriver,element,elementnum,subelement,subelementnum,resourceid,resourcenum,resourcename resource,resourcename stdresource,resourcetype,costdriverunit,entrycurrency,collectamt,allocstdamt,actualrate,case when standardrate=null then 0 else standardrate end standardrate");
        DataSet dataSet = this.dealResourceShow(actRateDataSet.copy());
        actRateDataSet = actRateDataSet.join(dataSet, JoinType.INNER).on("costdriver", "costdriver").select(actRateDataSet.getRowMeta().getFieldNames(), new String[]{"resourcestr"}).finish();
        actRateDataSet = actRateDataSet.filter("(resourcestr like '%/%' and standardrate!=0 and standardrate != null) or resourcestr not like '%/%'");
        actRateDataSet = "avg".equals(actPeriodSum) ? actRateDataSet.select("org," + manuorgField + "costaccount,periodid,period,costcenter,costcentername,workcenter,costdriver,element,elementnum,subelement,subelementnum,resourcenum,resourcestr,stdresource,resourcetype,costdriverunit,entrycurrency,collectamt,allocstdamt/60 as allocstdamt,actualrate*60 as actualrate,standardrate*60 as standardrate") : actRateDataSet.select("org," + manuorgField + "costaccount,periodid,period,costcenter,costcentername,workcenter,costdriver,element,elementnum,subelement,subelementnum,resourcenum,resourcestr,stdresource,resourcetype,costdriverunit,entrycurrency,collectamt,allocstdamt/60 as allocstdamt,case when allocstdamt=0 then 0 else collectamt/(allocstdamt/60) end actualrate,standardrate*60 as standardrate");
        return actRateDataSet.select("org," + manuorgField + "costaccount,periodid,period,costcenter,costcentername,workcenter,costdriver,element,elementnum,subelement,subelementnum,resourcenum,resourcestr resource,stdresource,resourcetype,costdriverunit,entrycurrency,collectamt,allocstdamt,actualrate,standardrate,round(actualrate-standardrate,10) ratediff,case when standardrate=0  then '' else concat(round(abs(actualrate-standardrate)*100/standardrate,2),'%') end ratediffabs").addField("0", "top");
    }

    private Set<Long> getCostTypeIds(DataSet dataSet) {
        HashSet<Long> costTypeIds = new HashSet<Long>(10);
        if (dataSet == null) {
            return costTypeIds;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long costType = row.getLong("costtype");
            if (CadEmptyUtils.isEmpty((Long)costType)) continue;
            costTypeIds.add(costType);
        }
        return costTypeIds;
    }

    private Set<Long> getReourceIds(DataSet dataSet) {
        HashSet<Long> resourceIds = new HashSet<Long>(10);
        if (dataSet == null) {
            return resourceIds;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long resource = row.getLong("resource");
            if (CadEmptyUtils.isEmpty((Long)resource)) continue;
            resourceIds.add(resource);
        }
        return resourceIds;
    }

    private DataSet dealSubSumDataSet(DataSet resultDataSet) {
        String CAD_SUBSUMTOTAL = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ActualRateAnalyRptQuery_0", (String)"macc-cad-report", (Object[])new Object[0]);
        DataSet dataSet = resultDataSet.copy();
        String manuorgField = this.enableMulFactory != false ? "0 as entryprodorg," : "";
        String selectFields = "0 as org," + manuorgField + "0 as costaccount,periodid,period,'" + CAD_SUBSUMTOTAL + "' as costcenter,'' as costcentername,0 as workcenter,0 as costdriver,0 as element,'' as elementnum,0 as subelement,'' as subelementnum,'' as resourcenum,'' as resource,'' as stdresource,'' as resourcetype,0 as costdriverunit," + this.currencyId + " as entrycurrency,collectamt,allocstdamt,actualrate,standardrate,(actualrate - standardrate) ratediff,case when standardrate=0 then '' else concat(round(abs(actualrate-standardrate)*100/standardrate,2),'%') end ratediffabs";
        dataSet = dataSet.groupBy(new String[]{"periodid", "period"}).sum("collectamt").sum("allocstdamt").sum("actualrate").sum("standardrate").finish().select(selectFields).addField("0", "top");
        return dataSet;
    }

    private DataSet dealShowPeriodTotalSumDataSet(DataSet resultDataSet) {
        String CAD_SUMTOTAL = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ActualRateAnalyRptQuery_1", (String)"macc-cad-report", (Object[])new Object[0]);
        DataSet dataSet = resultDataSet.copy();
        String manuorgField = this.enableMulFactory != false ? "0 as entryprodorg," : "";
        String selectFields = "0 as org," + manuorgField + "0 as costaccount,0 as periodid,'' as period,'" + CAD_SUMTOTAL + "' as costcenter,'' as costcentername,0 as workcenter,0 as costdriver,0 as element,'' as elementnum,0 as subelement,'' as subelementnum,'' as resourcenum,'' as resource,'' as stdresource,'' as resourcetype,0 as costdriverunit," + this.currencyId + " as entrycurrency,collectamt,allocstdamt,actualrate,standardrate,(actualrate - standardrate) ratediff,case when standardrate=0 then '' else concat(round(abs(actualrate-standardrate)*100/standardrate,2),'%') end ratediffabs";
        dataSet = dataSet.groupBy(new String[]{"org"}).sum("collectamt").sum("allocstdamt").sum("actualrate").sum("standardrate").finish().select(selectFields).addField("2", "top");
        return dataSet;
    }

    private DataSet dealTotalSumDataSet(DataSet resultDataSet) {
        String CAD_SUMTOTAL = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ActualRateAnalyRptQuery_1", (String)"macc-cad-report", (Object[])new Object[0]);
        DataSet dataSet = resultDataSet.copy();
        String manuorgField = this.enableMulFactory != false ? "0 as entryprodorg," : "";
        String selectFields = "0 as org," + manuorgField + "0 as costaccount,0 as periodid,'" + CAD_SUMTOTAL + "' as period,'' as costcenter,'' as costcentername,0 as workcenter,0 as costdriver,0 as element,'' as elementnum,0 as subelement,'' as subelementnum,'' as resourcenum,'' as resource,'' as stdresource,'' as resourcetype,0 as costdriverunit," + this.currencyId + " as entrycurrency,collectamt,allocstdamt,actualrate,standardrate,(actualrate - standardrate) as ratediff,case when standardrate=0 then '' else concat(round(abs(actualrate-standardrate)*100/standardrate,2),'%') end ratediffabs";
        dataSet = dataSet.groupBy(new String[]{"org"}).sum("collectamt").sum("allocstdamt").sum("actualrate").sum("standardrate").finish().select(selectFields).addField("2", "top");
        return dataSet;
    }

    private DataSet getActRateDataSet(FilterInfo filterInfo, Set<Long> costCenters) {
        ArrayList groupFields = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "periodid", "period", "costcenterid", "costcenter", "costcentername", "workcenter", "costdriver", "element", "elementnum", "subelement", "subelementnum", "costdriverunit", "entrycurrency", "allocstdamt"});
        List<QFilter> qFilters = this.getQFilters(filterInfo, costCenters);
        DataSet basicProductionDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getBasicProductionDataSet", (String)"cad_mfgfeeallocco", (String)("id,org,costaccount,manuorg as entryprodorg,period as periodid,period.name as period,benefcostcenter costcenterid,benefcostcenter.number as costcenter,benefcostcenter.name as costcentername,costdriver,element,element.number elementnum,subelement,subelement.number subelementnum,baseunit as costdriverunit,amount as collectamt,costdriverqty as allocstdamt," + this.currencyId + " as entrycurrency"), (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DynamicObject startPeriod = filterInfo.getDynamicObject("startperiod");
        DynamicObject endPeriod = filterInfo.getDynamicObject("endperiod");
        List queryPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        DataSet costCenterDataSet = this.getCostCenterDataSet(costCenters, queryPeriodIds);
        basicProductionDataSet = basicProductionDataSet.join(costCenterDataSet, JoinType.LEFT).on("periodid", "period").on("costcenterid", "costcenter").select(basicProductionDataSet.getRowMeta().getFieldNames(), new String[]{"workcenter"}).finish();
        boolean showPeriodSum = filterInfo.getBoolean("showperiodsum");
        String actPeriodSum = filterInfo.getString("actperiodsum");
        String manuorgField = "";
        if (this.enableMulFactory.booleanValue()) {
            groupFields.add("entryprodorg");
            manuorgField = "entryprodorg,";
        }
        if (showPeriodSum) {
            if ("avg".equals(actPeriodSum)) {
                basicProductionDataSet = basicProductionDataSet.groupBy(groupFields.toArray(new String[0])).sum("collectamt").finish();
                basicProductionDataSet = basicProductionDataSet.addField("case when allocstdamt=0 then 0.0 else collectamt/allocstdamt end", "actualrate");
                groupFields.remove("periodid");
                groupFields.remove("period");
                groupFields.remove("allocstdamt");
                basicProductionDataSet = basicProductionDataSet.groupBy(groupFields.toArray(new String[0])).sum("collectamt").sum("allocstdamt").avg("actualrate").finish();
                basicProductionDataSet = basicProductionDataSet.select("org,costaccount," + manuorgField + "0L periodid,'' period,costcenterid,costcenter,costcentername,workcenter,costdriver,element,elementnum,subelement,subelementnum,costdriverunit,entrycurrency,collectamt,0.0 as allocstdamt,actualrate");
            } else if ("weightavg".equals(actPeriodSum)) {
                basicProductionDataSet = basicProductionDataSet.groupBy(groupFields.toArray(new String[0])).sum("collectamt").finish();
                groupFields.remove("periodid");
                groupFields.remove("period");
                groupFields.remove("allocstdamt");
                basicProductionDataSet = basicProductionDataSet.groupBy(groupFields.toArray(new String[0])).sum("collectamt").sum("allocstdamt").finish();
                basicProductionDataSet = basicProductionDataSet.addField("case when allocstdamt=0 then 0.0 else collectamt/allocstdamt end", "actualrate");
                basicProductionDataSet = basicProductionDataSet.select("org,costaccount," + manuorgField + "0L periodid,'' period,costcenterid,costcenter,costcentername,workcenter,costdriver,element,elementnum,subelement,subelementnum,costdriverunit,entrycurrency,collectamt,allocstdamt,actualrate");
            }
        } else {
            basicProductionDataSet = basicProductionDataSet.groupBy(groupFields.toArray(new String[0])).sum("collectamt").finish();
            basicProductionDataSet = basicProductionDataSet.addField("case when allocstdamt=0 then 0.0 else collectamt/allocstdamt end", "actualrate");
            basicProductionDataSet = basicProductionDataSet.select("org,costaccount," + manuorgField + "periodid,period,costcenterid,costcenter,costcentername,workcenter,costdriver,element,elementnum,subelement,subelementnum,costdriverunit,entrycurrency,collectamt,allocstdamt,actualrate");
        }
        DataSet costDriverResDataSet = this.getCostDriverResDataSet();
        basicProductionDataSet = basicProductionDataSet.join(costDriverResDataSet, JoinType.LEFT).on("costdriver", "costdriver").select(basicProductionDataSet.getRowMeta().getFieldNames(), new String[]{"matchpattern", "resource", "resourcetype"}).finish();
        return basicProductionDataSet;
    }

    private DataSet getStdRateDataSet(FilterInfo filterInfo, Set<Long> costTypeIds, DataSet manuOrgAndCostTypeDataSet, DataSet actRateDataSet) {
        DataSet actRateDataSetCopy = actRateDataSet.copy().filter("resource!=null and resource>0");
        actRateDataSetCopy = actRateDataSetCopy.select("workcenter,costcenterid,costdriver,matchpattern,resource,resourcetype,subelement").distinct();
        Boolean isQueryPeriod = this.isQueryByPeriod();
        boolean showPeriodSum = filterInfo.getBoolean("showperiodsum");
        String stdPeriodSum = filterInfo.getString("stdperiodsum");
        DataSet resDataSet = null;
        if (showPeriodSum) {
            if ("avg".equals(stdPeriodSum)) {
                DynamicObject startPeriod = filterInfo.getDynamicObject("startperiod");
                DynamicObject endPeriod = filterInfo.getDynamicObject("endperiod");
                List queryPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
                for (Object queryPeriodId : queryPeriodIds) {
                    DataSet dataSet = this.getResourceRateDataSet(costTypeIds, Long.parseLong(queryPeriodId.toString()), null);
                    if (resDataSet == null) {
                        resDataSet = dataSet;
                        continue;
                    }
                    resDataSet = DataSetUtils.union((DataSet)resDataSet, (DataSet)dataSet);
                }
                if ((resDataSet = this.getResourceRateDataSet(resDataSet, manuOrgAndCostTypeDataSet, actRateDataSetCopy)) == null) {
                    return null;
                }
                resDataSet = resDataSet.groupBy(new String[]{"period", "costdriver", "resource", "resourcetype", "matchpattern", "costcenterid", "workcenter", "calcbasis", "resourceunit", "costtype", "element", "subelement", "org"}).sum("qty").finish();
                resDataSet = resDataSet.groupBy(new String[]{"costdriver", "resource", "resourcetype", "matchpattern", "costcenterid", "workcenter", "calcbasis", "resourceunit", "costtype", "element", "subelement", "org"}).avg("qty").finish();
                DataSet transUnitDataSet = this.getTransUnitDataSet(resDataSet.copy());
                resDataSet = resDataSet.join(transUnitDataSet, JoinType.LEFT).on("resourceunit", "resourceunit").select(resDataSet.getRowMeta().getFieldNames(), new String[]{"transunitqty"}).finish();
                resDataSet = resDataSet.select("costdriver,resource,resourcetype,matchpattern,costcenterid,workcenter,calcbasis,resourceunit,case when transunitqty is null then qty else qty*transunitqty/60 end qty,element,subelement,org,costtype");
                resDataSet = resDataSet.select("0L as period,costdriver,resource,resourcetype,matchpattern,costcenterid,workcenter,calcbasis,resourceunit,costtype,element,subelement,qty,org");
            } else if ("date".equals(stdPeriodSum)) {
                if (isQueryPeriod.booleanValue()) {
                    DynamicObject queryPeriod = filterInfo.getDynamicObject("queryperiod");
                    resDataSet = this.getResourceRateDataSet(costTypeIds, queryPeriod == null ? -1L : queryPeriod.getLong("id"), null);
                    if ((resDataSet = this.getResourceRateDataSet(resDataSet, manuOrgAndCostTypeDataSet, actRateDataSetCopy)) == null) {
                        return null;
                    }
                    resDataSet = resDataSet.groupBy(new String[]{"costdriver", "resource", "resourcetype", "matchpattern", "costcenterid", "workcenter", "calcbasis", "resourceunit", "costtype", "element", "subelement", "org"}).sum("qty").finish();
                    DataSet transUnitDataSet = this.getTransUnitDataSet(resDataSet.copy());
                    resDataSet = resDataSet.join(transUnitDataSet, JoinType.LEFT).on("resourceunit", "resourceunit").select(resDataSet.getRowMeta().getFieldNames(), new String[]{"transunitqty"}).finish();
                    resDataSet = resDataSet.select("costdriver,resource,resourcetype,costcenterid,workcenter,calcbasis,resourceunit,case when transunitqty is null then qty else qty*transunitqty/60 end qty,element,subelement,org,costtype");
                    resDataSet = resDataSet.select("0L as period,costdriver,resource,resourcetype,costcenterid,workcenter,calcbasis,resourceunit,costtype,element,subelement,qty,org");
                } else {
                    Date queryDate = filterInfo.getDate("querydate");
                    resDataSet = this.getResourceRateDataSet(costTypeIds, 0L, queryDate);
                    if ((resDataSet = this.getResourceRateDataSet(resDataSet, manuOrgAndCostTypeDataSet, actRateDataSetCopy)) == null) {
                        return null;
                    }
                    resDataSet = resDataSet.groupBy(new String[]{"costdriver", "resource", "resourcetype", "matchpattern", "costcenterid", "workcenter", "calcbasis", "resourceunit", "costtype", "element", "subelement", "org"}).sum("qty").finish();
                    DataSet transUnitDataSet = this.getTransUnitDataSet(resDataSet.copy());
                    resDataSet = resDataSet.join(transUnitDataSet, JoinType.LEFT).on("resourceunit", "resourceunit").select(resDataSet.getRowMeta().getFieldNames(), new String[]{"transunitqty"}).finish();
                    resDataSet = resDataSet.select("costdriver,resource,resourcetype,costcenterid,workcenter,calcbasis,resourceunit,case when transunitqty is null then qty else qty*transunitqty/60 end qty,element,subelement,org,costtype");
                    resDataSet = resDataSet.select("0L as period,costdriver,resource,resourcetype,costcenterid,workcenter,calcbasis,resourceunit,costtype,element,subelement,qty,org");
                }
            }
        } else {
            DynamicObject startPeriod = filterInfo.getDynamicObject("startperiod");
            DynamicObject endPeriod = filterInfo.getDynamicObject("endperiod");
            List queryPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
            for (Object queryPeriodId : queryPeriodIds) {
                DataSet dataSet = this.getResourceRateDataSet(costTypeIds, Long.parseLong(queryPeriodId.toString()), null);
                if (resDataSet == null) {
                    resDataSet = dataSet;
                    continue;
                }
                resDataSet = DataSetUtils.union((DataSet)resDataSet, (DataSet)dataSet);
            }
            if ((resDataSet = this.getResourceRateDataSet(resDataSet, manuOrgAndCostTypeDataSet, actRateDataSetCopy)) == null) {
                return null;
            }
            resDataSet = resDataSet.groupBy(new String[]{"period", "costdriver", "resource", "resourcetype", "matchpattern", "costcenterid", "workcenter", "calcbasis", "resourceunit", "costtype", "element", "subelement", "org"}).sum("qty").finish();
            DataSet transUnitDataSet = this.getTransUnitDataSet(resDataSet.copy());
            resDataSet = resDataSet.join(transUnitDataSet, JoinType.LEFT).on("resourceunit", "resourceunit").select(resDataSet.getRowMeta().getFieldNames(), new String[]{"transunitqty"}).finish();
            resDataSet = resDataSet.select("period,costdriver,resource,resourcetype,matchpattern,costcenterid,workcenter,calcbasis,resourceunit,case when transunitqty is null then qty else qty*transunitqty/60 end qty,element,subelement,org,costtype");
            resDataSet = resDataSet.select("period,costdriver,resource,resourcetype,matchpattern,costcenterid,workcenter,calcbasis,resourceunit,costtype,element,subelement,qty,org");
        }
        return resDataSet;
    }

    private DataSet getResourceRateDataSet(DataSet resDataSet, DataSet manuOrgAndCostTypeDataSet, DataSet actRateDataSetCopy) {
        if (resDataSet == null || actRateDataSetCopy == null) {
            return null;
        }
        resDataSet = resDataSet.join(manuOrgAndCostTypeDataSet, JoinType.INNER).on("costtype", "costtype").select(new String[]{"period", "workcenter", "resource", "calcbasis", "resourceunit", "qty", "element", "subelement"}, new String[]{"org", "costtype"}).finish();
        DataSet wcResDataSet = resDataSet.filter("workcenter!=null and workcenter>0");
        DataSet nwcResDataSet = resDataSet.filter("workcenter=null or workcenter=0");
        wcResDataSet = actRateDataSetCopy.copy().join(wcResDataSet, JoinType.INNER).on("workcenter", "workcenter").on("resource", "resource").select(new String[]{"costdriver", "costcenterid", "workcenter", "matchpattern", "resourcetype"}, new String[]{"period", "resource", "calcbasis", "resourceunit", "costtype", "element", "subelement", "org", "qty"}).finish();
        Set<Long> resourceIds = this.getReourceIds(wcResDataSet.copy());
        if (CadEmptyUtils.isEmpty(resourceIds)) {
            nwcResDataSet = actRateDataSetCopy.copy().join(nwcResDataSet, JoinType.INNER).on("resource", "resource").select(new String[]{"costdriver", "costcenterid", "workcenter", "matchpattern", "resourcetype"}, new String[]{"period", "resource", "calcbasis", "resourceunit", "costtype", "element", "subelement", "org", "qty"}).finish();
        } else {
            DataSet actRateDataSet = actRateDataSetCopy.copy().filter("(workcenter=null or workcenter=0) or (workcenter!=null and workcenter>0 and resource not in (" + StringUtils.join(resourceIds, (String)",") + "))");
            nwcResDataSet = actRateDataSet.join(nwcResDataSet, JoinType.INNER).on("resource", "resource").select(new String[]{"costdriver", "costcenterid", "workcenter", "matchpattern", "resourcetype"}, new String[]{"period", "resource", "calcbasis", "resourceunit", "costtype", "element", "subelement", "org", "qty"}).finish();
        }
        resDataSet = nwcResDataSet == null ? wcResDataSet : wcResDataSet.union(nwcResDataSet);
        return resDataSet;
    }

    private DataSet getResourceRateDataSet(Set<Long> costTypes, Long periodId, Date date) {
        String queryFileds = "id,billno,effectdate,expdate,workcenter,resource.id as resource,calcbasis,resourceunit,qty,costtype,element,subelement," + periodId.toString() + "L as period";
        DataSet resourceDataSet = this.getResource(costTypes, queryFileds, periodId, date);
        String queryAttaFileds = "id,billno,effectdate,expdate,workcenter,resource.id as resource,calcbasis,resourceunit,entryentity.attaqty qty,costtype,entryentity.attaelement element,entryentity.attasubelement subelement," + periodId.toString() + "L as period";
        DataSet resourceAtta = this.getResourceAtta(costTypes, queryAttaFileds, periodId, date);
        resourceDataSet = resourceDataSet.union(resourceAtta);
        String queryPeriodGroups = "resource,subelement,costtype,workcenter";
        String queryPeriodFields = queryPeriodGroups + ",effectdate,expdate,billno";
        DataSet calcQueryPeriodDataSet = resourceDataSet.copy().select(queryPeriodFields.split(",")).orderBy(new String[]{"billno desc"}).groupBy(queryPeriodGroups.split(",")).maxP("expdate", "effectdate").maxP("expdate", "billno").max("expdate").finish();
        resourceDataSet = resourceDataSet.join(calcQueryPeriodDataSet, JoinType.INNER).on("billno", "billno").on("costtype", "costtype").on("workcenter", "workcenter").on("resource", "resource").on("subelement", "subelement").on("effectdate", "effectdate").on("expdate", "expdate").select(resourceDataSet.getRowMeta().getFieldNames(), null).finish();
        return resourceDataSet;
    }

    private DataSet getCostDriverResDataSet() {
        ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
        filter.add(new QFilter("status", "=", (Object)"C"));
        filter.add(new QFilter("enable", "=", (Object)"1"));
        filter.add(new QFilter("islinkresource", "=", (Object)Boolean.TRUE));
        QFilter resTypeFilter = new QFilter("matchpattern", "=", (Object)"resource");
        filter.add(resTypeFilter);
        DataSet resourceDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getCostDriverDataSet", (String)"cad_costdriver", (String)"id as costdriver,matchpattern,resource.fbasedataid as resource,resourcetype", (QFilter[])filter.toArray(new QFilter[0]), null);
        resourceDataSet = resourceDataSet.select("costdriver,matchpattern,resource,resourcetype");
        filter.remove(resTypeFilter);
        resTypeFilter = new QFilter("matchpattern", "=", (Object)"resourcetype");
        filter.add(resTypeFilter);
        DataSet resourceTypeDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getCostDriverDataSet", (String)"cad_costdriver", (String)"id as costdriver,matchpattern,resource.fbasedataid as resource,resourcetype", (QFilter[])filter.toArray(new QFilter[0]), null);
        resourceTypeDataSet = resourceTypeDataSet.select("costdriver,matchpattern,resource,resourcetype");
        resourceTypeDataSet = this.dealMulSourceType(resourceTypeDataSet);
        return resourceDataSet.union(resourceTypeDataSet);
    }

    private DataSet getTransUnitDataSet(DataSet resDataSet) {
        HashSet<Long> resUnits = new HashSet<Long>(10);
        Long costType = 0L;
        while (resDataSet.hasNext()) {
            Row row = resDataSet.next();
            Long resourceunit = row.getLong("resourceunit");
            if (CadEmptyUtils.isEmpty((Long)resourceunit)) continue;
            if (CadEmptyUtils.isEmpty((Long)costType)) {
                costType = row.getLong("costtype");
            }
            resUnits.add(resourceunit);
        }
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(10);
        for (Long resUnit : resUnits) {
            BigDecimal minuteQty = TimeConverter.convertPriceByConversionFactor((long)resUnit, (long)9L, (BigDecimal)new BigDecimal(60));
            Object[] object = new Object[]{resUnit, minuteQty};
            objectList.add(object);
        }
        return Algo.create((String)"macc-cad-rpt").createDataSet(objectList.iterator(), this.getTransUnitRowMeta());
    }

    private RowMeta getTransUnitRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("resourceunit", (DataType)DataType.LongType));
        field.add(new Field("transunitqty", (DataType)DataType.BigDecimalType));
        return new RowMeta(field.toArray(new Field[0]));
    }

    private DataSet dealMulSourceType(DataSet resourceTypeDataSet) {
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        resourceTypeDataSet = resourceTypeDataSet.addField("resourcetype", "realresourcetype");
        RowMeta rowMeta = resourceTypeDataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        for (Row row : resourceTypeDataSet) {
            String resourcetype = row.getString("resourcetype");
            if (resourcetype.charAt(0) == ',') {
                resourcetype = resourcetype.substring(1);
            }
            String[] types = resourcetype.split(",");
            String realResourceType = this.getResTypeName(types);
            for (String str : types) {
                if (CadEmptyUtils.isEmpty((String)str)) continue;
                Object[] rowData = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object val;
                    rowData[i] = val = row.get(i);
                }
                rowData[3] = str;
                rowData[4] = realResourceType;
                datasetlist.add(rowData);
            }
        }
        resourceTypeDataSet = Algo.create((String)"resourcetype").createDataSet(datasetlist.iterator(), rowMeta).select("costdriver,matchpattern,resource,case when resourcetype='A' then 'mpdm_equipment' when resourcetype='B' then 'mpdm_toolsresource' when resourcetype='C' then 'mpdm_toolequip' when resourcetype='D' then 'mpdm_mould' when resourcetype='E' then 'mpdm_manuperson' end resourcetype,realresourcetype");
        DataSet resoureAndType = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid,resourcesentryentity.itemclasstype resourcetype", null, null);
        resourceTypeDataSet = resourceTypeDataSet.join(resoureAndType, JoinType.INNER).on("resourcetype", "resourcetype").select(resourceTypeDataSet.getRowMeta().getFieldNames(), new String[]{"resourceid"}).finish();
        resourceTypeDataSet = resourceTypeDataSet.groupBy(new String[]{"costdriver", "matchpattern", "resourceid", "realresourcetype"}).finish().select("costdriver,matchpattern,resourceid resource,realresourcetype resourcetype");
        return resourceTypeDataSet;
    }

    private String getResTypeName(String[] types) {
        StringBuilder realType = new StringBuilder();
        block14: for (String str : types) {
            realType.append("\uff0c");
            switch (str) {
                case "A": {
                    realType.append(ResManager.loadKDString((String)"\u8bbe\u5907\u8d44\u6e90", (String)"ActualRateAnalyRptQuery_2", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "B": {
                    realType.append(ResManager.loadKDString((String)"\u5de5\u5177\u8d44\u6e90", (String)"ActualRateAnalyRptQuery_3", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "C": {
                    realType.append(ResManager.loadKDString((String)"\u5de5\u88c5\u8d44\u6e90", (String)"ActualRateAnalyRptQuery_4", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "D": {
                    realType.append(ResManager.loadKDString((String)"\u6a21\u5177\u8d44\u6e90", (String)"ActualRateAnalyRptQuery_5", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "E": {
                    realType.append(ResManager.loadKDString((String)"\u5236\u9020\u4eba\u5458", (String)"ActualRateAnalyRptQuery_6", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
            }
        }
        return realType.toString().substring(1);
    }

    private DataSet getCostCenterDataSet(Set<Long> costCenterIds, List<Object> queryPeriodIds) {
        DataSet resDataSet = null;
        QFilter costCenterFilter = new QFilter("costcenter", "in", costCenterIds);
        QFilter srcTypeFilter = new QFilter("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
        for (Object queryPeriodId : queryPeriodIds) {
            Date[] periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)Long.parseLong(queryPeriodId.toString()));
            if (periodtime == null) continue;
            QFilter timeFilter = new QFilter("effectdate", "<=", (Object)periodtime[1]);
            timeFilter.and(new QFilter("expdate", ">", (Object)periodtime[1]));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getCostWorkCenterDataSet", (String)"bos_costcentersourcemap", (String)("costcenter,entryentity.sourcedata.id workcenter," + queryPeriodId.toString() + "L as period"), (QFilter[])new QFilter[]{costCenterFilter, srcTypeFilter, timeFilter}, null);
            if (resDataSet == null) {
                resDataSet = dataSet;
                continue;
            }
            resDataSet = DataSetUtils.union((DataSet)resDataSet, (DataSet)dataSet);
        }
        if (resDataSet != null) {
            resDataSet = resDataSet.distinct();
        }
        return resDataSet;
    }

    private Set<Long> getCostCenters(FilterInfo filterInfo) {
        DynamicObjectCollection mulCostCenters = filterInfo.getDynamicObjectCollection("mulcostcenter");
        HashSet costCenterIds = new HashSet(10);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulCostCenters)) {
            mulCostCenters.forEach(p -> costCenterIds.add(p.getLong("id")));
        }
        DynamicObject org = filterInfo.getDynamicObject("org");
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            orgFilter.and(new QFilter("id", "in", costCenterIds));
        } else {
            orgFilter.and(new QFilter("orgduty", "=", (Object)4L));
        }
        orgFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{orgFilter});
        return DynamicObjectHelper.getIdSet((DynamicObjectCollection)dynamicObjects, (String)"id");
    }

    private List<QFilter> getQFilters(FilterInfo filterInfo, Set<Long> costCenters) {
        DynamicObjectCollection mulSubElements;
        DynamicObject costaccount;
        String appId = filterInfo.getString("appnum");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        DynamicObject org = filterInfo.getDynamicObject("org");
        if (org != null) {
            filterList.add(new QFilter("org", "=", (Object)org.getLong("id")));
        }
        if (costCenters != null) {
            filterList.add(new QFilter("benefcostcenter", "in", costCenters));
        }
        if ((costaccount = filterInfo.getDynamicObject("costaccount")) != null) {
            filterList.add(new QFilter("costaccount", "=", (Object)costaccount.getLong("id")));
        }
        DynamicObject startperiod = filterInfo.getDynamicObject("startperiod");
        DynamicObject endperiod = filterInfo.getDynamicObject("endperiod");
        if (startperiod != null && endperiod != null) {
            filterList.add(new QFilter("period", ">=", (Object)startperiod.getLong("id")));
            filterList.add(new QFilter("period", "<=", (Object)endperiod.getLong("id")));
        }
        DynamicObjectCollection prodorgs = filterInfo.getDynamicObjectCollection("mulprodorg");
        if (this.enableMulFactory.booleanValue() && prodorgs != null) {
            ArrayList manuOrgList = new ArrayList(16);
            prodorgs.forEach(p -> manuOrgList.add(p.getLong("id")));
            filterList.add(new QFilter("manuorg", "in", manuOrgList));
        } else if (this.enableMulFactory.booleanValue() && org != null) {
            String entityId = filterInfo.getString("entityId");
            List manuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)entityId, (String)appId);
            filterList.add(new QFilter("manuorg", "in", (Object)manuOrgs));
        }
        ArrayList elements = new ArrayList(10);
        ArrayList subElements = new ArrayList(10);
        DynamicObjectCollection mulElements = filterInfo.getDynamicObjectCollection("mulelement");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulElements)) {
            mulElements.forEach(p -> elements.add(p.getLong("id")));
        }
        if ((mulSubElements = filterInfo.getDynamicObjectCollection("mulsubelement")) != null && mulSubElements.size() > 0) {
            mulSubElements.forEach(p -> subElements.add(p.getLong("id")));
        }
        if (!CadEmptyUtils.isEmpty(elements)) {
            filterList.add(new QFilter("element", "in", elements));
        }
        if (!CadEmptyUtils.isEmpty(subElements)) {
            filterList.add(new QFilter("subelement", "in", subElements));
        }
        filterList.add(new QFilter("subelement.type", "in", (Object)new String[]{"001", "002", "003", "004"}));
        return filterList;
    }

    private void init(FilterInfo filterInfo) {
        DynamicObject currency;
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        if (costaccount != null) {
            this.enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.parseLong(costaccount.getPkValue().toString()));
        }
        if ((currency = filterInfo.getDynamicObject("currency")) != null) {
            this.currencyId = currency.getLong("id");
        }
    }

    private Boolean isQueryByPeriod() {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        Date queryDate = filterInfo.getDate("querydate");
        if (queryDate != null) {
            return Boolean.FALSE;
        }
        DynamicObject queryPeriod = filterInfo.getDynamicObject("queryperiod");
        if (queryPeriod == null) {
            return Boolean.FALSE;
        }
        Long queryPeriodId = queryPeriod.getLong("id");
        if (queryPeriodId != 0L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private DataSet getResource(Set<Long> costTypes, String selectFields, Long periodId, Date date) {
        Date[] periodtime;
        String algoKey = "getResource";
        QFilter costTypeFilter = new QFilter("costtype", "in", costTypes);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)date);
        timeFilter.and("expdate", ">=", (Object)date);
        if (!CadEmptyUtils.isEmpty((Long)periodId) && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)periodId)) != null) {
            timeFilter = CostUpdateHelper.getPeriodQFilter((Date[])periodtime);
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_resourcerate", (String)selectFields, (QFilter[])new QFilter[]{costTypeFilter, statusFilter, timeFilter}, null);
    }

    private DataSet getResourceAtta(Set<Long> costTypes, String selectFields, Long periodId, Date date) {
        Date[] periodtime;
        String algoKey = "getResourceAtta";
        QFilter costTypeFilter = new QFilter("costtype", "in", costTypes);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)date);
        timeFilter.and("expdate", ">=", (Object)date);
        if (!CadEmptyUtils.isEmpty((Long)periodId) && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)periodId)) != null) {
            timeFilter = CostUpdateHelper.getPeriodQFilter((Date[])periodtime);
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_resourcerate", (String)selectFields, (QFilter[])new QFilter[]{costTypeFilter, statusFilter, timeFilter}, null);
    }

    private DataSet dealResourceShow(DataSet dataSet) {
        HashMap<Long, Set> costDriverResIdMap = new HashMap<Long, Set>(16);
        HashMap<Long, String> costDriverResStrMap = new HashMap<Long, String>(16);
        while (dataSet.hasNext()) {
            String res;
            Row row = dataSet.next();
            Long costdriver = row.getLong("costdriver");
            Long resourceid = row.getLong("resourceid");
            String string = res = row.getString("resource") == null ? "" : row.getString("resource");
            if (!costDriverResStrMap.containsKey(costdriver)) {
                costDriverResStrMap.put(costdriver, res);
            } else {
                Set resIds = (Set)costDriverResIdMap.get(costdriver);
                if (resIds.contains(resourceid)) continue;
                String oldRes = (String)costDriverResStrMap.get(costdriver);
                if (!CadEmptyUtils.isEmpty((String)res)) {
                    res = oldRes + "/" + res;
                }
                costDriverResStrMap.put(costdriver, res);
            }
            costDriverResIdMap.computeIfAbsent(costdriver, p -> new HashSet()).add(resourceid);
        }
        costDriverResIdMap.clear();
        return this.structCostDriverResDataSet(costDriverResStrMap);
    }

    private DataSet structCostDriverResDataSet(Map<Long, String> costDriverResStrMap) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, String> entry : costDriverResStrMap.entrySet()) {
            Object[] object = new Object[]{entry.getKey(), entry.getValue()};
            objectList.add(object);
        }
        costDriverResStrMap.clear();
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("costdriver", (DataType)DataType.LongType), new Field("resourcestr", (DataType)DataType.StringType)});
        return Algo.create((String)"macc-cad-rpt").createDataSet(objectList.iterator(), rowMeta);
    }

    private DataSet getManuOrgAndCostTypeDataSet(FilterInfo filterInfo, Date date) {
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        DataSet costTypeDataSet = this.getCostTypeDataSet(org == null ? 0L : org.getLong("id"), costAccount == null ? 0L : costAccount.getLong("id"), this.enableMulFactory, date);
        if (!this.enableMulFactory.booleanValue()) {
            return costTypeDataSet;
        }
        String appId = filterInfo.getString("appnum");
        HashSet<Long> manuOrgIds = new HashSet<Long>(10);
        DynamicObjectCollection prodorgs = filterInfo.getDynamicObjectCollection("mulprodorg");
        if (this.enableMulFactory.booleanValue() && prodorgs != null) {
            ArrayList manuOrgList = new ArrayList(16);
            prodorgs.forEach(p -> manuOrgList.add(p.getLong("id")));
            manuOrgIds.addAll(manuOrgList);
        } else if (this.enableMulFactory.booleanValue() && org != null) {
            String entityId = filterInfo.getString("entityId");
            List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)entityId, (String)appId);
            manuOrgIds.addAll(manuOrg);
        }
        DataSet invOrgDataSet = this.getInvOrgDataSetByProOrgs(manuOrgIds);
        DataSet result = invOrgDataSet.join(costTypeDataSet, JoinType.INNER).on("invorg", "invorg").select(new String[]{"manuorg"}, new String[]{"costtype"}).finish();
        return result.groupBy(result.getRowMeta().getFieldNames()).finish().select("manuorg as org,costtype");
    }

    private DataSet getCostTypeDataSet(Long orgId, Long costAccountId, Boolean isMulFactory, Date date) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        if (!isMulFactory.booleanValue()) {
            filter.and(new QFilter("calorg", "=", (Object)orgId));
        }
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)date);
        timeFilter.and("invaliddate", ">", (Object)date);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery.getCostTypeDataSet", (String)"cal_bd_costtypeorg", (String)"calorg org,storageorgunit invorg,costaccount,costtype", (QFilter[])new QFilter[]{filter, timeFilter}, null);
        return dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
    }

    private DataSet getInvOrgDataSetByProOrgs(Set<Long> manuOrgIds) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>();
        for (Long manuOrgId : manuOrgIds) {
            List invOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrgId, (boolean)true);
            for (Long invOrg : invOrgs) {
                Object[] object = new Object[]{manuOrgId, invOrg};
                objectList.add(object);
            }
        }
        return Algo.create((String)"macc-cad-rpt").createDataSet(objectList.iterator(), this.getProAndInvOrgRowMeta());
    }

    private RowMeta getProAndInvOrgRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("manuorg", (DataType)DataType.LongType));
        field.add(new Field("invorg", (DataType)DataType.LongType));
        return new RowMeta(field.toArray(new Field[0]));
    }
}

