/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.function.TimeConverter;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import org.apache.commons.lang.StringUtils;

public class ActualRateRptQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ActualRateRptQuery.class);
    private static final String TOP = "top";
    private static final String PERIOD_ID = "periodid";
    private static final String COST_CENTER = "costcenter";
    private static final String ENTRY_PRODORG = "entryprodorg";
    private static final String ELEMENT = "element";
    private static final String SUBELEMENT = "subelement";
    private Date queryDate = null;
    private Long orgId = 0L;
    private Long currencyId = 0L;
    private Long costAccountId = 0L;
    private Boolean enableMulFactory = Boolean.FALSE;
    private Set<Long> manuOrgIds = new HashSet<Long>(16);
    private static String[] groupFields = new String[]{"org", "costaccount", "periodid", "period", "costcenter", "costcentername", "costdriver", "workactivity", "element", "subelement", "resource", "resourcetype", "costdriverunit", "entrycurrency"};
    private static String[] mulGroupFields = new String[]{"org", "entryprodorg", "costaccount", "periodid", "period", "costcenter", "costcentername", "costdriver", "workactivity", "element", "subelement", "resource", "resourcetype", "costdriverunit", "entrycurrency"};
    private final String[] orderByFields = new String[]{"top", "periodid", "costcenter", "element", "subelement"};
    private final String[] multipleOrderByFields = new String[]{"top", "periodid", "costcenter", "entryprodorg", "element", "subelement"};
    private List<String> groupByAvgProps = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "periodid", "period", "costcenter", "costcentername", "element", "subelement", "resource", "resourcetype", "costdriverunit", "entrycurrency", "top", "costdriver"});

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Boolean isPeriodAvg = filterInfo.getBoolean("isperiodavg");
        this.init(filterInfo);
        Map<Long, Long> costCenters = this.getCostCenters(filterInfo);
        ArrayList<Long> auxiliaryProduction = new ArrayList<Long>(10);
        ArrayList<Long> basicProduction = new ArrayList<Long>(10);
        this.groupingCostCenters(costCenters, auxiliaryProduction, basicProduction);
        DynamicObjectCollection mulElements = filterInfo.getDynamicObjectCollection("mulelement");
        DataSet auxiliaryProductionDataSet = null;
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulElements)) {
            auxiliaryProductionDataSet = this.getAuxiliaryProductionDataSet(filterInfo, auxiliaryProduction);
        }
        DataSet basicProductionDataSet = this.getBasicProductionDataSet(filterInfo, basicProduction);
        DataSet resultDataSet = auxiliaryProductionDataSet == null ? basicProductionDataSet : auxiliaryProductionDataSet.union(basicProductionDataSet);
        Object[] fieldNames = resultDataSet.getRowMeta().getFieldNames();
        StringBuilder sb = new StringBuilder();
        for (String string : fieldNames) {
            if ("allocstdamt".equals(string)) {
                if (sb.toString().isEmpty()) {
                    sb.append("allocstdamt/60 as allocstdamt");
                    continue;
                }
                sb.append(",allocstdamt/60 as allocstdamt");
                continue;
            }
            if ("actualrate".equals(string)) {
                if (sb.toString().isEmpty()) {
                    sb.append("case when allocstdamt=0 then 0 else collectamt/(allocstdamt/60) end actualrate");
                    continue;
                }
                sb.append(",case when allocstdamt=0 then 0 else collectamt/(allocstdamt/60) end actualrate");
                continue;
            }
            if ("standardrate".equals(string)) {
                if (sb.toString().isEmpty()) {
                    sb.append("standardrate*60 as standardrate");
                    continue;
                }
                sb.append(",standardrate*60 as standardrate");
                continue;
            }
            if (sb.toString().isEmpty()) {
                sb.append(string);
                continue;
            }
            sb.append(",").append(string);
        }
        resultDataSet = resultDataSet.select(sb.toString());
        String name = StringUtils.join((Object[])fieldNames, (String)",");
        resultDataSet = resultDataSet.select(name + ",round(actualrate-standardrate,10) ratediff,case when standardrate=0 then '' else concat(round(abs(actualrate-standardrate)*100/standardrate,2),'%') end ratediffabs");
        if (isPeriodAvg.booleanValue()) {
            resultDataSet = resultDataSet.removeFields(new String[]{"workactivity"});
            String manuorgField = "";
            if (this.enableMulFactory.booleanValue()) {
                this.groupByAvgProps.add(ENTRY_PRODORG);
                manuorgField = "entryprodorg,";
            }
            resultDataSet = resultDataSet.groupBy(this.groupByAvgProps.toArray(new String[0])).sum("collectamt").sum("allocstdamt").avg("standardrate").finish();
            resultDataSet = resultDataSet.select("org," + manuorgField + "costaccount,periodid,period,costcenter,costcentername,element,subelement,resource,resourcetype,costdriverunit,entrycurrency,top,costdriver,standardrate,collectamt,allocstdamt,case when (allocstdamt is null or allocstdamt=0) then 0 else collectamt/allocstdamt end avgactualrate");
            this.groupByAvgProps.remove(PERIOD_ID);
            this.groupByAvgProps.remove("period");
            resultDataSet = resultDataSet.groupBy(this.groupByAvgProps.toArray(new String[0])).sum("collectamt").sum("allocstdamt").avg("standardrate").sum("avgactualrate").count(PERIOD_ID).finish();
            resultDataSet = resultDataSet.select("org," + manuorgField + "costaccount,costcenter,costcentername,element,subelement,resource,resourcetype,costdriverunit,entrycurrency,top,costdriver,collectamt,allocstdamt,standardrate,avgactualrate/periodid avgactualrate,round(avgactualrate/periodid-standardrate,10) ratediff,case when standardrate=0 then '' else concat(round(abs(avgactualrate-standardrate)*100/periodid/standardrate,2),'%') end ratediffabs");
            DataSet sumDataSet = this.dealAvgTotalSumDataSet(resultDataSet);
            resultDataSet = DataSetUtils.union((DataSet)resultDataSet, (DataSet)sumDataSet);
            if (this.enableMulFactory.booleanValue()) {
                return resultDataSet.orderBy(new String[]{TOP, COST_CENTER, ENTRY_PRODORG, ELEMENT, SUBELEMENT});
            }
            return resultDataSet.orderBy(new String[]{TOP, COST_CENTER, ELEMENT, SUBELEMENT});
        }
        DataSet subSumDataSet = this.dealSubSumDataSet(resultDataSet);
        DataSet sumDataSet = this.dealTotalSumDataSet(resultDataSet);
        DataSet dataSet = DataSetUtils.union((DataSet)DataSetUtils.union((DataSet)resultDataSet, (DataSet)subSumDataSet), (DataSet)sumDataSet);
        if (this.enableMulFactory.booleanValue()) {
            return dataSet.orderBy(this.multipleOrderByFields);
        }
        return dataSet.orderBy(this.orderByFields);
    }

    private DataSet dealSubSumDataSet(DataSet resultDataSet) {
        String CAD_SUBSUMTOTAL = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"ActualRateRptQuery_7", (String)"macc-cad-report", (Object[])new Object[0]);
        DataSet dataSet = resultDataSet.copy();
        String manuorgField = this.enableMulFactory != false ? "0 as entryprodorg," : "";
        String selectFields = "0 as org," + manuorgField + "0 as costaccount,periodid,period,'" + CAD_SUBSUMTOTAL + "' as costcenter,'' as costcentername,0 as costdriver,0 as workactivity,0 as element,0 as subelement,'' as resource,'' as resourcetype,0 as costdriverunit," + this.currencyId + " as entrycurrency,collectamt,allocstdamt,actualrate,standardrate,(actualrate - standardrate) ratediff,case when standardrate=0 then '' else concat(round(abs(actualrate-standardrate)*100/standardrate,2),'%') end ratediffabs";
        dataSet = dataSet.groupBy(new String[]{PERIOD_ID, "period"}).sum("collectamt").sum("allocstdamt").sum("actualrate").sum("standardrate").finish().select(selectFields).addField("0", TOP);
        return dataSet;
    }

    private DataSet dealAvgTotalSumDataSet(DataSet resultDataSet) {
        String CAD_SUMTOTAL = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ActualRateRptQuery_8", (String)"macc-cad-report", (Object[])new Object[0]);
        DataSet dataSet = resultDataSet.copy();
        String manuorgField = this.enableMulFactory != false ? "0 as entryprodorg," : "";
        String selectFields = "0 as org," + manuorgField + "0 as costaccount,'" + CAD_SUMTOTAL + "' as costcenter,'' as costcentername,0 as costdriver,0 as element,0 as subelement,'' as resource,'' as resourcetype,0 as costdriverunit," + this.currencyId + " as entrycurrency,collectamt,allocstdamt,standardrate,avgactualrate,(avgactualrate - standardrate) as ratediff,case when standardrate=0 then '' else concat(round(abs(avgactualrate-standardrate)*100/standardrate,2),'%') end ratediffabs";
        dataSet = dataSet.groupBy(new String[]{"org"}).sum("collectamt").sum("allocstdamt").sum("avgactualrate").sum("standardrate").finish().select(selectFields).addField("2", TOP);
        return dataSet;
    }

    private DataSet dealTotalSumDataSet(DataSet resultDataSet) {
        String CAD_SUMTOTAL = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ActualRateRptQuery_8", (String)"macc-cad-report", (Object[])new Object[0]);
        DataSet dataSet = resultDataSet.copy();
        String manuorgField = this.enableMulFactory != false ? "0 as entryprodorg," : "";
        String selectFields = "0 as org," + manuorgField + "0 as costaccount,0 as periodid,'" + CAD_SUMTOTAL + "' as period,'' as costcenter,'' as costcentername,0 as costdriver,0 as workactivity,0 as element,0 as subelement,'' as resource,'' as resourcetype,0 as costdriverunit," + this.currencyId + " as entrycurrency,collectamt,allocstdamt,actualrate,standardrate,(actualrate - standardrate) as ratediff,case when standardrate=0 then '' else concat(round(abs(actualrate-standardrate)*100/standardrate,2),'%') end ratediffabs";
        dataSet = dataSet.groupBy(new String[]{"org"}).sum("collectamt").sum("allocstdamt").sum("actualrate").sum("standardrate").finish().select(selectFields).addField("2", TOP);
        return dataSet;
    }

    private DataSet getBasicProductionDataSet(FilterInfo filterInfo, List<Long> basicProduction) {
        QFilter filter = this.getQFilters(filterInfo, Boolean.TRUE, basicProduction);
        DataSet costDriverDataSet = this.getResourceDataSet(filterInfo);
        DataSet basicProductionDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getBasicProductionDataSet", (String)"cad_mfgfeeallocco", (String)("id,org,costaccount,manuorg as entryprodorg,period as periodid,period.name as period,benefcostcenter costcenterid,benefcostcenter.number as costcenter,benefcostcenter.name as costcentername,costdriver as costdriver,element,subelement,0 as workactivity,amount as collectamt,baseunit as costdriverunit,costdriverqty as allocstdamt,actualrate," + this.currencyId + " as entrycurrency"), (QFilter[])filter.toArray(), null);
        basicProductionDataSet = this.enableMulFactory == false ? basicProductionDataSet.join(costDriverDataSet, JoinType.LEFT).on("org", "org").on("costcenterid", COST_CENTER).on("costdriver", "costdriver").on(SUBELEMENT, SUBELEMENT).select(basicProductionDataSet.getRowMeta().getFieldNames(), new String[]{"matchpattern", "resource", "resourcetype", "qty"}).finish() : basicProductionDataSet.join(costDriverDataSet, JoinType.LEFT).on(ENTRY_PRODORG, "org").on("costcenterid", COST_CENTER).on("costdriver", "costdriver").on(SUBELEMENT, SUBELEMENT).select(basicProductionDataSet.getRowMeta().getFieldNames(), new String[]{"matchpattern", "resource", "resourcetype", "qty"}).finish();
        basicProductionDataSet = basicProductionDataSet.groupBy(basicProductionDataSet.getRowMeta().getFieldNames()).finish().filter("costdriver != null");
        DynamicObject org = filterInfo.getDynamicObject("org");
        QFilter resourceUsefilter = new QFilter(COST_CENTER, "in", basicProduction);
        resourceUsefilter.and("appnum", "=", (Object)"sca");
        if (org != null) {
            resourceUsefilter.and(new QFilter("org", "=", (Object)org.getLong("id")));
        }
        DataSet resourceUseData = QueryServiceHelper.queryDataSet((String)"sca_resourceuse", (String)"sca_resourceuse", (String)"costcenter,resource", (QFilter[])resourceUsefilter.toArray(), null);
        resourceUseData = resourceUseData.groupBy(resourceUseData.getRowMeta().getFieldNames()).finish();
        DataSet resource_is_null = basicProductionDataSet.filter("resource is null");
        DataSet resource_is_not_null = basicProductionDataSet.filter("resource is not null");
        resource_is_not_null = resource_is_not_null.join(resourceUseData, JoinType.INNER).on("costcenterid", COST_CENTER).on("resource", "resource").select(basicProductionDataSet.getRowMeta().getFieldNames()).finish();
        resource_is_not_null = resource_is_not_null.select("id,org,costaccount,entryprodorg,periodid,period,costcenterid,costcenter,costcentername,costdriver,element,subelement,workactivity,collectamt,costdriverunit,allocstdamt,actualrate,entrycurrency,matchpattern,case when matchpattern='resourcetype' then 0L else resource end resource,resourcetype,qty");
        String groupFields = "id,org,costaccount,entryprodorg,periodid,period,costcenterid,costcenter,costcentername,costdriver,element,subelement,workactivity,collectamt,costdriverunit,allocstdamt,actualrate,entrycurrency,matchpattern,resource,resourcetype";
        basicProductionDataSet = resource_is_null.union(resource_is_not_null);
        basicProductionDataSet = basicProductionDataSet.groupBy(groupFields.split(",")).sum("qty").finish();
        DataSet resoureMpdm = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid,name as resource", null, null);
        DataSet dataSet = basicProductionDataSet.join(resoureMpdm, JoinType.LEFT).on("resource", "resourceid").select(new String[]{"id", "org", "costaccount", ENTRY_PRODORG, PERIOD_ID, "period", "costcenterid", COST_CENTER, "costcentername", "costdriver", ELEMENT, SUBELEMENT, "workactivity", "collectamt", "costdriverunit", "allocstdamt", "actualrate", "entrycurrency", " matchpattern", "resourcetype", "qty"}, new String[]{"resource"}).finish().select("id,org,costaccount,entryprodorg,periodid,period,costcenterid,costcenter,costcentername,costdriver,element,subelement,workactivity,collectamt,costdriverunit,allocstdamt,actualrate,entrycurrency,matchpattern,case when resource is null then '' else resource end resource,resourcetype,case when qty is null then 0 else qty end qty");
        DataSet resultDataSet = this.dealResourceShow(dataSet);
        return resultDataSet.groupBy(this.enableMulFactory != false ? mulGroupFields : ActualRateRptQuery.groupFields).sum("collectamt").sum("allocstdamt").sum("actualrate").sum("qty", "standardrate").finish().addField("0", TOP);
    }

    private DataSet getAuxiliaryProductionDataSet(FilterInfo filterInfo, List<Long> basicProduction) {
        QFilter filter = this.getQFilters(filterInfo, Boolean.FALSE, basicProduction);
        DataSet costDriverDataSet = this.getCostDriverDataSet();
        DataSet auxiliaryProductionDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getAuxiliaryProductionDataSet", (String)"cad_auxprodalloc", (String)("id,org,costaccount,manuorg as entryprodorg,period as periodid,period.name as period,costcenter.number as costcenter,costcenter.name as costcentername,allocmethod,comentity.costdriver as costdriver,0 as element,0 as subelement,'' as resource,'' as resourcetype,0 as standardrate,case when allocmethod!='mutual'then comentity.actualrate else comentity.actualoutrate end actualrate,comentity.baseunit as costdriverunit,comentity.costdriverqty as allocstdamt,comentity.allocamount as collectamt," + this.currencyId + " as entrycurrency"), (QFilter[])filter.toArray(), null);
        DataSet dataSet = auxiliaryProductionDataSet.join(costDriverDataSet, JoinType.LEFT).on("costdriver", "costdriver").select(auxiliaryProductionDataSet.getRowMeta().getFieldNames(), new String[]{"workactivity"}).finish();
        dataSet = dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish().filter("costdriver != null and workactivity != null");
        return dataSet.groupBy(this.enableMulFactory != false ? mulGroupFields : groupFields).sum("collectamt").sum("allocstdamt").sum("actualrate").sum("standardrate").finish().addField("0", TOP);
    }

    private DataSet getCostDriverDataSet() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("isrelatedwork", "=", (Object)Boolean.TRUE));
        return QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getCostDriverDataSet", (String)"cad_costdriver", (String)"id as costdriver,workactivity.id workactivity", (QFilter[])filter.toArray(), null);
    }

    private DataSet getResourceDataSet(FilterInfo filterInfo) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
        filter.add(new QFilter("status", "=", (Object)"C"));
        filter.add(new QFilter("enable", "=", (Object)"1"));
        filter.add(new QFilter("islinkresource", "=", (Object)Boolean.TRUE));
        QFilter resTypeFilter = new QFilter("matchpattern", "=", (Object)"resource");
        filter.add(resTypeFilter);
        DataSet resourceDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getCostDriverDataSet", (String)"cad_costdriver", (String)"id as costdriver,matchpattern,resource.fbasedataid as resource,resourcetype", (QFilter[])filter.toArray(new QFilter[0]), null);
        resourceDataSet = resourceDataSet.select("costdriver,matchpattern,resource,resourcetype");
        filter.remove(resTypeFilter);
        resTypeFilter = new QFilter("matchpattern", "=", (Object)"resourcetype");
        filter.add(resTypeFilter);
        DataSet resourceTypeDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getCostDriverDataSet", (String)"cad_costdriver", (String)"id as costdriver,matchpattern,resource.fbasedataid as resource,resourcetype", (QFilter[])filter.toArray(new QFilter[0]), null);
        resourceTypeDataSet = resourceTypeDataSet.select("costdriver,matchpattern,resource,resourcetype");
        resourceTypeDataSet = this.dealMulSourceType(resourceTypeDataSet);
        Boolean isQueryPeriod = this.isQueryByPeriod();
        DataSet manuOrgAndCostTypeDataSet = this.getManuOrgAndCostTypeDataSet(this.orgId, this.manuOrgIds, this.costAccountId, this.enableMulFactory, new Date());
        DataSet costWorkCenterDataSet = this.getCostWorkCenterDataSet(this.orgId, new Date());
        if (isQueryPeriod.booleanValue()) {
            DynamicObject startPeriod = filterInfo.getDynamicObject("queryperiod");
            DynamicObject endPeriod = filterInfo.getDynamicObject("queryperiodend");
            List queryPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
            DataSet resDataSet = null;
            for (Object queryPeriodId : queryPeriodIds) {
                Long periodId = Long.valueOf(queryPeriodId + "");
                String queryFileds = "id,effectdate,workcenter,resource.id as resource,calcbasis,resourceunit,qty,0 as workactivity,costtype,element,subelement," + periodId + " as period";
                DataSet resourcedataSet = this.getResource(isQueryPeriod, queryFileds, periodId);
                String queryAttaFileds = "id,effectdate,workcenter,resource.id as resource,calcbasis,resourceunit,entryentity.attaqty qty,0 as workactivity,costtype,entryentity.attaelement element,entryentity.attasubelement subelement," + periodId + " as period";
                DataSet resourceAtta = this.getResourceAtta(isQueryPeriod, queryAttaFileds, periodId);
                resourcedataSet = resourcedataSet.union(resourceAtta);
                DataSet dataSet = manuOrgAndCostTypeDataSet.copy().join(resourcedataSet, JoinType.INNER).on("costtype", "costtype").select(new String[]{"id", "effectdate", "workcenter", "resource", "calcbasis", "resourceunit", "qty", "workactivity", ELEMENT, SUBELEMENT}, new String[]{"org", "costtype"}).finish();
                dataSet = dataSet.join(costWorkCenterDataSet.copy(), JoinType.INNER).on("workcenter", "workcenter").select(dataSet.getRowMeta().getFieldNames(), new String[]{COST_CENTER}).finish();
                String queryPeriodGroups = "resource,org,costcenter";
                String queryPeriodFields = queryPeriodGroups + ",effectdate";
                DataSet calcQueryPeriodDataSet = dataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
                dataSet = dataSet.join(calcQueryPeriodDataSet, JoinType.INNER).on("org", "org").on("resource", "resource").on(COST_CENTER, COST_CENTER).on("effectdate", "effectdate").select(dataSet.getRowMeta().getFieldNames(), null).finish();
                dataSet = dataSet.removeFields(new String[]{"effectdate"});
                dataSet = dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
                if (resDataSet == null) {
                    resDataSet = dataSet;
                    continue;
                }
                resDataSet = DataSetUtils.union((DataSet)resDataSet, (DataSet)dataSet);
            }
            if (resDataSet != null) {
                resDataSet = resDataSet.groupBy(new String[]{"resource", COST_CENTER, "calcbasis", "resourceunit", "workactivity", "costtype", ELEMENT, SUBELEMENT, "org"}).sum("qty").count("period").finish();
                resDataSet = resDataSet.select("resource,costcenter,calcbasis,resourceunit,workactivity,costtype,element,subelement,qty/period qty,org");
                DataSet transUnitDataSet = this.getTransUnitDataSet(resDataSet.copy());
                resDataSet = resDataSet.join(transUnitDataSet, JoinType.LEFT).on("resourceunit", "resourceunit").select(resDataSet.getRowMeta().getFieldNames(), new String[]{"transunitqty"}).finish();
                resDataSet = resDataSet.select("resource,costcenter,calcbasis,resourceunit,case when transunitqty is null then qty else qty*transunitqty/60 end qty,workactivity,element,subelement,org,costtype");
                resourceDataSet = resourceDataSet.union(resourceTypeDataSet);
                resourceDataSet = resourceDataSet.join(resDataSet, JoinType.LEFT).on("resource", "resource").select(resourceDataSet.getRowMeta().getFieldNames(), new String[]{"qty", "workactivity", "org", COST_CENTER, ELEMENT, SUBELEMENT}).finish();
                resourceDataSet = resourceDataSet.groupBy(resourceDataSet.getRowMeta().getFieldNames()).finish();
                resourceDataSet = resourceDataSet.groupBy(new String[]{"costdriver", "matchpattern", "resource", "resourcetype", "workactivity", "org", COST_CENTER, ELEMENT, SUBELEMENT}).sum("qty").finish().filter("org>0");
            }
        } else {
            DataSet resourcedataSet = this.getResource(false, "id,effectdate,workcenter,resource.id as resource,calcbasis,resourceunit,qty,0 as workactivity,costtype,element,subelement", null);
            DataSet resourceAtta = this.getResourceAtta(isQueryPeriod, "id,effectdate,workcenter,resource.id as resource,calcbasis,resourceunit,entryentity.attaqty qty,0 as workactivity,costtype,entryentity.attaelement element,entryentity.attasubelement subelement", null);
            resourcedataSet = resourcedataSet.union(resourceAtta);
            DataSet dataSet = manuOrgAndCostTypeDataSet.join(resourcedataSet, JoinType.INNER).on("costtype", "costtype").select(new String[]{"id", "effectdate", "workcenter", "resource", "calcbasis", "resourceunit", "qty", "workactivity", ELEMENT, SUBELEMENT}, new String[]{"org", "costtype"}).finish();
            dataSet = dataSet.join(costWorkCenterDataSet, JoinType.INNER).on("workcenter", "workcenter").select(dataSet.getRowMeta().getFieldNames(), new String[]{COST_CENTER}).finish();
            dataSet = dataSet.removeFields(new String[]{"effectdate"});
            DataSet resDataSet = dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
            DataSet transUnitDataSet = this.getTransUnitDataSet(resDataSet.copy());
            resDataSet = resDataSet.join(transUnitDataSet, JoinType.LEFT).on("resourceunit", "resourceunit").select(resDataSet.getRowMeta().getFieldNames(), new String[]{"transunitqty"}).finish();
            resDataSet = resDataSet.select("resource,costcenter,calcbasis,resourceunit,case when transunitqty is null then qty else qty*transunitqty/60 end qty,workactivity,element,subelement,org,costtype");
            resourceDataSet = resourceDataSet.union(resourceTypeDataSet);
            resourceDataSet = resourceDataSet.join(resDataSet, JoinType.LEFT).on("resource", "resource").select(resourceDataSet.getRowMeta().getFieldNames(), new String[]{"qty", "workactivity", "org", COST_CENTER, ELEMENT, SUBELEMENT}).finish();
            resourceDataSet = resourceDataSet.groupBy(resourceDataSet.getRowMeta().getFieldNames()).finish();
            resourceDataSet = resourceDataSet.groupBy(new String[]{"costdriver", "matchpattern", "resource", "resourcetype", "workactivity", "org", COST_CENTER, ELEMENT, SUBELEMENT}).sum("qty").finish().filter("org>0");
        }
        return resourceDataSet;
    }

    private DataSet getTransUnitDataSet(DataSet resDataSet) {
        HashSet<Long> resUnits = new HashSet<Long>(10);
        Long costType = 0L;
        while (resDataSet.hasNext()) {
            Row row = resDataSet.next();
            Long resourceunit = row.getLong("resourceunit");
            if (CadEmptyUtils.isEmpty((Long)resourceunit)) continue;
            if (CadEmptyUtils.isEmpty((Long)costType)) {
                costType = row.getLong("costtype");
            }
            resUnits.add(resourceunit);
        }
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(10);
        for (Long resUnit : resUnits) {
            BigDecimal minuteQty = TimeConverter.convertPriceByConversionFactor((long)resUnit, (long)9L, (BigDecimal)new BigDecimal(60));
            Object[] object = new Object[]{resUnit, minuteQty};
            objectList.add(object);
        }
        return Algo.create((String)"macc-cad-rpt").createDataSet(objectList.iterator(), this.getTransUnitRowMeta());
    }

    private RowMeta getTransUnitRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("resourceunit", (DataType)DataType.LongType));
        field.add(new Field("transunitqty", (DataType)DataType.BigDecimalType));
        return new RowMeta(field.toArray(new Field[0]));
    }

    private DataSet dealMulSourceType(DataSet resourceTypeDataSet) {
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        resourceTypeDataSet = resourceTypeDataSet.addField("resourcetype", "realresourcetype");
        RowMeta rowMeta = resourceTypeDataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        for (Row row : resourceTypeDataSet) {
            String resourcetype = row.getString("resourcetype");
            if (resourcetype.charAt(0) == ',') {
                resourcetype = resourcetype.substring(1);
            }
            String[] types = resourcetype.split(",");
            String realResourceType = this.getResTypeName(types);
            for (String str : types) {
                if (CadEmptyUtils.isEmpty((String)str)) continue;
                Object[] rowData = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object val;
                    rowData[i] = val = row.get(i);
                }
                rowData[3] = str;
                rowData[4] = realResourceType;
                datasetlist.add(rowData);
            }
        }
        resourceTypeDataSet = Algo.create((String)"resourcetype").createDataSet(datasetlist.iterator(), rowMeta).select("costdriver,matchpattern,resource,case when resourcetype='A' then 'mpdm_equipment' when resourcetype='B' then 'mpdm_toolsresource' when resourcetype='C' then 'mpdm_toolequip' when resourcetype='D' then 'mpdm_mould' when resourcetype='E' then 'mpdm_manuperson' end resourcetype,realresourcetype");
        DataSet resoureAndType = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid,resourcesentryentity.itemclasstype resourcetype", null, null);
        resourceTypeDataSet = resourceTypeDataSet.join(resoureAndType, JoinType.INNER).on("resourcetype", "resourcetype").select(resourceTypeDataSet.getRowMeta().getFieldNames(), new String[]{"resourceid"}).finish();
        resourceTypeDataSet = resourceTypeDataSet.groupBy(new String[]{"costdriver", "matchpattern", "resourceid", "realresourcetype"}).finish().select("costdriver,matchpattern,resourceid resource,realresourcetype resourcetype");
        return resourceTypeDataSet;
    }

    private String getResTypeName(String[] types) {
        StringBuilder realType = new StringBuilder();
        block14: for (String str : types) {
            realType.append("\uff0c");
            switch (str) {
                case "A": {
                    realType.append(ResManager.loadKDString((String)"\u8bbe\u5907\u8d44\u6e90", (String)"ActualRateRptQuery_2", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "B": {
                    realType.append(ResManager.loadKDString((String)"\u5de5\u5177\u8d44\u6e90", (String)"ActualRateRptQuery_3", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "C": {
                    realType.append(ResManager.loadKDString((String)"\u5de5\u88c5\u8d44\u6e90", (String)"ActualRateRptQuery_4", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "D": {
                    realType.append(ResManager.loadKDString((String)"\u6a21\u5177\u8d44\u6e90", (String)"ActualRateRptQuery_5", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "E": {
                    realType.append(ResManager.loadKDString((String)"\u5236\u9020\u4eba\u5458", (String)"ActualRateRptQuery_6", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
            }
        }
        return realType.toString().substring(1);
    }

    private void groupingCostCenters(Map<Long, Long> costCenters, List<Long> auxiliaryProduction, List<Long> basicProduction) {
        if (CadEmptyUtils.isEmpty(costCenters)) {
            return;
        }
        for (Map.Entry<Long, Long> costCenter : costCenters.entrySet()) {
            Long costCenterId = costCenter.getKey();
            Long orgduty = costCenter.getValue();
            if (orgduty == 4L) {
                basicProduction.add(costCenterId);
                continue;
            }
            auxiliaryProduction.add(costCenterId);
        }
    }

    private Map<Long, Long> getCostCenters(FilterInfo filterInfo) {
        HashMap<Long, Long> costCenters = new HashMap<Long, Long>(16);
        DynamicObjectCollection mulCostCenters = filterInfo.getDynamicObjectCollection("mulcostcenter");
        HashSet costCenterIds = new HashSet(10);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulCostCenters)) {
            mulCostCenters.forEach(p -> costCenterIds.add(p.getLong("id")));
        }
        DynamicObject org = filterInfo.getDynamicObject("org");
        QFilter orgFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            orgFilter.and(new QFilter("id", "in", costCenterIds));
        } else {
            orgFilter.and(new QFilter("orgduty.number", "in", (Object)new String[]{"4", "5"}));
        }
        DynamicObjectCollection costCenterColls = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,orgduty as orgduty", (QFilter[])new QFilter[]{orgFilter});
        costCenterColls.forEach(p -> costCenters.put(p.getLong("id"), p.getLong("orgduty")));
        return costCenters;
    }

    private QFilter getQFilters(FilterInfo filterInfo, Boolean isBaseAllocType, List<Long> costCenters) {
        DynamicObjectCollection mulSubElements;
        DynamicObject costaccount;
        DynamicObject org;
        String appId = filterInfo.getString("appnum");
        QFilter filter = new QFilter(COST_CENTER, "in", costCenters);
        if (isBaseAllocType.booleanValue()) {
            filter = new QFilter("benefcostcenter", "in", costCenters);
        }
        if ((org = filterInfo.getDynamicObject("org")) != null) {
            filter.and(new QFilter("org", "=", (Object)org.getLong("id")));
        }
        if ((costaccount = filterInfo.getDynamicObject("costaccount")) != null) {
            filter.and(new QFilter("costaccount", "=", (Object)costaccount.getLong("id")));
        }
        DynamicObject startperiod = filterInfo.getDynamicObject("startperiod");
        DynamicObject endperiod = filterInfo.getDynamicObject("endperiod");
        if (startperiod != null && endperiod != null) {
            filter.and(new QFilter("period", ">=", (Object)startperiod.getLong("id")));
            filter.and(new QFilter("period", "<=", (Object)endperiod.getLong("id")));
        }
        DynamicObjectCollection prodorgs = filterInfo.getDynamicObjectCollection("mulprodorg");
        if (this.enableMulFactory.booleanValue() && prodorgs != null) {
            ArrayList manuOrgList = new ArrayList(16);
            prodorgs.forEach(p -> manuOrgList.add(p.getLong("id")));
            filter.and(new QFilter("manuorg", "in", manuOrgList));
            this.manuOrgIds.addAll(manuOrgList);
        } else if (this.enableMulFactory.booleanValue() && org != null) {
            String entityId = filterInfo.getString("entityId");
            List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)entityId, (String)appId);
            filter.and(new QFilter("manuorg", "in", (Object)manuOrg));
            this.manuOrgIds.addAll(manuOrg);
        }
        if (!isBaseAllocType.booleanValue()) {
            return filter;
        }
        ArrayList elements = new ArrayList(10);
        ArrayList subElements = new ArrayList(10);
        DynamicObjectCollection mulElements = filterInfo.getDynamicObjectCollection("mulelement");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulElements)) {
            mulElements.forEach(p -> elements.add(p.getLong("id")));
        }
        if ((mulSubElements = filterInfo.getDynamicObjectCollection("mulsubelement")) != null && mulSubElements.size() > 0) {
            mulSubElements.forEach(p -> subElements.add(p.getLong("id")));
        }
        if (!CadEmptyUtils.isEmpty(elements)) {
            filter.and(new QFilter(ELEMENT, "in", elements));
        }
        if (!CadEmptyUtils.isEmpty(subElements)) {
            filter.and(new QFilter(SUBELEMENT, "in", subElements));
        }
        return filter;
    }

    private void init(FilterInfo filterInfo) {
        DynamicObject costaccount;
        this.queryDate = filterInfo.getDate("querydate");
        DynamicObject currency = filterInfo.getDynamicObject("currency");
        DynamicObject org = filterInfo.getDynamicObject("org");
        if (org != null) {
            this.orgId = org.getLong("id");
        }
        if ((costaccount = filterInfo.getDynamicObject("costaccount")) != null) {
            this.costAccountId = costaccount.getLong("id");
            this.enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.parseLong(costaccount.getPkValue().toString()));
        }
        if (currency != null) {
            this.currencyId = currency.getLong("id");
        }
    }

    private Boolean isQueryByPeriod() {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        Date queryDate = filterInfo.getDate("querydate");
        if (queryDate != null) {
            return Boolean.FALSE;
        }
        DynamicObject queryPeriod = filterInfo.getDynamicObject("queryperiod");
        if (queryPeriod == null) {
            return Boolean.FALSE;
        }
        Long queryPeriodId = queryPeriod.getLong("id");
        if (queryPeriodId != 0L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private DataSet getResource(Boolean isQueryPeriod, String selectFields, Long periodId) {
        Date[] periodtime;
        String algoKey = "kd.macc.cad.report.queryplugin.ActualRateRptQuery#getResourceDataSet";
        QFilter costTypeFilter = new QFilter("costtype.type", "=", (Object)"0");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)this.queryDate);
        timeFilter.and("expdate", ">=", (Object)this.queryDate);
        if (isQueryPeriod.booleanValue() && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)periodId)) != null) {
            timeFilter = CostUpdateHelper.getPeriodQFilter((Date[])periodtime);
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_resourcerate", (String)selectFields, (QFilter[])new QFilter[]{costTypeFilter, statusFilter, timeFilter}, null);
    }

    private DataSet getResourceAtta(Boolean isQueryPeriod, String selectFields, Long periodId) {
        Date[] periodtime;
        String algoKey = "kd.macc.cad.report.queryplugin.ActualRateRptQuery#getResourceDataSet";
        QFilter costTypeFilter = new QFilter("costtype.type", "=", (Object)"0");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)this.queryDate);
        timeFilter.and("expdate", ">=", (Object)this.queryDate);
        if (isQueryPeriod.booleanValue() && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)periodId)) != null) {
            timeFilter = CostUpdateHelper.getPeriodQFilter((Date[])periodtime);
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_resourcerate", (String)selectFields, (QFilter[])new QFilter[]{costTypeFilter, statusFilter, timeFilter}, null);
    }

    private DataSet dealResourceShow(DataSet dataSet) {
        HashMap<Long, Object[]> resultMap = new HashMap<Long, Object[]>(16);
        RowMeta rowMeta = dataSet.getRowMeta();
        int len = rowMeta.getFields().length;
        String[] fieldNames = rowMeta.getFieldNames();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long id = row.getLong("id");
            Object[] objs = new Object[len];
            if (!resultMap.containsKey(id)) {
                for (int i = 0; i < len; ++i) {
                    objs[i] = row.get(i);
                }
                resultMap.put(id, objs);
                continue;
            }
            Object[] objects = (Object[])resultMap.get(id);
            for (int i = 0; i < len; ++i) {
                if ("resource".equals(fieldNames[i])) {
                    String oldRes = (String)objects[i];
                    String res = row.getString(i);
                    if (CadEmptyUtils.isEmpty((String)res)) continue;
                    res = oldRes + "\uff0c" + res;
                    objects[i] = res;
                    logger.info("\u5bf9\u5e94\u8d44\u6e90\u5b57\u6bb5-\u539f\u59cb\u503c\uff1a{},\u73b0\u5728\u503c\uff1a{},\u7ed3\u679c\uff1a{}", new Object[]{oldRes, res, res});
                    continue;
                }
                if (!"qty".equals(fieldNames[i])) continue;
                BigDecimal qty = row.getBigDecimal(i);
                BigDecimal oldQty = (BigDecimal)objects[i];
                if (qty == null) continue;
                qty = oldQty == null ? qty : oldQty.add(qty);
                objects[i] = qty;
                logger.info("\u6807\u51c6\u8d39\u7387\u5b57\u6bb5-\u539f\u59cb\u503c\uff1a{},\u73b0\u5728\u503c\uff1a{},\u7ed3\u679c\uff1a{}", new Object[]{oldQty, qty, qty});
            }
            resultMap.put(id, objects);
        }
        Collection values = resultMap.values();
        return Algo.create((String)"macc.cad.rpt").createDataSet(values.iterator(), rowMeta);
    }

    private DataSet getManuOrgAndCostTypeDataSet(Long orgId, Set<Long> manuOrgIds, Long costAccountId, Boolean isMulFactory, Date date) {
        DataSet costTypeDataSet = this.getCostTypeDataSet(orgId, costAccountId, isMulFactory, date);
        if (!isMulFactory.booleanValue()) {
            return costTypeDataSet;
        }
        DataSet invOrgDataSet = this.getInvOrgDataSetByProOrgs(manuOrgIds);
        DataSet result = invOrgDataSet.join(costTypeDataSet, JoinType.INNER).on("invorg", "invorg").select(new String[]{"manuorg"}, new String[]{"costtype"}).finish();
        return result.groupBy(result.getRowMeta().getFieldNames()).finish().select("manuorg as org,costtype");
    }

    private DataSet getCostWorkCenterDataSet(Long orgId, Date date) {
        QFilter filter = new QFilter("accountorg", "=", (Object)orgId);
        filter.and(new QFilter("orgduty", "=", (Object)4L));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection csObjs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{filter});
        List costCenterIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)csObjs, (String)"id");
        QFilter srcFilter = new QFilter(COST_CENTER, "in", (Object)costCenterIds);
        srcFilter.and(new QFilter("entryentity.sourcetype", "=", (Object)"mpdm_workcentre"));
        srcFilter.and(new QFilter("effectdate", "<=", (Object)date));
        srcFilter.and(new QFilter("expdate", ">", (Object)date));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getCostWorkCenterDataSet", (String)"bos_costcentersourcemap", (String)"costcenter,entryentity.sourcedata.id workcenter", (QFilter[])new QFilter[]{srcFilter}, null);
        if (dataSet.isEmpty()) {
            return QueryServiceHelper.queryDataSet((String)"getCostWorkCenterDataSet", (String)"bos_costcenter", (String)"id costcenter,0L workcenter", (QFilter[])new QFilter[]{filter}, null);
        }
        return dataSet;
    }

    private DataSet getCostTypeDataSet(Long orgId, Long costAccountId, Boolean isMulFactory, Date date) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        if (!isMulFactory.booleanValue()) {
            filter.and(new QFilter("calorg", "=", (Object)orgId));
        }
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)date);
        timeFilter.and("invaliddate", ">", (Object)date);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery.getCostTypeDataSet", (String)"cal_bd_costtypeorg", (String)"calorg org,storageorgunit invorg,costaccount,costtype", (QFilter[])new QFilter[]{filter, timeFilter}, null);
        return dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
    }

    private DataSet getInvOrgDataSetByProOrgs(Set<Long> manuOrgIds) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>();
        for (Long manuOrgId : manuOrgIds) {
            List invOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrgId, (boolean)true);
            for (Long invOrg : invOrgs) {
                Object[] object = new Object[]{manuOrgId, invOrg};
                objectList.add(object);
            }
        }
        return Algo.create((String)"macc-cad-rpt").createDataSet(objectList.iterator(), this.getProAndInvOrgRowMeta());
    }

    private RowMeta getProAndInvOrgRowMeta() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("manuorg", (DataType)DataType.LongType));
        field.add(new Field("invorg", (DataType)DataType.LongType));
        return new RowMeta(field.toArray(new Field[0]));
    }
}

