/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.business.numcheck.CollNumCheckHelper;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.report.queryplugin.CollectNumCheckQueryPlugin;
import org.apache.commons.lang3.StringUtils;

public class CollectConCheckQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(CollectNumCheckQueryPlugin.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String mulTargetBills;
        String[] targetBills;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        LogarithmParam logarithmParam = this.init(filterInfo);
        DataSet resultDs = CollNumCheckHelper.queryDetailConDataSet((LogarithmParam)logarithmParam, (String[])(targetBills = (mulTargetBills = filterInfo.getString("multargetbill")).split(",")));
        if (resultDs == null) {
            return resultDs;
        }
        resultDs = resultDs.addField(logarithmParam.getOrgId() + "L", "org");
        return resultDs;
    }

    private LogarithmParam init(FilterInfo filterInfo) {
        DynamicObject fsrcbilltype;
        LogarithmParam logarithmParam = new LogarithmParam();
        Long orgId = filterInfo.getDynamicObject("forg") == null ? 0L : filterInfo.getDynamicObject("forg").getLong("id");
        DynamicObject project = filterInfo.getDynamicObject("fproject");
        logarithmParam.setOrgId(orgId);
        DynamicObjectCollection mulbizorgs = filterInfo.getDynamicObjectCollection("mulbizorg");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulbizorgs)) {
            for (DynamicObject mulbizorg : mulbizorgs) {
                logarithmParam.getBizorgIds().add(mulbizorg.getLong("id"));
            }
        }
        Map queryTime = LogarithmHelper.getQueryTime((FilterInfo)filterInfo);
        Long costaccountId = filterInfo.getDynamicObject("fcostaccount") == null ? 0L : filterInfo.getDynamicObject("fcostaccount").getLong("id");
        logarithmParam.setCostaccountId(costaccountId);
        logarithmParam.setStartDate((Date)queryTime.get("startDate"));
        logarithmParam.setEndDate((Date)queryTime.get("endDate"));
        logarithmParam.setAppnum(filterInfo.getString("appnum"));
        logarithmParam.setIsWareHousePoint(this.getWareHousePoint(logarithmParam));
        logarithmParam.setShowdiffonly(filterInfo.getBoolean("showdiffonly"));
        if ("sca".equals(filterInfo.getString("appnum")) && OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            logarithmParam.setShowBizOrg(true);
        }
        if ("1".equals(filterInfo.getString("entryIdSearchType"))) {
            logarithmParam.setEntryIdSearchType("1");
        }
        if ("eca".equals(filterInfo.getString("appnum")) || "1".equals(filterInfo.getString("entryIdSearchType"))) {
            if (project != null) {
                logarithmParam.setProjectId(Long.valueOf(project.getLong("id")));
            }
            logarithmParam.setEntryIdSearchType("1");
        }
        if ((fsrcbilltype = filterInfo.getDynamicObject("fsrcbilltype")) != null) {
            logarithmParam.getBillTypes().add(fsrcbilltype.getString("id"));
        }
        List costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)logarithmParam.getOrgId(), (Long[])new Long[]{4L});
        logarithmParam.setCostCenterIds(costCenterIds);
        String entryids = filterInfo.getString("entryids");
        if (!StringUtils.isEmpty((CharSequence)entryids)) {
            String[] ids;
            for (String id : ids = entryids.split(",")) {
                if (CadEmptyUtils.isEmpty((String)id)) continue;
                try {
                    logarithmParam.getEntryIds().add(Long.parseLong(id));
                }
                catch (Exception ex) {
                    logger.info("\u8f6c\u6362\u62a5\u9519", (Object)ex);
                }
            }
        }
        return logarithmParam;
    }

    private Boolean getWareHousePoint(LogarithmParam logarithmParam) {
        QFilter acctOrgFilter = new QFilter("accountorg", "=", (Object)logarithmParam.getOrgId());
        QFilter whFilter = new QFilter("warehousepoint", "=", (Object)Boolean.TRUE);
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)logarithmParam.getAppnum());
        if (QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{acctOrgFilter, whFilter, appNumFilter})) {
            return true;
        }
        return false;
    }
}

