/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.NumDiffHelper;

public class CollectionCheckRptQuery
extends AbstractReportListDataPlugin {
    private LogarithmParam logarithmParam = new LogarithmParam();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.init(filterInfo);
        DynamicObject org = filterInfo.getDynamicObject("org");
        LogarithmHelper.queryObjSourceBill((LogarithmParam)this.logarithmParam, (long)(org == null ? 0L : org.getLong("id")));
        String mulTargetBills = filterInfo.getString("multargetbill");
        String[] targetBills = mulTargetBills.split(",");
        return NumDiffHelper.getNumDiff((LogarithmParam)this.logarithmParam, (String[])targetBills);
    }

    private void init(FilterInfo filterInfo) {
        Long orgId = filterInfo.getDynamicObject("org") == null ? 0L : filterInfo.getDynamicObject("org").getLong("id");
        this.logarithmParam.setOrgId(orgId);
        DynamicObjectCollection mulbizorgs = filterInfo.getDynamicObjectCollection("mulbizorg");
        for (DynamicObject mulbizorg : mulbizorgs) {
            this.logarithmParam.getBizorgIds().add(mulbizorg.getLong("id"));
        }
        Map queryTime = LogarithmHelper.getQueryTime((FilterInfo)filterInfo);
        this.logarithmParam.setStartDate((Date)queryTime.get("startDate"));
        this.logarithmParam.setEndDate((Date)queryTime.get("endDate"));
        this.logarithmParam.setAppnum(filterInfo.getString("appnum"));
        this.logarithmParam.setIsWareHousePoint(this.getWareHousePoint());
        List costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)this.logarithmParam.getOrgId(), (Long[])new Long[]{4L});
        this.logarithmParam.setCostCenterIds(costCenterIds);
    }

    private Boolean getWareHousePoint() {
        QFilter acctOrgFilter = new QFilter("accountorg", "=", (Object)this.logarithmParam.getOrgId());
        QFilter whFilter = new QFilter("warehousepoint", "=", (Object)Boolean.TRUE);
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)this.logarithmParam.getAppnum());
        if (QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{acctOrgFilter, whFilter, appNumFilter})) {
            return true;
        }
        return false;
    }
}

