/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.constants.MultiLanguageConstants;
import kd.macc.cad.common.helper.CollectRangeHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.OldCollectConfigHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class CollectionQuantityVarianceRptQuery
extends AbstractReportListDataPlugin {
    private LogarithmParam logarithmParam = new LogarithmParam();
    private static String[] groupByStr = new String[]{"entrybizorg", "sourcebilltype", "bizbillno", "bizbillrow", "targetbill", "costbillno", "transactiontypeid", "transactiontype", "srcbilltype", "costcenter"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.init(filterInfo);
        DynamicObject org = filterInfo.getDynamicObject("org");
        LogarithmHelper.queryObjSourceBill((LogarithmParam)this.logarithmParam, (long)(org == null ? 0L : org.getLong("id")));
        String mulTargetBills = filterInfo.getString("multargetbill");
        String[] targetBills = mulTargetBills.split(",");
        DataSet resultData = this.getDataSet(targetBills);
        if (resultData == null) {
            return resultData;
        }
        DataSet dataSet = resultData.filter("bizbillrow=null or targetbillrow=null");
        FilterItemInfo filterInfo1 = filterInfo.getFilterItem("sourcebill");
        if (filterInfo1 != null) {
            String sourcebilltype = filterInfo.getString("sourcebill");
            Long transactiontypeid = filterInfo.getLong("transactiontypeid");
            String fieldBillType = "sourcebilltype = '" + sourcebilltype + "'";
            String fieldTran = "transactiontypeid = " + transactiontypeid + "";
            if (MultiLanguageConstants.getCadMftOrder().equals(sourcebilltype)) {
                fieldBillType = fieldBillType + " or sourcebilltype = '" + MultiLanguageConstants.getCadMftOrderLog() + "' or sourcebilltype = '" + MultiLanguageConstants.getCadMftOrderSplitLog() + "'";
            }
            if (MultiLanguageConstants.getCadOmMftOrder().equals(sourcebilltype)) {
                fieldBillType = fieldBillType + " or sourcebilltype = '" + MultiLanguageConstants.getCadOmMftOrderLog() + "'";
            }
            if (CadEmptyUtils.isEmpty((String)sourcebilltype)) {
                fieldBillType = "sourcebilltype = null";
            }
            if (CadEmptyUtils.isEmpty((Long)transactiontypeid)) {
                fieldTran = "(transactiontypeid = null or transactiontypeid = 0)";
            }
            return dataSet.filter(fieldBillType).filter(fieldTran);
        }
        return dataSet;
    }

    private DataSet getDataSet(String[] targetBills) {
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>(5);
        DataSet resultDataSet = null;
        for (int i = 0; i < targetBills.length; ++i) {
            DataSet dataSet;
            if (CadEmptyUtils.isEmpty((String)targetBills[i]) || (dataSet = this.getResultDataSet(targetBills[i])) == null) continue;
            if (resultDataSet == null) {
                resultDataSet = dataSet;
                continue;
            }
            dataSetList.add(dataSet);
        }
        return resultDataSet == null || CadEmptyUtils.isEmpty(dataSetList) ? resultDataSet : resultDataSet.union(dataSetList.toArray(new DataSet[0]));
    }

    private DataSet getResultDataSet(String billType) {
        Long orgId = this.logarithmParam.getOrgId();
        String appNum = this.logarithmParam.getAppnum();
        String algoKey = "kd.macc.cad.report.queryplugin.CollectionCheckRptQuery#getLogarithmDataSet";
        QFilter filter = null;
        if ("A".equals(billType)) {
            filter = this.getCollectionQFilter("A");
            DataSet costObjectSourceDataSet = LogarithmHelper.getCostObjectSource((LogarithmParam)this.logarithmParam, (String)algoKey);
            DataSet costObjectDataSet = LogarithmHelper.getCostObject((QFilter)filter, (String)algoKey);
            String unionFields = "entryorg,entrybizorg,bizbillno,entryseq,transactiontypeid,transactiontype,sourcebilltype,'A' as targetbill,bizmaterial,srcbillnum,costcenter,costobjectbillno,material,bizstatus,billnum,srcbilltype";
            DataSet dataSet1 = costObjectSourceDataSet.join(costObjectDataSet, JoinType.LEFT).on("entryId", "probill").select(new String[]{"bizorg as entrybizorg", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "sourcebilltype", "targetbill", "bizmaterial", "srcbillnum", "srcbilltype"}, new String[]{"org as entryorg", "costcenter", "costobjectbillno", "material", "bizstatus", "billnum"}).finish().select(unionFields);
            DataSet dataSet2 = costObjectSourceDataSet.join(costObjectDataSet, JoinType.RIGHT).on("entryId", "probill").select(new String[]{"org as entryorg", "manuorg as entrybizorg", "costcenter", "costobjectbillno", "material", "bizstatus", "billnum"}, new String[]{"bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "sourcebilltype", "targetbill", "bizmaterial", "srcbillnum", "srcbilltype"}).finish().select(unionFields);
            DataSet dataSet = dataSet1.union(dataSet2).groupBy(dataSet1.getRowMeta().getFieldNames()).finish();
            dataSet = dataSet.select("entrybizorg,sourcebilltype,bizbillno,entryseq as bizbillrow,targetbill,costobjectbillno as costbillno,billnum,case when transactiontypeid = null then " + BigDecimal.ZERO + " else transactiontypeid end transactiontypeid,transactiontype,srcbilltype,costcenter").groupBy(groupByStr).sum("billnum", "targetbillrow").finish();
            return dataSet;
        }
        if ("B".equals(billType)) {
            Set ranges = OldCollectConfigHelper.getInnerSys((Long)orgId, (String)"cad_plannedoutputbill", (String)appNum);
            Map collectMap = OldCollectConfigHelper.getCollectBillBizIdsMap((Long)orgId, (String)"cad_plannedoutputbill", (String)appNum);
            filter = this.getCollectionQFilter("B");
            DataSet plannedOutputSourceDataSet = LogarithmHelper.getPlannedOutputSource((LogarithmParam)this.logarithmParam, (String)algoKey);
            DataSet manuBillsSourceDataSet = plannedOutputSourceDataSet.copy().filter("srcbilltype = 'pom_mftorder'");
            DataSet omManuBillsSourceDataSet = plannedOutputSourceDataSet.copy().filter("srcbilltype = 'om_mftorder'");
            if (CollectRangeHelper.checkContainsEntity((LogarithmParam)this.logarithmParam, (String)"cad_plannedoutputbill", (String)"pom_mftorder")) {
                DataSet pomXmftOrderLogDataSet = LogarithmHelper.getPomXmftOrderLog((QFilter)this.getResourceLogQFilter(), (String)algoKey);
                DataSet pomXmftOrderSplitLogDataSet = LogarithmHelper.getPomMftOrderSplitLog((QFilter)this.getResourceSplitLogQFilter(), (String)algoKey);
                manuBillsSourceDataSet = LogarithmHelper.getManuBillDataSet((DataSet)manuBillsSourceDataSet, (DataSet)pomXmftOrderLogDataSet, (DataSet)pomXmftOrderSplitLogDataSet, (QFilter)this.getNotCurrManuBillQFilter(), (Boolean)Boolean.FALSE, (String)algoKey, (Map)collectMap);
            }
            if (CollectRangeHelper.checkContainsEntity((LogarithmParam)this.logarithmParam, (String)"cad_plannedoutputbill", (String)"om_mftorder")) {
                DataSet omXmftOrderLogDataSet = LogarithmHelper.getOmXmftOrderLog((QFilter)this.getResourceLogQFilter(), (String)algoKey);
                DataSet omXmftOrderSplitLogDataSet = LogarithmHelper.getOmMftOrderSplitLog((QFilter)this.getResourceSplitLogQFilter(), (String)algoKey);
                omManuBillsSourceDataSet = LogarithmHelper.getManuBillDataSet((DataSet)omManuBillsSourceDataSet, (DataSet)omXmftOrderLogDataSet, (DataSet)omXmftOrderSplitLogDataSet, (QFilter)this.getNotCurrManuBillQFilter(), (Boolean)Boolean.TRUE, (String)algoKey, (Map)collectMap);
            }
            plannedOutputSourceDataSet = manuBillsSourceDataSet.union(omManuBillsSourceDataSet.select(manuBillsSourceDataSet.getRowMeta().getFieldNames())).groupBy(manuBillsSourceDataSet.getRowMeta().getFieldNames()).finish();
            DataSet plannedOutputDataSet = LogarithmHelper.getPlannedOutput((QFilter)filter, (String)algoKey);
            if ("aca".equals(appNum)) {
                ArrayList<String> srcbilltype = new ArrayList<String>(10);
                ArrayList<String> source = new ArrayList<String>(10);
                if (ranges.contains("SCGD")) {
                    srcbilltype.add(String.format("'%s'", "pom_mftorder"));
                    source.add(String.format("'%s'", "pom_mftorder"));
                    source.add(String.format("'%s'", "pom_xmftorderlog"));
                    source.add(String.format("'%s'", "pom_mftorder_splitlog"));
                }
                if (ranges.contains("WWGD")) {
                    srcbilltype.add(String.format("'%s'", "om_mftorder"));
                    source.add(String.format("'%s'", "om_mftorder"));
                    source.add(String.format("'%s'", "om_xmftorderlog"));
                    source.add(String.format("'%s'", "om_mftorder_splitog"));
                }
                if (srcbilltype.size() > 0) {
                    plannedOutputSourceDataSet = plannedOutputSourceDataSet.filter("srcbilltype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
                }
                if (source.size() > 0) {
                    plannedOutputDataSet = plannedOutputDataSet.filter("sourceType in (" + StringUtils.join(source, (String)",") + ")");
                }
            }
            String unionFields = "entryorg,entrybizorg,bizbillno,entryseq,transactiontypeid,transactiontype,bizmaterial,bizbaseunit,bizqty,bizstatus,bizclosetime,'B' as targetbill,sourcebilltype,srcbillnum,costcenter,plannedoutputbillno,material,baseunit,qty,closestatus,closetime,billnum,srcbilltype";
            DataSet plannedOutputSourceDataSet1 = plannedOutputSourceDataSet.filter("fromlogid = 0");
            DataSet plannedOutputDataSet1 = plannedOutputDataSet.filter("fromlogid = 0");
            DataSet plannedOutputSourceDataSet2 = plannedOutputSourceDataSet.filter("fromlogid != 0");
            DataSet plannedOutputDataSet2 = plannedOutputDataSet.filter("fromlogid != 0");
            DataSet dataSet1 = plannedOutputSourceDataSet1.join(plannedOutputDataSet1, JoinType.LEFT).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"bizorg as entrybizorg", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "targetbill", "sourcebilltype", "srcbillnum", "srcbilltype"}, new String[]{"accountorg as entryorg", "costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "billnum"}).finish().select(unionFields);
            DataSet dataSet11 = plannedOutputSourceDataSet2.join(plannedOutputDataSet2, JoinType.LEFT).on("id", "sourcebill").on("entryId", "sourcebillentry").on("fromlogid", "fromlogid").select(new String[]{"bizorg as entrybizorg", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "targetbill", "sourcebilltype", "srcbillnum", "srcbilltype"}, new String[]{"accountorg as entryorg", "costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "billnum"}).finish().select(unionFields);
            DataSet dataSet2 = plannedOutputSourceDataSet1.join(plannedOutputDataSet1, JoinType.RIGHT).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"accountorg as entryorg", "manuorg as entrybizorg", "costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "billnum"}, new String[]{"bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "targetbill", "sourcebilltype", "srcbillnum", "srcbilltype"}).finish().select(unionFields);
            DataSet dataSet21 = plannedOutputSourceDataSet2.join(plannedOutputDataSet2, JoinType.RIGHT).on("id", "sourcebill").on("entryId", "sourcebillentry").on("fromlogid", "fromlogid").select(new String[]{"accountorg as entryorg", "manuorg as entrybizorg", "costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "billnum"}, new String[]{"bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "targetbill", "sourcebilltype", "srcbillnum", "srcbilltype"}).finish().select(unionFields);
            DataSet dataSet = dataSet1.union(dataSet2).union(dataSet11).union(dataSet21).groupBy(dataSet1.getRowMeta().getFieldNames()).finish();
            dataSet = dataSet.select("entrybizorg,sourcebilltype,bizbillno,entryseq as bizbillrow,targetbill,plannedoutputbillno as costbillno,billnum,case when transactiontypeid = null then " + BigDecimal.ZERO + " else transactiontypeid end transactiontypeid,transactiontype,srcbilltype,costcenter").groupBy(groupByStr).sum("billnum", "targetbillrow").finish();
            return dataSet;
        }
        if ("C".equals(billType)) {
            Set ranges = OldCollectConfigHelper.getInnerSys((Long)this.logarithmParam.getOrgId(), (String)"cad_factnedoutputbill", (String)this.logarithmParam.getAppnum());
            filter = this.getCollectionQFilter("C");
            DataSet factOutputSourceDataSet = LogarithmHelper.getFactoutputSource((LogarithmParam)this.logarithmParam, (String)algoKey);
            DataSet factOutputDataSet = LogarithmHelper.getFactoutput((QFilter)filter, (String)algoKey, (String)"cad_factnedoutputbill");
            ArrayList<String> srcbilltype = new ArrayList<String>(10);
            if (ranges.contains("WIPCOMPELETE")) {
                srcbilltype.add(String.format("'%s'", "im_mdc_mftmanuinbill"));
                srcbilltype.add(String.format("'%s'", "im_mdc_mftreturnbill"));
            }
            if (ranges.contains("WWGRK")) {
                srcbilltype.add(String.format("'%s'", "im_mdc_omcmplinbill"));
            }
            if (srcbilltype.size() > 0) {
                factOutputSourceDataSet = factOutputSourceDataSet.filter("srcbilltype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
                factOutputDataSet = factOutputDataSet.filter("completetype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
            }
            String unionFields = "entryorg,entrybizorg,manubillno,bizbillno,entryseq,transactiontypeid,transactiontype,bizmaterial,bizbaseunit,bizqty,srcbilltype,'C' as targetbill,sourcebilltype,srcbillnum,costcenter,factoutputbillno,material,baseunit,completeqty,costobject,billnum";
            DataSet dataSet1 = factOutputSourceDataSet.join(factOutputDataSet, JoinType.LEFT).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"bizorg as entrybizorg", "manubillno", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill", "sourcebilltype", "srcbillnum"}, new String[]{"org as entryorg", "costcenter", "factoutputbillno", "material", "baseunit", "completeqty", "costobject", "billnum"}).finish().select(unionFields);
            DataSet dataSet2 = factOutputSourceDataSet.join(factOutputDataSet, JoinType.RIGHT).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"org as entryorg", "manuorg as entrybizorg", "costcenter", "factoutputbillno", "material", "baseunit", "completeqty", "costobject", "billnum"}, new String[]{"manubillno", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill", "sourcebilltype", "srcbillnum"}).finish().select(unionFields);
            DataSet dataSet = dataSet1.union(dataSet2).groupBy(dataSet1.getRowMeta().getFieldNames()).finish();
            dataSet = dataSet.select("entrybizorg,sourcebilltype,bizbillno,entryseq as bizbillrow,targetbill,factoutputbillno as costbillno,billnum,case when transactiontypeid = null then " + BigDecimal.ZERO + " else transactiontypeid end transactiontypeid,transactiontype,srcbilltype,costcenter").groupBy(groupByStr).sum("billnum", "targetbillrow").finish();
            return dataSet;
        }
        if ("D".equals(billType)) {
            Set ranges = OldCollectConfigHelper.getInnerSys((Long)this.logarithmParam.getOrgId(), (String)"sca_resourceuse", (String)this.logarithmParam.getAppnum());
            filter = this.getCollectionQFilter("D");
            DataSet resourceUseSourceDataSet = LogarithmHelper.getResourceUseSource((LogarithmParam)this.logarithmParam, (String)algoKey).addField("bizbillno+'-'+cast(seq as String)+'-'+cast(subseq as String)", "selectKey");
            DataSet resourceUseDataSet = LogarithmHelper.getResourceUse((QFilter)filter, (String)algoKey, (String)"sca_resourceuse");
            ArrayList<String> srcbilltype = new ArrayList<String>(10);
            ArrayList<String> sourcebilltype = new ArrayList<String>(10);
            if (ranges.contains("PROCESSREPORT")) {
                srcbilltype.add(String.format("'%s'", "sfc_processreportbill"));
                sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadProcessReportBill()));
            }
            if (ranges.contains("PROCESSADJUST")) {
                srcbilltype.add(String.format("'%s'", "sfc_reportresource_adjust"));
                sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadReportResourceAdjust()));
            }
            if (ranges.contains("MFTORDERREPORT")) {
                srcbilltype.add(String.format("'%s'", "pom_mftorderreport"));
                sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadMftOrderReport()));
            }
            if (ranges.contains("WGXHB")) {
                srcbilltype.add(String.format("'%s'", "om_processreport"));
                sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadProcessReport()));
            }
            if (srcbilltype.size() > 0) {
                resourceUseSourceDataSet = resourceUseSourceDataSet.filter("srcbilltype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
            }
            if (sourcebilltype.size() > 0) {
                resourceUseDataSet = resourceUseDataSet.filter("sourcebilltype in (" + StringUtils.join(sourcebilltype, (String)",") + ")");
            }
            String unionFields = "entryorg,entrybizorg,manubillno,bizbillno,subseq,bizmaterial,oprunit,completqty,srcbilltype,entryresource,subentryunit,subentrysumqty,'D' as targetbill,sourcebilltype,transactiontypeid,transactiontype,srcbillnum,costcenter,resourceusebillno,material,resource,workhour,facthour,factuse,factbatch,costobject,billnum";
            DataSet dataSet1 = resourceUseSourceDataSet.join(resourceUseDataSet, JoinType.LEFT).on("id", "srcbillid").on("selectKey", "resourceusebillno").select(new String[]{"bizorg as entrybizorg", "manubillno", "bizbillno", "subseq", "bizmaterial", "oprunit", "completqty", "srcbilltype", "entryresource", "subentryunit", "subentrysumqty", "targetbill", "sourcebilltype", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "srcbillnum"}, new String[]{"org as entryorg", "costcenter", "resourceusebillno", "material", "resource", "workhour", "facthour", "factuse", "factbatch", "costobject", "billnum"}).finish().select(unionFields);
            DataSet dataSet2 = resourceUseSourceDataSet.join(resourceUseDataSet, JoinType.RIGHT).on("id", "srcbillid").on("selectKey", "resourceusebillno").select(new String[]{"org as entryorg", "manuorg as entrybizorg", "costcenter", "resourceusebillno", "material", "resource", "workhour", "facthour", "factuse", "factbatch", "costobject", "billnum"}, new String[]{"manubillno", "bizbillno", "subseq", "bizmaterial", "oprunit", "completqty", "srcbilltype", "entryresource", "subentryunit", "subentrysumqty", "sourcebilltype", "targetbill", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "srcbillnum"}).finish().select(unionFields);
            DataSet dataSet = dataSet1.union(dataSet2).groupBy(dataSet1.getRowMeta().getFieldNames()).finish();
            dataSet = dataSet.select("entrybizorg,sourcebilltype,bizbillno,subseq as bizbillrow,targetbill,resourceusebillno as costbillno,billnum,case when transactiontypeid = null then " + BigDecimal.ZERO + " else transactiontypeid end transactiontypeid,transactiontype,srcbilltype,costcenter").groupBy(groupByStr).sum("billnum", "targetbillrow").finish();
            return dataSet;
        }
        String entity = "sca_matusecollect";
        if ("ACA".equalsIgnoreCase(appNum)) {
            entity = "aca_matusecollect";
        }
        Set ranges = OldCollectConfigHelper.getInnerSys((Long)orgId, (String)entity, (String)appNum);
        filter = this.getCollectionQFilter("E");
        DataSet matUseCollectSourceDataSet = LogarithmHelper.getMatUseCollectSource((LogarithmParam)this.logarithmParam, (String)algoKey);
        DataSet matUseCollectDataSet = LogarithmHelper.getMatUseCollect((QFilter)filter, (String)algoKey, (String)entity);
        ArrayList<String> srcbilltype = new ArrayList<String>(10);
        if (ranges.contains("PRO_GET")) {
            srcbilltype.add(String.format("'%s'", "im_mdc_mftproorder"));
            srcbilltype.add(String.format("'%s'", "im_mdc_mftreturnorder"));
            srcbilltype.add(String.format("'%s'", "im_mdc_mftfeedorder"));
        }
        if (ranges.contains("GET_OUTSTORAGE")) {
            srcbilltype.add(String.format("'%s'", "im_materialreqoutbill"));
        }
        if (ranges.contains("WLL")) {
            srcbilltype.add(String.format("'%s'", "im_mdc_omoutbill"));
            srcbilltype.add(String.format("'%s'", "im_mdc_omreturnbill"));
            srcbilltype.add(String.format("'%s'", "im_mdc_omfeedbill"));
        }
        if (srcbilltype.size() > 0) {
            matUseCollectSourceDataSet = matUseCollectSourceDataSet.filter("srcbilltype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
            matUseCollectDataSet = matUseCollectDataSet.filter("srcbill in (" + StringUtils.join(srcbilltype, (String)",") + ")");
        }
        String unionFields = "entryorg,entrybizorg,manubillno,bizbillno,entryseq,transactiontypeid,transactiontype,bizmaterial,bizbaseunit,bizqty,srcbilltype,'E' as targetbill,sourcebilltype,srcbillnum,costcenter,matcollectbillno,material,unit,qty,appnum,billnum";
        DataSet dataSet1 = matUseCollectSourceDataSet.join(matUseCollectDataSet, JoinType.LEFT).on("id", "sourcebillid").on("entryId", "sourceEntryId").select(new String[]{"bizorg as entrybizorg", "manubillno", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill", "sourcebilltype", "srcbillnum"}, new String[]{"org as entryorg", "costcenter", "matcollectbillno", "material", "unit", "qty", "appnum", "billnum"}).finish().select(unionFields);
        DataSet dataSet2 = matUseCollectSourceDataSet.join(matUseCollectDataSet, JoinType.RIGHT).on("id", "sourcebillid").on("entryId", "sourceEntryId").select(new String[]{"org as entryorg", "manuorg as entrybizorg", "costcenter", "matcollectbillno", "material", "unit", "qty", "appnum", "billnum"}, new String[]{"manubillno", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill", "sourcebilltype", "srcbillnum"}).finish().select(unionFields);
        DataSet dataSet = dataSet1.union(dataSet2).groupBy(dataSet1.getRowMeta().getFieldNames()).finish();
        dataSet = dataSet.select("entrybizorg,sourcebilltype,bizbillno,entryseq as bizbillrow,targetbill,matcollectbillno as costbillno,billnum,case when transactiontypeid = null then " + BigDecimal.ZERO + " else transactiontypeid end transactiontypeid,transactiontype,srcbilltype,costcenter").groupBy(groupByStr).sum("billnum", "targetbillrow").finish();
        return dataSet;
    }

    private void init(FilterInfo filterInfo) {
        Long orgId = filterInfo.getDynamicObject("org").getLong("id");
        this.logarithmParam.setOrgId(orgId);
        DynamicObjectCollection mulbizorgs = filterInfo.getDynamicObjectCollection("mulbizorg");
        for (DynamicObject mulbizorg : mulbizorgs) {
            this.logarithmParam.getBizorgIds().add(mulbizorg.getLong("id"));
        }
        Map queryTime = LogarithmHelper.getQueryTime((FilterInfo)filterInfo);
        this.logarithmParam.setStartDate((Date)queryTime.get("startDate"));
        this.logarithmParam.setEndDate((Date)queryTime.get("endDate"));
        this.logarithmParam.setAppnum(filterInfo.getString("appnum"));
        this.logarithmParam.setIsWareHousePoint(this.getWareHousePoint());
        List costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)this.logarithmParam.getOrgId(), (Long[])new Long[]{4L});
        this.logarithmParam.setCostCenterIds(costCenterIds);
    }

    private Boolean getWareHousePoint() {
        QFilter acctOrgFilter = new QFilter("accountorg", "=", (Object)this.logarithmParam.getOrgId());
        QFilter whFilter = new QFilter("warehousepoint", "=", (Object)Boolean.TRUE);
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)this.logarithmParam.getAppnum());
        if (QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{acctOrgFilter, whFilter, appNumFilter})) {
            return true;
        }
        return false;
    }

    private QFilter getCollectionQFilter(String billType) {
        Long orgId = this.logarithmParam.getOrgId();
        List bizorgIds = this.logarithmParam.getBizorgIds();
        Date startDate = this.logarithmParam.getStartDate();
        Date endDate = this.logarithmParam.getEndDate();
        String appNum = this.logarithmParam.getAppnum();
        QFilter filter = new QFilter("1", "=", (Object)"1");
        switch (billType) {
            case "A": {
                filter = new QFilter("org", "=", (Object)orgId);
                filter.and(new QFilter("sotype", "=", (Object)"PB"));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", (Object)bizorgIds));
                filter.and(new QFilter("bookdate", ">=", (Object)startDate));
                filter.and(new QFilter("bookdate", "<", (Object)endDate));
                break;
            }
            case "B": {
                filter = new QFilter("accountorg", "=", (Object)orgId);
                filter.and(new QFilter("srcbilltype", "in", (Object)new String[]{"pom_mftorder", "pom_xmftorderlog", "pom_mftorder_splitlog", "om_mftorder", "om_xmftorderlog", "pom_xmftorderlog", "om_mftorder_splitog"}));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", (Object)bizorgIds));
                filter.and(new QFilter("bizdate", ">=", (Object)startDate));
                filter.and(new QFilter("bizdate", "<", (Object)endDate));
                filter.and(new QFilter("appnum", "=", (Object)appNum));
                break;
            }
            case "C": {
                filter = new QFilter("org", "=", (Object)orgId);
                filter.and(new QFilter("completetype", "in", (Object)new String[]{"WIPCOMPELETE", "WIPCOMPELETEBACK", "WWGRK", "CONFIG"}));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", (Object)bizorgIds));
                filter.and(new QFilter("bookdate", ">=", (Object)startDate));
                filter.and(new QFilter("bookdate", "<", (Object)endDate));
                filter.and(new QFilter("appnum", "=", (Object)appNum));
                break;
            }
            case "D": {
                filter = new QFilter("org", "=", (Object)orgId);
                filter.and(new QFilter("source", "in", (Object)new String[]{"OBJECTRULE", "CONFIG"}));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", (Object)bizorgIds));
                filter.and(new QFilter("bookdate", ">=", (Object)startDate));
                filter.and(new QFilter("bookdate", "<", (Object)endDate));
                filter.and(new QFilter("appnum", "=", (Object)appNum));
                break;
            }
            case "E": {
                filter = new QFilter("org", "=", (Object)orgId);
                filter.and(new QFilter("srcbilltype", "in", (Object)new String[]{"im_materialreqoutbill", "im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill"}));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", (Object)bizorgIds));
                filter.and(new QFilter("bookdate", ">=", (Object)startDate));
                filter.and(new QFilter("bookdate", "<", (Object)endDate));
                filter.and(new QFilter("appnum", "=", (Object)appNum));
            }
        }
        return filter;
    }

    private QFilter getResourceLogQFilter() {
        QFilter filter = new QFilter("changestatus", "=", (Object)"B");
        filter.and(new QFilter("biztime", ">=", (Object)this.logarithmParam.getStartDate()));
        filter.and(new QFilter("biztime", "<", (Object)this.logarithmParam.getEndDate()));
        return filter;
    }

    private QFilter getResourceSplitLogQFilter() {
        QFilter filter = new QFilter("orderstatus", "=", (Object)"C");
        filter.and(new QFilter("createtime", ">=", (Object)this.logarithmParam.getStartDate()));
        filter.and(new QFilter("createtime", "<", (Object)this.logarithmParam.getEndDate()));
        return filter;
    }

    private QFilter getNotCurrManuBillQFilter() {
        QFilter filter = new QFilter("org", "in", (Object)this.logarithmParam.getBizorgIds());
        filter.and(new QFilter("treeentryentity.taskstatus", "!=", (Object)"A"));
        if ("sca".equals(this.logarithmParam.getAppnum())) {
            filter.and(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
        }
        return filter;
    }
}

