/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.helper.CostUpdateRptHelper;

public class CostUpdateRptQueryPlugin
extends AbstractReportListDataPlugin {
    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object arg1) throws Throwable {
        FilterInfo filter = reportQueryParam.getFilter();
        DataSet rawDataSet = this.queryRawData(filter);
        return this.addTotalRow(rawDataSet);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        this.handleDynamicColumn(columns);
        return columns;
    }

    private DataSet queryRawData(FilterInfo filter) {
        ReportQueryParam reportQueryParam = this.getQueryParam();
        List filters = CostUpdateRptHelper.getFilters((FilterInfo)filter);
        DynamicObject targetCostType = filter.getDynamicObject("targetcosttype");
        DynamicObject srccosttype = filter.getDynamicObject("srccosttype");
        ORMImpl orm = new ORMImpl();
        return orm.queryDataSet(this.getAlgoKey("queryRawData"), "cad_costupdateestablished", this.getSelectFields(targetCostType.getString("type"), filter.getString("querytype")), filters.toArray(new QFilter[0]), "costupdateentry.srctype ", 100000, null);
    }

    private String getSelectFields(String costTypeAtt, String displayType) {
        return "0 accountorg,0 discostaccount,0 warehouse,costupdateentry.material.id materialid,costupdateentry.material.number material,costupdateentry.material.name matname,costupdateentry.material.modelnum model,costupdateentry.material.baseunit baseunit,costupdateentry.matversion matversion,costupdateentry.auxprop auxprop,costupdateentry.element element,costupdateentry.subelement subelement,costupdateentry.oldprice oldprice,costupdateentry.newprice newprice,costupdateentry.diffprice diffprice,costupdateentry.srctype srctype,0 qty,0 totalType,0 subTotalType";
    }

    private void handleDynamicColumn(List<AbstractReportColumn> columns) {
        ReportQueryParam reportQueryParam = this.getQueryParam();
        FilterInfo filter = reportQueryParam.getFilter();
        DynamicObject targetCostType = filter.getDynamicObject("targetcosttype");
        this.hideColumns(columns);
    }

    private void addDynamicColumns(String groupcaption, String dyfieldKey, List<AbstractReportColumn> columns) {
        ReportColumnGroup clg = new ReportColumnGroup();
        clg.setCaption(new LocaleString(groupcaption));
        List colsList = clg.getChildren();
        ReportColumn qty = new ReportColumn();
        qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u91cf", (String)"CostUpdateRptQueryPlugin_0", (String)"macc-cad-report", (Object[])new Object[0])));
        qty.setFieldKey("fqty" + dyfieldKey);
        qty.setFieldType("qty");
        ReportColumn oldCost = new ReportColumn();
        oldCost.setCaption(new LocaleString(ResManager.loadKDString((String)"\u539f\u5e93\u5b58\u6210\u672c", (String)"CostUpdateRptQueryPlugin_1", (String)"macc-cad-report", (Object[])new Object[0])));
        oldCost.setFieldKey("foldCost" + dyfieldKey);
        oldCost.setFieldType("amount");
        oldCost.setScale(2);
        ReportColumn newCost = new ReportColumn();
        newCost.setCaption(new LocaleString(ResManager.loadKDString((String)"\u66f4\u65b0\u540e\u5e93\u5b58\u6210\u672c", (String)"CostUpdateRptQueryPlugin_2", (String)"macc-cad-report", (Object[])new Object[0])));
        newCost.setFieldKey("fnewCost" + dyfieldKey);
        newCost.setFieldType("amount");
        newCost.setScale(2);
        ReportColumn diffCost = new ReportColumn();
        diffCost.setCaption(new LocaleString(ResManager.loadKDString((String)"\u66f4\u65b0\u5dee\u5f02", (String)"CostUpdateRptQueryPlugin_3", (String)"macc-cad-report", (Object[])new Object[0])));
        diffCost.setFieldKey("fdiffCost" + dyfieldKey);
        diffCost.setFieldType("amount");
        diffCost.setScale(2);
        colsList.add(qty);
        colsList.add(oldCost);
        colsList.add(newCost);
        colsList.add(diffCost);
        columns.add((AbstractReportColumn)clg);
    }

    private String getDynamicGroupSql() {
        ReportQueryParam reportQueryParam = this.getQueryParam();
        FilterInfo filter = reportQueryParam.getFilter();
        StringBuilder dySql = new StringBuilder();
        DynamicObjectCollection coll = CostUpdateRptHelper.getDynamicColumnsData((ReportQueryParam)reportQueryParam);
        String queryType = filter.getString("querytype");
        for (int index = 0; index < coll.size(); ++index) {
            String accountorgNumber;
            String costaccountNumber;
            DynamicObject costUpdateInfo = (DynamicObject)coll.get(index);
            String dyfieldKey = null;
            if ("1".equals(queryType)) {
                costaccountNumber = costUpdateInfo.getString("acctentry.acctcostaccount.number");
                accountorgNumber = costUpdateInfo.getString("acctentry.acctaccountorg.number");
                dyfieldKey = (costaccountNumber + accountorgNumber).replaceAll("\\.", "s");
            } else {
                costaccountNumber = costUpdateInfo.getString("storagecostentry.costaccount.number");
                accountorgNumber = costUpdateInfo.getString("storagecostentry.accountorg.number");
                String warehouseNumber = costUpdateInfo.getString("storagecostentry.warehouse.number");
                dyfieldKey = (costaccountNumber + accountorgNumber + warehouseNumber).replaceAll("\\.", "s");
            }
            if (dySql.indexOf(dyfieldKey) > 0) continue;
            dySql.append(",foldCost").append(dyfieldKey);
            dySql.append(",fnewCost").append(dyfieldKey);
            dySql.append(",fqty").append(dyfieldKey);
            dySql.append(",fdiffCost").append(dyfieldKey);
        }
        return dySql.toString();
    }

    private DataSet getGroupDataSet(DataSet dataSet) {
        GroupbyDataSet groupDataSet = dataSet.groupBy(new String[]{"materialid", "material", "matname", "model", "baseunit", "matversion", "auxprop", "element", "subelement", "srctype", "totalType", "subTotalType"});
        groupDataSet.max("oldprice");
        groupDataSet.max("newprice");
        String groupFieldStr = this.getDynamicGroupSql();
        String[] groupFields = groupFieldStr.split(",");
        for (int i = 0; i < groupFields.length; ++i) {
            if (i == 0) continue;
            groupDataSet.sum(groupFields[i]);
        }
        return groupDataSet.finish();
    }

    private void hideColumns(List<AbstractReportColumn> columns) {
        ((ReportColumn)columns.get(0)).setHide(true);
        ((ReportColumn)columns.get(1)).setHide(true);
        ((ReportColumn)columns.get(2)).setHide(true);
        ((ReportColumn)columns.get(3)).setHide(true);
        ((ReportColumn)columns.get(10)).setHide(true);
        ((ReportColumn)columns.get(15)).setHide(true);
        ((ReportColumn)columns.get(16)).setHide(true);
        ((ReportColumn)columns.get(17)).setHide(true);
    }

    private String getSqlWhere(String querytype) {
        ReportQueryParam reportQueryParam = this.getQueryParam();
        FilterInfo filter = reportQueryParam.getFilter();
        StringBuilder where = new StringBuilder();
        DynamicObject updatebillinfo = BusinessDataServiceHelper.loadSingle((Object)filter.getDynamicObject("billno").getPkValue(), (String)"cad_costupdatenew");
        if (filter.getDynamicObject("billno") != null) {
            where.append("where bill.FID = ").append(updatebillinfo.getLong("updatebillno"));
        }
        if ("1".equals(querytype)) {
            if (filter.getDynamicObject("querymaterial") != null) {
                where.append(" and sotr.facctmaterialid = ").append(filter.getDynamicObject("querymaterial").getPkValue());
            }
            if (filter.getDynamicObject("acctorg") != null) {
                where.append(" and sotr.facctaccountorgid = ").append(filter.getDynamicObject("acctorg").getPkValue());
            }
            if (filter.getDynamicObject("costaccount") != null) {
                where.append(" and sotr.facctcostaccountid = ").append(filter.getDynamicObject("costaccount").getPkValue());
            }
        } else {
            if (filter.getDynamicObject("querymaterial") != null) {
                where.append(" and sotr.fmaterialid = ").append(filter.getDynamicObject("querymaterial").getPkValue());
            }
            if (filter.getDynamicObject("acctorg") != null) {
                where.append(" and sotr.faccountorgid = ").append(filter.getDynamicObject("acctorg").getPkValue());
            }
            if (filter.getDynamicObject("costaccount") != null) {
                where.append(" and sotr.fcostaccountid = ").append(filter.getDynamicObject("costaccount").getPkValue());
            }
            if (filter.getDynamicObject("warehouse") != null) {
                where.append(" and sotr.fwarehouseid = ").append(filter.getDynamicObject("warehouse").getPkValue());
            }
        }
        return where.toString();
    }

    private DataSet addTotalRow(DataSet dataSet) {
        String totalTag = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostUpdateRptQueryPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]);
        String subTotalTag = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CostUpdateRptQueryPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]);
        ReportQueryParam reportQueryParam = this.getQueryParam();
        FilterInfo filter = reportQueryParam.getFilter();
        DynamicObject targetCostType = filter.getDynamicObject("targetcosttype");
        GroupbyDataSet totalGroupDataSet = dataSet.groupBy(null);
        totalGroupDataSet.sum("oldprice");
        totalGroupDataSet.sum("newprice");
        DataSet totalDataSet = totalGroupDataSet.finish().select("0 as accountorg,0 as discostaccount,0 as warehouse,0 as materialid,'" + totalTag + "' as material,'" + totalTag + "' as matname,''model,0 as baseunit,0 as matversion,0 as auxprop,0 as element,0 as subelement,oldprice, newprice,oldprice-newprice as diffprice,'' as srctype,0 as qty,1 as totalType,0 as subTotalType");
        DataSet allDataSet = dataSet.union(totalDataSet);
        return allDataSet.orderBy(new String[]{"totalType", "material"});
    }
}

