/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.FinalStdAnalysisRptParam;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.FinalStdAnalysisRptHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.BigDecimalUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DateUtils;

public class FinalStdAnalysisRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(FinalStdAnalysisRptQueryPlugin.class);
    private int currency_a;

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FinalStdAnalysisRptParam rptParam = FinalStdAnalysisRptHelper.getRptParam((ReportQueryParam)reportQueryParam);
        this.currency_a = rptParam.getCostType_a().getInt("currency.id");
        DataSet dataSet_a = null;
        DataSet dataSet_b = null;
        DataSet commonDataSet = null;
        DataSet allDataSet_a = null;
        DataSet allDataSet_b = null;
        List<Object[]> dataList = null;
        try {
            String[] leftFileName;
            dataSet_a = this.queryDataSet(rptParam, "A");
            dataSet_b = this.queryDataSet(rptParam, "B");
            String deteialFields_1 = "submaterial,subkeycol,subauxprop,datatype,calcbasis,resource,submatnumber,matname,resnumber,resname,subconfiguredcode,subtracknumber,subproject,sublot";
            GroupbyDataSet commonGroupByDataSet = null;
            DataSet dataSet_detail_a = null;
            DataSet dataSet_detail_b = null;
            if (rptParam.isDateial().booleanValue()) {
                dataSet_detail_a = dataSet_a.select(this.getCommonAliasFields() + ",material_a submaterial, keycol_a subkeycol, auxprop_a subauxprop, datatype_a datatype, calcbasis_a calcbasis, resource_a resource,matnumber_a submatnumber,matname_a matname,resnumber_a resnumber,resname_a resname,subconfiguredcode_a subconfiguredcode,subtracknumber_a subtracknumber,subproject_a subproject,sublot_a sublot");
                dataSet_detail_b = dataSet_b.select(this.getCommonAliasFields() + ",material_b submaterial, keycol_b subkeycol, auxprop_b subauxprop, datatype_b datatype, calcbasis_b calcbasis,resource_b resource,matnumber_b submatnumber,matname_b matname,resnumber_b resnumber,resname_b resname,subconfiguredcode_b subconfiguredcode,subtracknumber_b subtracknumber,subproject_b subproject,sublot_b sublot");
                commonGroupByDataSet = DataSetUtils.union((DataSet)dataSet_detail_a, (DataSet)dataSet_detail_b).groupBy((this.getCommonAliasFields() + "," + deteialFields_1).split(","));
            } else {
                commonGroupByDataSet = dataSet_a.select(this.getCommonAliasFields()).union(dataSet_b.select(this.getCommonAliasFields())).groupBy(this.getCommonAliasFields().split(","));
            }
            commonDataSet = commonGroupByDataSet.finish();
            if (rptParam.isDateial().booleanValue()) {
                DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet((DynamicObjectCollection)rptParam.getMulmaterialgroup(), (boolean)false, (DynamicObject)rptParam.getMaterialgrpstd());
                DataSet matDataSet = commonDataSet.filter("submaterial!=0");
                DataSet notMatDataSet = commonDataSet.filter("submaterial=0");
                matDataSet = matDataSet.leftJoin(materialDataSet).on("submaterial", "material").select(commonDataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish();
                notMatDataSet = notMatDataSet.leftJoin(materialDataSet).on("material", "material").select(commonDataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish();
                commonDataSet = DataSetUtils.union((DataSet)matDataSet, (DataSet)notMatDataSet);
            }
            JoinDataSet joinDataSet_a = commonDataSet.join(dataSet_a, JoinType.LEFT);
            joinDataSet_a = joinDataSet_a.on("material", "material");
            joinDataSet_a = joinDataSet_a.on("keycol", "keycol");
            joinDataSet_a = joinDataSet_a.on("element", "element");
            joinDataSet_a = joinDataSet_a.on("subelement", "subelement");
            if (rptParam.isDateial().booleanValue()) {
                joinDataSet_a = joinDataSet_a.on("submaterial", "material_a");
                joinDataSet_a = joinDataSet_a.on("subkeycol", "keycol_a");
                joinDataSet_a = joinDataSet_a.on("datatype", "datatype_a");
                joinDataSet_a = joinDataSet_a.on("calcbasis", "calcbasis_a");
                joinDataSet_a = joinDataSet_a.on("resource", "resource_a");
            }
            String[] rightFileName = this.getCostTypeAAliasFields(rptParam, false).split(",");
            if (rptParam.isDateial().booleanValue()) {
                leftFileName = (this.getCommonAliasFields() + ",materialgroup," + deteialFields_1).split(",");
                allDataSet_a = joinDataSet_a.select(leftFileName, rightFileName).finish();
            } else {
                leftFileName = this.getCommonAliasFields().split(",");
                allDataSet_a = joinDataSet_a.select(leftFileName, rightFileName).finish();
            }
            JoinDataSet joinDataSet_b = allDataSet_a.join(dataSet_b, JoinType.LEFT);
            joinDataSet_b = joinDataSet_b.on("material", "material");
            joinDataSet_b = joinDataSet_b.on("keycol", "keycol");
            joinDataSet_b = joinDataSet_b.on("element", "element");
            joinDataSet_b = joinDataSet_b.on("subelement", "subelement");
            if (rptParam.isDateial().booleanValue()) {
                joinDataSet_b = joinDataSet_b.on("submaterial", "material_b");
                joinDataSet_b = joinDataSet_b.on("subkeycol", "keycol_b");
                joinDataSet_b = joinDataSet_b.on("datatype", "datatype_b");
                joinDataSet_b = joinDataSet_b.on("calcbasis", "calcbasis_b");
                joinDataSet_b = joinDataSet_b.on("resource", "resource_b");
            }
            if (rptParam.isDateial().booleanValue()) {
                allDataSet_b = joinDataSet_b.select((this.getCommonAliasFields() + ",materialgroup,0 diffqty, 0 diffcost," + this.getCostTypeAAliasFields(rptParam, false)).split(","), this.getCostTypeBAliasFields(rptParam, false).split(",")).finish();
                allDataSet_b = allDataSet_b.addField("matnumber_a+resnumber_a", "matresnumber_a").addField("matname_a+resname_a", "matresname_a").addField("matnumber_b+resnumber_b", "matresnumber_b").addField("matname_b+resname_b", "matresname_b");
            } else {
                allDataSet_b = joinDataSet_b.select((this.getCommonAliasFields() + ",0 diffqty, 0 diffcost," + this.getCostTypeAAliasFields(rptParam, false)).split(","), this.getCostTypeBAliasFields(rptParam, false).split(",")).finish();
            }
            dataList = this.count(allDataSet_b, rptParam);
        }
        catch (Throwable throwable) {
            DataSetUtils.colse((DataSet[])new DataSet[]{dataSet_a, dataSet_b, commonDataSet, allDataSet_a, allDataSet_b});
            throw throwable;
        }
        DataSetUtils.colse((DataSet[])new DataSet[]{dataSet_a, dataSet_b, commonDataSet, allDataSet_a, allDataSet_b});
        DataSet finishDataSet = Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), this.getRowMeta(rptParam));
        return finishDataSet;
    }

    private void getMatInfos(FinalStdAnalysisRptParam param, String category, Long costTypeId) {
        Date[] periodtime;
        String lots;
        List projectNumberIds;
        List trackNumberIds;
        List configuredCodeIds;
        DynamicObject materials;
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        List mnCostType = CostTypeHelper.getMnCostByHs((Long)costTypeId);
        if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
            if ("A".equals(category)) {
                param.setSimCosttypeIdA((Long)mnCostType.get(0));
            } else {
                param.setSimCosttypeIdB((Long)mnCostType.get(0));
            }
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(materials = param.getMaterial()))) {
            filters.add(new QFilter("material", "=", (Object)materials.getLong("id")));
        }
        if (!CadEmptyUtils.isEmpty((List)(configuredCodeIds = param.getConfiguredCodeIds()))) {
            filters.add(new QFilter("configuredcode", "in", (Object)configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(trackNumberIds = param.getTrackNumberIds()))) {
            filters.add(new QFilter("tracknumber", "in", (Object)trackNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(projectNumberIds = param.getProjectNumberIds()))) {
            filters.add(new QFilter("project", "in", (Object)projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = param.getLots()))) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        Date date = param.getQueryDate();
        if (param.getQueryDate() != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)date));
            filters.add(new QFilter("expdate", ">", (Object)date));
        } else if (param.getQueryPeriodId() != null && param.getQueryPeriodId() != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)param.getQueryPeriodId())) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        String queryFileds = "id,material,keycol,tracknumber";
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet("getMatInfos", "cad_matcostinfo", queryFileds, filters.toArray(new QFilter[0]), "keycol", -1, null);
        HashSet<Long> matCostInfoIds = new HashSet<Long>(16);
        HashSet<String> trackKeyCols = new HashSet<String>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long tracknumber = row.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty((Long)tracknumber)) {
                matCostInfoIds.add(row.getLong("id"));
                continue;
            }
            trackKeyCols.add(row.getString("keycol"));
        }
        if ("A".equals(category)) {
            param.setMatCostInfoIdsA(matCostInfoIds);
            param.setTrackKeyColsA(trackKeyCols);
        } else {
            param.setMatCostInfoIdsB(matCostInfoIds);
            param.setTrackKeyColsB(trackKeyCols);
        }
    }

    protected DataSet queryDataSet(FinalStdAnalysisRptParam param, String category) {
        Long costTypeId = 0L;
        costTypeId = "A".equals(category) ? Long.valueOf(param.getCostType_a().getLong("id")) : Long.valueOf(param.getCostType_b().getLong("id"));
        boolean isAnalogCost = BomRouterHelper.isAnalogCostType((Long)costTypeId);
        if (!isAnalogCost) {
            this.getMatInfos(param, category, costTypeId);
        }
        List commonFilters = FinalStdAnalysisRptHelper.getCommonFiltersBy((FinalStdAnalysisRptParam)param, (String)category, (boolean)isAnalogCost);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        ArrayList<QFilter> traFilters = new ArrayList<QFilter>(10);
        traFilters.add(new QFilter("entryentity.entrylevel", "=", (Object)0));
        HashSet<Long> calcMatIds = new HashSet<Long>(16);
        Date date = null;
        Long queryPeriodId = 0L;
        if (!isAnalogCost) {
            date = param.getQueryDate();
            queryPeriodId = param.getQueryPeriodId();
        }
        DataSet bomSettingDataSet = this.getBomSettingMatIds(costTypeId, param.getMaterial(), date, queryPeriodId);
        while (bomSettingDataSet.hasNext()) {
            Row row = bomSettingDataSet.next();
            calcMatIds.add(row.getLong("material"));
            Long copentrymaterial = row.getLong("copentrymaterial");
            if (copentrymaterial == null || copentrymaterial <= 0L) continue;
            calcMatIds.add(copentrymaterial);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)param.getMaterial())) {
            long matId = param.getMaterial().getLong("id");
            traFilters.add(new QFilter("material", "=", (Object)matId));
            calcMatIds.add(matId);
            filters.add(new QFilter("material", "in", calcMatIds));
        }
        DataSet dataSet = null;
        HashSet<Long> mulmaterialIdSet = null;
        DynamicObjectCollection mulgroupmaterial = param.getMulgroupmaterial();
        if (mulgroupmaterial != null) {
            mulmaterialIdSet = mulgroupmaterial.stream().map(costObject -> costObject.getLong("id")).collect(Collectors.toSet());
        }
        if (Long.compare(param.getMaterialgrpstd().getLong("id"), 730148448254487552L) != 0) {
            HashSet<Long> classifiedMaterialId = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)param.getMulmaterialgroup(), (boolean)false, (DynamicObject)param.getMaterialgrpstd(), (boolean)true);
            if (mulmaterialIdSet == null || mulmaterialIdSet.size() == 0) {
                mulmaterialIdSet = classifiedMaterialId;
            } else if (classifiedMaterialId != null) {
                mulmaterialIdSet.retainAll(classifiedMaterialId);
            }
            if (mulmaterialIdSet == null) {
                mulmaterialIdSet = new HashSet<Long>();
            }
        }
        filters.addAll(commonFilters);
        traFilters.addAll(commonFilters);
        if (mulmaterialIdSet != null) {
            List traObjects;
            String table = isAnalogCost ? "cad_calcsimulationresult" : "cad_calceffectiveresult";
            List objects = QueryServiceHelper.queryPrimaryKeys((String)table, (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
            filters.clear();
            filters.add(new QFilter("id", "in", (Object)objects));
            if ("A".equals(category)) {
                if (isAnalogCost || !CadEmptyUtils.isEmpty((Set)param.getTrackKeyColsA())) {
                    traObjects = QueryServiceHelper.queryPrimaryKeys((String)"cad_trackstdcalcresult", (QFilter[])traFilters.toArray(new QFilter[0]), null, (int)-1);
                    traFilters.clear();
                    filters.add(new QFilter("costtype", "=", (Object)(isAnalogCost ? costTypeId : param.getSimCosttypeIdA())));
                    traFilters.add(new QFilter("id", "in", (Object)traObjects));
                }
            } else if (isAnalogCost || !CadEmptyUtils.isEmpty((Set)param.getTrackKeyColsB())) {
                traObjects = QueryServiceHelper.queryPrimaryKeys((String)"cad_trackstdcalcresult", (QFilter[])traFilters.toArray(new QFilter[0]), null, (int)-1);
                traFilters.clear();
                filters.add(new QFilter("costtype", "=", (Object)(isAnalogCost ? costTypeId : param.getSimCosttypeIdB())));
                traFilters.add(new QFilter("id", "in", (Object)traObjects));
            }
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulgroupmaterial)) {
                mulmaterialIdSet.add(0L);
            }
            param.setSubMatIds(mulmaterialIdSet);
        }
        dataSet = isAnalogCost ? this.queryAnalogDataSet(filters, traFilters, param, Arrays.asList("2", "3"), category) : this.queryAuditDataSet(filters, traFilters, param, Arrays.asList("2", "3"), category);
        DataSet subMatDataSet = null;
        if (mulgroupmaterial == null && !isAnalogCost) {
            HashSet<Long> outcalcMatIds = new HashSet<Long>(1);
            DynamicObject queryMat = param.getMaterial();
            if (queryMat != null) {
                outcalcMatIds.add(queryMat.getLong("id"));
            }
            DataSet filterOutDataSet = this.getPurPriceMatDataSet(costTypeId, outcalcMatIds, param, category, date);
            filterOutDataSet = filterOutDataSet.leftJoin(dataSet).on("material", "material").on("keycol", "keycol").select(filterOutDataSet.getRowMeta().getFieldNames(), new String[]{"material as analogmaterial"}).finish();
            filterOutDataSet = filterOutDataSet.filter("analogmaterial is null or analogmaterial == 0");
            filterOutDataSet = filterOutDataSet.removeFields(new String[]{"analogmaterial"}).distinct();
            subMatDataSet = this.groupBy(filterOutDataSet, param, category);
        }
        if ("A".equals(category)) {
            String AFields = "costtype," + this.getCommonAliasFields() + ",bom_a,cost_a";
            if (param.isDateial().booleanValue()) {
                AFields = AFields + ",qty_a,price_a,material_a,keycol_a,auxprop_a,datatype_a,calcbasis_a,resource_a,matnumber_a,matname_a,resnumber_a,resname_a,subconfiguredcode_a,subtracknumber_a,subproject_a,sublot_a";
            }
            dataSet = dataSet.select(AFields);
            if (subMatDataSet != null) {
                dataSet = dataSet.union(subMatDataSet.select(AFields));
            }
        } else {
            String BFields = "costtype," + this.getCommonAliasFields() + ",bom_b,cost_b";
            if (param.isDateial().booleanValue()) {
                BFields = BFields + ",qty_b,price_b,material_b,keycol_b,auxprop_b,datatype_b,calcbasis_b,resource_b,matnumber_b,matname_b,resnumber_b,resname_b,subconfiguredcode_b,subtracknumber_b,subproject_b,sublot_b";
            }
            dataSet = dataSet.select(BFields);
            if (subMatDataSet != null) {
                dataSet = dataSet.union(subMatDataSet.select(BFields));
            }
        }
        return dataSet;
    }

    protected DataSet queryAnalogDataSet(List<QFilter> filters, List<QFilter> traFilters, FinalStdAnalysisRptParam param, List<String> dateTypeList, String category) {
        QFilter recordFilter;
        Long costTypeId = 0L;
        costTypeId = "A".equals(category) ? Long.valueOf(param.getCostType_a().getLong("id")) : Long.valueOf(param.getCostType_b().getLong("id"));
        filters.add(new QFilter("entryentity.datatype", "in", dateTypeList));
        traFilters.add(new QFilter("entryentity.subentryentity.datatype", "in", dateTypeList));
        filters.add(new QFilter("ismaindata", "=", (Object)1));
        traFilters.add(new QFilter("entryentity.entryismaindata", "=", (Object)1));
        String calcRecordIdName = param.getCalcRecordAName();
        if ("B".equals(category)) {
            calcRecordIdName = param.getCalcRecordBName();
        }
        if (!CadEmptyUtils.isEmpty((String)calcRecordIdName)) {
            recordFilter = new QFilter("calcrecord.name", "=", (Object)calcRecordIdName);
            filters.add(recordFilter);
            traFilters.add(new QFilter("1", "=", (Object)2));
        } else {
            recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
            filters.add(recordFilter);
        }
        Set subMatIds = param.getSubMatIds();
        if (!CadEmptyUtils.isEmpty((Set)subMatIds)) {
            QFilter subMaterialFilter = new QFilter("entryentity.submaterial", "in", (Object)subMatIds);
            QFilter subMaterialFilter2 = new QFilter("origentryentity.origentrymaterial", "in", (Object)subMatIds);
            filters.add(subMaterialFilter);
            traFilters.add(subMaterialFilter2);
        }
        ORMImpl orm = new ORMImpl();
        DataSet analogDataSet = orm.queryDataSet(this.getAlgoKey("queryAnalogDataSet"), "cad_calcsimulationresult", this.getAnalogSelectFields(category), filters.toArray(new QFilter[0]), "level asc,treepath asc", -1, null);
        DataSet trackNumberDataSet = orm.queryDataSet(this.getAlgoKey("queryAnalogDataSet"), "cad_trackstdcalcresult", this.getTraSelectFields(category), traFilters.toArray(new QFilter[0]), "treepath asc", -1, null);
        DataSet dateDataSet = trackNumberDataSet.filter("expdate is not null");
        DataSet trackNumberDateDataSet = dateDataSet.filter("curdate>=effectdate and curdate<=expdate");
        DataSet keyColDateDataSet = dateDataSet.groupBy(new String[]{"material", "keycol keyColcherck"}).finish();
        DataSet trackNumberUnDateDataSet = trackNumberDataSet.leftJoin(keyColDateDataSet).on("material", "material").on("keycol", "keyColcherck").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"keyColcherck"}).finish().filter("keyColcherck is null");
        DataSet dataSet = DataSetUtils.union((DataSet)DataSetUtils.union((DataSet)analogDataSet, (DataSet)trackNumberDateDataSet), (DataSet)trackNumberUnDateDataSet);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)param.getMulgroupmaterial())) {
            DataSet outDataSet = this.getOutMatDataSet(costTypeId, param, category);
            dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)outDataSet);
            DataSet maxDateDataSet = dataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
            dataSet = dataSet.join(maxDateDataSet).on("material", "material").on("keycol", "keycol").select(dataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
            dataSet = dataSet.filter("calcdate=maxcalcdate");
        }
        return this.groupBy(dataSet, param, category);
    }

    private DataSet getPurPriceMatDataSet(Long costTypeId, Set<Long> isNotDownCalcMatIds, FinalStdAnalysisRptParam param, String category, Date date) {
        String fields = "costtype, material, 0 treepath,material.number matnumber,material.baseunit.name unit,material.modelnum model,keycol,configuredcode,tracknumber,project,lot,auxpty auxproperty,entryentity.element.id element,entryentity.element.name elementname,entryentity.subelement.id subelement";
        Set matCostInfos = param.getMatCostInfoIdsA();
        if ("A".equals(category)) {
            fields = fields + ",0 AS bom_a, 1.0000000000 AS qty_a, entryentity.price AS price_a, entryentity.price AS cost_a";
            fields = fields + ",0 material_a, '' keycol_a, 0 auxprop_a,'' AS datatype_a, '' AS calcbasis,0 resource_a,'' matnumber_a,'' matname_a,'' resnumber_a,'' resname_a,0L subconfiguredcode_a,0L subtracknumber_a,0L subproject_a,'' sublot_a";
        } else {
            matCostInfos = param.getMatCostInfoIdsB();
            fields = fields + ",0 AS bom_b, 1.0000000000 AS qty_b, entryentity.price AS price_b, entryentity.price AS cost_b";
            fields = fields + ",0 material_b, '' keycol_b, 0 auxprop_b,'' AS datatype_b, '' AS calcbasis_b,0 resource_b,'' matnumber_b,'' matname_b,'' resnumber_b,'' resname_b,0L subconfiguredcode_b,0L subtracknumber_b,0L subproject_b,'' sublot_b";
        }
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter costTypeQf = new QFilter("costtype", "=", (Object)costTypeId);
        if (!CadEmptyUtils.isEmpty(isNotDownCalcMatIds)) {
            costTypeQf.and(new QFilter("material", "in", isNotDownCalcMatIds));
        }
        Date dayEnd = DateUtils.getDayEndTime((Date)new Date());
        QFilter dateQfe = new QFilter("effectdate", "<=", (Object)dayEnd);
        QFilter dateQfen = new QFilter("expdate", ">", (Object)dayEnd);
        QFilter idQf = new QFilter("matcostid", "in", (Object)matCostInfos);
        ORMImpl orm = new ORMImpl();
        DataSet subMatDataSet = orm.queryDataSet(this.getAlgoKey("count"), "cad_purprices", fields, new QFilter[]{billStatusQf, costTypeQf, dateQfe, dateQfen, idQf}, "", -1, null);
        return subMatDataSet;
    }

    protected DataSet getOutMatDataSet(Long costTypeId, FinalStdAnalysisRptParam param, String category) {
        QFilter recordFilter;
        boolean isAnalogCost = BomRouterHelper.isAnalogCostType((Long)costTypeId);
        List filters = FinalStdAnalysisRptHelper.getCommonFiltersBy((FinalStdAnalysisRptParam)param, (String)category, (boolean)isAnalogCost);
        String calcRecordIdName = param.getCalcRecordAName();
        if ("B".equals(category)) {
            calcRecordIdName = param.getCalcRecordBName();
        }
        if (!CadEmptyUtils.isEmpty((String)calcRecordIdName)) {
            recordFilter = new QFilter("calcrecord.name", "=", (Object)calcRecordIdName);
            filters.add(recordFilter);
        } else {
            recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
            filters.add(recordFilter);
        }
        if (param.getMaterial() != null) {
            long matId = param.getMaterial().getLong("id");
            filters.add(new QFilter("material", "=", (Object)matId));
        }
        String fields = "costtype,calcdate, material, '0' treepath,material.number matnumber,material.baseunit.name unit,material.modelnum model,keycol,configuredcode,tracknumber,project,lot,auxpty auxproperty,entryentity.element.id element,entryentity.element.name elementname,entryentity.subelement.id subelement";
        if ("A".equals(category)) {
            fields = fields + ",0 AS bom_a, 1.0000000000 AS qty_a, entryentity.price AS price_a, entryentity.price AS cost_a";
            fields = fields + ",0 material_a, '' keycol_a, 0 auxprop_a,'' AS datatype_a,'' AS calcbasis_a, 0L resource_a,'' matnumber_a,'' matname_a,'' resnumber_a,'' resname_a,0L subconfiguredcode_a,0L subtracknumber_a,0L subproject_a,'' sublot_a";
        } else {
            fields = fields + ",0 AS bom_b, 1.0000000000 AS qty_b, entryentity.price AS price_b, entryentity.price AS cost_b";
            fields = fields + ",0 material_b, '' keycol_b, 0 auxprop_b,'' AS datatype_b, '' AS calcbasis_b,0L resource_b,'' matnumber_b,'' matname_b,'' resnumber_b,'' resname_b,0L subconfiguredcode_b,0L subtracknumber_b,0L subproject_b,'' sublot_b";
        }
        ORMImpl orm = new ORMImpl();
        DataSet outDataSet = orm.queryDataSet(this.getAlgoKey("count"), "cad_calcpurprices", fields, filters.toArray(new QFilter[0]), "", -1, null);
        return outDataSet;
    }

    private DataSet queryAuditDataSet(List<QFilter> filters, List<QFilter> traFilters, FinalStdAnalysisRptParam param, List<String> dateTypeList, String category) {
        Date[] periodtime;
        Long costTypeId = 0L;
        filters.add((QFilter)new QFilter("entryentity.datatype", "in", dateTypeList));
        filters.add((QFilter)new QFilter("ismaindata", "=", (Object)1));
        Set matCostInfos = param.getMatCostInfoIdsA();
        Set trackKeyCols = param.getTrackKeyColsA();
        if ("B".equals(category)) {
            trackKeyCols = param.getTrackKeyColsB();
            matCostInfos = param.getMatCostInfoIdsB();
        }
        filters.add((QFilter)new QFilter("matcostid", "in", (Object)matCostInfos));
        Date queryDate = param.getQueryDate();
        if (queryDate != null) {
            filters.add((QFilter)new QFilter("effectdate", "<=", (Object)queryDate));
            filters.add((QFilter)new QFilter("expdate", ">=", (Object)queryDate));
        } else if (param.getQueryPeriodId() != null && param.getQueryPeriodId() != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)param.getQueryPeriodId())) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(this.getAlgoKey("queryAuditDataSet"), "cad_calceffectiveresult", this.getAuditSelectFields(category), filters.toArray(new QFilter[0]), "level asc,treepath asc", -1, null);
        if (Boolean.TRUE.equals(CostUpdateHelper.isQueryPeriod((ReportQueryParam)this.getQueryParam()))) {
            String queryPeriodGroups = "material,auxproperty,keycol";
            String queryPeriodFields = queryPeriodGroups + ",effectdate";
            DataSet queryPeriodDataSet = dataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
            dataSet = dataSet.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("keycol", "keycol").on("effectdate", "effectdate").select(dataSet.getRowMeta().getFieldNames(), null).finish();
        }
        if (!CadEmptyUtils.isEmpty((Set)trackKeyCols)) {
            Date[] periodtime2;
            traFilters.add((QFilter)new QFilter("entryentity.subentryentity.datatype", "in", dateTypeList));
            traFilters.add((QFilter)new QFilter("entryentity.entryismaindata", "=", (Object)1));
            traFilters.add((QFilter)new QFilter("keycol", "in", (Object)trackKeyCols));
            if (param.getQueryDate() != null) {
                traFilters.add((QFilter)new QFilter("effectdate", "<=", (Object)queryDate));
                traFilters.add((QFilter)new QFilter("expdate", ">", (Object)queryDate));
            } else if (param.getQueryPeriodId() != null && param.getQueryPeriodId() != 0L && (periodtime2 = PeriodHelper.getPeriodStartAndEndTime((Long)param.getQueryPeriodId())) != null) {
                traFilters = CostUpdateHelper.getPeriodQF(traFilters, (Date[])periodtime2);
            }
            DataSet trackNumberDataSet = orm.queryDataSet(this.getAlgoKey("queryAnalogDataSet"), "cad_trackstdcalcresult", this.getTraSelectFields(category), traFilters.toArray(new QFilter[0]), "treepath asc", -1, null);
            DataSet dateDataSet = trackNumberDataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
            trackNumberDataSet = trackNumberDataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
            trackNumberDataSet = trackNumberDataSet.filter("calcdate=maxcalcdate");
            dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)trackNumberDataSet);
        }
        return this.groupBy(dataSet, param, category);
    }

    protected DataSet groupBy(DataSet dataSet, FinalStdAnalysisRptParam param, String category) {
        if ("A".equals(category)) {
            String selectFields = "costtype,treepath,material,matnumber,unit,model,keycol,auxproperty,configuredcode,tracknumber,project,lot,element,elementname,subelement,bom_a,qty_a,price_a,cost_a,material_a,keycol_a,auxprop_a,datatype_a,calcbasis_a,resource_a,matnumber_a,matname_a,resnumber_a,resname_a,subconfiguredcode_a,subtracknumber_a,subproject_a,sublot_a";
            ArrayList<String> groupFields = new ArrayList<String>(Arrays.asList("costtype", "element", "elementname", "subelement", "material", "matnumber", "configuredcode", "tracknumber", "project", "lot", "keycol", "auxproperty", "bom_a", "model", "unit"));
            if (param.isDateial().booleanValue()) {
                groupFields.add("material_a");
                groupFields.add("keycol_a");
                groupFields.add("auxprop_a");
                groupFields.add("datatype_a");
                groupFields.add("calcbasis_a");
                groupFields.add("resource_a");
                groupFields.add("matnumber_a");
                groupFields.add("matname_a");
                groupFields.add("resnumber_a");
                groupFields.add("resname_a");
                groupFields.add("subconfiguredcode_a");
                groupFields.add("subtracknumber_a");
                groupFields.add("subproject_a");
                groupFields.add("sublot_a");
            }
            GroupbyDataSet gds = dataSet.select(selectFields).groupBy(groupFields.toArray(new String[0]));
            if (param.isDateial().booleanValue()) {
                gds = gds.sum("qty_a").avg("price_a");
            }
            dataSet = gds.sum("cost_a").finish().orderBy(new String[]{"matnumber desc"});
        } else {
            String selectFields = "costtype,treepath,material,matnumber,unit,model,keycol,auxproperty,configuredcode,tracknumber,project,lot,element,elementname,subelement,bom_b,qty_b,price_b,cost_b,material_b,keycol_b,auxprop_b,datatype_b,calcbasis_b,resource_b,matnumber_b,matname_b,resnumber_b,resname_b,subconfiguredcode_b,subtracknumber_b,subproject_b,sublot_b";
            ArrayList<String> groupFields = new ArrayList<String>(Arrays.asList("costtype", "element", "elementname", "subelement", "material", "matnumber", "configuredcode", "tracknumber", "project", "lot", "keycol", "auxproperty", "bom_b", "model", "unit"));
            if (param.isDateial().booleanValue()) {
                groupFields.add("material_b");
                groupFields.add("keycol_b");
                groupFields.add("auxprop_b");
                groupFields.add("datatype_b");
                groupFields.add("calcbasis_b");
                groupFields.add("resource_b");
                groupFields.add("matnumber_b");
                groupFields.add("matname_b");
                groupFields.add("resnumber_b");
                groupFields.add("resname_b");
                groupFields.add("subconfiguredcode_b");
                groupFields.add("subtracknumber_b");
                groupFields.add("subproject_b");
                groupFields.add("sublot_b");
            }
            GroupbyDataSet gds = dataSet.select(selectFields).groupBy(groupFields.toArray(new String[0]));
            if (param.isDateial().booleanValue()) {
                gds = gds.sum("qty_b").avg("price_b");
            }
            dataSet = gds.sum("cost_b").finish().orderBy(new String[]{"matnumber desc"});
        }
        return dataSet;
    }

    protected List<Object[]> count(DataSet allDataSet_b, FinalStdAnalysisRptParam rptParam) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        LinkedHashMap<String, List<Row>> matMap = new LinkedHashMap<String, List<Row>>();
        HashSet<Long> elementIds = new HashSet<Long>();
        this.groupMatMap(allDataSet_b.copy(), matMap, elementIds, rptParam.getShowgroup());
        HashSet<Long> elementIsMatPropSet = new HashSet<Long>(16);
        HashSet<Long> elementIsNotMatPropSet = new HashSet<Long>(16);
        this.getMatPropElementIds(elementIds, elementIsMatPropSet, elementIsNotMatPropSet);
        LinkedHashMap<String, Object[]> groupMap = new LinkedHashMap<String, Object[]>(16);
        int materialgroupindex = this.getListFieldIndex("materialgroup", rptParam);
        int costaindexa = this.getListFieldIndex("cost_a", rptParam);
        int costbindexb = this.getListFieldIndex("cost_b", rptParam);
        int diffcostindex = this.getListFieldIndex("diffcost", rptParam);
        int subelementindex = this.getListFieldIndex("subelement", rptParam);
        StringBuilder keyBuilder = new StringBuilder();
        for (Map.Entry entry : matMap.entrySet()) {
            int i;
            List items = (List)entry.getValue();
            Object[] countRowData = new Object[this.getRowMeta(rptParam).getFields().length];
            String[] matInfos = ((String)entry.getKey()).split("@");
            countRowData[this.getListFieldIndex((String)"material", (FinalStdAnalysisRptParam)rptParam)] = matInfos[0];
            countRowData[this.getListFieldIndex((String)"keycol", (FinalStdAnalysisRptParam)rptParam)] = matInfos[1];
            countRowData[this.getListFieldIndex((String)"auxprop", (FinalStdAnalysisRptParam)rptParam)] = matInfos[2];
            countRowData[this.getListFieldIndex((String)"elementname", (FinalStdAnalysisRptParam)rptParam)] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"FinalStdAnalysisRptQueryPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]);
            BigDecimal totalCost_a = BigDecimal.ZERO;
            BigDecimal totalCost_b = BigDecimal.ZERO;
            Long bom_a = 0L;
            Long bom_b = 0L;
            String baseunit = null;
            Boolean isAddSmallLine = false;
            for (i = 0; i < items.size(); ++i) {
                Long rowBom_b;
                Row row = (Row)items.get(i);
                if (i == 0) {
                    countRowData[this.getListFieldIndex((String)"configuredcode", (FinalStdAnalysisRptParam)rptParam)] = row.getLong("configuredcode");
                    countRowData[this.getListFieldIndex((String)"tracknumber", (FinalStdAnalysisRptParam)rptParam)] = row.getLong("tracknumber");
                    countRowData[this.getListFieldIndex((String)"project", (FinalStdAnalysisRptParam)rptParam)] = row.getLong("project");
                    countRowData[this.getListFieldIndex((String)"lot", (FinalStdAnalysisRptParam)rptParam)] = row.getString("lot");
                    countRowData[this.getListFieldIndex((String)"keycol", (FinalStdAnalysisRptParam)rptParam)] = row.getString("keycol");
                }
                BigDecimal cost_a = row.getBigDecimal("cost_a");
                BigDecimal cost_b = row.getBigDecimal("cost_b");
                if (cost_a == null && cost_b == null) continue;
                totalCost_a = totalCost_a.add(cost_a == null ? BigDecimal.ZERO : cost_a);
                totalCost_b = totalCost_b.add(cost_b == null ? BigDecimal.ZERO : cost_b);
                Long rowBom_a = row.getLong("bom_a");
                if (rowBom_a != null) {
                    bom_a = rowBom_a;
                }
                if ((rowBom_b = row.getLong("bom_b")) != null) {
                    bom_b = rowBom_b;
                }
                String rowBaseunit = row.getString("unit");
                if (StringUtils.isEmpty(baseunit) && !StringUtils.isEmpty((CharSequence)rowBaseunit)) {
                    baseunit = rowBaseunit;
                }
                if (rptParam.isDateial().booleanValue()) {
                    Long materialgroup = row.getLong("materialgroup");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rptParam.getMulmaterialgroup())) {
                        isAddSmallLine = true;
                        continue;
                    }
                    if (CadEmptyUtils.isEmpty((Long)materialgroup)) continue;
                    isAddSmallLine = true;
                    continue;
                }
                isAddSmallLine = true;
            }
            countRowData[this.getListFieldIndex((String)"currency", (FinalStdAnalysisRptParam)rptParam)] = this.currency_a;
            countRowData[this.getListFieldIndex((String)"cost_a", (FinalStdAnalysisRptParam)rptParam)] = totalCost_a;
            countRowData[this.getListFieldIndex((String)"cost_b", (FinalStdAnalysisRptParam)rptParam)] = totalCost_b;
            countRowData[this.getListFieldIndex((String)"diffcost", (FinalStdAnalysisRptParam)rptParam)] = totalCost_a.subtract(totalCost_b);
            countRowData[this.getListFieldIndex((String)"bom_a", (FinalStdAnalysisRptParam)rptParam)] = bom_a;
            countRowData[this.getListFieldIndex((String)"bom_b", (FinalStdAnalysisRptParam)rptParam)] = bom_b;
            countRowData[this.getListFieldIndex((String)"unit", (FinalStdAnalysisRptParam)rptParam)] = baseunit;
            if (!isAddSmallLine.booleanValue()) continue;
            dataList.add(countRowData);
            if (rptParam.getShowsum().booleanValue()) continue;
            for (i = 0; i < items.size(); ++i) {
                Object[] objectRow = this.getObjectRow((Row)items.get(i), elementIsNotMatPropSet, elementIsMatPropSet, rptParam);
                if (objectRow == null) continue;
                if (rptParam.getShowgroup().booleanValue()) {
                    Long materialgroup = (Long)objectRow[materialgroupindex];
                    Long subelement = (Long)objectRow[subelementindex];
                    keyBuilder.setLength(0);
                    String key = keyBuilder.append(materialgroup).append("/").append(subelement).toString();
                    Object[] objects = (Object[])((HashMap)groupMap).get(key);
                    if (objects != null) {
                        this.setRowValue(costaindexa, objectRow, objects[costaindexa]);
                        this.setRowValue(costbindexb, objectRow, objects[costbindexb]);
                        this.setRowValue(diffcostindex, objectRow, objects[diffcostindex]);
                    }
                    groupMap.put(key, objectRow);
                    continue;
                }
                dataList.add(objectRow);
            }
            if (!rptParam.getShowgroup().booleanValue() || groupMap.size() <= 0) continue;
            for (Map.Entry mapEntry : ((HashMap)groupMap).entrySet()) {
                dataList.add((Object[])mapEntry.getValue());
            }
            ((HashMap)groupMap).clear();
        }
        return dataList;
    }

    private void setRowValue(int costaindexa, Object[] objectRow, Object object) {
        if (object == null) {
            return;
        }
        BigDecimal stdprice = BigDecimal.ZERO;
        if (object instanceof BigDecimal) {
            stdprice = (BigDecimal)object;
        } else if (object instanceof String) {
            String value = (String)object;
            stdprice = new BigDecimal(value);
        }
        if (CadEmptyUtils.isEmpty((BigDecimal)stdprice)) {
            return;
        }
        BigDecimal rowStdPrice = (BigDecimal)objectRow[costaindexa];
        objectRow[costaindexa] = CadEmptyUtils.isEmpty((BigDecimal)rowStdPrice) ? stdprice : stdprice.add(rowStdPrice).toPlainString();
    }

    private void getMatPropElementIds(Set<Long> elementIds, Set<Long> elementIsMatPropSet, Set<Long> elementIsNotMatPropSet) {
        QFilter elementNameFilter = new QFilter("id", "in", elementIds);
        DynamicObjectCollection elements = QueryServiceHelper.query((String)"cad_element", (String)"id, type", (QFilter[])new QFilter[]{elementNameFilter});
        elements.forEach(e -> {
            String type = e.getString("type");
            if ("003".equals(type) || "004".equals(type)) {
                elementIsNotMatPropSet.add(e.getLong("id"));
            } else if ("001".equals(type) || "002".equals(type)) {
                elementIsMatPropSet.add(e.getLong("id"));
            }
        });
    }

    private void groupMatMap(DataSet rows, Map<String, List<Row>> matMap, Set<Long> elementIds, Boolean showgroup) {
        while (rows.hasNext()) {
            Row row = rows.next();
            String key = row.getString("material") + "@" + row.getString("keycol") + "@" + row.getString("auxproperty");
            matMap.computeIfAbsent(key, s -> new ArrayList()).add(row);
            elementIds.add((Long)row.get("element"));
        }
    }

    protected Object[] getObjectRow(Row row, Set<Long> elementIsNotMatPropSet, Set<Long> elementIsMatPropSet, FinalStdAnalysisRptParam rptParam) {
        ArrayList<String> notShowFields = new ArrayList<String>(Arrays.asList("material", "keycol", "modelnum", "bom", "unit", "configuredcode", "tracknumber", "project", "lot"));
        int matresnumberindex = this.getListFieldIndex("matresnumber", rptParam);
        int matresnameindex = this.getListFieldIndex("matresname", rptParam);
        int subkeycolindex = this.getListFieldIndex("subkeycol", rptParam);
        int subauxpropindex = this.getListFieldIndex("subauxprop", rptParam);
        int subdatatypeindex = this.getListFieldIndex("subdatatype", rptParam);
        int materialaindex = this.getListFieldIndex("material_a", rptParam);
        int materialbindex = this.getListFieldIndex("material_b", rptParam);
        int submaterialindex = this.getListFieldIndex("submaterial", rptParam);
        if (this.isDetail()) {
            notShowFields.remove("unit");
        }
        boolean isNotMatProp = elementIsNotMatPropSet.contains((Long)row.get("element"));
        boolean isMatProp = elementIsMatPropSet.contains((Long)row.get("element"));
        Field[] fields = this.getRowMeta(rptParam).getFields();
        Object[] rowData = new Object[fields.length];
        HashSet dataSetNotExistFileNames = Sets.newHashSet((Object[])new String[]{"matresnumber", "matresname", "subkeycol", "subauxprop", "subdatatype", "submaterial"});
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (dataSetNotExistFileNames.contains(name)) continue;
            if ("material_b".equals(name) || "material_a".equals(name)) {
                Set subMatIds;
                Long submaterial = (Long)row.get(name);
                if (submaterial == null) {
                    submaterial = 0L;
                }
                if (!CadEmptyUtils.isEmpty((Long)submaterial)) {
                    rowData[submaterialindex] = submaterial;
                }
                if ((subMatIds = rptParam.getSubMatIds()) != null && !subMatIds.contains(submaterial)) {
                    return null;
                }
            }
            if (notShowFields.contains(name)) continue;
            try {
                if ("currency".equals(name)) {
                    rowData[i] = this.currency_a;
                    continue;
                }
                Object val = row.get(name);
                switch (name) {
                    case "unit": {
                        if (!isNotMatProp) break;
                        String calcbasisA = row.getString("calcbasis_a");
                        String calcbasisB = row.getString("calcbasis_b");
                        if ("001".equals(calcbasisA) || "001".equals(calcbasisB)) {
                            val = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"FinalStdAnalysisRptQueryPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]);
                            break;
                        }
                        val = ResManager.loadKDString((String)"\u4e2a", (String)"FinalStdAnalysisRptQueryPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
                        break;
                    }
                    case "qty_a": {
                        if (!isNotMatProp) break;
                        val = ((BigDecimal)val).divide(new BigDecimal(60), 10, 4);
                        break;
                    }
                    case "price_a": {
                        if (!isNotMatProp) break;
                        val = ((BigDecimal)val).multiply(new BigDecimal(60));
                        break;
                    }
                    case "qty_b": {
                        if (!isNotMatProp) break;
                        val = ((BigDecimal)val).divide(new BigDecimal(60), 10, 4);
                        break;
                    }
                    case "price_b": {
                        if (!isNotMatProp) break;
                        val = ((BigDecimal)val).multiply(new BigDecimal(60));
                        break;
                    }
                    case "diffqty": {
                        BigDecimal qty_a = row.get("qty_a") == null ? BigDecimal.ZERO : (BigDecimal)row.get("qty_a");
                        BigDecimal qty_b = row.get("qty_b") == null ? BigDecimal.ZERO : (BigDecimal)row.get("qty_b");
                        BigDecimal diffVal = qty_a.subtract(qty_b);
                        if (isNotMatProp) {
                            diffVal = diffVal.divide(new BigDecimal(60), 10, 4);
                        }
                        val = BigDecimalUtils.format((BigDecimal)diffVal, (String)"0.0000000000");
                        break;
                    }
                    case "diffcost": {
                        BigDecimal cost_a = row.get("cost_a") == null ? BigDecimal.ZERO : (BigDecimal)row.get("cost_a");
                        BigDecimal cost_b = row.get("cost_b") == null ? BigDecimal.ZERO : (BigDecimal)row.get("cost_b");
                        val = cost_a.subtract(cost_b);
                        break;
                    }
                    case "datatype_a": {
                        if (rptParam.getShowgroup().booleanValue()) {
                            if (isMatProp) {
                                val = "";
                            }
                        } else {
                            Long subMatId_a = (Long)row.get("material_a");
                            if (isMatProp || subMatId_a != null && subMatId_a != 0L) {
                                val = "";
                            }
                        }
                        if (val == null || "".equals(val)) break;
                        rowData[subdatatypeindex] = val;
                        break;
                    }
                    case "datatype_b": {
                        if (rptParam.getShowgroup().booleanValue()) {
                            if (isMatProp) {
                                val = "";
                            }
                        } else {
                            Long subMatId_b = (Long)row.get("material_b");
                            if (isMatProp || subMatId_b != null && subMatId_b != 0L) {
                                val = "";
                            }
                        }
                        if (val == null || "".equals(val)) break;
                        rowData[subdatatypeindex] = val;
                        break;
                    }
                    case "materialgroup": {
                        Long materialgroup;
                        DynamicObject materialgrpstd = rptParam.getMaterialgrpstd();
                        if ((materialgrpstd == null || Long.compare(materialgrpstd.getLong("id"), 730148448254487552L) == 0) && CadEmptyUtils.isEmpty((DynamicObjectCollection)rptParam.getMulmaterialgroup()) || !CadEmptyUtils.isEmpty((Long)(materialgroup = (Long)row.get("materialgroup")))) break;
                        return null;
                    }
                    case "matresnumber_a": 
                    case "matresnumber_b": {
                        if (val == null || "".equals(val)) break;
                        rowData[matresnumberindex] = val;
                        break;
                    }
                    case "matresname_a": 
                    case "matresname_b": {
                        if (val == null || "".equals(val)) break;
                        rowData[matresnameindex] = val;
                        break;
                    }
                    case "keycol_a": 
                    case "keycol_b": {
                        if (CadEmptyUtils.isEmpty((String)(val + ""))) break;
                        rowData[subkeycolindex] = val;
                        break;
                    }
                    case "auxprop_a": 
                    case "auxprop_b": {
                        if (CadEmptyUtils.isEmpty((Long)((Long)val))) break;
                        rowData[subauxpropindex] = val;
                        Long rowDatum = (Long)rowData[materialbindex];
                        if (!CadEmptyUtils.isEmpty((Long)rowDatum)) break;
                        rowData[materialbindex] = rowData[materialaindex];
                    }
                }
                rowData[i] = val;
                continue;
            }
            catch (Exception e) {
                logger.error("\u5931\u8d25", (Throwable)e);
            }
        }
        return rowData;
    }

    protected RowMeta getRowMeta(FinalStdAnalysisRptParam rptParam) {
        List<Field> field = this.getRowMetaField(rptParam);
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected List<Field> getRowMetaField(FinalStdAnalysisRptParam rptParam) {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("id", (DataType)DataType.LongType));
        field.add(new Field("material", (DataType)DataType.LongType));
        field.add(new Field("materialname", (DataType)DataType.StringType));
        field.add(new Field("model", (DataType)DataType.StringType));
        field.add(new Field("keycol", (DataType)DataType.StringType));
        field.add(new Field("auxprop", (DataType)DataType.LongType));
        field.add(new Field("elementname", (DataType)DataType.StringType));
        field.add(new Field("subelement", (DataType)DataType.LongType));
        field.add(new Field("unit", (DataType)DataType.StringType));
        field.add(new Field("currency", (DataType)DataType.LongType));
        field.add(new Field("materialgroup", (DataType)DataType.LongType));
        field.add(new Field("bom_a", (DataType)DataType.LongType));
        field.add(new Field("cost_a", (DataType)DataType.BigDecimalType));
        if (rptParam.isDateial().booleanValue()) {
            field.add(new Field("material_a", (DataType)DataType.LongType));
            field.add(new Field("matname_a", (DataType)DataType.StringType));
            field.add(new Field("keycol_a", (DataType)DataType.StringType));
            field.add(new Field("auxprop_a", (DataType)DataType.LongType));
            field.add(new Field("qty_a", (DataType)DataType.StringType));
            field.add(new Field("price_a", (DataType)DataType.StringType));
            field.add(new Field("datatype_a", (DataType)DataType.StringType));
            field.add(new Field("calcbasis_a", (DataType)DataType.StringType));
            field.add(new Field("resource_a", (DataType)DataType.LongType));
            field.add(new Field("matresnumber_a", (DataType)DataType.StringType));
            field.add(new Field("matresname_a", (DataType)DataType.StringType));
        }
        field.add(new Field("bom_b", (DataType)DataType.LongType));
        field.add(new Field("cost_b", (DataType)DataType.BigDecimalType));
        if (rptParam.isDateial().booleanValue()) {
            field.add(new Field("material_b", (DataType)DataType.LongType));
            field.add(new Field("matname_b", (DataType)DataType.StringType));
            field.add(new Field("keycol_b", (DataType)DataType.StringType));
            field.add(new Field("auxprop_b", (DataType)DataType.LongType));
            field.add(new Field("qty_b", (DataType)DataType.StringType));
            field.add(new Field("price_b", (DataType)DataType.StringType));
            field.add(new Field("datatype_b", (DataType)DataType.StringType));
            field.add(new Field("calcbasis_b", (DataType)DataType.StringType));
            field.add(new Field("resource_b", (DataType)DataType.LongType));
            field.add(new Field("matresnumber_b", (DataType)DataType.StringType));
            field.add(new Field("matresname_b", (DataType)DataType.StringType));
        }
        field.add(new Field("diffqty", (DataType)DataType.StringType));
        field.add(new Field("diffcost", (DataType)DataType.BigDecimalType));
        field.add(new Field("matresnumber", (DataType)DataType.StringType));
        field.add(new Field("matresname", (DataType)DataType.StringType));
        field.add(new Field("subkeycol", (DataType)DataType.StringType));
        field.add(new Field("subauxprop", (DataType)DataType.LongType));
        field.add(new Field("subdatatype", (DataType)DataType.StringType));
        field.add(new Field("submaterial", (DataType)DataType.LongType));
        field.add(new Field("configuredcode", (DataType)DataType.LongType));
        field.add(new Field("tracknumber", (DataType)DataType.LongType));
        field.add(new Field("project", (DataType)DataType.LongType));
        field.add(new Field("lot", (DataType)DataType.StringType));
        field.add(new Field("subconfiguredcode", (DataType)DataType.LongType));
        field.add(new Field("subtracknumber", (DataType)DataType.LongType));
        field.add(new Field("subproject", (DataType)DataType.LongType));
        field.add(new Field("sublot", (DataType)DataType.StringType));
        return field;
    }

    private boolean isDetail() {
        try {
            FinalStdAnalysisRptParam rptParam = FinalStdAnalysisRptHelper.getRptParam((ReportQueryParam)this.getQueryParam());
            return rptParam.isDateial();
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private String getCostTypeBSelectFields() {
        String selectFields = "bom bom_b,entryentity.qty qty_b,entryentity.stdprice cost_b,entryentity.submaterial material_b,entryentity.subkeycol keycol_b,entryentity.subauxproperty auxprop_b,entryentity.price price_b, entryentity.datatype datatype_b, entryentity.calcbasis calcbasis_b,entryentity.resource resource_b,entryentity.submaterial.number matnumber_b,entryentity.submaterial.name matname_b,entryentity.resource.number resnumber_b,entryentity.resource.name resname_b,entryentity.subconfiguredcode subconfiguredcode_b,entryentity.subtracknumber subtracknumber_b,entryentity.subproject subproject_b,entryentity.sublot sublot_b";
        return selectFields;
    }

    private String getTraCostTypeBSelectFields() {
        String selectFields = "bomid bom_b,entryentity.subentryentity.qty qty_b,entryentity.subentryentity.stdprice cost_b,entryentity.subentryentity.submaterial material_b,entryentity.subentryentity.subkeycol keycol_b,entryentity.subentryentity.subauxproperty auxprop_b,entryentity.subentryentity.price price_b, entryentity.subentryentity.datatype datatype_b, entryentity.subentryentity.calcbasis calcbasis_b,entryentity.subentryentity.resource resource_b,entryentity.subentryentity.submaterial.number matnumber_b,entryentity.subentryentity.submaterial.name matname_b,entryentity.subentryentity.resource.number resnumber_b,entryentity.subentryentity.resource.name resname_b,entryentity.subentryentity.subconfiguredcode subconfiguredcode_b,entryentity.subentryentity.subtracknumber subtracknumber_b,entryentity.subentryentity.subproject subproject_b,entryentity.subentryentity.sublot sublot_b";
        return selectFields;
    }

    private String getCostTypeBAliasFields(FinalStdAnalysisRptParam rptParam, boolean isFinalResult) {
        String field = ",matnumber_b,matname_b,resnumber_b,resname_b,subconfiguredcode_b,subtracknumber_b,subproject_b,sublot_b";
        if (isFinalResult) {
            field = ",matresnumber_b,matresname_b";
        }
        if (rptParam.isDateial().booleanValue()) {
            return "bom_b,qty_b,cost_b,material_b,keycol_b,auxprop_b,datatype_b,calcbasis_b,resource_b,price_b" + field;
        }
        return "bom_b,cost_b";
    }

    private String getCostTypeASelectFields() {
        String selectFields = "bom bom_a,entryentity.qty qty_a,entryentity.stdprice cost_a,entryentity.submaterial material_a, entryentity.subkeycol keycol_a,entryentity.subauxproperty auxprop_a,entryentity.price price_a, entryentity.datatype datatype_a, entryentity.calcbasis calcbasis_a, entryentity.resource resource_a,entryentity.submaterial.number matnumber_a,entryentity.submaterial.name matname_a,entryentity.resource.number resnumber_a,entryentity.resource.name resname_a,entryentity.subconfiguredcode subconfiguredcode_a,entryentity.subtracknumber subtracknumber_a,entryentity.subproject subproject_a,entryentity.sublot sublot_a";
        return selectFields;
    }

    private String getTraCostTypeASelectFields() {
        String selectFields = "bomid bom_a,entryentity.subentryentity.qty qty_a,entryentity.subentryentity.stdprice cost_a,entryentity.subentryentity.submaterial material_a, entryentity.subentryentity.subkeycol keycol_a,entryentity.subentryentity.subauxproperty auxprop_a,entryentity.subentryentity.price price_a, entryentity.subentryentity.datatype datatype_a, entryentity.subentryentity.calcbasis calcbasis_a, entryentity.subentryentity.resource resource_a,entryentity.subentryentity.submaterial.number matnumber_a,entryentity.subentryentity.submaterial.name matname_a,entryentity.subentryentity.resource.number resnumber_a,entryentity.subentryentity.resource.name resname_a,entryentity.subentryentity.subconfiguredcode subconfiguredcode_a,entryentity.subentryentity.subtracknumber subtracknumber_a,entryentity.subentryentity.subproject subproject_a,entryentity.subentryentity.sublot sublot_a";
        return selectFields;
    }

    private String getCostTypeAAliasFields(FinalStdAnalysisRptParam rptParam, boolean isFinalResult) {
        String field = ",matnumber_a,matname_a,resnumber_a,resname_a,subconfiguredcode_a,subtracknumber_a,subproject_a,sublot_a";
        if (isFinalResult) {
            field = ",matresnumber_a,matresname_a";
        }
        if (rptParam.isDateial().booleanValue()) {
            return "bom_a,qty_a,cost_a,material_a,keycol_a,auxprop_a,datatype_a,calcbasis_a,resource_a,price_a" + field;
        }
        return "bom_a,cost_a";
    }

    private String getCommonNoCostTypeSelectFields() {
        String selectFields = "treepath,material,material.baseunit.name unit,material.number matnumber,material.modelnum model,auxproperty,keycol,configuredcode,tracknumber,project,lot,entryentity.element.id element,entryentity.element.name elementname,entryentity.subelement.id subelement";
        return selectFields;
    }

    private String getTraCommonNoCostTypeSelectFields() {
        String selectFields = "treepath,material,material.baseunit.name unit,material.number matnumber,material.modelnum model,auxproperty,keycol,configuredcode,tracknumber,project,lot,entryentity.subentryentity.element.id element,entryentity.subentryentity.element.name elementname,entryentity.subentryentity.subelement.id subelement,effectdate,expdate,now() as curDate";
        return selectFields;
    }

    private String getCommonAliasFields() {
        String selectFields = "material,unit,matnumber,model,auxproperty,keycol,configuredcode,tracknumber,project,lot,element,elementname,subelement";
        return selectFields;
    }

    protected String getAnalogSelectFields(String category) {
        if ("A".equals(category)) {
            return "costtype,calcdate," + this.getCommonNoCostTypeSelectFields() + "," + this.getCostTypeASelectFields();
        }
        return "costtype,calcdate," + this.getCommonNoCostTypeSelectFields() + "," + this.getCostTypeBSelectFields();
    }

    protected String getTraSelectFields(String category) {
        if ("A".equals(category)) {
            return "costtype,calcdate," + this.getTraCommonNoCostTypeSelectFields() + "," + this.getTraCostTypeASelectFields();
        }
        return "costtype,calcdate," + this.getTraCommonNoCostTypeSelectFields() + "," + this.getTraCostTypeBSelectFields();
    }

    protected String getAuditSelectFields(String category) {
        String selectFields = ",effectdate,expdate";
        if ("A".equals(category)) {
            return "costtype," + this.getCommonNoCostTypeSelectFields() + "," + this.getCostTypeASelectFields() + selectFields;
        }
        return "costtype," + this.getCommonNoCostTypeSelectFields() + "," + this.getCostTypeBSelectFields() + selectFields;
    }

    protected int getListFieldIndex(String field, FinalStdAnalysisRptParam rptParam) {
        Field[] fields = this.getRowMeta(rptParam).getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private DataSet getBomSettingMatIds(Long costTypeId, DynamicObject material, Date date, Long queryPeriodId) {
        Date[] periodtime;
        List filters = new ArrayList<QFilter>();
        filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (material != null) {
            filters.add(new QFilter("material", "=", material.getPkValue()));
        }
        if (date != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)date));
            filters.add(new QFilter("expdate", ">", (Object)date));
        } else if (Boolean.TRUE.equals(CostUpdateHelper.isQueryPeriod((ReportQueryParam)this.getQueryParam())) && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)queryPeriodId)) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        String bomSettingFields = "material.masterid AS material, isdowncalc,bom.copentry.copentrymaterial copentrymaterial";
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getBomSettingMatIds"), (String)"cad_bomsetting", (String)bomSettingFields, (QFilter[])filters.toArray(new QFilter[0]), null);
    }
}

