/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.WriteLogUtils;

public class InnerDistributionRptQueryPlugin
extends AbstractReportListDataPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object arg1) {
        DataSet select;
        DataSet smallSumDataSet;
        DataSet mfgFeeAllDataDataSet;
        FilterInfo filter = reportQueryParam.getFilter();
        String appnum = filter.getString("appnum");
        List<QFilter> queryFilter = this.getQueryFilter(filter);
        Boolean sumByPeriod = (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"sumbyperiod");
        Boolean dividedetail = (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"dividedetail");
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory((Long)((Long)filter.getDynamicObject("costaccount").getPkValue()));
        String queryFileNames = isMulFactory ? "id,billno,period.id periodId,period.name period,manuorg.number manuorgnum, manuorg.name manuorgname,productgroup, benefcostcenter.number as benefcostcenter ,benefcostcenter.name as costcentername,element,subelement.number subelement,allocexpenseitem expenseitem,amount sumamount,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.auxpty auxpty,case when allocstatus!='2' then 0 else entryentity.allocamt end allocamt ,0 unocamt ,entryentity.id entryid" : "id,billno,period.id periodId,period.name period, ''  manuorgnum, ''  manuorgname,productgroup, benefcostcenter.number as benefcostcenter ,benefcostcenter.name as costcentername,element,subelement.number subelement,allocexpenseitem expenseitem,amount sumamount,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.costobject.auxpty auxpty,case when allocstatus!='2' then 0 else entryentity.allocamt end allocamt ,0 unocamt ,entryentity.id entryid";
        String orderByFileName = "period,id,benefcostcenter,element,subelement,entryentity.costobject,productgroup";
        if (sumByPeriod.booleanValue()) {
            orderByFileName = "benefcostcenter,element,subelement,period,entryentity.costobject,id,productgroup";
        }
        if ((mfgFeeAllDataDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)"cad_mfgfeeallocco", (String)queryFileNames, (QFilter[])queryFilter.toArray(new QFilter[0]), (String)orderByFileName)).isEmpty()) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), mfgFeeAllDataDataSet.getRowMeta());
        }
        String sumSql = "select id,periodId,period,manuorgnum,productgroup,manuorgname, benefcostcenter,costcentername,element, subelement,  sum(allocamt) allocamt, sum(sumamount) sumamount group by id,periodId,period,manuorgnum,manuorgname,benefcostcenter,costcentername, element, subelement,productgroup";
        String nullSql = "id,periodId,period,manuorgnum,productgroup,manuorgname, benefcostcenter,costcentername, element, subelement,  case when allocamt is null then 0 else allocamt end allocamt,  case when sumamount is null then 0 else sumamount end sumamount";
        if (sumByPeriod.booleanValue()) {
            sumSql = "select manuorgnum,manuorgname,productgroup, benefcostcenter, costcentername,element,subelement, sum(allocamt) allocamt , sum(sumamount) sumamount group by manuorgnum,manuorgname,benefcostcenter,costcentername,element, subelement,productgroup";
            nullSql = " manuorgnum,manuorgname,productgroup,benefcostcenter,costcentername,element,  subelement,  case when allocamt is null then 0 else allocamt end allocamt,  case when sumamount is null then 0 else sumamount end sumamount";
        }
        ArrayList groupByFields = Lists.newArrayList((Object[])new String[]{"periodId", "period", "manuorgnum", "manuorgname", "benefcostcenter", "costcentername", "element", "subelement", "id", "productgroup"});
        if (sumByPeriod.booleanValue()) {
            groupByFields.remove("periodId");
            groupByFields.remove("period");
        }
        DataSet goupbyDataSet = mfgFeeAllDataDataSet.groupBy(groupByFields.toArray(new String[0])).sum("allocamt").avg("sumamount").finish().executeSql(sumSql).select(nullSql).addField("sumamount-allocamt ", "unocamt");
        DataSet billNoAndExpenseItem = mfgFeeAllDataDataSet.copy().select("id,billno,expenseitem").distinct();
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)"getSubelementInfo", (String)"cad_subelement", (String)"number,name as subelementname", null, null).distinct();
        if (((Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"onlyundivide")).booleanValue()) {
            DataSet onlyundivideDatSet = goupbyDataSet.filter("unocamt is not null and unocamt > 0").addField("'A'", "sunhand");
            if (sumByPeriod.booleanValue()) {
                String selectSql = "manuorgnum,manuorgname,productgroup,benefcostcenter,costcentername,0 element,  subelement, allocamt , sumamount,unocamt, 'B' sunhand";
                DataSet finish = onlyundivideDatSet.groupBy(new String[]{"manuorgnum", "manuorgname", "productgroup", "benefcostcenter", "costcentername", "subelement"}).sum("sumamount").sum("allocamt").sum("unocamt").finish().select(selectSql);
                onlyundivideDatSet = onlyundivideDatSet.union(finish).orderBy(new String[]{"manuorgnum", "benefcostcenter", "costcentername", "subelement", "sunhand"});
                selectSql = "'' manuorgnum,'' manuorgname,0L productgroup,'' benefcostcenter,'' costcentername,0 element,''  subelement, allocamt , sumamount,unocamt, 'C' sunhand";
                DataSet sumHand = finish.groupBy().sum("sumamount").sum("allocamt").sum("unocamt").finish().select(selectSql);
                onlyundivideDatSet = onlyundivideDatSet.union(sumHand);
            } else {
                String selectSql = "0L id,periodId,period,'' manuorgnum,0L productgroup,'' manuorgname,'' benefcostcenter,'' costcentername,0 element,'' subelement,  allocamt, sumamount,unocamt,'B' sunhand";
                DataSet finish = onlyundivideDatSet.groupBy(new String[]{"periodId", "period"}).sum("sumamount").sum("allocamt").sum("unocamt").finish().select(selectSql);
                onlyundivideDatSet = onlyundivideDatSet.union(finish).orderBy(new String[]{"periodId", "period", "sunhand"});
                selectSql = "0L id,0L periodId,'' period,'' manuorgnum,0L productgroup,'' manuorgname,'' benefcostcenter,'' costcentername,0 element,'' subelement,  allocamt, sumamount,unocamt,'C' sunhand";
                DataSet sumHand = finish.groupBy().sum("sumamount").sum("allocamt").sum("unocamt").finish().select(selectSql);
                onlyundivideDatSet = onlyundivideDatSet.union(sumHand);
            }
            if (!sumByPeriod.booleanValue()) {
                onlyundivideDatSet = onlyundivideDatSet.leftJoin(billNoAndExpenseItem).on("id", "id").select(onlyundivideDatSet.getRowMeta().getFieldNames(), new String[]{"billno", "expenseitem"}).finish();
            }
            onlyundivideDatSet = onlyundivideDatSet.join(subElementDs, JoinType.LEFT).on("subelement", "number").select(onlyundivideDatSet.getRowMeta().getFieldNames(), new String[]{"subelementname"}).finish();
            return onlyundivideDatSet;
        }
        HashMap<String, BigDecimal> sumLineMap = new HashMap<String, BigDecimal>(16);
        DataSet groupDataFirstData = this.getGroupDataFristData(mfgFeeAllDataDataSet.copy(), sumByPeriod, goupbyDataSet, sumLineMap);
        if (sumByPeriod.booleanValue()) {
            smallSumDataSet = goupbyDataSet.groupBy(new String[]{"manuorgnum", "manuorgname", "productgroup", "benefcostcenter", "costcentername", "element"}).sum("allocamt").sum("sumamount").sum("unocamt").finish().addNullField(new String[]{"periodId", "period", "costobject", "material", "auxpty", "id", "subelement"});
            select = goupbyDataSet.groupBy(new String[]{"manuorgnum", "manuorgname", "productgroup", "benefcostcenter", "costcentername"}).sum("allocamt").sum("sumamount").finish().select("benefcostcenter,costcentername,0 element,'' subelement,allocamt,sumamount,sumamount-allocamt unocamt,0L  periodId,'' period,'' manuorgnum,'' manuorgname,productgroup, 0 costobject, 0 material,0 auxpty,1 id").addField("'B'", "sunhand").addField("1", "finalsort");
            smallSumDataSet = smallSumDataSet.addField("'A'", "sunhand").addNullField("finalsort").select(select.getRowMeta().getFieldNames()).union(select);
        } else {
            smallSumDataSet = goupbyDataSet.groupBy(new String[]{"periodId", "period", "manuorgnum", "manuorgname", "productgroup", "benefcostcenter", "costcentername"}).sum("allocamt").sum("sumamount").sum("unocamt").finish().addNullField(new String[]{"costobject", "material", "auxpty", "id", "subelement", "element"});
            select = goupbyDataSet.groupBy(new String[]{"periodId", "period"}).sum("allocamt").sum("sumamount").finish().select("periodId,period,'' manuorgnum,'' manuorgname,0L productgroup, '' benefcostcenter,'' costcentername,0 element,'' subelement,allocamt,sumamount,sumamount-allocamt unocamt,0 costobject, 0 material,0 auxpty,1 id").addField("'B'", "sunhand").addField("1", "finalsort");
            smallSumDataSet = smallSumDataSet.addField("'A'", "sunhand").addNullField("finalsort").select(select.getRowMeta().getFieldNames()).union(select);
        }
        smallSumDataSet = smallSumDataSet.addField("0", "sumamountfirst").select("periodId,period,manuorgnum,manuorgname,productgroup, benefcostcenter,costcentername, element, subelement, sumamount, costobject, material,auxpty, allocamt,unocamt,sumamountfirst,id,sunhand,finalsort");
        DataSet mfgFeeAllDataSet = mfgFeeAllDataDataSet.select("id,periodId,period,manuorgnum,productgroup,manuorgname,benefcostcenter,costcentername,element,subelement,0 sumamount, costobject, material,auxpty, allocamt , unocamt , entryid");
        if (dividedetail.booleanValue()) {
            ArrayList groupFields = Lists.newArrayList((Object[])new String[]{"id", "periodId", "period", "manuorgnum", "manuorgname", "productgroup", "benefcostcenter", "costcentername", "element", "subelement", "sumamount", "costobject", "material", "auxpty"});
            if (sumByPeriod.booleanValue()) {
                groupFields.remove("id");
            }
            mfgFeeAllDataSet = mfgFeeAllDataSet.join(groupDataFirstData, JoinType.LEFT).on("id", "id").on("entryid", "entryid").select(new String[]{"id", "periodId", "period", "manuorgnum", "manuorgname", "productgroup", "benefcostcenter", "costcentername", "element", "subelement", "sumamount", "costobject", "material", "auxpty", "allocamt", "unocamt"}, new String[]{"sumamount sumamountfirst"}).finish().groupBy(groupFields.toArray(new String[0])).sum("allocamt").sum("unocamt").sum("sumamountfirst").finish();
            if (sumByPeriod.booleanValue()) {
                mfgFeeAllDataSet = mfgFeeAllDataSet.addNullField("id");
            }
        } else {
            mfgFeeAllDataSet = groupDataFirstData.join(mfgFeeAllDataSet, JoinType.LEFT).on("id", "id").on("entryid", "entryid").select(new String[]{"sumamount sumamountfirst", "allocamt"}, new String[]{"periodId", "period", "manuorgnum", "manuorgname", "productgroup", "benefcostcenter", "costcentername", "element", "subelement", "sumamount", "costobject", "material", "auxpty", "unocamt", "id"}).finish();
        }
        mfgFeeAllDataSet = mfgFeeAllDataSet.addNullField("sunhand").addNullField("finalsort").select(smallSumDataSet.getRowMeta().getFieldNames()).union(smallSumDataSet).orderBy(this.getOrderByFileName(sumByPeriod)).select("id,periodId,period,manuorgnum,manuorgname,productgroup,benefcostcenter,costcentername,element,subelement,case when  sumamountfirst is not null and sumamountfirst!=0  then sumamountfirst else sumamount end  sumamount,costobject, material,auxpty, allocamt, unocamt,sunhand").filter("(sumamount is not null and sumamount!=0) or (allocamt is not null and allocamt!=0) or (unocamt is not null and unocamt!=0)");
        BigDecimal sumamount = (BigDecimal)sumLineMap.get("sumamount");
        BigDecimal allocamt = (BigDecimal)sumLineMap.get("allocamt");
        if (sumamount != null && allocamt != null && BigDecimal.ZERO.compareTo(sumamount) != 0) {
            Object[] objects = new Object[]{0L, 0L, "", "", "", 0L, "", "", 0, "", sumamount, 0, 0, 0, allocamt, sumamount.subtract(allocamt), "C"};
            DataSetBuilder sumLine = Algo.create((String)this.getAlgoKey("sumLine")).createDataSetBuilder(mfgFeeAllDataSet.getRowMeta());
            sumLine.append(objects);
            mfgFeeAllDataSet = mfgFeeAllDataSet.union(sumLine.build());
        }
        if (!sumByPeriod.booleanValue()) {
            mfgFeeAllDataSet = mfgFeeAllDataSet.leftJoin(billNoAndExpenseItem).on("id", "id").select(mfgFeeAllDataSet.getRowMeta().getFieldNames(), new String[]{"billno", "expenseitem"}).finish();
        }
        mfgFeeAllDataSet = mfgFeeAllDataSet.join(subElementDs, JoinType.LEFT).on("subelement", "number").select(mfgFeeAllDataSet.getRowMeta().getFieldNames(), new String[]{"subelementname"}).finish();
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"InnerDistributionRptQueryPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]), (String)"InnerDistributionRptQueryPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"InnerDistributionRptQueryPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]), (String)"InnerDistributionRptQueryPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"cad_innerdistribution", (String)appnum);
        return mfgFeeAllDataSet;
    }

    private String[] getOrderByFileName(Boolean sumByPeriod) {
        String[] stringArray;
        if (sumByPeriod.booleanValue()) {
            String[] stringArray2 = new String[12];
            stringArray2[0] = "benefcostcenter";
            stringArray2[1] = "costcentername";
            stringArray2[2] = "finalsort";
            stringArray2[3] = "element";
            stringArray2[4] = "sunhand";
            stringArray2[5] = "subelement";
            stringArray2[6] = "sumamount";
            stringArray2[7] = "periodId";
            stringArray2[8] = "costobject";
            stringArray2[9] = "manuorgnum";
            stringArray2[10] = "manuorgname";
            stringArray = stringArray2;
            stringArray2[11] = "id";
        } else {
            String[] stringArray3 = new String[11];
            stringArray3[0] = "periodId";
            stringArray3[1] = "finalsort";
            stringArray3[2] = "manuorgnum";
            stringArray3[3] = "benefcostcenter";
            stringArray3[4] = "costcentername";
            stringArray3[5] = "sunhand";
            stringArray3[6] = "element";
            stringArray3[7] = "subelement";
            stringArray3[8] = "id";
            stringArray3[9] = "sumamount";
            stringArray = stringArray3;
            stringArray3[10] = "costobject";
        }
        return stringArray;
    }

    private DataSet getGroupDataFristData(DataSet mfgFeeAllDataSet, Boolean isSumByPeriod, DataSet goupbyDataSet, Map<String, BigDecimal> sumLineMap) {
        String manuorgnum;
        DataSetBuilder dataSetBuilder = Algo.create((String)this.getAlgoKey("getGroupDataFristData")).createDataSetBuilder(this.getInnerRowMeta());
        StringBuilder builder = new StringBuilder();
        String oldDataFlag = null;
        Long firstEntryId = null;
        Long firstId = null;
        Long firstperiodId = null;
        String firstbenefcostcenter = null;
        String firstmanuorgnum = null;
        String firstmanuorgname = null;
        String firstcostcentername = null;
        Long firstelement = null;
        String firstsubelement = null;
        BigDecimal firstallocamt = null;
        if (isSumByPeriod.booleanValue()) {
            while (mfgFeeAllDataSet.hasNext()) {
                Row firstRow = mfgFeeAllDataSet.next();
                String benefcostcenter = firstRow.getString("benefcostcenter");
                manuorgnum = firstRow.getString("manuorgnum");
                String manuorgname = firstRow.getString("manuorgname");
                String costcentername = firstRow.getString("costcentername");
                Long entryid = firstRow.getLong("entryid");
                Long id = firstRow.getLong("id");
                String subelement = firstRow.getString("subelement");
                Long element = firstRow.getLong("element");
                BigDecimal allocamt = firstRow.getBigDecimal("allocamt");
                String now = builder.append(manuorgnum).append(manuorgname).append(benefcostcenter).append(costcentername).append(element).append(subelement).toString();
                if (oldDataFlag == null || oldDataFlag.equals(now) && this.isNullOrZero(firstallocamt).booleanValue() && !this.isNullOrZero(allocamt).booleanValue()) {
                    oldDataFlag = now;
                    firstId = id;
                    firstEntryId = entryid;
                    firstbenefcostcenter = benefcostcenter;
                    firstmanuorgnum = manuorgnum;
                    firstmanuorgname = manuorgname;
                    firstcostcentername = costcentername;
                    firstelement = element;
                    firstsubelement = subelement;
                    firstallocamt = allocamt;
                } else if (!oldDataFlag.equals(now)) {
                    oldDataFlag = now;
                    dataSetBuilder.append(new Object[]{firstId, firstEntryId, 0, firstmanuorgnum, firstmanuorgname, firstbenefcostcenter, firstcostcentername, firstelement, firstsubelement});
                    firstId = id;
                    firstEntryId = entryid;
                    firstmanuorgnum = manuorgnum;
                    firstmanuorgname = manuorgname;
                    firstbenefcostcenter = benefcostcenter;
                    firstcostcentername = costcentername;
                    firstelement = element;
                    firstsubelement = subelement;
                    firstallocamt = allocamt;
                }
                builder.delete(0, builder.length());
            }
        } else {
            while (mfgFeeAllDataSet.hasNext()) {
                Row firstRow = mfgFeeAllDataSet.next();
                Long periodId = firstRow.getLong("periodId");
                manuorgnum = firstRow.getString("manuorgnum");
                String manuorgname = firstRow.getString("manuorgname");
                String benefcostcenter = firstRow.getString("benefcostcenter");
                String costcentername = firstRow.getString("costcentername");
                Long element = firstRow.getLong("element");
                String subelement = firstRow.getString("subelement");
                Long id = firstRow.getLong("id");
                Long entryid = firstRow.getLong("entryid");
                BigDecimal allocamt = firstRow.getBigDecimal("allocamt");
                String now = builder.append(id).toString();
                if (oldDataFlag == null || oldDataFlag.equals(now) && this.isNullOrZero(firstallocamt).booleanValue() && !this.isNullOrZero(allocamt).booleanValue()) {
                    oldDataFlag = now;
                    firstId = id;
                    firstEntryId = entryid;
                    firstperiodId = periodId;
                    firstmanuorgnum = manuorgnum;
                    firstmanuorgname = manuorgname;
                    firstbenefcostcenter = benefcostcenter;
                    firstcostcentername = costcentername;
                    firstelement = element;
                    firstsubelement = subelement;
                    firstallocamt = allocamt;
                } else if (!oldDataFlag.equals(now)) {
                    oldDataFlag = now;
                    dataSetBuilder.append(new Object[]{firstId, firstEntryId, firstperiodId, firstmanuorgnum, firstmanuorgname, firstbenefcostcenter, firstcostcentername, firstelement, firstsubelement});
                    firstId = id;
                    firstEntryId = entryid;
                    firstperiodId = periodId;
                    firstmanuorgnum = manuorgnum;
                    firstmanuorgname = manuorgname;
                    firstbenefcostcenter = benefcostcenter;
                    firstcostcentername = costcentername;
                    firstelement = element;
                    firstsubelement = subelement;
                    firstallocamt = allocamt;
                }
                builder.delete(0, builder.length());
            }
        }
        dataSetBuilder.append(new Object[]{firstId, firstEntryId, firstperiodId, firstmanuorgnum, firstmanuorgname, firstbenefcostcenter, firstcostcentername, firstelement, firstsubelement});
        DataSet sumAmountDataSet = goupbyDataSet.executeSql("select sum(sumamount) sumamount ,sum(allocamt) allocamt");
        if (!sumAmountDataSet.isEmpty()) {
            Row next = sumAmountDataSet.next();
            sumLineMap.put("sumamount", next.getBigDecimal("sumamount"));
            sumLineMap.put("allocamt", next.getBigDecimal("allocamt"));
        }
        if (isSumByPeriod.booleanValue()) {
            return dataSetBuilder.build().leftJoin(goupbyDataSet).select(new String[]{"id", "entryid"}, new String[]{"sumamount", "allocamt"}).on("manuorgnum", "manuorgnum").on("manuorgname", "manuorgname").on("benefcostcenter", "benefcostcenter").on("costcentername", "costcentername").on("element", "element").on("subelement", "subelement").finish();
        }
        return dataSetBuilder.build().leftJoin(goupbyDataSet).select(new String[]{"id", "entryid"}, new String[]{"sumamount", "allocamt"}).on("id", "id").on("periodId", "periodId").on("manuorgnum", "manuorgnum").on("manuorgname", "manuorgname").on("benefcostcenter", "benefcostcenter").on("costcentername", "costcentername").on("element", "element").on("subelement", "subelement").finish();
    }

    private RowMeta getInnerRowMeta() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("id", (DataType)DataType.LongType));
        fields.add(new Field("entryid", (DataType)DataType.LongType));
        fields.add(new Field("periodId", (DataType)DataType.LongType));
        fields.add(new Field("manuorgnum", (DataType)DataType.StringType));
        fields.add(new Field("manuorgname", (DataType)DataType.StringType));
        fields.add(new Field("benefcostcenter", (DataType)DataType.StringType));
        fields.add(new Field("costcentername", (DataType)DataType.StringType));
        fields.add(new Field("element", (DataType)DataType.LongType));
        fields.add(new Field("subelement", (DataType)DataType.StringType));
        return new RowMeta(fields.toArray(new Field[0]));
    }

    private List<QFilter> getQueryFilter(FilterInfo filter) {
        List<Long> subelementId;
        List<Long> elementId;
        String appId = filter.getString("appnum");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject accountorg = filter.getDynamicObject("accountorg");
        qFilters.add(new QFilter("org", "=", accountorg.getPkValue()));
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", costaccount.getPkValue()));
        DynamicObject currency = filter.getDynamicObject("currency");
        qFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        DynamicObject beginperiod = filter.getDynamicObject("beginperiod");
        DynamicObject endperiod = filter.getDynamicObject("endperiod");
        List start2EndAllPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)beginperiod, (DynamicObject)endperiod);
        start2EndAllPeriodIds.add(beginperiod.getPkValue());
        start2EndAllPeriodIds.add(endperiod.getPkValue());
        qFilters.add(new QFilter("period", "in", (Object)start2EndAllPeriodIds));
        DynamicObjectCollection manuorg = filter.getDynamicObjectCollection("manuorg");
        if (manuorg != null) {
            List collect = manuorg.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilters.add(new QFilter("manuorg", "in", collect));
        } else {
            long orgId;
            String entityId = filter.getString("entityId");
            if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)(orgId = accountorg.getLong("id")))) {
                qFilters.add(new QFilter("manuorg", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)entityId, (String)appId)));
            }
        }
        List<Long> costcenterId = this.getMoreSelectValue(filter, "costcenter");
        if (!CollectionUtils.isEmpty(costcenterId)) {
            qFilters.add(new QFilter("benefcostcenter", "in", costcenterId));
        }
        if (!CollectionUtils.isEmpty(elementId = this.getMoreSelectValue(filter, "felement"))) {
            qFilters.add(new QFilter("element", "in", elementId));
        }
        if (!CollectionUtils.isEmpty(subelementId = this.getMoreSelectValue(filter, "fsubelement"))) {
            qFilters.add(new QFilter("subelement", "in", subelementId));
        }
        qFilters.add(new QFilter("appnum", "=", (Object)appId));
        return qFilters;
    }

    private List<Long> getMoreSelectValue(FilterInfo filter, String fileName) {
        DynamicObjectCollection subelement = filter.getDynamicObjectCollection(fileName);
        if (subelement == null) {
            return null;
        }
        return subelement.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    private Boolean isNullOrZero(BigDecimal value) {
        if (value == null || BigDecimal.ZERO.compareTo(value) == 0 || "0E-10".equals(value.toString())) {
            return true;
        }
        return false;
    }
}

