/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.InputOutputRptParam;
import kd.macc.cad.common.helper.InputOutputRptHelper;

public class InputOutputRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(InputOutputRptQueryPlugin.class);
    private static final String planInputEntity = "cad_plannedoutputbill";
    private static final String factnedOutputEntity = "cad_factnedoutputbill";

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        InputOutputRptParam queryParam = InputOutputRptHelper.getRptParam((ReportQueryParam)reportQueryParam);
        DataSet planInputData = this.queryPlanInputData(queryParam);
        DataSet finishDataSet = planInputData.copy();
        List<Object[]> dataList = this.countDetail(finishDataSet.iterator());
        if (dataList == null) {
            dataList = new ArrayList<Object[]>();
        }
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), this.getRowMeta());
    }

    private List<Object[]> countDetail(Iterator<Row> rows) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        ArrayList<String> groupFields = new ArrayList<String>(10);
        groupFields.add("accountorgnum");
        groupFields.add("costobjectnum");
        groupFields.add("matnum");
        Map<String, List<Row>> map = this.getGroupMap(rows, groupFields);
        if (map == null) {
            return null;
        }
        HashSet<Long> accountorgMap = new HashSet<Long>();
        for (Map.Entry<String, List<Row>> entry : map.entrySet()) {
            List<Row> items = entry.getValue();
            Object[] countRowData = new Object[this.getRowMeta().getFields().length];
            BigDecimal totalPlanQty = BigDecimal.ZERO;
            Long accountorgnum = null;
            Long manuorgnum = null;
            Long costcenternum = null;
            Long costobjectnum = null;
            Long auxpty = null;
            Long matnum = null;
            for (int i = 0; i < items.size(); ++i) {
                Row row = items.get(i);
                BigDecimal planqty = row.getBigDecimal("planqty");
                if (planqty != null) {
                    totalPlanQty = totalPlanQty.add(planqty);
                }
                Long rowAccountorgnum = row.getLong("accountorgnum");
                if (accountorgnum == null && rowAccountorgnum != null && accountorgMap.add(rowAccountorgnum)) {
                    accountorgnum = rowAccountorgnum;
                }
                Long rowManuorgNum = row.getLong("manuorgnum");
                if (manuorgnum == null && rowManuorgNum != null) {
                    manuorgnum = rowManuorgNum;
                }
                Long rowCostcenternum = row.getLong("costcenternum");
                if (costcenternum == null && rowCostcenternum != null) {
                    costcenternum = rowCostcenternum;
                }
                Long rowCostobjectnum = row.getLong("costobjectnum");
                if (costobjectnum == null && rowCostobjectnum != null) {
                    costobjectnum = rowCostobjectnum;
                }
                Long rowMatnum = row.getLong("matnum");
                if (matnum == null && rowMatnum != null) {
                    matnum = rowMatnum;
                }
                Long rowAuxpty = row.getLong("auxpty");
                if (auxpty != null || rowAuxpty == null) continue;
                auxpty = rowAuxpty;
            }
            countRowData[this.getListFieldIndex((String)"accountorgnum")] = accountorgnum;
            countRowData[this.getListFieldIndex((String)"totalinqty")] = BigDecimal.ZERO;
            countRowData[this.getListFieldIndex((String)"wipqty")] = BigDecimal.ZERO;
            countRowData[this.getListFieldIndex((String)"manuorgnum")] = manuorgnum;
            countRowData[this.getListFieldIndex((String)"costcenternum")] = costcenternum;
            countRowData[this.getListFieldIndex((String)"costobjectnum")] = costobjectnum;
            countRowData[this.getListFieldIndex((String)"matnum")] = matnum;
            countRowData[this.getListFieldIndex((String)"auxpty")] = auxpty;
            dataList.add(countRowData);
            BigDecimal totaLinqty = BigDecimal.ZERO;
            BigDecimal totalWipqty = BigDecimal.ZERO;
            for (int i = 0; i < items.size(); ++i) {
                Object[] objectRow = this.getObjectRow(items.get(i), 1);
                BigDecimal totalinqty = (BigDecimal)objectRow[this.getRowMeta().getFieldIndex("totalinqty")];
                BigDecimal wipqty = (BigDecimal)objectRow[this.getRowMeta().getFieldIndex("wipqty")];
                totaLinqty = totaLinqty.add(totalinqty != null ? totalinqty : BigDecimal.ZERO);
                totalWipqty = totalWipqty.add(wipqty != null ? wipqty : BigDecimal.ZERO);
                if (!this.isShowDetail()) continue;
                dataList.add(objectRow);
            }
            Row row = items.get(0);
            countRowData[this.getListFieldIndex((String)"planqty")] = this.updatePrecision(row, totalPlanQty);
            countRowData[this.getListFieldIndex((String)"totalinqty")] = this.updatePrecision(row, totaLinqty);
            countRowData[this.getListFieldIndex((String)"wipqty")] = this.updatePrecision(row, totalWipqty);
        }
        return dataList;
    }

    private BigDecimal updatePrecision(Row row, BigDecimal value) {
        if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
            return null;
        }
        int precision = 10;
        if (row != null) {
            precision = row.getInteger("precision");
        }
        return value.setScale(precision);
    }

    private Object[] getObjectRow(Row row, int sPos) {
        ArrayList<String> removeFields = new ArrayList<String>(10);
        removeFields.add("accountorgnum");
        if (this.isShowDetail()) {
            removeFields.add("costcenternum");
            removeFields.add("costobjectnum");
            removeFields.add("matnum");
            removeFields.add("planedbillid");
        }
        Field[] fields = this.getRowMeta().getFields();
        Object[] rowData = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (removeFields.contains(name) && sPos > 0) continue;
            try {
                if ("factneddates".equals(name)) {
                    rowData[i] = this.getFactneddate(row);
                    continue;
                }
                Object value = row.get(name);
                switch (name) {
                    case "planqty": {
                        value = this.updatePrecision(row, (BigDecimal)value);
                        break;
                    }
                    case "totalinqty": {
                        value = this.updatePrecision(row, this.getTotalinqty(row));
                        break;
                    }
                    case "wipqty": {
                        BigDecimal totalinqty = (BigDecimal)rowData[this.getRowMeta().getFieldIndex("totalinqty")];
                        value = this.updatePrecision(row, this.getWipqty(row, totalinqty));
                    }
                }
                rowData[i] = value;
                continue;
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u7ed3\u679c\u96c6\u5931\u8d25", (Throwable)e);
            }
        }
        return rowData;
    }

    private BigDecimal getWipqty(Row row, BigDecimal totalinqty) {
        Long accountorg;
        BigDecimal wipqty = null;
        if (totalinqty == null) {
            totalinqty = BigDecimal.ZERO;
        }
        if ((accountorg = row.getLong("accountorgnum")) == null || accountorg == 0L) {
            return BigDecimal.ZERO;
        }
        String bizstatus = row.getString("bizstatus");
        boolean isClosed = row.getBoolean("closeingstatuses");
        if (!isClosed && "A".equals(bizstatus)) {
            BigDecimal planqty = row.getBigDecimal("planqty");
            wipqty = planqty.subtract(totalinqty);
        } else if ("B".equals(bizstatus) || isClosed) {
            wipqty = BigDecimal.ZERO;
        }
        return wipqty;
    }

    private BigDecimal getTotalinqty(Row row) {
        BigDecimal totalinqty = BigDecimal.ZERO;
        Long accountorg = row.getLong("accountorgnum");
        if (accountorg == null || accountorg == 0L) {
            return totalinqty;
        }
        Long planedbillid = row.getLong("planedbillid");
        QFilter planedbillidQF = new QFilter("entryentity.plannedoutput", "=", (Object)planedbillid);
        DynamicObjectCollection result = QueryServiceHelper.query((String)factnedOutputEntity, (String)"entryentity.qty AS qty", (QFilter[])new QFilter[]{planedbillidQF});
        for (DynamicObject d : result) {
            BigDecimal tempQty = d.getBigDecimal("qty");
            totalinqty = tempQty == null ? totalinqty : totalinqty.add(tempQty);
        }
        return totalinqty;
    }

    private Date getFactneddate(Row row) {
        String orderby;
        QFilter idQF;
        Date planneddates = row.getDate("planneddates");
        Date bizdate = row.getDate("bizdate");
        QFilter startQF = new QFilter("bizdate", ">=", (Object)bizdate);
        DynamicObjectCollection result = QueryServiceHelper.query((String)factnedOutputEntity, (String)"bizdate", (QFilter[])new QFilter[]{startQF, idQF = new QFilter("entryentity.plannedoutput", "=", (Object)row.getLong("planedbillid"))}, (String)(orderby = "bizdate DESC"));
        if (result != null && !result.isEmpty()) {
            return ((DynamicObject)result.get(0)).getDate("bizdate");
        }
        return null;
    }

    private boolean isShowDetail() {
        try {
            InputOutputRptParam queryParam = InputOutputRptHelper.getRptParam((ReportQueryParam)this.getQueryParam());
            return queryParam.getIsShowDetail();
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private DataSet queryPlanInputData(InputOutputRptParam queryParam) {
        String fields = "id AS planedbillid, billno AS plannum, accountorg AS accountorgnum, manuorg AS manuorgnum, costcenter AS costcenternum, costobject AS costobjectnum, costobject.bizstatus AS bizstatus,material AS matnum, auxpty AS auxpty, baseunit AS baseunit, baseunit.precision AS precision, qty AS planqty, totalinqty, wipqty,planneddate AS planneddates,  closestatu AS closeingstatuses,bizdate AS bizdate";
        String orderBy = "";
        List filters = InputOutputRptHelper.getFiltersByPlan((InputOutputRptParam)queryParam, (String)"cad_inputoutputrpt", (String)queryParam.getAppNum());
        filters.add(new QFilter("accountorg", "!=", (Object)0L));
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(this.getAlgoKey("queryPlanInputData"), planInputEntity, fields, filters.toArray(new QFilter[0]), orderBy, 100000, null);
        return dataSet;
    }

    private Map<String, List<Row>> getGroupMap(Iterator<Row> rows, List<String> groupFields) {
        if (!rows.hasNext()) {
            return null;
        }
        LinkedHashMap<String, List<Row>> groupMap = new LinkedHashMap<String, List<Row>>();
        while (rows.hasNext()) {
            Row row = rows.next();
            StringBuilder key = new StringBuilder();
            if (groupFields.size() > 1) {
                for (String groupField : groupFields) {
                    key.append(',').append(row.getLong(groupField));
                }
            } else {
                key.append(groupFields.get(0));
            }
            if (groupMap.containsKey(key.toString())) {
                ((List)groupMap.get(key.toString())).add(row);
                continue;
            }
            ArrayList<Row> list = new ArrayList<Row>(10);
            list.add(row);
            groupMap.put(key.toString(), list);
        }
        LinkedHashMap sortMap = new LinkedHashMap();
        groupMap.entrySet().stream().sorted(Map.Entry.comparingByKey(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        })).forEachOrdered(x -> {
            List cfr_ignored_0 = (List)sortMap.put(x.getKey(), x.getValue());
        });
        return groupMap;
    }

    private int getListFieldIndex(String field) {
        Field[] fields = this.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    private RowMeta getRowMeta() {
        List<Field> field = this.getRowMetaField();
        return new RowMeta(field.toArray(new Field[0]));
    }

    private List<Field> getRowMetaField() {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("planedbillid", (DataType)DataType.LongType));
        field.add(new Field("accountorgnum", (DataType)DataType.LongType));
        field.add(new Field("manuorgnum", (DataType)DataType.LongType));
        field.add(new Field("costcenternum", (DataType)DataType.LongType));
        field.add(new Field("costobjectnum", (DataType)DataType.LongType));
        field.add(new Field("matnum", (DataType)DataType.LongType));
        field.add(new Field("auxpty", (DataType)DataType.LongType));
        field.add(new Field("baseunit", (DataType)DataType.LongType));
        field.add(new Field("plannum", (DataType)DataType.StringType));
        field.add(new Field("planqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalinqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("wipqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("closeingstatuses", (DataType)DataType.StringType));
        field.add(new Field("planneddates", (DataType)DataType.DateType));
        field.add(new Field("factneddates", (DataType)DataType.DateType));
        return field;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List<String> freezeFields = Arrays.asList("accountorgnum", "accountorgname");
        for (AbstractReportColumn a : columns) {
            ReportColumn reportColumn = (ReportColumn)a;
            String key = reportColumn.getFieldKey();
            if (!freezeFields.contains(key)) continue;
            reportColumn.setFreeze(true);
        }
        return columns;
    }
}

