/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.report.queryplugin.MatStdCostDownQueryPlugin;
import org.apache.commons.lang.ArrayUtils;

public class MatCostBomQueryRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(MatStdCostDownQueryPlugin.class);
    private Long costTypeId;
    private boolean isEffect;
    private String entity;
    private Date searchDate;
    private Long queryperiodid = 0L;
    private Long currencyId = 0L;
    private boolean isCountOnly;
    private String subElement;
    private static final String[] joinFields_2 = new String[]{"querymat", "querykeycol", "querymatauxprop", "queryconfiguredcode", "querytracknumber", "queryproject", "querylot", "rootmat", "rootkeycol", "rootmatauxprop", "rootconfiguredcode", "roottracknumber", "rootproject", "rootlot"};

    public DataSet query(ReportQueryParam rptParam, Object o) throws Throwable {
        FilterInfo filterInfo = rptParam.getFilter();
        this.init(filterInfo);
        DataSet queryMatAndRootMatDataSet = this.getRootNodeMats(filterInfo);
        Date start = new Date();
        DataSet bomStructure = this.getBomStructure(queryMatAndRootMatDataSet);
        Date end = new Date();
        logger.info("\u67e5\u8be2bom\u6570\u65f6\u95f4\uff1a{}", (Object)(end.getTime() - start.getTime()));
        DataSet bomCalc = this.addCalcInfo(bomStructure).orderBy(new String[]{"querymat", "querykeycol", "path asc", "datatype asc"});
        Date end1 = new Date();
        DataSet trackBomCalc = this.getTrackBomCalc(filterInfo);
        if (this.isCountOnly) {
            trackBomCalc = trackBomCalc.filter("subelement=" + this.subElement);
        }
        trackBomCalc = trackBomCalc.orderBy(new String[]{"querymat", "querykeycol", "path asc", "datatype asc"});
        bomCalc = DataSetUtils.union((DataSet)bomCalc, (DataSet)trackBomCalc);
        logger.info("\u603b\u67e5\u8be2\u65f6\u95f4\uff1a{}", (Object)(end1.getTime() - start.getTime()));
        return bomCalc;
    }

    private DataSet getTrackBomCalc(FilterInfo filterInfo) {
        DataSet unRootDataSet = this.getUnRootTrackBomCalcDataSet(filterInfo);
        DataSet rootDataSet = this.getRootTrackBomCalcDataSet(filterInfo);
        DataSet dataSet = DataSetUtils.union((DataSet)unRootDataSet, (DataSet)rootDataSet);
        return dataSet;
    }

    private DataSet getRootTrackBomCalcDataSet(FilterInfo filterInfo) {
        DataSet dateDataSet;
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection mulConfiguredCode;
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materials");
        Set materialIds = materials.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
        Long mnCostTypeId = 0L;
        List<QFilter> filters = new ArrayList<QFilter>(16);
        if (this.isEffect) {
            Date[] periodtime;
            List mnCostType = CostTypeHelper.getMnCostByHs((Long)this.costTypeId);
            if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
                mnCostTypeId = (Long)mnCostType.get(0);
                filters.add(new QFilter("costtype", "=", (Object)mnCostTypeId));
            } else {
                filters.add(new QFilter("costtype", "=", (Object)this.costTypeId));
            }
            if (this.searchDate != null) {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
            } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
                filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
            }
        } else {
            filters.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        }
        filters.add(new QFilter("material", "in", materialIds));
        String mulAuxpty = filterInfo.getString("mulauxpty");
        if (!CadEmptyUtils.isEmpty((String)mulAuxpty)) {
            String[] split = mulAuxpty.split(",");
            ArrayList<Long> auxptyIds = new ArrayList<Long>(10);
            for (String s : split) {
                auxptyIds.add(Long.parseLong(s));
            }
            filters.add(new QFilter("auxproperty", "in", auxptyIds));
        }
        if ((mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode")) != null) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("sublot", "in", (Object)lots.split(",")));
        }
        String queryFileds = "id,calcdate,material,costtype,keycol,effectdate,expdate,now() as curDate";
        ORMImpl orm = new ORMImpl();
        DataSet trackNumberDataSet = orm.queryDataSet("getTrackBomCalcIds", "cad_trackstdcalcresult", queryFileds, filters.toArray(new QFilter[0]), "keycol", -1, null);
        DataSet dataSet = null;
        if (this.isEffect) {
            dateDataSet = trackNumberDataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
            trackNumberDataSet = trackNumberDataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
            dataSet = trackNumberDataSet.filter("calcdate=maxcalcdate");
        } else {
            dateDataSet = trackNumberDataSet.filter("expdate is not null");
            DataSet trackNumberDateDataSet = dateDataSet.filter("curdate>=effectdate and curdate<=expdate");
            DataSet keyColDateDataSet = dateDataSet.groupBy(new String[]{"material", "keycol keyColcherck"}).finish();
            DataSet trackNumberUnDateDataSet = trackNumberDataSet.leftJoin(keyColDateDataSet).on("material", "material").on("keycol", "keyColcherck").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"keyColcherck"}).finish().filter("keyColcherck is null");
            dataSet = DataSetUtils.union((DataSet)trackNumberDateDataSet, (DataSet)trackNumberUnDateDataSet);
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ids.add(row.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", ids);
        if (this.isEffect && mnCostTypeId != 0L) {
            filter.and(new QFilter("costtype", "=", (Object)mnCostTypeId));
        } else {
            filter.and(new QFilter("costtype", "=", (Object)this.costTypeId));
        }
        filter.and(new QFilter("entryentity.subentryentity.datatype", "in", (Object)new String[]{"1", "2", "4"}));
        String fileds = "id,material querymat,keycol querykeycol,auxproperty querymatauxprop,configuredcode queryconfiguredcode,tracknumber querytracknumber,project queryproject,lot querylot,material rootmat,keycol rootkeycol,auxproperty rootmatauxprop,configuredcode rootconfiguredcode,tracknumber roottracknumber,project rootproject,lot rootlot,entryentity.entrymaterial.modelnum modelnum,entryentity.entrymaterial entrymaterial,entryentity.entrykeycol entrykeycol,entryentity.entryauxproperty entryauxproperty,entryentity.entryconfiguredcode entryconfiguredcode,entryentity.entrytracknumber entrytracknumber,entryentity.entryproject entryproject,entryentity.entrylot entrylot,entryentity.subentryentity.element.name element,entryentity.subentryentity.subelement.name subelement,entryentity.subentryentity.stdprice amount,entryentity.subentryentity.subkeycol subkeycol,entryentity.subentryentity.price price,entryentity.subentryentity.qty qty,entryentity.entrylevel levelcal,entryentity.entrytreepath path,entryentity.subentryentity.datatype datatype,bomid bom";
        DataSet dataSetTra = orm.queryDataSet("getTrackBomCalc", "cad_trackstdcalcresult", fileds, new QFilter[]{filter}, "keycol", -1, null);
        DataSet calDataSet = dataSetTra.copy().filter("levelcal=0").select(new String[]{"id", "querymat", "querykeycol", "querymatauxprop", "queryconfiguredcode", "querytracknumber", "queryproject", "querylot", "rootmat", "rootkeycol", "rootmatauxprop", "rootconfiguredcode", "roottracknumber", "rootproject", "rootlot", "modelnum", "entrymaterial mat", "entrykeycol keycol", "entryauxproperty matauxprop", "entryconfiguredcode configuredcode", "entrytracknumber tracknumber", "entryproject project", "entrylot lot", "0L pmat", "0L pmatauxprop", "'' pkeycol", "0L pconfiguredcode", "0L ptracknumber", "0L pproject", "'' plot", "bom", "element", "case when datatype = '1' then " + this.subElement + " else subelement end subelement", "qty", "price", "amount", "path", "datatype", "subkeycol", "'0' level", this.currencyId + " entrycurrency", "'0' dataresource", "'' matstr", "'' rootnodemat"});
        DataSet dataSetPrent = calDataSet.copy().filter("datatype = '4'").select(new String[]{"id", "mat pmat", "keycol pkeycol", "matauxprop pmatauxprop", "configuredcode pconfiguredcode", "tracknumber ptracknumber", "project pproject", "lot plot", "subkeycol"});
        if (dataSetPrent.hasNext()) {
            calDataSet = this.getTraLevelDataSet(dataSetTra.copy(), calDataSet, 1, dataSetPrent);
        }
        DataSet result = calDataSet.groupBy(new String[]{"id", "querymat", "querykeycol", "querymatauxprop", "queryconfiguredcode", "querytracknumber", "queryproject", "querylot", "rootmat", "rootkeycol", "rootmatauxprop", "rootconfiguredcode", "roottracknumber", "rootproject", "rootlot", "modelnum", "mat", "keycol", "matauxprop", "configuredcode", "tracknumber", "project", "lot", "pmat", "pmatauxprop", "pkeycol", "pconfiguredcode", "ptracknumber", "pproject", "plot", "bom", "element", "subelement", "path", "datatype", "level", "entrycurrency", "dataresource", "matstr", "rootnodemat"}).sum("qty").sum("price").sum("amount").finish();
        return result;
    }

    private DataSet getTraLevelDataSet(DataSet dataSetTra, DataSet calDataSet, int level, DataSet dataSetPrent) {
        String levelStr = this.getLevelStr(level);
        DataSet dataSetSub = dataSetTra.copy().filter("levelcal=" + level).select(new String[]{"id", "querymat", "querykeycol", "querymatauxprop", "queryconfiguredcode", "querytracknumber", "queryproject", "querylot", "rootmat", "rootkeycol", "rootmatauxprop", "rootconfiguredcode", "roottracknumber", "rootproject", "rootlot", "modelnum", "entrymaterial mat", "entrykeycol keycol", "entryauxproperty matauxprop", "entryconfiguredcode configuredcode", "entrytracknumber tracknumber", "entryproject project", "entrylot lot", "bom", "element", "case when datatype = '1' then " + this.subElement + " else subelement end subelement", "qty", "price", "amount", "path", "datatype", "subkeycol", levelStr + " level", this.currencyId + " entrycurrency", "'0' dataresource", "'' matstr", "'' rootnodemat"});
        dataSetSub = dataSetSub.leftJoin(dataSetPrent).on("id", "id").on("keycol", "subkeycol").select(dataSetSub.getRowMeta().getFieldNames(), new String[]{"pmat", "pkeycol", "pmatauxprop", "pconfiguredcode", "ptracknumber", "pproject", "plot"}).finish();
        DataSet dataSetSubPrent = dataSetSub.filter("datatype = '4'").select(new String[]{"id", "mat pmat", "keycol pkeycol", "matauxprop pmatauxprop", "configuredcode pconfiguredcode", "tracknumber ptracknumber", "project pproject", "lot plot", "subkeycol"});
        calDataSet = DataSetUtils.union((DataSet)calDataSet, (DataSet)dataSetSub);
        if (dataSetSubPrent.hasNext()) {
            calDataSet = this.getTraLevelDataSet(dataSetTra.copy(), calDataSet.copy(), ++level, dataSetSubPrent);
        }
        return calDataSet;
    }

    private DataSet getUnRootTrackBomCalcDataSet(FilterInfo filterInfo) {
        DataSet dateDataSet;
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection mulConfiguredCode;
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materials");
        Set materialIds = materials.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
        Long mnCostTypeId = 0L;
        List<QFilter> filters = new ArrayList<QFilter>(16);
        if (this.isEffect) {
            Date[] periodtime;
            List mnCostType = CostTypeHelper.getMnCostByHs((Long)this.costTypeId);
            if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
                mnCostTypeId = (Long)mnCostType.get(0);
                filters.add(new QFilter("costtype", "=", (Object)mnCostTypeId));
            } else {
                filters.add(new QFilter("costtype", "=", (Object)this.costTypeId));
            }
            if (this.searchDate != null) {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
            } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
                filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
            }
        } else {
            filters.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        }
        filters.add(new QFilter("entryentity.subentryentity.submaterial", "in", materialIds));
        String mulAuxpty = filterInfo.getString("mulauxpty");
        if (!CadEmptyUtils.isEmpty((String)mulAuxpty)) {
            String[] split = mulAuxpty.split(",");
            ArrayList<Long> auxptyIds = new ArrayList<Long>(10);
            for (String s : split) {
                auxptyIds.add(Long.parseLong(s));
            }
            filters.add(new QFilter("entryentity.subentryentity.subauxproperty", "in", auxptyIds));
        }
        if ((mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode")) != null) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subentryentity.subconfiguredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subentryentity.subtracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subentryentity.subproject", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("entryentity.subentryentity.subsublot", "in", (Object)lots.split(",")));
        }
        String queryFileds = "id,calcdate,material,costtype,keycol,effectdate,expdate,now() as curDate";
        ORMImpl orm = new ORMImpl();
        DataSet trackNumberDataSet = orm.queryDataSet("getTrackBomCalcIds", "cad_trackstdcalcresult", queryFileds, filters.toArray(new QFilter[0]), "keycol", -1, null);
        DataSet dataSet = null;
        if (this.isEffect) {
            dateDataSet = trackNumberDataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
            trackNumberDataSet = trackNumberDataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
            dataSet = trackNumberDataSet.filter("calcdate=maxcalcdate");
        } else {
            dateDataSet = trackNumberDataSet.filter("expdate is not null");
            DataSet trackNumberDateDataSet = dateDataSet.filter("curdate>=effectdate and curdate<=expdate");
            DataSet keyColDateDataSet = dateDataSet.groupBy(new String[]{"material", "keycol keyColcherck"}).finish();
            DataSet trackNumberUnDateDataSet = trackNumberDataSet.leftJoin(keyColDateDataSet).on("material", "material").on("keycol", "keyColcherck").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"keyColcherck"}).finish().filter("keyColcherck is null");
            dataSet = DataSetUtils.union((DataSet)trackNumberDateDataSet, (DataSet)trackNumberUnDateDataSet);
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ids.add(row.getLong("id"));
        }
        QFilter qfilter = new QFilter("id", "in", ids);
        if (this.isEffect && mnCostTypeId != 0L) {
            qfilter.and(new QFilter("costtype", "=", (Object)mnCostTypeId));
        } else {
            qfilter.and(new QFilter("costtype", "=", (Object)this.costTypeId));
        }
        qfilter.and(new QFilter("entryentity.entrymaterial", "in", materialIds));
        qfilter.and(new QFilter("entryentity.entrylevel", ">", (Object)0));
        String qfileds = "id,entryentity.entrymaterial querymat,entryentity.entrykeycol querykeycol,entryentity.entryauxproperty querymatauxprop,entryentity.entryconfiguredcode queryconfiguredcode,entryentity.entrytracknumber querytracknumber,entryentity.entryproject queryproject,lot querylot";
        DataSet dataSetQuery = orm.queryDataSet("getTrackBomCalc", "cad_trackstdcalcresult", qfileds, new QFilter[]{qfilter}, null, -1, null);
        QFilter filter = new QFilter("id", "in", ids);
        qfilter.and(new QFilter("costtype", "=", (Object)this.costTypeId));
        filter.and(new QFilter("entryentity.subentryentity.datatype", "in", (Object)new String[]{"1", "2", "4"}));
        String fileds = "id,material rootmat,keycol rootkeycol,auxproperty rootmatauxprop,configuredcode rootconfiguredcode,tracknumber roottracknumber,project rootproject,lot rootlot,entryentity.entrymaterial.modelnum modelnum,entryentity.entrymaterial entrymaterial,entryentity.entrykeycol entrykeycol,entryentity.entryauxproperty entryauxproperty,entryentity.entryconfiguredcode entryconfiguredcode,entryentity.entrytracknumber entrytracknumber,entryentity.entryproject entryproject,entryentity.entrylot entrylot,entryentity.subentryentity.element.name element,entryentity.subentryentity.subelement.name subelement,entryentity.subentryentity.stdprice amount,entryentity.subentryentity.subkeycol subkeycol,entryentity.subentryentity.price price,entryentity.subentryentity.qty qty,entryentity.entrylevel levelcal,entryentity.entrytreepath path,entryentity.subentryentity.datatype datatype,bomid bom";
        DataSet dataSetTra = orm.queryDataSet("getTrackBomCalc", "cad_trackstdcalcresult", fileds, new QFilter[]{filter}, "keycol", -1, null);
        dataSetTra = dataSetTra.join(dataSetQuery).on("id", "id").select(dataSetTra.getRowMeta().getFieldNames(), new String[]{"querymat", "querykeycol", "querymatauxprop", "queryconfiguredcode", "querytracknumber", "queryproject", "querylot"}).finish();
        DataSet calDataSet = dataSetTra.copy().filter("levelcal=0").select(new String[]{"id", "querymat", "querykeycol", "querymatauxprop", "queryconfiguredcode", "querytracknumber", "queryproject", "querylot", "rootmat", "rootkeycol", "rootmatauxprop", "rootconfiguredcode", "roottracknumber", "rootproject", "rootlot", "modelnum", "entrymaterial mat", "entrykeycol keycol", "entryauxproperty matauxprop", "entryconfiguredcode configuredcode", "entrytracknumber tracknumber", "entryproject project", "entrylot lot", "0L pmat", "0L pmatauxprop", "'' pkeycol", "0L pconfiguredcode", "0L ptracknumber", "0L pproject", "'' plot", "bom", "element", "case when datatype = '1' then " + this.subElement + " else subelement end subelement", "qty", "price", "amount", "path", "datatype", "subkeycol", "'0' level", this.currencyId + " entrycurrency", "'0' dataresource", "'' matstr", "'' rootnodemat"});
        DataSet dataSetPrent = calDataSet.copy().filter("datatype = '4'").select(new String[]{"id", "mat pmat", "keycol pkeycol", "matauxprop pmatauxprop", "configuredcode pconfiguredcode", "tracknumber ptracknumber", "project pproject", "lot plot", "subkeycol"});
        if (dataSetPrent.hasNext()) {
            calDataSet = this.getTraLevelDataSet(dataSetTra.copy(), calDataSet, 1, dataSetPrent);
        }
        DataSet result = calDataSet.groupBy(new String[]{"id", "querymat", "querykeycol", "querymatauxprop", "queryconfiguredcode", "querytracknumber", "queryproject", "querylot", "rootmat", "rootkeycol", "rootmatauxprop", "rootconfiguredcode", "roottracknumber", "rootproject", "rootlot", "modelnum", "mat", "keycol", "matauxprop", "configuredcode", "tracknumber", "project", "lot", "pmat", "pmatauxprop", "pkeycol", "pconfiguredcode", "ptracknumber", "pproject", "plot", "bom", "element", "subelement", "path", "datatype", "level", "entrycurrency", "dataresource", "matstr", "rootnodemat"}).sum("qty").sum("price").sum("amount").finish();
        return result;
    }

    private Set<String> getKeyCols(FilterInfo filterInfo) {
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materials");
        Set materialIds = materials.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        filters.add(new QFilter("material", "in", materialIds));
        DynamicObjectCollection mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode");
        if (mulConfiguredCode != null && mulConfiguredCode.size() > 0) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null && mulTracknumber.size() > 0) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null && mulProjectNumber.size() > 0) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        String queryFileds = "id,costtype,keycol";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)this.entity, (String)queryFileds, (QFilter[])filters.toArray(new QFilter[0]));
        HashSet<String> keyCols = new HashSet<String>(10);
        for (DynamicObject data : datas) {
            keyCols.add(data.getString("keycol"));
        }
        return keyCols;
    }

    private List<String> getSubKeyCols(FilterInfo filterInfo) {
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materials");
        Set materialIds = materials.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        filters.add(new QFilter("entryentity.submaterial", "in", materialIds));
        DynamicObjectCollection mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode");
        if (mulConfiguredCode != null) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subconfiguredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subtracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subproject", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("entryentity.sublot", "in", (Object)lots.split(",")));
        }
        String queryFileds = "id,costtype,entryentity.subkeycol subkeycol";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)this.entity, (String)queryFileds, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<String> keyCols = new ArrayList<String>(10);
        for (DynamicObject data : datas) {
            keyCols.add(data.getString("subkeycol"));
        }
        return keyCols;
    }

    private DataSet getRootNodeMats(FilterInfo filterInfo) {
        QFilter costTypeQf;
        QFilter filter = costTypeQf = new QFilter("costtype", "=", (Object)this.costTypeId);
        if (this.isEffect) {
            Date[] periodtime;
            if (this.searchDate != null) {
                filter.and(new QFilter("effectdate", "<=", (Object)this.searchDate)).and(new QFilter("expdate", ">", (Object)this.searchDate));
            } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null && periodtime.length == 2) {
                filter.and(QFilter.of((String)"effectdate != expdate", null));
                Date startDate = periodtime[0];
                Date endDate = periodtime[1];
                QFilter filter1 = new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate));
                QFilter filter2 = new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate));
                filter1.or(filter2);
                filter.and(filter1);
            }
        }
        String fields_1 = "material querymat, keycol querykeycol, auxproperty querymatauxprop, rootnode,configuredcode queryconfiguredcode,tracknumber querytracknumber,project queryproject,lot querylot";
        QFilter queryMatQf_1 = new QFilter("keycol", "in", this.getKeyCols(filterInfo));
        queryMatQf_1.and(costTypeQf);
        DataSet queryMatDataSet_1 = QueryServiceHelper.queryDataSet((String)"", (String)this.entity, (String)fields_1, (QFilter[])queryMatQf_1.toArray(), null);
        String fields_2 = "entryentity.submaterial querymat, entryentity.subkeycol querykeycol, entryentity.subauxproperty querymatauxprop, rootnode,entryentity.subconfiguredcode queryconfiguredcode,entryentity.subtracknumber querytracknumber,entryentity.subproject queryproject,entryentity.sublot querylot";
        QFilter queryMatQf_2 = new QFilter("entryentity.subkeycol", "in", this.getSubKeyCols(filterInfo));
        queryMatQf_2.and(costTypeQf);
        DataSet queryMatDataSet_2 = QueryServiceHelper.queryDataSet((String)"", (String)this.entity, (String)fields_2, (QFilter[])queryMatQf_2.toArray(), null);
        DataSet queryMatDataSet = queryMatDataSet_1.union(queryMatDataSet_2);
        queryMatDataSet = queryMatDataSet.groupBy("querymat, querykeycol, querymatauxprop, rootnode,queryconfiguredcode,querytracknumber,queryproject,querylot".split(",")).finish();
        HashSet<String> rootNodes = new HashSet<String>(16);
        DataSet queryMatDataSetCopy = queryMatDataSet.copy();
        while (queryMatDataSetCopy.hasNext()) {
            Row next = queryMatDataSetCopy.next();
            rootNodes.add(next.getString("rootnode"));
        }
        String rootFields = "material rootmat, keycol rootkeycol, auxproperty rootmatauxprop, configuredcode rootconfiguredcode,tracknumber roottracknumber,project rootproject,lot rootlot,treepath,concat(material,concat('@',concat(keycol,concat('@',auxproperty)))) rootnodemat";
        QFilter rootNode = new QFilter("treepath", "in", rootNodes);
        rootNode.and(new QFilter("tracknumber", "is null", null).or(new QFilter("tracknumber", "=", (Object)0)));
        DataSet rootDataSet = QueryServiceHelper.queryDataSet((String)"", (String)this.entity, (String)rootFields, (QFilter[])rootNode.toArray(), null).groupBy("rootmat, rootkeycol, rootmatauxprop,rootconfiguredcode,roottracknumber,rootproject,rootlot, treepath, rootnodemat".split(",")).finish();
        DataSet queryMatAndRootMatDataSet = queryMatDataSet.join(rootDataSet, JoinType.LEFT).on("rootnode", "treepath").select(queryMatDataSet.getRowMeta().getFieldNames(), new String[]{"rootmat", "rootkeycol", "rootmatauxprop", "rootnodemat", "rootconfiguredcode", "roottracknumber", "rootproject", "rootlot"}).finish();
        return queryMatAndRootMatDataSet;
    }

    private void init(FilterInfo filterInfo) {
        DynamicObject costType = filterInfo.getDynamicObject("costtype");
        this.currencyId = costType.getLong("currency.id");
        this.costTypeId = (Long)costType.getPkValue();
        this.isEffect = costType.getString("type").equals("0");
        this.isCountOnly = filterInfo.getBoolean("iscountonly");
        this.searchDate = this.isEffect ? filterInfo.getDate("date") : new Date();
        DynamicObject period = filterInfo.getDynamicObject("queryperiod");
        if (period != null) {
            this.queryperiodid = period.getLong("id");
        }
        this.subElement = ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"MatCostBomQueryRpt_8", (String)"macc-cad-report", (Object[])new Object[0]);
        this.entity = this.isEffect ? "cad_calceffectiveresult" : "cad_calcsimulationresult";
    }

    private DataSet addCalcInfo(DataSet bomStructure) {
        DataSet calcResultDataSet = this.getCalcResDataSet();
        DataSet copyBomStructure = bomStructure.copy();
        DataSet allDataSet = bomStructure.leftJoin(calcResultDataSet).on("mat", "material").on("keycol", "keycol").select(bomStructure.getRowMeta().getFieldNames(), new String[]{"modelnum", "bom", "element", ResManager.loadKDString((String)"case when datatype = '1' then '\u5c0f\u8ba1' else subelement end subelement", (String)"MatCostBomQueryRpt_2", (String)"macc-cad-report", (Object[])new Object[0]), "qty", "price", "amount", "datatype", "dataresource", this.currencyId + " entrycurrency"}).finish();
        DataSet selfCalcDataSet = allDataSet.filter("bom != null");
        Object[] selfMatFields = (String[])ArrayUtils.addAll((Object[])bomStructure.getRowMeta().getFieldNames(), (Object[])new String[]{"modelnum", "bom", "element", "subelement", "qty", "price", "amount", "datatype", "dataresource,entrycurrency"});
        selfCalcDataSet = selfCalcDataSet.select(Arrays.toString(selfMatFields).replace("[", "").replace("]", ""));
        DataSet outCalcDataSet = allDataSet.filter("bom = null");
        HashSet<String> outMatKeyCols = new HashSet<String>(10);
        outCalcDataSet.copy().forEach(o -> outMatKeyCols.add(o.getString("keycol")));
        DataSet outMaterialDataSet = this.getOutMaterialDataSet(outMatKeyCols);
        outCalcDataSet = outCalcDataSet.select(copyBomStructure.getRowMeta().getFieldNames());
        outCalcDataSet = outCalcDataSet.leftJoin(outMaterialDataSet).on("mat", "material").on("keycol", "keycol").select(bomStructure.getRowMeta().getFieldNames(), new String[]{"modelnum", "bom", "element", "subelement", "qty", "price", "amount", "datatype", "dataresource"}).finish();
        Object[] outMatFields = (String[])ArrayUtils.addAll((Object[])bomStructure.getRowMeta().getFieldNames(), (Object[])new String[]{"modelnum", "bom", "element", "subelement", "qty", "price", "amount", "datatype", "dataresource", this.currencyId + " entrycurrency"});
        outCalcDataSet = outCalcDataSet.select(Arrays.toString(outMatFields).replace("[", "").replace("]", ""));
        outCalcDataSet = this.addSumRow(outCalcDataSet);
        DataSet bomMatDataSet = selfCalcDataSet.union(outCalcDataSet);
        if (this.isCountOnly) {
            bomMatDataSet = bomMatDataSet.filter(ResManager.loadKDString((String)"subelement = '\u5c0f\u8ba1'", (String)"MatCostBomQueryRpt_3", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        return bomMatDataSet;
    }

    private DataSet getOutMaterialDataSet(Set<String> outMatKeyCols) {
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        filters.add(new QFilter("keycol", "in", outMatKeyCols));
        String outEntity = "cad_calcpurprices";
        String add = ",effectdate";
        if (this.isEffect) {
            outEntity = "cad_purprices";
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            if (this.queryperiodid != null && this.queryperiodid != 0L) {
                Date[] periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid);
                if (periodtime != null) {
                    filters = CostUpdateHelper.getPeriodQFilter(filters, (Date[])periodtime);
                }
            } else {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">", (Object)this.searchDate));
            }
        } else {
            add = ",calcdate effectdate";
        }
        String outFields = "material, keycol, auxpty auxproperty, material.modelnum modelnum, 0 as bom,configuredcode,tracknumber,project,lot,1 as qty,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.price as amount,entryentity.price as price,'20' datatype,'1' as dataresource" + add;
        DataSet outMaterialDataSet = QueryServiceHelper.queryDataSet((String)"outDataQuery", (String)outEntity, (String)outFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        String queryPeriodGroups = "material,keycol";
        String queryPeriodFields = queryPeriodGroups + ",effectdate";
        DataSet queryPeriodDataSet = outMaterialDataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodFields.split(",")).max("effectdate").finish();
        outMaterialDataSet = outMaterialDataSet.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("keycol", "keycol").on("effectdate", "effectdate").select(outMaterialDataSet.getRowMeta().getFieldNames(), null).finish();
        outMaterialDataSet.removeFields(new String[]{"effectdate"});
        outMaterialDataSet = outMaterialDataSet.groupBy(new String[]{"modelnum", "bom", "element", "subelement", "material", "qty", "price", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "modelnum", "datatype", "dataresource"}).sum("amount").finish();
        return outMaterialDataSet;
    }

    private DataSet getCalcResDataSet() {
        List<Object> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("ismaindata", "=", (Object)1));
        qfList.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        qfList.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"1", "2", "4"}));
        if (this.isEffect) {
            if (this.queryperiodid != null && this.queryperiodid != 0L) {
                Date[] periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid);
                if (periodtime != null) {
                    qfList = CostUpdateHelper.getPeriodQFilter(qfList, (Date[])periodtime);
                }
            } else {
                qfList.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                qfList.add(new QFilter("expdate", ">", (Object)this.searchDate));
            }
        }
        String selfFields = (this.isEffect ? "effectdate," : "") + "material, keycol, auxproperty,configuredcode,tracknumber,project,lot,material.modelnum modelnum, bom,entryentity.element.name AS element,entryentity.subelement.name AS subelement,entryentity.qty AS qty,entryentity.price AS price,entryentity.stdprice AS amount,entryentity.datatype AS datatype,'0' as dataresource";
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)"calcDataQuery", (String)this.entity, (String)selfFields, (QFilter[])qfList.toArray(new QFilter[0]), null);
        if (this.isEffect) {
            if (Boolean.TRUE.equals(this.isQueryPeriod())) {
                String queryPeriodGroups = "material,keycol,auxproperty";
                String queryPeriodFields = queryPeriodGroups + ",effectdate";
                DataSet queryPeriodDataSet = resultDataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
                resultDataSet = resultDataSet.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("keycol", "keycol").on("effectdate", "effectdate").select(resultDataSet.getRowMeta().getFieldNames(), null).finish();
            }
            resultDataSet = resultDataSet.removeFields(new String[]{"effectdate"});
        }
        resultDataSet = resultDataSet.groupBy(new String[]{"bom", "element", "subelement", "material", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "modelnum", "datatype", "dataresource"}).sum("amount").sum("qty").finish();
        resultDataSet = resultDataSet.select(new String[]{"bom", "element", "subelement", "material", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "modelnum", "datatype", "dataresource", "amount", "qty", "case when qty!= 0 then amount/qty else 0 end price"});
        return resultDataSet;
    }

    private DataSet getBomStructure(DataSet queryMatAndRootMatDataSet) {
        DataSet rootMatDataSet = queryMatAndRootMatDataSet.copy();
        HashSet<String> rootKeyCol = new HashSet<String>(16);
        while (rootMatDataSet.hasNext()) {
            Row next = rootMatDataSet.next();
            rootKeyCol.add(next.getString("rootkeycol"));
        }
        List<QFilter> filter = this.getLevelDataQFilter(rootKeyCol);
        String fields = "'0' level," + (this.isEffect ? "effectdate," : "") + "material mat, keycol, auxproperty matauxprop,configuredcode,tracknumber,project,lot,0 pmat, '' pkeycol, 0 pmatauxprop,configuredcode pconfiguredcode,tracknumber ptracknumber,project pproject,lot plot,concat('',material) matstr,concat('',material) path,concat(material,concat('@',concat(keycol,concat('@',auxproperty)))) rootnodemat";
        String groupFields = "level, mat, keycol, matauxprop,configuredcode,tracknumber,project,lot, pmat, pkeycol, pmatauxprop,pconfiguredcode,ptracknumber,pproject,plot, matstr, path, rootnodemat";
        String[] groupFieldArr = groupFields.split(",");
        DataSet calcDataSet = QueryServiceHelper.queryDataSet((String)"", (String)this.entity, (String)fields, (QFilter[])filter.toArray(new QFilter[0]), null);
        if (this.isEffect) {
            if (Boolean.TRUE.equals(this.isQueryPeriod())) {
                String queryPeriodGroups = "mat,keycol,matauxprop";
                String queryPeriodFields = queryPeriodGroups + ",effectdate";
                DataSet queryPeriodDataSet = calcDataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
                calcDataSet = calcDataSet.join(queryPeriodDataSet, JoinType.INNER).on("mat", "mat").on("keycol", "keycol").on("effectdate", "effectdate").select(calcDataSet.getRowMeta().getFieldNames(), null).finish();
            }
            calcDataSet.removeFields(new String[]{"effectdate"});
        }
        GroupbyDataSet groupbyDataSet = calcDataSet.groupBy(groupFieldArr);
        DataSet oneLevelDataSet = groupbyDataSet.finish().select(groupFieldArr);
        int level = 0;
        DataSet allDataSet = this.nextLevelData(oneLevelDataSet, ++level);
        DataSet currMatAndParentMatDateSet = oneLevelDataSet.union(allDataSet);
        String[] joinFields_1 = currMatAndParentMatDateSet.getRowMeta().getFieldNames();
        DataSet finishedBomStructureDataSet = queryMatAndRootMatDataSet.join(currMatAndParentMatDateSet, JoinType.RIGHT).on("rootnodemat", "rootnodemat").select(joinFields_1, joinFields_2).finish();
        return finishedBomStructureDataSet;
    }

    private List<QFilter> getLevelDataQFilter(Set<String> rootKeyCol) {
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        filters.add(new QFilter("ismaindata", "=", (Object)1));
        filters.add(new QFilter("entryentity.datatype", "=", (Object)"4"));
        filters.add(new QFilter("keyCol", "in", rootKeyCol));
        if (this.isEffect) {
            if (this.queryperiodid != null && this.queryperiodid != 0L) {
                Date[] periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid);
                if (periodtime != null) {
                    filters = CostUpdateHelper.getPeriodQFilter(filters, (Date[])periodtime);
                }
            } else {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">", (Object)this.searchDate));
            }
        }
        return filters;
    }

    private DataSet nextLevelData(DataSet dataSet, int level) {
        DataSet copy = dataSet.copy();
        if (!copy.hasNext()) {
            return Algo.create((String)"").createDataSet(new ArrayList(), copy.getRowMeta());
        }
        String fields = this.getLevelStr(level) + " level,entryentity.submaterial mat,entryentity.subkeycol keycol,entryentity.subauxproperty matauxprop,entryentity.subconfiguredcode configuredcode,entryentity.subtracknumber tracknumber,entryentity.subproject project,entryentity.sublot lot," + (this.isEffect ? "effectdate," : "") + "material pmat, keycol pkeycol, auxproperty pmatauxprop,configuredcode pconfiguredcode,tracknumber ptracknumber,project pproject,lot plot,concat('',entryentity.submaterial) matstr";
        String groupFields = "level, mat, keycol, matauxprop,configuredcode,tracknumber,project,lot, pmat, pkeycol, pmatauxprop,pconfiguredcode,ptracknumber,pproject,plot, matstr";
        HashSet<String> keyCols = new HashSet<String>(16);
        while (copy.hasNext()) {
            Row row = copy.next();
            keyCols.add(row.getString("keycol"));
        }
        List<QFilter> levelDataQFilter = this.getLevelDataQFilter(keyCols);
        DataSet calcDataSet = QueryServiceHelper.queryDataSet((String)"", (String)this.entity, (String)fields, (QFilter[])levelDataQFilter.toArray(new QFilter[0]), null);
        if (this.isEffect) {
            if (Boolean.TRUE.equals(this.isQueryPeriod())) {
                String queryPeriodGroups = "mat,keycol,matauxprop";
                String queryPeriodFields = queryPeriodGroups + ",effectdate";
                DataSet queryPeriodDataSet = calcDataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
                calcDataSet = calcDataSet.join(queryPeriodDataSet, JoinType.INNER).on("mat", "mat").on("keycol", "keycol").on("effectdate", "effectdate").select(calcDataSet.getRowMeta().getFieldNames(), null).finish();
            }
            calcDataSet = calcDataSet.removeFields(new String[]{"effectdate"});
        }
        DataSet tmpDataSet = calcDataSet.groupBy(groupFields.split(",")).finish();
        DataSet levelDataSet = tmpDataSet.join(dataSet, JoinType.INNER).on("pmat", "mat").on("pkeycol", "keycol").select(tmpDataSet.getRowMeta().getFieldNames(), new String[]{"path", "rootnodemat"}).finish();
        String[] fields_2 = (String[])ArrayUtils.addAll((Object[])groupFields.split(","), (Object[])new String[]{"concat(path,concat('@',matstr)) path", "rootnodemat"});
        levelDataSet = levelDataSet.select(fields_2);
        DataSet nextLevelData = this.nextLevelData(levelDataSet, ++level);
        return levelDataSet.union(nextLevelData);
    }

    private Set<String> getDownCalcMaterialFromBomSetting(Set<String> keyCols) {
        List bomSettingQfList = new ArrayList<QFilter>();
        bomSettingQfList.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        bomSettingQfList.add(new QFilter("keycol", "in", keyCols));
        bomSettingQfList.add(new QFilter("isdowncalc", "=", (Object)Boolean.TRUE));
        bomSettingQfList.add(new QFilter("status", "=", (Object)"C"));
        bomSettingQfList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (this.queryperiodid != null && this.queryperiodid != 0L) {
            Date[] periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid);
            if (periodtime != null) {
                bomSettingQfList = CostUpdateHelper.getPeriodQFilter(bomSettingQfList, (Date[])periodtime);
            }
        } else {
            bomSettingQfList.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
            bomSettingQfList.add(new QFilter("expdate", ">", (Object)this.searchDate));
        }
        DataSet bomSettingData = QueryServiceHelper.queryDataSet((String)"", (String)"cad_bomsetting", (String)"material, bomversion, auxprop,keycol", (QFilter[])bomSettingQfList.toArray(new QFilter[0]), null);
        HashSet<String> selfKeyCols = new HashSet<String>(16);
        while (bomSettingData.hasNext()) {
            Row row = bomSettingData.next();
            String keycol = row.getString("keycol");
            selfKeyCols.add(keycol);
        }
        return selfKeyCols;
    }

    private String getCalcMaterialFromBomSetting(DataSet calcResDataSet) {
        List bomSettingFilter = new ArrayList<QFilter>(16);
        bomSettingFilter.add(new QFilter("costtype", "=", (Object)this.costTypeId));
        bomSettingFilter.add(new QFilter("isdowncalc", "=", (Object)Boolean.FALSE));
        bomSettingFilter.add(new QFilter("status", "=", (Object)"C"));
        bomSettingFilter.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (this.queryperiodid != null && this.queryperiodid != 0L) {
            Date[] periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid);
            if (periodtime != null) {
                bomSettingFilter = CostUpdateHelper.getPeriodQFilter(bomSettingFilter, (Date[])periodtime);
            }
        } else {
            bomSettingFilter.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
            bomSettingFilter.add(new QFilter("expdate", ">", (Object)this.searchDate));
        }
        DataSet bomSettingData = QueryServiceHelper.queryDataSet((String)"", (String)"cad_bomsetting", (String)"material,isdowncalc", (QFilter[])bomSettingFilter.toArray(new QFilter[0]), null);
        DataSet calcResMatInBomSetting = calcResDataSet.join(bomSettingData, JoinType.INNER).on("material", "material").select(calcResDataSet.getRowMeta().getFieldNames(), new String[]{"isdowncalc"}).finish();
        StringBuilder materials = new StringBuilder("0");
        while (calcResMatInBomSetting.hasNext()) {
            Long matId = calcResMatInBomSetting.next().getLong("material");
            materials.append(",");
            materials.append(matId);
        }
        return materials.toString();
    }

    private DataSet addSumRow(DataSet dataSet) {
        Date start = new Date();
        RowMeta rowMeta = dataSet.copy().getRowMeta();
        HashMap map = new HashMap();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String key = row.getString("path");
            List rows = (List)map.get(key);
            if (rows != null) {
                rows.add(row);
                continue;
            }
            ArrayList<Row> arrayList = new ArrayList<Row>();
            arrayList.add(row);
            map.put(key, arrayList);
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        Field[] fields = rowMeta.getFields();
        for (Map.Entry entry : map.entrySet()) {
            BigDecimal sum = BigDecimal.ZERO;
            Object[] sumRowData = null;
            List value = (List)entry.getValue();
            for (int i = 0; i < value.size(); ++i) {
                Row row = (Row)value.get(i);
                Object[] rowData = new Object[fields.length];
                for (int j = 0; j < fields.length; ++j) {
                    Object val;
                    String name = fields[j].getName();
                    if ("amount".equals(name) && row.getBigDecimal(name) != null) {
                        sum = sum.add(row.getBigDecimal(name));
                    }
                    rowData[j] = val = row.get(name);
                }
                dataList.add(rowData);
                if (i != value.size() - 1) continue;
                sumRowData = (Object[])rowData.clone();
                sumRowData[rowMeta.getFieldIndex((String)"element")] = ResManager.loadKDString((String)"\u7269\u6599", (String)"MatCostBomQueryRpt_4", (String)"macc-cad-report", (Object[])new Object[0]);
                sumRowData[rowMeta.getFieldIndex((String)"subelement")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"MatCostBomQueryRpt_5", (String)"macc-cad-report", (Object[])new Object[0]);
                BigDecimal qty = row.getBigDecimal("qty");
                if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal price = sum.divide(qty, 5, RoundingMode.HALF_UP);
                    sumRowData[rowMeta.getFieldIndex((String)"price")] = price;
                }
                sumRowData[rowMeta.getFieldIndex((String)"datatype")] = "0";
                sumRowData[rowMeta.getFieldIndex((String)"amount")] = sum;
            }
            if (sum.compareTo(BigDecimal.ZERO) == 0) continue;
            dataList.add(sumRowData);
        }
        Date end = new Date();
        logger.info("\u5904\u7406\u5408\u8ba1\u884c\u6d88\u8017\u65f6\u95f4\uff1a{}\u6beb\u79d2", (Object)(end.getTime() - start.getTime()));
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), rowMeta);
    }

    private String getLevelStr(int level) {
        String levelStr = "" + level;
        for (int i = 1; i <= level; ++i) {
            levelStr = "--" + levelStr;
        }
        return "'" + levelStr + "'";
    }

    private Boolean isQueryPeriod() {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject period = filterInfo.getDynamicObject("queryperiod");
        if (period != null && period.getLong("id") != 0L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

