/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import org.apache.commons.lang.ArrayUtils;

public class MatStdCostDownQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(MatStdCostDownQueryPlugin.class);
    private Long costtypeid;
    private boolean iseffect;
    private String entity;
    private Date searchDate;
    private Long queryperiodid = 0L;
    private Long currencyid = 0L;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.init(filterInfo);
        Date start = new Date();
        DataSet bomStructure = this.getBomStructure(filterInfo);
        Date end = new Date();
        logger.info("\u67e5\u8be2bom\u6570\u65f6\u95f4\uff1a" + (end.getTime() - start.getTime()));
        DataSet bomCalc = this.addCalcInfo(bomStructure).orderBy(new String[]{"path asc", "datatype"});
        Date end1 = new Date();
        DataSet trackBomCalc = this.getTrackBomCalc(filterInfo).orderBy(new String[]{"id", "path asc", "keycol", "datatype"});
        bomCalc = DataSetUtils.union((DataSet)bomCalc, (DataSet)trackBomCalc);
        logger.info("\u603b\u67e5\u8be2\u65f6\u95f4\uff1a" + (end1.getTime() - start.getTime()));
        return bomCalc;
    }

    private Set<Long> getTrackBomCalcIds(FilterInfo filterInfo) {
        DataSet dateDataSet;
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection mulConfiguredCode;
        Set allMaterial = (Set)filterInfo.getFilterItem("allmaterial").getValue();
        List<QFilter> filters = new ArrayList<QFilter>(16);
        if (this.iseffect) {
            Date[] periodtime;
            List mnCostType = CostTypeHelper.getMnCostByHs((Long)this.costtypeid);
            if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
                filters.add(new QFilter("costtype", "=", mnCostType.get(0)));
            } else {
                filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
            }
            if (this.searchDate != null) {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
            } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
                filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
            }
        } else {
            filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        }
        filters.add(new QFilter("material", "in", (Object)allMaterial));
        String mulAuxpty = filterInfo.getString("mulauxpty");
        if (!CadEmptyUtils.isEmpty((String)mulAuxpty)) {
            String[] split = mulAuxpty.split(",");
            ArrayList<Long> auxptyIds = new ArrayList<Long>(10);
            for (String s : split) {
                auxptyIds.add(Long.parseLong(s));
            }
            filters.add(new QFilter("auxproperty", "in", auxptyIds));
        }
        if ((mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode")) != null) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        String queryFileds = "id,calcdate,material,costtype,keycol,effectdate,expdate,now() as curDate";
        ORMImpl orm = new ORMImpl();
        DataSet trackNumberDataSet = orm.queryDataSet("getTrackBomCalcIds", "cad_trackstdcalcresult", queryFileds, filters.toArray(new QFilter[0]), "keycol", -1, null);
        DataSet dataSet = null;
        if (this.iseffect) {
            dateDataSet = trackNumberDataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
            trackNumberDataSet = trackNumberDataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
            dataSet = trackNumberDataSet.filter("calcdate=maxcalcdate");
        } else {
            dateDataSet = trackNumberDataSet.filter("expdate is not null");
            DataSet trackNumberDateDataSet = dateDataSet.filter("curdate>=effectdate and curdate<=expdate");
            DataSet keyColDateDataSet = dateDataSet.groupBy(new String[]{"material", "keycol keyColcherck"}).finish();
            DataSet trackNumberUnDateDataSet = trackNumberDataSet.leftJoin(keyColDateDataSet).on("material", "material").on("keycol", "keyColcherck").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"keyColcherck"}).finish().filter("keyColcherck is null");
            dataSet = DataSetUtils.union((DataSet)trackNumberDateDataSet, (DataSet)trackNumberUnDateDataSet);
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    private DataSet addCalcInfo(DataSet bomStructure) {
        DataSet resultDataSet = null;
        List<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        String outEntity = "cad_calcpurprices";
        String add = ",effectdate";
        if (this.iseffect) {
            Date[] periodtime;
            outEntity = "cad_purprices";
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            if (this.searchDate != null) {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
            } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
                filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
            }
            resultDataSet = this.getEffectResultDataSet();
        } else {
            add = ",calcdate effectdate";
            resultDataSet = this.getSimulaTionResultDataSet();
        }
        String total = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"MatStdCostDownQueryPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]);
        DataSet copyBomStructure = bomStructure.copy();
        DataSet allDataSet = bomStructure.leftJoin(resultDataSet).on("submaterial", "material").on("subkeycol", "keycol").select(bomStructure.getRowMeta().getFieldNames(), new String[]{"modelnum", "bom", "element", "case when datatype = '1' then '" + total + "' else subelement end subelement", "qty", "price", "amount", "datatype", "dataresource", this.currencyid + " entrycurrency"}).finish();
        DataSet selfCalcDataSet = allDataSet.filter("bom != null");
        DataSet outCalcDataSet = allDataSet.filter("bom = null");
        outCalcDataSet = outCalcDataSet.select(copyBomStructure.getRowMeta().getFieldNames());
        HashSet outKeyCols = new HashSet(16);
        outCalcDataSet.copy().forEach(o -> outKeyCols.add(o.getString("subkeycol")));
        filters.add(new QFilter("keycol", "in", outKeyCols));
        Object[] objects1 = (String[])ArrayUtils.addAll((Object[])bomStructure.getRowMeta().getFieldNames(), (Object[])new String[]{"modelnum", "bom", "element", "subelement", "bomrate*qty as qty", "price", "qty*bomrate*price amount", "datatype", "dataresource,entrycurrency"});
        selfCalcDataSet = selfCalcDataSet.select(Arrays.toString(objects1).replace("[", "").replace("]", ""));
        String outFields = "material,keycol,auxpty as auxproperty,material.modelnum modelnum,0 as bom,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.price as price,entryentity.price as amount,1 qty,'20' datatype,'1' as dataresource" + add;
        DataSet outMaterialDataSet = QueryServiceHelper.queryDataSet((String)"outDataQuery", (String)outEntity, (String)outFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        String queryPeriodGroups = "material,keycol";
        String queryPeriodFields = queryPeriodGroups + ",effectdate";
        DataSet queryPeriodDataSet = outMaterialDataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
        outMaterialDataSet = outMaterialDataSet.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("keycol", "keycol").on("effectdate", "effectdate").select(outMaterialDataSet.getRowMeta().getFieldNames(), null).finish();
        outMaterialDataSet = outMaterialDataSet.removeFields(new String[]{"effectdate"});
        outMaterialDataSet = outMaterialDataSet.groupBy(new String[]{"modelnum", "bom", "element", "subelement", "material", "qty", "price", "keycol", "auxproperty", "modelnum", "datatype", "dataresource"}).sum("amount").finish();
        outCalcDataSet = outCalcDataSet.leftJoin(outMaterialDataSet).on("submaterial", "material").on("subkeycol", "keycol").select(bomStructure.getRowMeta().getFieldNames(), new String[]{"modelnum", "bom", "element", "subelement", "qty", "price", "amount", "datatype", "dataresource"}).finish();
        Object[] objects = (String[])ArrayUtils.addAll((Object[])bomStructure.getRowMeta().getFieldNames(), (Object[])new String[]{"modelnum", "bom", "element", "subelement", "bomrate qty", "price", "bomrate*price amount", "datatype", "dataresource," + this.currencyid + " entrycurrency"});
        outCalcDataSet = outCalcDataSet.select(Arrays.toString(objects).replace("[", "").replace("]", ""));
        outCalcDataSet = this.addSumRow(outCalcDataSet);
        DataSet dataSet = selfCalcDataSet.union(outCalcDataSet).distinct();
        return dataSet.select("level,submaterial,modelnum,subkeycol,subauxproperty,configuredcode,tracknumber,project,lot,bom,element,subelement,case when subelement != '" + total + "' then 0L else subbaseunit end subbaseunit,qty,price,amount,entrycurrency,datatype,dataresource,bomrate,path,keycol");
    }

    private DataSet getSimulaTionResultDataSet() {
        QFilter ismaindata = new QFilter("ismaindata", "=", (Object)1);
        QFilter costtypeq = new QFilter("costtype", "=", (Object)this.costtypeid);
        QFilter[] selfFilter = new QFilter[]{costtypeq, ismaindata, new QFilter("entryentity.datatype", "in", (Object)new String[]{"1", "2", "4"})};
        String selfFields = "material,keycol,auxproperty,material.modelnum modelnum,bom,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.qty qty,entryentity.price price ,entryentity.stdprice as amount,entryentity.datatype as datatype,'0' as dataresource";
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)"calcDataQuery", (String)"cad_calcsimulationresult", (String)(selfFields + ",calcdate"), (QFilter[])selfFilter, null).groupBy(new String[]{"bom", "element", "subelement", "material", "keycol", "auxproperty", "modelnum", "datatype", "dataresource"}).max("calcdate").sum("amount").sum("qty").finish();
        resultDataSet = resultDataSet.select(new String[]{"bom", "element", "subelement", "material", "keycol", "auxproperty", "modelnum", "datatype", "dataresource", "calcdate", "amount", "qty", " case when qty!= 0 then amount/qty else 0 end price"});
        String outMaterial = this.getCalcMaterialFromBomSetting(resultDataSet.copy());
        return resultDataSet.filter("material not in (" + outMaterial + ")");
    }

    public DataSet getEffectResultDataSet() {
        Date[] periodtime;
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("ismaindata", "=", (Object)1));
        filters.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"1", "2", "4"}));
        if (this.searchDate != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
            filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
        } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        String selfFields = "effectdate,material,keycol,auxproperty,material.modelnum modelnum,bom,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.qty qty,entryentity.price price ,entryentity.stdprice as amount,entryentity.datatype as datatype,'0' as dataresource";
        DataSet effectResult = QueryServiceHelper.queryDataSet((String)"calcDataQuery", (String)this.entity, (String)selfFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        if (Boolean.TRUE.equals(CostUpdateHelper.isQueryPeriod((ReportQueryParam)this.getQueryParam()))) {
            String queryPeriodGroups = "material,keycol,auxproperty";
            String queryPeriodFields = queryPeriodGroups + ",effectdate";
            DataSet queryPeriodDataSet = effectResult.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
            effectResult = effectResult.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("keycol", "keycol").on("effectdate", "effectdate").select(effectResult.getRowMeta().getFieldNames(), null).finish();
        }
        effectResult = effectResult.removeFields(new String[]{"effectdate"});
        effectResult = effectResult.groupBy(new String[]{"bom", "element", "subelement", "material", "keycol", "auxproperty", "modelnum", "datatype", "dataresource"}).sum("amount").sum("qty").finish();
        return effectResult.select(new String[]{"bom", "element", "subelement", "material", "keycol", "auxproperty", "modelnum", "datatype", "dataresource", "amount", "qty", "case when qty!= 0 then amount/qty else 0 end price"});
    }

    private void init(FilterInfo filterInfo) {
        DynamicObject currency = filterInfo.getDynamicObject("currency");
        if (currency != null) {
            this.currencyid = (Long)currency.getPkValue();
        }
        DynamicObject costtype = filterInfo.getDynamicObject("costtype");
        this.searchDate = filterInfo.getDate("searchdate");
        DynamicObject queryPeriod = filterInfo.getDynamicObject("queryperiod");
        if (queryPeriod != null) {
            this.queryperiodid = queryPeriod.getLong("id");
        }
        this.costtypeid = (Long)costtype.getPkValue();
        this.iseffect = costtype.getString("type").equals("0");
        if (this.iseffect) {
            this.entity = "cad_calceffectiveresult";
            this.iseffect = true;
        } else {
            this.entity = "cad_calcsimulationresult";
            this.iseffect = false;
        }
        Set<Long> productFilter = this.getProductFilter(filterInfo);
        filterInfo.addFilterItem("allmaterial", productFilter);
    }

    private Set<Long> getProductFilter(FilterInfo filterInfo) {
        HashSet<Long> matIds = new HashSet<Long>(10);
        if (filterInfo == null) {
            return matIds;
        }
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materials");
        for (DynamicObject material : materials) {
            matIds.add(material.getLong("id"));
        }
        HashSet<Long> bomIds = new HashSet<Long>(10);
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"bom", (QFilter[])new QFilter[]{new QFilter("costtype", "=", (Object)filterInfo.getLong("costtype"))});
        for (DynamicObject bomSetting : bomSettings) {
            bomIds.add(bomSetting.getLong("bom"));
        }
        QFilter filter = new QFilter("id", "in", bomIds);
        filter.and(new QFilter("iscoproduct", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("copentry.copentrymaterial", "in", matIds));
        filter.and(new QFilter("material", "not in", matIds));
        DynamicObjectCollection boms = QueryServiceHelper.query((String)"cad_costbom", (String)"material", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bom : boms) {
            matIds.add(bom.getLong("material"));
        }
        return matIds;
    }

    private DataSet getTrackBomCalc(FilterInfo filterInfo) {
        String subelement = ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"MatStdCostDownQueryPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
        Set<Long> ids = this.getTrackBomCalcIds(filterInfo);
        QFilter filter = new QFilter("id", "in", ids);
        if (this.iseffect) {
            List mnCostType = CostTypeHelper.getMnCostByHs((Long)this.costtypeid);
            if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
                filter.and(new QFilter("costtype", "=", mnCostType.get(0)));
            } else {
                filter.and(new QFilter("costtype", "=", (Object)this.costtypeid));
            }
        } else {
            filter.and(new QFilter("costtype", "=", (Object)this.costtypeid));
        }
        filter.and(new QFilter("entryentity.subentryentity.datatype", "in", (Object)new String[]{"1", "2", "4"}));
        String queryFileds = "id,calcdate,entryentity.entrylevel levelcal,entryentity.entrymaterial material,entryentity.entrymaterial.modelnum modelnum,entryentity.entrykeycol keycol,entryentity.entryauxproperty auxproperty,entryentity.entryconfiguredcode configuredcode,entryentity.entrytracknumber tracknumber,entryentity.entryproject project,entryentity.entrylot lot,entryentity.entrybomid bom,entryentity.subentryentity.element.name element,entryentity.subentryentity.subelement.name subelement,entryentity.entrymaterial.baseunit baseunit, entryentity.subentryentity.qty qty,entryentity.subentryentity.stdprice stdprice,entryentity.subentryentity.submaterial submaterial,entryentity.subentryentity.subkeycol subkeycol,entryentity.subentryentity.subauxproperty subauxproperty,entryentity.subentryentity.submaterial.baseunit subbaseunit,entryentity.entrytreepath path,entryentity.subentryentity.datatype datatype";
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet("getTrackBomCalcIds", "cad_trackstdcalcresult", queryFileds, new QFilter[]{filter}, "keycol", -1, null);
        DataSet dateDataSet = dataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
        dataSet = dataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(dataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
        dataSet = dataSet.filter("calcdate=maxcalcdate");
        DataSet sumDataSet = dataSet.copy().filter("datatype = '1'");
        DataSet calDataSet = dataSet.copy().filter("levelcal=0 and datatype != '1'").select(new String[]{"id", "levelcal", "material", "keycol", "element", "subelement", "submaterial", "subkeycol", "1 bomrate", "'0' level"});
        DataSet dataSetCal = dataSet.copy().filter("levelcal=0 and datatype = '4'").select(new String[]{"id", "material", "keycol", "submaterial", "subkeycol", "qty calqty"});
        if (dataSetCal.hasNext()) {
            calDataSet = this.getTraLevelDataSet(dataSet.copy(), calDataSet, 1, dataSetCal);
        }
        DataSet calSumDataSet = calDataSet.copy().groupBy(new String[]{"id", "levelcal", "material", "keycol", "element", "subelement", "bomrate", "level"}).finish().distinct();
        sumDataSet = sumDataSet.join(calSumDataSet).on("id", "id").on("material", "material").on("keycol", "keycol").on("levelcal", "levelcal").select(sumDataSet.getRowMeta().getFieldNames(), new String[]{"bomrate", "level"}).finish().select(new String[]{"id", "levelcal", "material", "modelnum", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "bom", "element", "baseunit", "qty*bomrate qty", "stdprice*bomrate amount", "path", "datatype", "bomrate", "level"}).addField(subelement, "subelement");
        sumDataSet = sumDataSet.groupBy(sumDataSet.getRowMeta().getFieldNames()).finish();
        DataSet detailDataSet = dataSet.copy().filter("datatype != '1'");
        detailDataSet = detailDataSet.join(calDataSet).on("id", "id").on("material", "material").on("keycol", "keycol").on("subkeycol", "subkeycol").on("levelcal", "levelcal").on("subelement", "subelement").select(detailDataSet.getRowMeta().getFieldNames(), new String[]{"bomrate", "level"}).finish();
        detailDataSet = detailDataSet.groupBy(new String[]{"id", "levelcal", "material", "modelnum", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "bom", "element", "subelement", "baseunit", "path", "datatype", "bomrate", "level"}).sum("qty").sum("stdprice").finish();
        detailDataSet = detailDataSet.select(new String[]{"id", "levelcal", "material", "modelnum", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "bom", "element", "subelement", "0L baseunit", "qty*bomrate qty", "stdprice*bomrate amount", "path", "datatype", "bomrate", "level"});
        DataSet result = DataSetUtils.union((DataSet)sumDataSet, (DataSet)detailDataSet).select(new String[]{"id", "level", "material submaterial", "modelnum", "keycol", "keycol subkeycol", "auxproperty subauxproperty", "configuredcode", "tracknumber", "project", "lot", "bom", "element", "subelement", "baseunit subbaseunit", "qty", "case when qty!= 0 then amount/qty else 0 end price", "amount", "datatype", "'0' dataresource", "bomrate", "path", this.currencyid + " entrycurrency"});
        result = result.groupBy(result.getRowMeta().getFieldNames()).finish();
        return result;
    }

    private DataSet getTraLevelDataSet(DataSet dataSet, DataSet calDataSet, int callevel, DataSet dataSetCal) {
        DataSet otherDataSet = dataSet.copy().filter("levelcal=" + callevel + " and datatype != '1'").select(new String[]{"id", "levelcal", "material", "keycol", "element", "subelement", "submaterial", "subkeycol", "qty", "datatype"});
        String level = this.getLevelStr(callevel);
        DataSet calDataSetLevel = otherDataSet.join(dataSetCal).on("id", "id").on("material", "submaterial").on("keycol", "subkeycol").select(otherDataSet.getRowMeta().getFieldNames(), new String[]{"calqty bomrate", "qty*calqty calqty", level + " level"}).finish();
        DataSet dataSetCalNext = calDataSetLevel.copy().filter("datatype = '4'").select(new String[]{"id", "material", "keycol", "submaterial", "subkeycol", "calqty"});
        calDataSet = DataSetUtils.union((DataSet)calDataSet, (DataSet)calDataSetLevel);
        if (dataSetCalNext.hasNext()) {
            calDataSet = this.getTraLevelDataSet(dataSet, calDataSet.copy(), ++callevel, dataSetCalNext);
        }
        return calDataSet;
    }

    private DataSet getBomStructure(FilterInfo filterInfo) {
        Set<String> keyCols = this.getKeyCols(filterInfo);
        List<Node> list = new ArrayList<Node>(10);
        DataSet dataSet = this.getLevelDataSet(keyCols, 0);
        DataSet dataSet2 = dataSet = this.iseffect ? dataSet.select(new String[]{"id", "material", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "baseunit", "material as submaterial", "keycol as subkeycol", "auxproperty as subauxproperty", "baseunit as subbaseunit", "bomrate", "calcqty", "level", "path"}) : dataSet.select(new String[]{"id", "material", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "baseunit", "material as submaterial", "keycol as subkeycol", "auxproperty as subauxproperty", "baseunit as subbaseunit", "bomrate", "calcqty", "level", "path", "calcdate"});
        if (!this.iseffect) {
            DataSet outDataSet = this.getOutDataSet(filterInfo);
            dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)outDataSet);
            DataSet maxDataSet = dataSet.groupBy(new String[]{"material", "keycol"}).max("calcdate").finish();
            dataSet = dataSet.join(maxDataSet).on("material", "material").on("keycol", "keycol").on("calcdate", "calcdate").select(dataSet.getRowMeta().getFieldNames(), null).finish();
            dataSet = dataSet.removeFields(new String[]{"calcdate"});
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String parentKey = "root";
            String key = row.getLong("material") + "@" + row.getString("keycol");
            Node node = new Node(key, parentKey, row.getBigDecimal("bomrate"), this.parseRow(row, rowMeta));
            if (list.contains(node)) continue;
            list.add(node);
        }
        list = this.getLevelData(keyCols, 1, list);
        LinkedList<Node> resultList = new LinkedList<Node>();
        Date start = new Date();
        this.sortList(list, "root", BigDecimal.ONE, resultList, "root");
        Date end = new Date();
        logger.info("\u6392\u5e8f\u6d88\u8017\u65f6\u95f4\uff1a" + (end.getTime() - start.getTime()));
        List dataList = resultList.stream().map(Node::getData).collect(Collectors.toList());
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), rowMeta);
    }

    private List<Node> getLevelData(Set<String> keyCols, int level, List<Node> list) {
        DataSet dataSet = this.getLevelDataSet(keyCols, level);
        Set<String> subkeycols = this.getMaterialSet(list, dataSet);
        if (subkeycols.size() > 0) {
            list = this.getLevelData(subkeycols, ++level, list);
        }
        return list;
    }

    private Set<String> getKeyCols(FilterInfo filterInfo) {
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection mulConfiguredCode;
        Set allMaterial = (Set)filterInfo.getFilterItem("allmaterial").getValue();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("material", "in", (Object)allMaterial));
        String mulAuxpty = filterInfo.getString("mulauxpty");
        if (!CadEmptyUtils.isEmpty((String)mulAuxpty)) {
            String[] split = mulAuxpty.split(",");
            ArrayList<Long> auxptyIds = new ArrayList<Long>(10);
            for (String s : split) {
                auxptyIds.add(Long.parseLong(s));
            }
            filters.add(new QFilter("entryentity.subauxproperty", "in", auxptyIds));
        }
        if ((mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode")) != null && mulConfiguredCode.size() > 0) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null && mulTracknumber.size() > 0) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null && mulProjectNumber.size() > 0) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        String queryFileds = "id,costtype,keycol";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)this.entity, (String)queryFileds, (QFilter[])filters.toArray(new QFilter[0]));
        HashSet<String> keyCols = new HashSet<String>(16);
        for (DynamicObject data : datas) {
            keyCols.add(data.getString("keycol"));
        }
        return keyCols;
    }

    private Set<String> getMaterialSet(List<Node> list, DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        HashSet<String> subKeyCols = new HashSet<String>(16);
        while (dataSet.hasNext()) {
            BigDecimal bomrate;
            Row row = dataSet.next();
            subKeyCols.add(row.getString("subkeycol"));
            String parentKey = row.getLong("material") + "@" + row.getString("keycol");
            String key = row.getLong("submaterial") + "@" + row.getString("subkeycol");
            Node node = new Node(key, parentKey, bomrate = row.getBigDecimal("bomrate"), this.parseRow(row, rowMeta));
            if (list.contains(node)) continue;
            list.add(node);
        }
        return subKeyCols;
    }

    private Object[] parseRow(Row row, RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        Object[] rowData = new Object[fields.length];
        for (int j = 0; j < fields.length; ++j) {
            Object val;
            String name = fields[j].getName();
            rowData[j] = val = row.get(name);
        }
        return rowData;
    }

    private DataSet getOutDataSet(FilterInfo filterInfo) {
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection mulConfiguredCode;
        Set allMaterial = (Set)filterInfo.getFilterItem("allmaterial").getValue();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("material", "in", (Object)allMaterial));
        String mulAuxpty = filterInfo.getString("mulauxpty");
        if (!CadEmptyUtils.isEmpty((String)mulAuxpty)) {
            String[] split = mulAuxpty.split(",");
            ArrayList<Long> auxptyIds = new ArrayList<Long>(10);
            for (String s : split) {
                auxptyIds.add(Long.parseLong(s));
            }
            filters.add(new QFilter("auxpty", "in", auxptyIds));
        }
        if ((mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode")) != null) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        String levelStr = this.getLevelStr(0);
        String fields = "id,calcdate,material,keycol,auxpty auxproperty,configuredcode,tracknumber,project,lot,material.baseunit baseunit,material as submaterial,keycol as subkeycol,auxpty as subauxproperty,material.baseunit as subbaseunit,1 bomrate,1 calcqty,'' path," + levelStr + " level";
        ORMImpl orm = new ORMImpl();
        DataSet outDataSet = orm.queryDataSet("out", "cad_calcpurprices", fields, filters.toArray(new QFilter[0]), "", -1, null);
        String queryGroups = "keycol,material";
        String queryFields = queryGroups + ",calcdate";
        DataSet queryOutDataSet = outDataSet.copy().select(queryFields.split(",")).groupBy(queryGroups.split(",")).max("calcdate").finish();
        outDataSet = outDataSet.join(queryOutDataSet, JoinType.INNER).on("material", "material").on("keycol", "keycol").on("calcdate", "calcdate").select(outDataSet.getRowMeta().getFieldNames(), null).finish();
        return outDataSet;
    }

    private DataSet getLevelDataSet(Set<String> keyColsParam, int level) {
        Date[] periodtime;
        Date start = new Date();
        String levelStr = this.getLevelStr(level);
        QFilter ismaindata = new QFilter("ismaindata", "=", (Object)1);
        QFilter costtypeq = new QFilter("costtype", "=", (Object)this.costtypeid);
        if (!this.iseffect) {
            String[] stringArray;
            QFilter[] filter = new QFilter[]{costtypeq, ismaindata, new QFilter("entryentity.datatype", "in", (Object)new String[]{"4"}), new QFilter("keycol", "in", keyColsParam)};
            String fields = "id,material,keycol,auxproperty,configuredcode,tracknumber,project,lot,material.baseunit as baseunit,entryentity.submaterial as submaterial,entryentity.subkeycol as subkeycol,entryentity.subauxproperty as subauxproperty,entryentity.submaterial.baseunit as subbaseunit," + (level == 0 ? "entryentity.qty/entryentity.qty bomrate," : "entryentity.qty bomrate,") + (level == 0 ? "entryentity.qty/entryentity.qty calcqty," : "entryentity.qty calcqty,") + levelStr + " level,'' path";
            if (level == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "calcdate";
            } else {
                stringArray = new String[]{};
            }
            String[] calcdate = stringArray;
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"aa", (String)this.entity, (String)"material as gmaterial,keycol as gkeycol,auxproperty as gauxproperty,calcdate", (QFilter[])filter, null);
            dataSet = dataSet.groupBy(new String[]{"gmaterial", "gkeycol"}).max("calcdate").finish();
            DataSet allDataSet = QueryServiceHelper.queryDataSet((String)"aa", (String)this.entity, (String)fields, (QFilter[])filter, null);
            dataSet = allDataSet.join(dataSet, JoinType.INNER).on("material", "gmaterial").on("keycol", "gkeycol").select(allDataSet.getRowMeta().getFieldNames(), calcdate).finish();
            Date end = new Date();
            logger.info("\u7b2c" + level + "\u5c42\u67e5\u8be2\u6d88\u8017\u65f6\u95f4\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
            return dataSet;
        }
        List filters = new ArrayList<QFilter>(16);
        filters.add(costtypeq);
        filters.add(ismaindata);
        filters.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"4"}));
        filters.add(new QFilter("keycol", "in", keyColsParam));
        filters.add(new QFilter("tracknumber", "is null", null).or(new QFilter("tracknumber", "=", (Object)0)));
        if (this.searchDate != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
            filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
        } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        String fields = "id,material,keycol,auxproperty,configuredcode,tracknumber,project,lot,material.baseunit as baseunit,entryentity.submaterial as submaterial,entryentity.subkeycol as subkeycol,entryentity.subauxproperty as subauxproperty,entryentity.submaterial.baseunit as subbaseunit," + (level == 0 ? "1 bomrate," : "entryentity.qty bomrate,") + (level == 0 ? "1 calcqty," : "entryentity.qty calcqty,") + levelStr + " level,'' path";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"aa", (String)this.entity, (String)fields, (QFilter[])filters.toArray(new QFilter[0]), null);
        Date end = new Date();
        logger.info("\u7b2c" + level + "\u5c42\u67e5\u8be2\u6d88\u8017\u65f6\u95f4\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
        return dataSet;
    }

    private Set<String> getUpCalcMaterialFromBomSetting(Set<String> keyColsParam) {
        Date[] periodtime;
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("keycol", "in", keyColsParam));
        filters.add(new QFilter("isdowncalc", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        if (this.searchDate != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
            filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
        } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        DataSet bomSettingData = QueryServiceHelper.queryDataSet((String)"aaa", (String)"cad_bomsetting", (String)"keycol", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<String> selfKeyCol = new HashSet<String>(16);
        while (bomSettingData.hasNext()) {
            Row row = bomSettingData.next();
            selfKeyCol.add(row.getString("keycol"));
        }
        return selfKeyCol;
    }

    private String getCalcMaterialFromBomSetting(DataSet materialIds) {
        Date[] periodtime;
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("isdowncalc", "=", (Object)"0"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        if (this.searchDate != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
            filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
        } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        DataSet bomSettingData = QueryServiceHelper.queryDataSet((String)"aaa", (String)"cad_bomsetting", (String)"material,keycol,auxprop,isdowncalc", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet finish = materialIds.join(bomSettingData, JoinType.INNER).on("material", "material").on("keycol", "keycol").select(materialIds.getRowMeta().getFieldNames(), new String[]{"isdowncalc"}).finish();
        StringBuilder materials = new StringBuilder("0");
        HashSet<Long> set = new HashSet<Long>(16);
        while (finish.hasNext()) {
            set.add(finish.next().getLong("material"));
        }
        for (Long id : set) {
            materials.append(",");
            materials.append(id);
        }
        return materials.toString();
    }

    private DataSet addSumRow(DataSet dataSet) {
        Date start = new Date();
        RowMeta rowMeta = dataSet.copy().getRowMeta();
        HashMap map = new HashMap();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String key = row.getString("path");
            List rows = (List)map.get(key);
            if (rows != null) {
                rows.add(row);
                continue;
            }
            ArrayList<Row> arrayList = new ArrayList<Row>();
            arrayList.add(row);
            map.put(key, arrayList);
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        Field[] fields = rowMeta.getFields();
        for (Map.Entry entry : map.entrySet()) {
            BigDecimal sum = BigDecimal.ZERO;
            Object[] sumRowData = null;
            List value = (List)entry.getValue();
            for (int i = 0; i < value.size(); ++i) {
                Row row = (Row)value.get(i);
                Object[] rowData = new Object[fields.length];
                for (int j = 0; j < fields.length; ++j) {
                    Object val;
                    String name = fields[j].getName();
                    if ("amount".equals(name) && row.getBigDecimal(name) != null) {
                        sum = sum.add(row.getBigDecimal(name));
                    }
                    rowData[j] = val = row.get(name);
                }
                dataList.add(rowData);
                if (i != value.size() - 1) continue;
                sumRowData = (Object[])rowData.clone();
                sumRowData[rowMeta.getFieldIndex((String)"element")] = ResManager.loadKDString((String)"\u7269\u6599", (String)"MatStdCostDownQueryPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]);
                sumRowData[rowMeta.getFieldIndex((String)"subelement")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"MatStdCostDownQueryPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]);
                BigDecimal qty = row.getBigDecimal("qty");
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal price = sum.divide(qty, 5, RoundingMode.HALF_UP);
                    sumRowData[rowMeta.getFieldIndex((String)"price")] = price;
                }
                sumRowData[rowMeta.getFieldIndex((String)"datatype")] = "0";
                sumRowData[rowMeta.getFieldIndex((String)"amount")] = sum;
            }
            if (sum.compareTo(BigDecimal.ZERO) == 0) continue;
            dataList.add(sumRowData);
        }
        Date end = new Date();
        logger.info("\u5904\u7406\u5408\u8ba1\u884c\u6d88\u8017\u65f6\u95f4\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), rowMeta);
    }

    public void sortList(List<Node> list, String id, BigDecimal qty, List<Node> resultList, String parentPath) {
        for (Node node : list) {
            if (!node.getPid().equals(id)) continue;
            String path = parentPath + "-" + node.getId();
            Node clone = node.clone();
            clone.setPath(path);
            BigDecimal multiply = clone.getBomrate().multiply(qty);
            clone.setBomrate(multiply);
            boolean has = false;
            for (Node rNode : resultList) {
                if (!path.equals(rNode.getPath())) continue;
                has = true;
                break;
            }
            if (!has) {
                resultList.add(clone);
            }
            this.sortList(list, clone.getId(), multiply, resultList, path);
        }
    }

    private String getLevelStr(int level) {
        String levelStr = "" + level;
        for (int i = 1; i <= level; ++i) {
            levelStr = "--" + levelStr;
        }
        return "'" + levelStr + "'";
    }

    public static class Node
    implements Cloneable {
        private String id;
        private String pid;
        private BigDecimal bomrate;
        private String path;
        private Object[] data;

        public Node(String id, String pid, BigDecimal bomrate, Object[] data) {
            this.id = id;
            this.pid = pid;
            this.data = data;
            this.bomrate = bomrate;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPid() {
            return this.pid;
        }

        public void setPath(String path) {
            this.path = path;
            if (this.data != null) {
                this.data[this.data.length - 1] = path;
            }
        }

        public String getPath() {
            return this.path;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public Object[] getData() {
            return this.data;
        }

        public BigDecimal getBomrate() {
            return this.bomrate;
        }

        public void setBomrate(BigDecimal bomrate) {
            this.bomrate = bomrate;
            if (this.data != null) {
                this.data[this.data.length - 4] = bomrate;
            }
        }

        public String toString() {
            return "[ pid=" + this.pid + ", id= " + this.id + "]";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return ("" + this.getPid() + this.getId()).equals("" + ((Node)obj).getPid() + ((Node)obj).getId());
        }

        public Node clone() {
            Node node = null;
            try {
                node = (Node)super.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.info(e.getMessage());
            }
            if (node != null) {
                node.data = (Object[])this.data.clone();
            }
            return node;
        }
    }
}

