/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import org.apache.commons.lang.StringUtils;

public class MatStdCostUpRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(MatStdCostUpRptQueryPlugin.class);
    private Long costtypeid;
    private boolean iseffect;
    private String entity;
    private Date searchDate;
    private Long queryperiodid = 0L;
    private Long currencyid = 0L;

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        this.init(filterInfo);
        DataSet bomDataSet = this.getBomStruct(filterInfo);
        bomDataSet = this.getCalcInfo(bomDataSet).orderBy(new String[]{"querymaterialkeycol", "path asc", "keycol", "subauxproperty", "bom", "datatype asc"});
        DataSet trackDataSet = this.getTrackDataSetInfo(filterInfo).orderBy(new String[]{"querymaterialkeycol", "path desc", "keycol", "subauxproperty", "bom", "level desc", "datatype asc"});
        bomDataSet = DataSetUtils.union((DataSet)bomDataSet, (DataSet)trackDataSet);
        return bomDataSet;
    }

    private DataSet getTrackDataSetInfo(FilterInfo filterInfo) {
        String subelement = ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"MatStdCostUpRptQueryPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]);
        String mat = ResManager.loadKDString((String)"'\u7269\u6599'", (String)"MatStdCostUpRptQueryPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]);
        Set<Long> ids = this.getTrackBomCalcIds(filterInfo);
        QFilter filter = new QFilter("id", "in", ids);
        if (this.iseffect) {
            List mnCostType = CostTypeHelper.getMnCostByHs((Long)this.costtypeid);
            if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
                filter.and(new QFilter("costtype", "=", mnCostType.get(0)));
            } else {
                filter.and(new QFilter("costtype", "=", (Object)this.costtypeid));
            }
        } else {
            filter.and(new QFilter("costtype", "=", (Object)this.costtypeid));
        }
        filter.and(new QFilter("entryentity.subentryentity.datatype", "in", (Object)new String[]{"2", "4"}));
        String queryFileds = "id,material,keycol pkeycol,calcdate,entryentity.entrymaterial materialid,concat('',entryentity.entrymaterial) materialidstr,entryentity.entrykeycol keycol,entryentity.entryauxproperty auxproperty,entryentity.entryconfiguredcode configuredcode,entryentity.entrytracknumber tracknumber,entryentity.entryproject project,entryentity.entrylot lot,entryentity.entrybomid bom,entryentity.subentryentity.element.name element,entryentity.subentryentity.subelement.name subelement,entryentity.subentryentity.stdprice amount,entryentity.subentryentity.submaterial submaterial,entryentity.subentryentity.subkeycol subkeycol,entryentity.subentryentity.subauxproperty subauxproperty,entryentity.id entryid,entryentity.entrytreepath path,entryentity.subentryentity.datatype datatype,'0' dataresource," + this.currencyid + " entrycurrency";
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet("getTrackBomCalcIds", "cad_trackstdcalcresult", queryFileds, new QFilter[]{filter}, "keycol", -1, null);
        DataSet dateDataSet = dataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
        dataSet = dataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(dataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
        dataSet = dataSet.filter("calcdate=maxcalcdate");
        Set allMaterial = (Set)filterInfo.getFilterItem("allmaterial").getValue();
        DataSet calDataSet = dataSet.copy().filter("materialid in (" + StringUtils.join((Collection)allMaterial, (String)",") + ")").select(new String[]{"id", "entryid", "materialid", "materialidstr", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "materialid submaterial", "keycol subkeycol", "auxproperty subauxproperty", "'0' level", "materialid querymaterial", "keycol querymaterialkeycol", "path", "configuredcode subconfiguredcode", "tracknumber subtracknumber", "project subproject", "lot sublot", "bom", "element", "subelement", "amount", "datatype", "dataresource", "entrycurrency"});
        DataSet calDataSetTemp = calDataSet.copy();
        calDataSet = this.getTraLevelDataSet(dataSet.copy(), calDataSet, 1, calDataSetTemp);
        DataSet calDataSetSum = calDataSet.copy().groupBy(new String[]{"id", "entryid", "materialid", "materialidstr", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "subauxproperty", "level", "querymaterial", "querymaterialkeycol", "path", "subconfiguredcode", "subtracknumber", "subproject", "sublot", "bom", "dataresource", "entrycurrency"}).sum("amount").finish().addFields(new String[]{subelement, "0L", "''", "'1'", mat}, new String[]{"subelement", "submaterial", "subkeycol", "datatype", "element"}).distinct();
        calDataSet = DataSetUtils.union((DataSet)calDataSet, (DataSet)calDataSetSum);
        return calDataSet;
    }

    private DataSet getTraLevelDataSet(DataSet dataSet, DataSet calDataSet, int callevel, DataSet calDataSetTemp) {
        if (calDataSetTemp != null) {
            String level = this.getLevelStr(callevel);
            HashSet keycols = new HashSet(16);
            calDataSetTemp.copy().forEach(o -> keycols.add("'" + o.getString("keycol") + "'"));
            String filterStr = CadEmptyUtils.isEmpty(keycols) ? "1=2" : "subkeycol in (" + StringUtils.join(keycols, (String)",") + ")";
            DataSet dataSetTemp = dataSet.copy().filter("datatype = '4'").filter(filterStr);
            if (dataSetTemp.hasNext()) {
                dataSetTemp = dataSetTemp.join(calDataSetTemp).on("id", "id").on("subkeycol", "keycol").select(dataSetTemp.getRowMeta().getFieldNames(), new String[]{"querymaterial", "querymaterialkeycol", "subconfiguredcode", "subtracknumber", "subproject", "sublot"}).finish();
                DataSet keyTemp = dataSetTemp.groupBy(new String[]{"id", "keycol", "materialid", "querymaterial", "querymaterialkeycol", "subconfiguredcode", "subtracknumber", "subproject", "sublot"}).finish();
                DataSet temp = dataSet.copy().join(keyTemp).on("id", "id").on("materialid", "materialid").on("keycol", "keycol").select(new String[]{"id", "entryid", "materialid", "materialidstr", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "submaterial", "subkeycol", "subauxproperty", level + " level", "path", "bom", "element", "subelement", "amount", "datatype", "querymaterial", "querymaterialkeycol", "subconfiguredcode", "subtracknumber", "subproject", "sublot", "dataresource", "entrycurrency"}).finish();
                DataSet tempCopy = temp.copy();
                calDataSet = DataSetUtils.union((DataSet)calDataSet, (DataSet)temp);
                calDataSet = this.getTraLevelDataSet(dataSet, calDataSet.copy(), ++callevel, tempCopy);
            }
        }
        return calDataSet;
    }

    private Set<Long> getTrackBomCalcIds(FilterInfo filterInfo) {
        DataSet dateDataSet;
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection mulConfiguredCode;
        Set allMaterial = (Set)filterInfo.getFilterItem("allmaterial").getValue();
        List<QFilter> filters = new ArrayList<QFilter>(16);
        if (this.iseffect) {
            Date[] periodtime;
            List mnCostType = CostTypeHelper.getMnCostByHs((Long)this.costtypeid);
            if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
                filters.add(new QFilter("costtype", "=", mnCostType.get(0)));
            } else {
                filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
            }
            if (this.searchDate != null) {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
            } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
                filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
            }
        } else {
            filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        }
        filters.add(new QFilter("entryentity.subentryentity.submaterial", "in", (Object)allMaterial));
        String mulAuxpty = filterInfo.getString("mulauxpty");
        if (!CadEmptyUtils.isEmpty((String)mulAuxpty)) {
            String[] split = mulAuxpty.split(",");
            ArrayList<Long> auxptyIds = new ArrayList<Long>(10);
            for (String s : split) {
                auxptyIds.add(Long.parseLong(s));
            }
            filters.add(new QFilter("entryentity.entryauxproperty", "in", auxptyIds));
        }
        if ((mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode")) != null) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.entryconfiguredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.entrytracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.entryproject", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("entryentity.entrylot", "in", (Object)lots.split(",")));
        }
        String queryFileds = "id,material,costtype,keycol,effectdate,expdate,now() as curDate,calcdate";
        ORMImpl orm = new ORMImpl();
        DataSet trackNumberDataSet = orm.queryDataSet("getTrackBomCalcIds", "cad_trackstdcalcresult", queryFileds, filters.toArray(new QFilter[0]), "keycol", -1, null);
        DataSet dataSet = null;
        if (this.iseffect) {
            dateDataSet = trackNumberDataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
            trackNumberDataSet = trackNumberDataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
            dataSet = trackNumberDataSet.filter("calcdate=maxcalcdate");
        } else {
            dateDataSet = trackNumberDataSet.filter("expdate is not null");
            DataSet trackNumberDateDataSet = dateDataSet.filter("curdate>=effectdate and curdate<=expdate");
            DataSet keyColDateDataSet = dateDataSet.groupBy(new String[]{"material", "keycol keyColcherck"}).finish();
            DataSet trackNumberUnDateDataSet = trackNumberDataSet.leftJoin(keyColDateDataSet).on("material", "material").on("keycol", "keyColcherck").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"keyColcherck"}).finish().filter("keyColcherck is null");
            dataSet = DataSetUtils.union((DataSet)trackNumberDateDataSet, (DataSet)trackNumberUnDateDataSet);
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    private void init(FilterInfo filterInfo) {
        DynamicObject currency = filterInfo.getDynamicObject("currency");
        if (currency != null) {
            this.currencyid = (Long)currency.getPkValue();
        }
        DynamicObject costtype = filterInfo.getDynamicObject("costtype");
        this.searchDate = filterInfo.getDate("searchdate");
        DynamicObject queryPeriod = filterInfo.getDynamicObject("queryperiod");
        if (queryPeriod != null) {
            this.queryperiodid = queryPeriod.getLong("id");
        }
        this.costtypeid = (Long)costtype.getPkValue();
        this.iseffect = costtype.getString("type").equals("0");
        if (this.iseffect) {
            this.entity = "cad_calceffectiveresult";
            this.iseffect = true;
        } else {
            this.entity = "cad_calcsimulationresult";
            this.iseffect = false;
        }
        Set<Long> productFilter = this.getProductFilter(filterInfo);
        filterInfo.addFilterItem("allmaterial", productFilter);
    }

    private DataSet getBomStruct(FilterInfo filterInfo) {
        Date start = new Date();
        List<String> keyCols = this.getKeyCols(filterInfo);
        int level = 0;
        List<QFilter> filters = this.getLevelDataQFilter(new QFilter("entryentity.subkeycol", "in", keyCols));
        if (this.iseffect) {
            filters.add(new QFilter("tracknumber", "is null", null).or(new QFilter("tracknumber", "=", (Object)0)));
        }
        String fields = "entryentity.submaterial materialid,concat('',entryentity.submaterial) materialidstr,entryentity.subconfiguredcode configuredcode,entryentity.subtracknumber tracknumber,entryentity.subproject project,entryentity.sublot lot,entryentity.subkeycol keycol,entryentity.subauxproperty as auxproperty,entryentity.submaterial submaterial,entryentity.subkeycol subkeycol,entryentity.subauxproperty as subauxproperty,'0' level,entryentity.submaterial querymaterial,entryentity.subkeycol querymaterialkeycol,concat('',entryentity.submaterial) path,entryentity.subconfiguredcode subconfiguredcode,entryentity.subtracknumber subtracknumber,entryentity.subproject subproject,entryentity.sublot sublot";
        if (!this.iseffect) {
            fields = fields + ",calcdate calcdate";
        }
        GroupbyDataSet groupbyDataSet = QueryServiceHelper.queryDataSet((String)"aa", (String)this.entity, (String)fields, (QFilter[])filters.toArray(new QFilter[0]), null).groupBy(new String[]{"materialid", "materialidstr", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "submaterial", "subkeycol", "subauxproperty", "level", "querymaterial", "querymaterialkeycol", "path", "subconfiguredcode", "subtracknumber", "subproject", "sublot"});
        if (!this.iseffect) {
            groupbyDataSet.max("calcdate");
        }
        DataSet oneLevelDataSet = groupbyDataSet.finish().select(new String[]{"materialid", "materialidstr", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "submaterial", "subkeycol", "subauxproperty", "level", "querymaterial", "querymaterialkeycol", "path", "subconfiguredcode", "subtracknumber", "subproject", "sublot"});
        DataSet allDataSet = this.nextLevelData(oneLevelDataSet.copy(), ++level);
        DataSet dataSet = DataSetUtils.union((DataSet)oneLevelDataSet, (DataSet)allDataSet);
        Date end = new Date();
        logger.info("BOM\u6811\u67e5\u8be2\u8017\u65f6\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
        return dataSet;
    }

    private List<String> getKeyCols(FilterInfo filterInfo) {
        String lots;
        DynamicObjectCollection mulProjectNumber;
        DynamicObjectCollection mulTracknumber;
        DynamicObjectCollection mulConfiguredCode;
        Set allMaterial = (Set)filterInfo.getFilterItem("allmaterial").getValue();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("entryentity.submaterial", "in", (Object)allMaterial));
        String mulAuxpty = filterInfo.getString("mulauxpty");
        if (!CadEmptyUtils.isEmpty((String)mulAuxpty)) {
            String[] split = mulAuxpty.split(",");
            ArrayList<Long> auxptyIds = new ArrayList<Long>(10);
            for (String s : split) {
                auxptyIds.add(Long.parseLong(s));
            }
            filters.add(new QFilter("entryentity.subauxproperty", "in", auxptyIds));
        }
        if ((mulConfiguredCode = filterInfo.getDynamicObjectCollection("mulconfiguredcode")) != null) {
            List configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subconfiguredcode", "in", configuredCodeIds));
        }
        if ((mulTracknumber = filterInfo.getDynamicObjectCollection("multracknumber")) != null) {
            List trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subtracknumber", "in", trackNumberIds));
        }
        if ((mulProjectNumber = filterInfo.getDynamicObjectCollection("mulprojectnumber")) != null) {
            List projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            filters.add(new QFilter("entryentity.subproject", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = filterInfo.getString("mullot")))) {
            filters.add(new QFilter("entryentity.sublot", "in", (Object)lots.split(",")));
        }
        String queryFileds = "id,costtype,entryentity.subkeycol subkeycol";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)this.entity, (String)queryFileds, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<String> keyCols = new ArrayList<String>(10);
        for (DynamicObject data : datas) {
            keyCols.add(data.getString("subkeycol"));
        }
        return keyCols;
    }

    private DataSet nextLevelData(DataSet dataSet, int level) {
        DataSet copy = dataSet.copy();
        if (!copy.hasNext()) {
            return Algo.create((String)"").createDataSet(new ArrayList(), copy.getRowMeta());
        }
        String fields = "material materialid,concat('',material) materialidstr,keycol,auxproperty,configuredcode,tracknumber,project,lot,entryentity.submaterial submaterial,entryentity.subkeycol subkeycol,entryentity.subauxproperty as subauxproperty,entryentity.subconfiguredcode subconfiguredcode,entryentity.subtracknumber subtracknumber,entryentity.subproject subproject,entryentity.sublot sublot," + this.getLevelStr(level) + " level";
        if (!this.iseffect) {
            fields = fields + ",calcdate";
        }
        HashSet keyCols = new HashSet(16);
        copy.forEach(e -> keyCols.add(e.getString("keycol")));
        GroupbyDataSet groupbyDataSet = QueryServiceHelper.queryDataSet((String)"aa", (String)this.entity, (String)fields, (QFilter[])this.getLevelDataQFilter(new QFilter("entryentity.subkeycol", "in", keyCols)).toArray(new QFilter[0]), null).groupBy(new String[]{"materialid", "materialidstr", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "submaterial", "subkeycol", "subauxproperty", "subconfiguredcode", "subtracknumber", "subproject", "sublot", "level"});
        if (!this.iseffect) {
            groupbyDataSet.max("calcdate");
        }
        DataSet tmpDataSet = groupbyDataSet.finish();
        DataSet levelDataSet = tmpDataSet.join(dataSet, JoinType.INNER).on("submaterial", "materialid").on("subkeycol", "keycol").select(tmpDataSet.getRowMeta().getFieldNames(), new String[]{"querymaterial", "querymaterialkeycol", "path"}).finish();
        levelDataSet = levelDataSet.select(new String[]{"materialid", "materialidstr", "keycol", "auxproperty", "configuredcode", "tracknumber", "project", "lot", "submaterial", "subkeycol", "subauxproperty", "subconfiguredcode", "subtracknumber", "subproject", "sublot", "level", "querymaterial", "querymaterialkeycol", "concat(path,concat('@',materialidstr)) path"});
        DataSet nextLevelData = this.nextLevelData(levelDataSet, ++level);
        return DataSetUtils.union((DataSet)levelDataSet, (DataSet)nextLevelData);
    }

    private DataSet getCalcInfo(DataSet dataSet) {
        Date start = new Date();
        DataSet resultDataSet = null;
        DataSet allMaterial = dataSet.copy();
        List<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        String outEntity = "cad_calcpurprices";
        String add = ",effectdate";
        HashSet<String> keyCols = new HashSet<String>(16);
        dataSet.forEach(e -> keyCols.add(e.getString("keycol")));
        if (this.iseffect) {
            Date[] periodtime;
            outEntity = "cad_purprices";
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            if (this.searchDate != null) {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
            } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
                filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
            }
            resultDataSet = this.getEffectResultDataSet(keyCols);
        } else {
            add = ",calcdate effectdate";
            resultDataSet = this.getSimulaTionResultDataSet(keyCols);
        }
        resultDataSet = allMaterial.leftJoin(resultDataSet).on("materialid", "material").on("keycol", "keycol").select(allMaterial.getRowMeta().getFieldNames(), new String[]{"bom", "element", "subelement", "amount", "datatype", "dataresource", "entrycurrency"}).finish();
        DataSet selfCalcDataSet = resultDataSet.filter("bom != null");
        DataSet outCalcDataSet = resultDataSet.filter("bom = null");
        outCalcDataSet = outCalcDataSet.select(allMaterial.getRowMeta().getFieldNames());
        HashSet outMatkeyCols = new HashSet(16);
        outCalcDataSet.copy().forEach(o -> outMatkeyCols.add(o.getString("keycol")));
        filters.add(new QFilter("keycol", "in", outMatkeyCols));
        String outFields = "keycol,material,auxpty as auxproperty,0 as bom,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.price as amount,'20' datatype,'0' dataresource," + this.currencyid + " entrycurrency" + add;
        DataSet outMaterialDataSet = QueryServiceHelper.queryDataSet((String)"outDataQuery", (String)outEntity, (String)outFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        String queryPeriodGroups = "keycol,material";
        String queryPeriodFields = queryPeriodGroups + ",effectdate";
        DataSet queryPeriodDataSet = outMaterialDataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
        outMaterialDataSet = outMaterialDataSet.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("keycol", "keycol").on("effectdate", "effectdate").select(outMaterialDataSet.getRowMeta().getFieldNames(), null).finish();
        outMaterialDataSet = outMaterialDataSet.removeFields(new String[]{"effectdate"});
        outMaterialDataSet = outMaterialDataSet.groupBy(new String[]{"material", "keycol", "auxproperty", "bom", "element", "subelement", "datatype", "dataresource", "entrycurrency"}).sum("amount").finish();
        outCalcDataSet = outCalcDataSet.leftJoin(outMaterialDataSet).on("materialid", "material").on("keycol", "keycol").select(allMaterial.getRowMeta().getFieldNames(), new String[]{"bom", "element", "subelement", "amount", "datatype", "dataresource", "entrycurrency"}).finish();
        outCalcDataSet = this.addSumRow(outCalcDataSet);
        Date end = new Date();
        logger.info("\u7269\u6599\u6210\u672c\u4fe1\u606f\u67e5\u8be2\u8017\u65f6\uff1a" + (end.getTime() - start.getTime()) + "\u6beb\u79d2");
        return selfCalcDataSet.union(outCalcDataSet).distinct();
    }

    private DataSet getSimulaTionResultDataSet(Set<String> keyCols) {
        QFilter ismaindata = new QFilter("ismaindata", "=", (Object)1L);
        QFilter costtypeq = new QFilter("costtype", "=", (Object)this.costtypeid);
        QFilter[] selfFilter = new QFilter[]{costtypeq, ismaindata, new QFilter("entryentity.datatype", "in", (Object)new String[]{"1", "2", "4"}), new QFilter("keycol", "in", keyCols)};
        String selfFields = "keycol,material,auxproperty,material.modelnum modelnum,bom,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.qty qty,entryentity.price price ,entryentity.stdprice as amount,entryentity.datatype as datatype,'2' as dataresource";
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)"calcDataQuery", (String)"cad_calcsimulationresult", (String)(selfFields + ",calcdate"), (QFilter[])selfFilter, null).groupBy(new String[]{"keycol", "bom", "element", "subelement", "material", "auxproperty", "modelnum", "datatype", "dataresource"}).max("calcdate").sum("amount").finish();
        String outMaterial = this.getCalcMaterialFromBomSetting(resultDataSet.copy());
        return resultDataSet.filter("material not in (" + outMaterial + ")").select(new String[]{"keycol", "material", "auxproperty", "modelnum", "bom", "element", ResManager.loadKDString((String)"case when datatype = '1' then '\u5c0f\u8ba1' else subelement end subelement", (String)"MatStdCostUpRptQueryPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]), "amount", "datatype", "dataresource", this.currencyid + " entrycurrency"});
    }

    public DataSet getEffectResultDataSet(Set<String> keyCols) {
        Date[] periodtime;
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("ismaindata", "=", (Object)1L));
        filters.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"1", "2", "4"}));
        filters.add(new QFilter("keycol", "in", keyCols));
        if (this.searchDate != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
            filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
        } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        String selfFields = "keycol,effectdate,material,auxproperty,material.modelnum modelnum,bom,entryentity.element.name as element,entryentity.subelement.name as subelement ,entryentity.stdprice as amount,entryentity.datatype as datatype,'1' as dataresource";
        DataSet effectResult = QueryServiceHelper.queryDataSet((String)"calcDataQuery", (String)this.entity, (String)selfFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        if (Boolean.TRUE.equals(CostUpdateHelper.isQueryPeriod((ReportQueryParam)this.getQueryParam()))) {
            String queryPeriodGroups = "keycol,material,auxproperty";
            String queryPeriodFields = queryPeriodGroups + ",effectdate";
            DataSet queryPeriodDataSet = effectResult.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
            effectResult = effectResult.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("keycol", "keycol").on("effectdate", "effectdate").select(effectResult.getRowMeta().getFieldNames(), null).finish();
        }
        effectResult = effectResult.removeFields(new String[]{"effectdate"});
        effectResult = effectResult.groupBy(new String[]{"keycol", "bom", "element", "subelement", "material", "auxproperty", "modelnum", "datatype", "dataresource"}).sum("amount").finish();
        return effectResult.select(new String[]{"keycol", "material", "auxproperty", "modelnum", "bom", "element", ResManager.loadKDString((String)"case when datatype = '1' then '\u5c0f\u8ba1' else subelement end subelement", (String)"MatStdCostUpRptQueryPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]), "amount", "datatype", "dataresource", this.currencyid + " entrycurrency"});
    }

    private String getCalcMaterialFromBomSetting(DataSet materialIds) {
        Date[] periodtime;
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("isdowncalc", "=", (Object)"0"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        if (this.searchDate != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
            filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
        } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        DataSet bomSettingData = QueryServiceHelper.queryDataSet((String)"aaa", (String)"cad_bomsetting", (String)"material,keycol,auxprop,isdowncalc", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet finish = materialIds.join(bomSettingData, JoinType.INNER).on("material", "material").on("keycol", "keycol").select(materialIds.getRowMeta().getFieldNames(), new String[]{"isdowncalc"}).finish();
        StringBuilder materials = new StringBuilder("0");
        HashSet<Long> set = new HashSet<Long>(16);
        while (finish.hasNext()) {
            set.add(finish.next().getLong("material"));
        }
        for (Long id : set) {
            materials.append(",");
            materials.append(id);
        }
        return materials.toString();
    }

    private DataSet addSumRow(DataSet dataSet) {
        RowMeta rowMeta = dataSet.copy().getRowMeta();
        HashMap map = new HashMap();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long querymaterialId = row.getLong("querymaterial");
            Long materialId = row.getLong("materialId");
            String keyCol = row.getString("keycol");
            String key = querymaterialId + "@" + materialId + "@" + keyCol;
            List rows = (List)map.get(key);
            if (rows != null) {
                rows.add(row);
                continue;
            }
            ArrayList<Row> list = new ArrayList<Row>();
            list.add(row);
            map.put(key, list);
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        Field[] fields = rowMeta.getFields();
        for (Map.Entry entry : map.entrySet()) {
            BigDecimal sum = BigDecimal.ZERO;
            Object[] sumRowData = null;
            List value = (List)entry.getValue();
            for (int i = 0; i < value.size(); ++i) {
                Row row = (Row)value.get(i);
                Object[] rowData = new Object[fields.length];
                for (int j = 0; j < fields.length; ++j) {
                    Object val;
                    String name = fields[j].getName();
                    if ("amount".equals(name) && row.getBigDecimal(name) != null) {
                        sum = sum.add(row.getBigDecimal(name));
                    }
                    rowData[j] = val = row.get(name);
                }
                dataList.add(rowData);
                if (i != value.size() - 1) continue;
                sumRowData = (Object[])rowData.clone();
                sumRowData[rowMeta.getFieldIndex((String)"element")] = ResManager.loadKDString((String)"\u7269\u6599", (String)"MatStdCostUpRptQueryPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]);
                sumRowData[rowMeta.getFieldIndex((String)"subelement")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"MatStdCostUpRptQueryPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
                sumRowData[rowMeta.getFieldIndex((String)"datatype")] = "0";
                sumRowData[rowMeta.getFieldIndex((String)"amount")] = sum;
            }
            if (sum.compareTo(BigDecimal.ZERO) == 0) continue;
            dataList.add(sumRowData);
        }
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), rowMeta);
    }

    private Set<Long> getProductFilter(FilterInfo filterInfo) {
        HashSet<Long> matIds = new HashSet<Long>(10);
        if (filterInfo == null) {
            return matIds;
        }
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("material");
        for (DynamicObject material : materials) {
            matIds.add(material.getLong("id"));
        }
        HashSet<Long> bomIds = new HashSet<Long>(10);
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"bom", (QFilter[])new QFilter[]{new QFilter("costtype", "=", (Object)filterInfo.getLong("costtype"))});
        for (DynamicObject bomSetting : bomSettings) {
            bomIds.add(bomSetting.getLong("bom"));
        }
        QFilter filter = new QFilter("id", "in", bomIds);
        filter.and(new QFilter("iscoproduct", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("copentry.copentrymaterial", "in", matIds));
        filter.and(new QFilter("material", "not in", matIds));
        DynamicObjectCollection boms = QueryServiceHelper.query((String)"cad_costbom", (String)"material", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bom : boms) {
            matIds.add(bom.getLong("material"));
        }
        return matIds;
    }

    private List<QFilter> getLevelDataQFilter(QFilter subMaterialFilter) {
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.costtypeid));
        filters.add(new QFilter("ismaindata", "=", (Object)1L));
        if (subMaterialFilter != null) {
            filters.add(subMaterialFilter);
        }
        filters.add(new QFilter("entryentity.datatype", "=", (Object)"4"));
        if (this.iseffect) {
            Date[] periodtime;
            if (this.searchDate != null) {
                filters.add(new QFilter("effectdate", "<=", (Object)this.searchDate));
                filters.add(new QFilter("expdate", ">=", (Object)this.searchDate));
            } else if (this.queryperiodid != null && this.queryperiodid != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)this.queryperiodid)) != null) {
                filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
            }
            filters.add(new QFilter("tracknumber", "is null", null).or(new QFilter("tracknumber", "=", (Object)0)));
        } else {
            QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
            filters.add(recordFilter);
        }
        return filters;
    }

    private String getLevelStr(int level) {
        String levelStr = "" + level;
        for (int i = 1; i <= level; ++i) {
            levelStr = "--" + levelStr;
        }
        return "'" + levelStr + "'";
    }
}

