/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.OldCollectConfigHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatUseCollectLogarithmQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(MatUseCollectLogarithmQueryPlugin.class);
    private LogarithmParam logarithmParam = new LogarithmParam();

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object object) throws Throwable {
        logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u5f00\u59cb\uff01");
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.init(filterInfo);
        DataSet dataSet = this.queryData();
        FilterItemInfo filterInfo1 = filterInfo.getFilterItem("sourcebill");
        if (filterInfo1 != null) {
            String sourcebilltype = filterInfo.getString("sourcebill");
            Long transactiontypeid = filterInfo.getLong("transactiontypeid");
            String field1 = "sourcebilltype = '" + sourcebilltype + "'";
            String field2 = "transactiontype = " + transactiontypeid + "";
            if (CadEmptyUtils.isEmpty((String)sourcebilltype)) {
                field1 = "sourcebilltype = null";
            }
            if (CadEmptyUtils.isEmpty((Long)transactiontypeid)) {
                field2 = "(transactiontype = null or transactiontype = 0)";
            }
            return dataSet.filter(field1 + " and " + field2);
        }
        logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u7ed3\u675f\uff01");
        return dataSet;
    }

    private void init(FilterInfo info) {
        DynamicObject org = info.getDynamicObject("org");
        this.logarithmParam.setOrgId(Long.valueOf(org.getLong("id")));
        DynamicObjectCollection bizorgs = info.getDynamicObjectCollection("mulbizorg");
        ArrayList<Long> bizorgIds = this.logarithmParam.getBizorgIds();
        if (bizorgIds == null) {
            bizorgIds = new ArrayList<Long>(10);
        } else if (bizorgIds.size() > 0) {
            bizorgIds.clear();
        }
        for (DynamicObject bizorg : bizorgs) {
            bizorgIds.add(bizorg.getLong("id"));
        }
        String appnum = "";
        if (StringUtils.isNotEmpty((String)info.getString("appnum"))) {
            appnum = info.getString("appnum");
        }
        this.logarithmParam.setAppnum(appnum);
        Map dateMap = LogarithmHelper.getQueryTime((FilterInfo)info);
        this.logarithmParam.setStartDate((Date)dateMap.get("startDate"));
        this.logarithmParam.setEndDate((Date)dateMap.get("endDate"));
        List costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)this.logarithmParam.getOrgId(), (Long[])new Long[]{4L});
        this.logarithmParam.setCostCenterIds(costCenterIds);
    }

    private DataSet queryData() {
        QFilter filter = new QFilter("org", "=", (Object)this.logarithmParam.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("manuorg", "in", (Object)this.logarithmParam.getBizorgIds()));
        filter.and(new QFilter("bookdate", ">=", (Object)this.logarithmParam.getStartDate()));
        filter.and(new QFilter("bookdate", "<", (Object)this.logarithmParam.getEndDate()));
        filter.and(new QFilter("srcbilltype", "in", (Object)new String[]{"im_materialreqoutbill", "im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill"}));
        filter.and(new QFilter("appnum", "=", (Object)this.logarithmParam.getAppnum()));
        String entity = "sca_matusecollect";
        if ("ACA".equalsIgnoreCase(this.logarithmParam.getAppnum())) {
            entity = "aca_matusecollect";
        }
        Set ranges = OldCollectConfigHelper.getInnerSys((Long)this.logarithmParam.getOrgId(), (String)entity, (String)this.logarithmParam.getAppnum());
        return LogarithmHelper.getMatUseCollectLogarithm((LogarithmParam)this.logarithmParam, (QFilter)filter, (String)this.getAlgoKey("queryData"), (String)entity, (Set)ranges);
    }
}

