/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.mfgfee.report.MfgAuxAllocRptAlogxService;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.lang.StringUtils;

public class MfgAuxAllocRptQueryPlugin
extends AbstractReportListDataPlugin {
    private final Log logger = LogFactory.getLog(MfgAuxAllocRptQueryPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object arg1) throws Throwable {
        MfgAuxAllocRptAlogxService service = new MfgAuxAllocRptAlogxService();
        Map customParamMap = reportQueryParam.getCustomParam();
        String entityType = customParamMap.get("entitytype").toString();
        FilterInfo filter = reportQueryParam.getFilter();
        QFilter statusFilter = new QFilter("allocstatus", "!=", (Object)"0");
        List<QFilter> queryFilter = this.getQueryFilter(filter);
        if (entityType.equals("cad_planauxprodalloc")) {
            long planSchemeId = filter.getDynamicObject("planscheme").getLong("id");
            queryFilter.add(new QFilter("planscheme", "=", (Object)planSchemeId));
        }
        queryFilter.add(statusFilter);
        String carrymtd = (String)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"carrymtd");
        Boolean periodmerge = (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"periodmerge");
        Long currency = (Long)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"currency");
        List benefcsdutys = (List)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"benefcsorgduty");
        List<Long> subCostcenterId = this.getMoreSelectValue(filter, "subcostcenterf");
        long time = System.currentTimeMillis();
        DataSet resultDs = this.getQueryDataSet(queryFilter, carrymtd, benefcsdutys, subCostcenterId, entityType);
        this.logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u62a5\u8868\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        resultDs = service.auxRptDataDeal(resultDs, periodmerge.booleanValue(), StringUtils.equals((String)carrymtd, (String)"A"));
        String total = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"MfgAuxAllocRptQueryPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]);
        resultDs = resultDs.select("period,manuorg,allocmethod,costcenter,publicaux,expenseitem,costdriver,allocamount,baseunit,costdriverqty,actualrate,allocsum,subcostcenter,subexpenseitem,subcostdriver,subbaseunit,subinqty,subinamt,suboutqty,suboutamt,costcenternumber,case when expenseitem like('%" + total + "%')  or expenseitem=' ' or expenseitem='' or expenseitem is null then ' ' else expenseitemnumber end expenseitemnumber,case when subcostcenter>0 then subcostcenternumber else '' end subcostcenternumber,periodorder,seq,manuorgnumber");
        resultDs = resultDs.addField(currency + " ", "hcurrency");
        this.logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u62a5\u8868algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"MfgAuxAllocRptQueryPlugin_8", (String)"macc-cad-report", (Object[])new Object[0]), (String)"MfgAuxAllocRptQueryPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"MfgAuxAllocRptQueryPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]), (String)"MfgAuxAllocRptQueryPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"cad_mfgauxallocrpt", (String)filter.getString("appnum"));
        return resultDs;
    }

    private DataSet getQueryDataSet(List<QFilter> queryFilter, String carrymtd, List<Long> benefcsdutys, List<Long> subCostcenterId, String entityType) {
        String selectField = null;
        String orderByField = null;
        if ("A".equals(carrymtd)) {
            if (benefcsdutys != null && benefcsdutys.size() > 0) {
                queryFilter.add(new QFilter("comentity.comsubentity.subcostcenter.orgduty", "in", benefcsdutys));
            }
            if (subCostcenterId != null && subCostcenterId.size() > 0) {
                queryFilter.add(new QFilter("comentity.comsubentity.subcostcenter", "in", subCostcenterId));
            }
            selectField = "id,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,allocmethod,costcenter,costcenter.number costcenternumber,publicaux,comentity.id as sid,comentity.expenseitem.number as expenseitemnumber,comentity.expenseitem.name as expenseitem,comentity.costdriver as costdriver,comentity.allocamount as allocamount,comentity.baseunit as baseunit,comentity.costdriverqty as costdriverqty,case when allocmethod ='mutual' and publicaux='0' then comentity.actualoutrate else comentity.actualrate end actualrate,comentity.allocsum as allocsum,comentity.comsubentity.id as eid,comentity.comsubentity.subcostcenter as subcostcenter,comentity.comsubentity.subcostcenter.number as subcostcenternumber,comentity.comsubentity.subcostcenter.orgduty as orgduty,comentity.comsubentity.subexpenseitem as subexpenseitem,comentity.comsubentity.subcostdriver as subcostdriver,comentity.comsubentity.subbaseunit as subbaseunit,comentity.comsubentity.subqty as subqty,comentity.comsubentity.subamt as subamt,comentity.comsubentity.subinqty as subinqty,comentity.comsubentity.subinamt as subinamt,comentity.comsubentity.suboutqty as suboutqty,comentity.comsubentity.suboutamt as suboutamt";
        } else {
            if (subCostcenterId != null && subCostcenterId.size() > 0) {
                queryFilter.add(new QFilter("parallelentity.parallelsubentity.parsubcostcenter", "in", subCostcenterId).or(new QFilter("parallelentity.parallelsubentity.parsubcostcenter", "is null", (Object)"")));
            }
            selectField = "id,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,allocmethod,costcenter,costcenter.number costcenternumber,publicaux,parallelentity.id as sid,parallelentity.parexpenseitem.number as expenseitemnumber,parallelentity.parexpenseitem.name as expenseitem,parallelentity.parcostdriver as costdriver,parallelentity.parallocamount as allocamount,parallelentity.parbaseunit as baseunit,parallelentity.parcostdriverqty as costdriverqty,case when allocmethod ='mutual' and publicaux='0' then parallelentity.paractualoutrate else parallelentity.paractualrate end actualrate,parallelentity.parallocsum as allocsum,parallelentity.parallelsubentity.id as eid,parallelentity.parallelsubentity.parsubcostcenter as subcostcenter,parallelentity.parallelsubentity.parsubcostcenter.number as subcostcenternumber,parallelentity.parallelsubentity.parsubcostcenter.orgduty as orgduty,parallelentity.parallelsubentity.parsubexpenseitem as subexpenseitem,parallelentity.parallelsubentity.parsubcostdriver as subcostdriver,parallelentity.parallelsubentity.parsubbaseunit as subbaseunit,parallelentity.parallelsubentity.parsubqty as subqty,parallelentity.parallelsubentity.parsubamt as subamt,parallelentity.parallelsubentity.parsubinqty as subinqty,parallelentity.parallelsubentity.parsubinamt as subinamt,parallelentity.parallelsubentity.parsuboutqty as suboutqty,parallelentity.parallelsubentity.parsuboutamt as suboutamt";
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityType, (String)selectField, (QFilter[])queryFilter.toArray(new QFilter[0]), orderByField);
        if (benefcsdutys != null && benefcsdutys.size() > 0) {
            ds = ds.filter("orgduty is null or orgduty = 0L or orgduty in (" + StringUtils.join(benefcsdutys, (String)",") + ")");
        }
        DataSet resultDs = ds.select("id,period,periodorder,manuorg,manuorgnumber,allocmethod,costcenter,costcenternumber,publicaux,sid,expenseitem,expenseitemnumber,costdriver,allocamount,baseunit,costdriverqty,actualrate,allocsum,eid,subcostcenter,subcostcenternumber,orgduty subcostcenterorgduty,subexpenseitem,subcostdriver,subbaseunit,case when allocmethod ='mutual' and publicaux=false then subinqty when allocmethod ='algebra' and publicaux=false then subinqty when orgduty=5 then subqty else 0 end subinqty,case when allocmethod ='mutual' and publicaux=false then suboutqty when allocmethod ='algebra' and publicaux=false then suboutqty when orgduty=5 then 0 else subqty end suboutqty,case when allocmethod ='mutual' and publicaux=false then subinamt when allocmethod ='algebra' and publicaux=false then subinamt when orgduty=5 then subamt else 0 end subinamt,case when allocmethod ='mutual' and publicaux=false then suboutamt when allocmethod ='algebra' and publicaux=false then suboutamt when orgduty=5 then 0 else subamt end suboutamt");
        return resultDs;
    }

    private List<QFilter> getQueryFilter(FilterInfo filter) {
        String appId = filter.getString("appnum");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject accountorg = filter.getDynamicObject("accountorg");
        qFilters.add(new QFilter("org", "=", accountorg.getPkValue()));
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", costaccount.getPkValue()));
        DynamicObject currency = filter.getDynamicObject("currency");
        qFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        DynamicObject beginperiod = filter.getDynamicObject("beginperiod");
        DynamicObject endperiod = filter.getDynamicObject("endperiod");
        List start2EndAllPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)beginperiod, (DynamicObject)endperiod);
        qFilters.add(new QFilter("period", "in", (Object)start2EndAllPeriodIds));
        DynamicObjectCollection manuorg = filter.getDynamicObjectCollection("manuorgf");
        if (manuorg != null) {
            List collect = manuorg.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilters.add(new QFilter("manuorg", "in", collect));
        } else {
            long orgId;
            String entityId = filter.getString("entityId");
            if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)(orgId = accountorg.getLong("id")))) {
                qFilters.add(new QFilter("manuorg", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)entityId, (String)appId)));
            }
        }
        List<Long> costcenterId = this.getMoreSelectValue(filter, "costcenterf");
        if (!CollectionUtils.isEmpty(costcenterId)) {
            qFilters.add(new QFilter("costcenter", "in", costcenterId));
        }
        qFilters.add(new QFilter("appnum", "=", (Object)appId));
        return qFilters;
    }

    private List<Long> getMoreSelectValue(FilterInfo filter, String fileName) {
        DynamicObjectCollection dyns = filter.getDynamicObjectCollection(fileName);
        if (dyns == null) {
            return null;
        }
        return dyns.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }
}

