/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import kd.macc.cad.algox.mfgfee.report.MfgCostcenterRptAlgoxService;
import kd.macc.cad.business.feealloc.MfgFeeAllocBase;
import kd.macc.cad.business.feealloc.MfgFeeBasicAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.WriteLogUtils;

public class MfgCostcenterAllocRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(MfgCostcenterAllocRptQueryPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private Boolean isMergeBill = Boolean.TRUE;

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object arg1) throws Throwable {
        Object isPlanData;
        Map customParamMap = reportQueryParam.getCustomParam();
        boolean planData = false;
        if (customParamMap != null && (isPlanData = customParamMap.get("isplandata")) != null && StringUtils.equals((CharSequence)isPlanData.toString(), (CharSequence)"true")) {
            planData = true;
        }
        FilterInfo filter = reportQueryParam.getFilter();
        List<QFilter> queryFilter = this.getQueryFilter(filter);
        if (planData) {
            long planSchemeId = filter.getDynamicObject("planscheme").getLong("id");
            queryFilter.add(new QFilter("planscheme", "=", (Object)planSchemeId));
        }
        String allocMold = (String)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"allocmold");
        String carryMtd = (String)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"carrymtd");
        Boolean showBenefitCostCenter = (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"showbenefcostcenter");
        Boolean onlyUnDivide = (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"onlyundivide");
        Boolean periodMerge = (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"periodmerge");
        Boolean costCenterSum = (Boolean)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"costcentersum");
        List<Long> expenseItemIds = this.getMoreSelectValue(filter, "pexpenseitem");
        List<Long> costCenterId = this.getMoreSelectValue(filter, "pcostcenter");
        List<Long> syCostCenterIds = this.getMoreSelectValue(filter, "sycostcenter");
        List<Long> costTypes = this.getMoreSelectValue(filter, "costcentertype");
        Long currency = (Long)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"currency");
        this.isMergeBill = SysParamHelper.isMergeBill((Long)((Long)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"accountorg")), (Long)((Long)CalcRptHelper.getFilterItemValue((FilterInfo)filter, (String)"costaccount")), (String)filter.getString("appnum"));
        long time = System.currentTimeMillis();
        DataSet resultDs = this.getQueryDataSet(filter, queryFilter, costCenterId, allocMold, carryMtd, expenseItemIds, onlyUnDivide, showBenefitCostCenter, syCostCenterIds, costTypes, periodMerge, planData);
        logger.info("\u6210\u672c\u4e2d\u5fc3\u95f4\u62a5\u8868\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        String appNum = filter.getString("appnum");
        MfgCostcenterRptAlgoxService service = new MfgCostcenterRptAlgoxService();
        resultDs = service.costCenterRptDataDeal(resultDs, costCenterSum, showBenefitCostCenter, appNum, this.isMergeBill, planData);
        resultDs = resultDs.addField(currency + " ", "hcurrency");
        logger.info("\u6210\u672c\u4e2d\u5fc3\u95f4\u62a5\u8868algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"MfgCostcenterAllocRptQueryPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]), (String)"MfgCostcenterAllocRptQueryPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f!", (String)"MfgCostcenterAllocRptQueryPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]), (String)"MfgCostcenterAllocRptQueryPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"cad_mfgcsallocrpt", (String)appNum);
        return resultDs;
    }

    private DataSet getQueryDataSet(FilterInfo filterInfo, List<QFilter> queryFilter, List<Long> costCenterId, String allocMold, String carryMtd, List<Long> expenseItemIds, Boolean onlyUnDivide, Boolean showBenefCostCenter, List<Long> syCostCenterIds, List<Long> costTypes, boolean periodMerge, boolean planData) {
        DataSet dataSet;
        if (onlyUnDivide.booleanValue()) {
            queryFilter.add(new QFilter("allocstatus", "!=", (Object)"2"));
        }
        String nonProdEntityType = "cad_nonprodalloc";
        String auxProdEntityType = "cad_auxprodalloc";
        String basicProdEntityType = "cad_basicalloc";
        if (planData) {
            nonProdEntityType = "cad_plannonprodalloc";
            auxProdEntityType = "cad_planauxprodalloc";
            basicProdEntityType = "cad_planbasicalloc";
        }
        DataSet result = null;
        if (allocMold.contains("A")) {
            result = this.getNonProdDataSet(filterInfo, queryFilter, costCenterId, expenseItemIds, showBenefCostCenter, syCostCenterIds, costTypes, nonProdEntityType, planData);
        }
        if (allocMold.contains("B")) {
            dataSet = this.getAuxProdDataSet(filterInfo, queryFilter, costCenterId, carryMtd, expenseItemIds, showBenefCostCenter, syCostCenterIds, costTypes, auxProdEntityType, planData);
            result = result == null ? dataSet : result.union(dataSet);
        }
        if (allocMold.contains("C")) {
            dataSet = this.getBasicProdData(filterInfo, queryFilter, costCenterId, carryMtd, expenseItemIds, showBenefCostCenter, syCostCenterIds, costTypes, basicProdEntityType, planData);
            result = result == null ? dataSet : result.union(dataSet);
        }
        if (!planData && allocMold.contains("D")) {
            dataSet = this.getCostCenterInnerDataSet(filterInfo, queryFilter, costCenterId, carryMtd, expenseItemIds, showBenefCostCenter, periodMerge);
            result = result == null ? dataSet : result.union(dataSet);
        }
        return result;
    }

    private DataSet getNonProdDataSetFromAllocBill(List<QFilter> queryFilter, List<Long> costCenterId, List<Long> expenseItemIds, Boolean showBenefCostCenter, List<Long> syCostCenterIds, List<Long> costTypes, String entityType) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(queryFilter);
        String orderByField = null;
        if (expenseItemIds != null && expenseItemIds.size() > 0) {
            filterList.add(new QFilter("expenseitem", "in", expenseItemIds));
        }
        if (costCenterId != null && costCenterId.size() > 0) {
            filterList.add(new QFilter("costcenter", "in", costCenterId));
        }
        if (syCostCenterIds != null && syCostCenterIds.size() > 0) {
            filterList.add(new QFilter("entryentity.benefcostcenter", "in", syCostCenterIds));
        }
        if (costTypes != null && costTypes.size() > 0) {
            filterList.add(new QFilter("entryentity.benefcostcenter.orgduty", "in", costTypes));
        }
        String selectField = "id,allocstatus,org,costaccount account,costdriver,period currentperiod,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,costcenter,costcenter.name costcentername,0L as baseunit,costcenter.number costcenternumber,'A' as billtype,0L as element,0L as subelement,'' as elementnumber,'' as subelementnumber,expenseitem,expenseitem.number expenseitemnumber,amount collectamt,entryentity.benefcostcenter benefcostcenter,entryentity.benefcostcenter.number benefcostcenternumber,entryentity.allocvalue qty,expenseitem targetexpenseitem,expenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else entryentity.allocamt end allocamt";
        if (!showBenefCostCenter.booleanValue()) {
            selectField = "id,allocstatus,org,costaccount account,costdriver,period currentperiod,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,costcenter,costcenter.name costcentername,0L as baseunit,costcenter.number costcenternumber,'A' as billtype,0L as element,0L as subelement,'' as elementnumber,'' as subelementnumber,expenseitem,expenseitem.number expenseitemnumber,amount collectamt,0L as benefcostcenter,'' benefcostcenternumber,entryentity.allocvalue qty,expenseitem targetexpenseitem,expenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else entryentity.allocamt end allocamt";
        }
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityType, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), orderByField);
        resultDs = resultDs.addField("0.00", "unabsorbeddiff");
        return resultDs.select(new String[]{"id", "org", "account", "allocstatus", "baseunit", "period", "periodOrder", "costdriver", "collectamt", "qty", "billtype", "costcenter", "costcenternumber", "costcentername", "benefcostcenter", "benefcostcenternumber", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber", "targetexpenseitem", "targetexpenseitemnumber", "element", "elementnumber", "subelement", "subelementnumber", "allocamt", "unabsorbeddiff"});
    }

    private DataSet getAuxProdDataSetFromBill(List<QFilter> queryFilter, List<Long> costCenterId, String carryMtd, List<Long> expenseItemIds, Boolean showBenefCostCenter, List<Long> syCostCenterIds, List<Long> costTypes, String entityType) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(queryFilter);
        DataSet resultDs = null;
        String orderByField = null;
        String selectField = "id,allocstatus,org,costaccount account,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,costcenter,costcenter.number costcenternumber,0L as baseunit,'B' as billtype,0L as element,0L as subelement,'' as elementnumber,'' as subelementnumber,costcenter.name costcentername,";
        if (costCenterId != null && costCenterId.size() > 0) {
            filterList.add(new QFilter("costcenter", "in", costCenterId));
        }
        if (syCostCenterIds != null && syCostCenterIds.size() > 0) {
            filterList.add(new QFilter("costcenter", "in", syCostCenterIds));
        }
        if (costTypes != null && costTypes.size() > 0) {
            filterList.add(new QFilter("costcenter.orgduty", "in", costTypes));
        }
        if ("A".equals(carryMtd)) {
            if (!CollectionUtils.isEmpty(expenseItemIds)) {
                filterList.add(new QFilter("parallelentity.parexpenseitem", "in", expenseItemIds));
            }
            selectField = selectField + "parallelentity.parexpenseitem expenseitem,parallelentity.parexpenseitem.number expenseitemnumber,parallelentity.parallocamount collectamt,comentity.costdriver costdriver,comentity.costdriverqty qty," + (showBenefCostCenter != false ? "costcenter" : "0L as") + " benefcostcenter," + (showBenefCostCenter != false ? "costcenter.number" : "''") + " benefcostcenternumber,comentity.expenseitem targetexpenseitem,comentity.expenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else parallelentity.parallocamount end allocamt";
            resultDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityType, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), orderByField);
        } else {
            if (!CollectionUtils.isEmpty(expenseItemIds)) {
                filterList.add(new QFilter("parallelentity.parexpenseitem", "in", expenseItemIds));
            }
            selectField = selectField + "parallelentity.parexpenseitem expenseitem,parallelentity.parexpenseitem.number expenseitemnumber,parallelentity.parallocamount collectamt,comentity.costdriver costdriver,parallelentity.parcostdriverqty qty," + (showBenefCostCenter != false ? "costcenter" : "0L as") + " benefcostcenter," + (showBenefCostCenter != false ? "costcenter.number" : "''") + " benefcostcenternumber,parallelentity.parexpenseitem targetexpenseitem,parallelentity.parexpenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else parallelentity.parallocamount end allocamt";
            resultDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityType, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), orderByField);
        }
        resultDs = resultDs.addField("0.00", "unabsorbeddiff");
        return resultDs.select(new String[]{"id", "org", "account", "allocstatus", "baseunit", "period", "periodOrder", "costdriver", "collectamt", "qty", "billtype", "costcenter", "costcenternumber", "costcentername", "benefcostcenter", "benefcostcenternumber", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber", "targetexpenseitem", "targetexpenseitemnumber", "element", "elementnumber", "subelement", "subelementnumber", "allocamt", "unabsorbeddiff"});
    }

    private DataSet getBasicProdDataSetFromAllocBill(List<QFilter> queryFilter, List<Long> costCenterId, String carryMtd, List<Long> expenseItemIds, Boolean showBenefCostCenter, List<Long> syCostCenterIds, List<Long> costTypes, String entityType) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(queryFilter);
        String orderByField = null;
        QFilter srcBillTypeFilter = new QFilter("srcbilltype", "=", (Object)"A");
        filterList.add(srcBillTypeFilter);
        QFilter expenseItemFilter = null;
        if (costCenterId != null && costCenterId.size() > 0) {
            filterList.add(new QFilter("costcenter", "in", costCenterId));
        }
        if (!CollectionUtils.isEmpty(expenseItemIds)) {
            expenseItemFilter = new QFilter("expenseitem", "in", expenseItemIds);
            filterList.add(expenseItemFilter);
        }
        QFilter syCenterFilter = null;
        QFilter costTypeFilter = null;
        if (showBenefCostCenter.booleanValue() && syCostCenterIds != null && !syCostCenterIds.isEmpty()) {
            syCenterFilter = new QFilter("entryentity.entrycostcenter", "in", syCostCenterIds);
            filterList.add(syCenterFilter);
        }
        if (costTypes != null && !costTypes.isEmpty()) {
            costTypeFilter = new QFilter("entryentity.entrycostcenter.orgduty", "in", costTypes);
            filterList.add(costTypeFilter);
        }
        String selectField = "id,org,costaccount account,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,allocstatus,'C' as billtype,0L as baseunit,0L as element,0L as subelement,'' as elementnumber,'' as subelementnumber,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,expenseitem,expenseitem.number expenseitemnumber,amount collectamt,costdriver,entryentity.entryqty qty,entryentity.entrycostcenter benefcostcenter,entryentity.entrycostcenter.number benefcostcenternumber,expenseitem targetexpenseitem,expenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else entryentity.entryamount end allocamt";
        if (!showBenefCostCenter.booleanValue()) {
            selectField = "id,org,costaccount account,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,allocstatus,'C' as billtype,0L as baseunit,0L as element,0L as subelement,'' as elementnumber,'' as subelementnumber,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,expenseitem,expenseitem.number expenseitemnumber,amount collectamt,costdriver,entryentity.entryqty qty,0L as benefcostcenter,'' benefcostcenternumber,expenseitem targetexpenseitem,expenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else entryentity.entryamount end allocamt";
        }
        DataSet colDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityType, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), null);
        srcBillTypeFilter.__setValue((Object)"B");
        selectField = "id,org,costaccount account,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,allocstatus,'C' as billtype,0L as baseunit,0L as element,0L as subelement,'' as elementnumber,'' as subelementnumber,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,";
        if ("A".equals(carryMtd)) {
            if (expenseItemFilter != null) {
                expenseItemFilter.__setProperty("comentity.comexpenseitem");
            }
            if (syCenterFilter != null) {
                syCenterFilter.__setProperty("comentity.comsubentity.subcostcenter");
            }
            if (costTypeFilter != null) {
                costTypeFilter.__setProperty("comentity.comsubentity.subcostcenter.orgduty");
            }
            selectField = showBenefCostCenter.booleanValue() ? selectField + "comentity.comexpenseitem expenseitem,comentity.comexpenseitem.number expenseitemnumber,comentity.allocamount collectamt,comentity.comsubentity.subcomcostdriver costdriver,comentity.comsubentity.subqty qty,comentity.comsubentity.subcostcenter benefcostcenter,comentity.comsubentity.subcostcenter.number benefcostcenternumber,comentity.comexpenseitem targetexpenseitem,comentity.comexpenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else comentity.comsubentity.subamt end allocamt" : selectField + "comentity.comexpenseitem expenseitem,comentity.comexpenseitem.number expenseitemnumber,comentity.allocamount collectamt,comentity.comcostdriver costdriver,comentity.costdriverqty qty,0L as benefcostcenter,'' benefcostcenternumber,comentity.comexpenseitem targetexpenseitem,comentity.comexpenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else comentity.allocamount end allocamt";
        } else {
            if (expenseItemFilter != null) {
                expenseItemFilter.__setProperty("parallelentity.parexpenseitem");
            }
            if (syCenterFilter != null) {
                syCenterFilter.__setProperty("parallelentity.parallelsubentity.parsubcostcenter");
            }
            if (costTypeFilter != null) {
                costTypeFilter.__setProperty("parallelentity.parallelsubentity.parsubcostcenter.orgduty");
            }
            selectField = showBenefCostCenter != false ? selectField + "parallelentity.parexpenseitem expenseitem,parallelentity.parexpenseitem.number expenseitemnumber,parallelentity.parallocamount collectamt,parallelentity.parallelsubentity.parsubcostdriver costdriver,parallelentity.parallelsubentity.parsubqty qty,parallelentity.parallelsubentity.parsubcostcenter benefcostcenter,parallelentity.parallelsubentity.parsubcostcenter.number benefcostcenternumber,parallelentity.parexpenseitem targetexpenseitem,parallelentity.parexpenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else parallelentity.parallelsubentity.parsubamt end allocamt" : selectField + "parallelentity.parexpenseitem expenseitem,parallelentity.parexpenseitem.number expenseitemnumber,parallelentity.parallocamount collectamt,parallelentity.parcostdriver costdriver,parallelentity.parcostdriverqty qty,0L as benefcostcenter,'' benefcostcenternumber,parallelentity.parexpenseitem targetexpenseitem,parallelentity.parexpenseitem.number targetexpenseitemnumber,case when allocstatus!='2' then 0 else parallelentity.parallocamount end allocamt";
        }
        DataSet auxDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityType, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), orderByField);
        DataSet resultDs = colDs.union(auxDs);
        resultDs = resultDs.addField("0.00", "unabsorbeddiff");
        return resultDs.select(new String[]{"id", "org", "account", "allocstatus", "baseunit", "period", "periodOrder", "costdriver", "collectamt", "qty", "billtype", "costcenter", "costcenternumber", "costcentername", "benefcostcenter", "benefcostcenternumber", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber", "targetexpenseitem", "targetexpenseitemnumber", "element", "elementnumber", "subelement", "subelementnumber", "allocamt", "unabsorbeddiff"});
    }

    private DataSet getCostCenterInnerDataSetFromAllocBill(List<QFilter> queryFilter, List<Long> costCenterId, String carryMtd, List<Long> expenseItemIds, Boolean showBenefCostCenter, boolean periodMerge) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(queryFilter);
        DataSet unAbsorbDiffDs = this.getUnAbsorbDiffDs(filterList);
        String entityName = "cad_mfgfeeallocco";
        QFilter expenseItemFilter = null;
        if (!CollectionUtils.isEmpty(expenseItemIds)) {
            expenseItemFilter = new QFilter("srcexpentry.expenseitem", "in", expenseItemIds);
            filterList.add(expenseItemFilter);
        }
        if (costCenterId != null && costCenterId.size() > 0) {
            filterList.add(new QFilter("benefcostcenter", "in", costCenterId));
        }
        String selectField = "id,allocstatus,org,costaccount account,costdriver,costdriverqty qty,billno,period.name period,period periodorder,manuorg,manuorg.number manuorgnumber,'D' as billtype,0L as baseunit,benefcostcenter costcenter,benefcostcenter.number costcenternumber,benefcostcenter.name costcentername,srcexpentry.expenseitem expenseitem,srcexpentry.expenseitem.number expenseitemnumber,srcexpentry.colamt collectamt," + (showBenefCostCenter != false ? "benefcostcenter" : "0L as") + " benefcostcenter," + (showBenefCostCenter != false ? "benefcostcenter.number" : "''") + " benefcostcenternumber," + (this.isMergeBill != false ? "0L" : "allocexpenseitem") + " targetexpenseitem," + (this.isMergeBill != false ? "''" : "allocexpenseitem.number") + " targetexpenseitemnumber,case when allocstatus!='2' then 0 else srcexpentry.colamt end allocamt,element,element.number elementnumber,subelement,subelement.number subelementnumber";
        DataSet resultDataSet = null;
        if ("A".equals(carryMtd)) {
            resultDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityName, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), null);
        } else {
            QFilter srcTypeFilter = new QFilter("srcexpentry.srctype", "in", (Object)new String[]{"A", "B", "D"});
            filterList.add(srcTypeFilter);
            DataSet nonAuxDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityName, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), null);
            srcTypeFilter.__setValue((Object)new String[]{"C", "E"});
            String auxSelectField = "id,org,costaccount account,billno,period.name period,period periodorder,costdriver,costdriverqty qty,manuorg,manuorg.number manuorgnumber,'D' as billtype,0L as baseunit,benefcostcenter costcenter,benefcostcenter.number costcenternumber,benefcostcenter.name costcentername," + (showBenefCostCenter != false ? "benefcostcenter" : "0L as") + " benefcostcenter," + (showBenefCostCenter != false ? "benefcostcenter.number" : "''") + " benefcostcenternumber,srcexpentry.srctype srctype,srcexpentry.expbillid expbillid,allocstatus,element,element.number elementnumber,subelement,subelement.number subelementnumber";
            DataSet auxDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)entityName, (String)auxSelectField, (QFilter[])filterList.toArray(new QFilter[0]), null);
            if (auxDs.isEmpty()) {
                resultDataSet = nonAuxDs;
            } else {
                HashSet<Long> auxBillIds = new HashSet<Long>();
                HashSet<Long> auxBillCostcenterIds = new HashSet<Long>();
                HashSet<Long> auxBasicBillIds = new HashSet<Long>();
                HashSet<Long> auxBasicBillCostcenterIds = new HashSet<Long>();
                DataSet setDs = auxDs.copy();
                while (setDs.hasNext()) {
                    Row row = setDs.next();
                    if (org.apache.commons.lang.StringUtils.equals((String)row.getString("srctype"), (String)"C")) {
                        auxBillIds.add(row.getLong("expbillid"));
                        auxBillCostcenterIds.add(row.getLong("costcenter"));
                        continue;
                    }
                    if (!org.apache.commons.lang.StringUtils.equals((String)row.getString("srctype"), (String)"E")) continue;
                    auxBasicBillIds.add(row.getLong("expbillid"));
                    auxBasicBillCostcenterIds.add(row.getLong("costcenter"));
                }
                DataSet auxBillDs = null;
                if (auxBillIds.size() > 0) {
                    auxBillDs = this.getAuxDsFromBillId(auxBillIds, auxBillCostcenterIds);
                }
                DataSet basicBillDs = null;
                if (auxBasicBillIds.size() > 0) {
                    basicBillDs = this.getBasicDsFromBillId(auxBasicBillIds, auxBasicBillCostcenterIds);
                }
                DataSet billDs = this.mergeDs(auxBillDs, basicBillDs);
                DataSet resultDs = auxDs.join(billDs).on("expbillid", "id").on("srctype", "type").on("costcenter", "costcenter").select(new String[]{"id", "org", "account", "billtype", "costdriver", "baseunit", "costcentername", "billno", "period", "periodorder", "manuorg", "manuorgnumber", "costcenter", "costcenternumber", "benefcostcenter", "benefcostcenternumber", "element", "elementnumber", "subelement", "subelementnumber", "allocstatus", "qty"}, new String[]{"expenseitem", "targetexpenseitem", "targetexpenseitemnumber", "expenseitemnumber", "collectamt", "case when allocstatus!='2' then 0 else collectamt end as allocamt"}).finish();
                resultDs = resultDs.select(nonAuxDs.getRowMeta().getFieldNames()).union(nonAuxDs);
                resultDataSet = resultDs.orderBy(new String[]{"id"});
            }
        }
        resultDataSet = resultDataSet.groupBy(new String[]{"id", "org", "account", "allocstatus", "billtype", "costdriver", "costcentername", "baseunit", "period", "periodOrder", "manuorg", "manuorgnumber", "costcenter", "costcenternumber", "expenseitem", "expenseitemnumber", "benefcostcenter", "benefcostcenternumber", "targetexpenseitem", "targetexpenseitemnumber", "element", "elementnumber", "subelement", "subelementnumber"}).sum("collectamt").sum("allocamt").max("qty").finish();
        resultDataSet = resultDataSet.leftJoin(unAbsorbDiffDs).on("org", "org").on("account", "costaccount").on("periodorder", "period").on("costcenter", "costcenter").on("subelement", "subelement").select(resultDataSet.getRowMeta().getFieldNames(), new String[]{"unabsorbeddiff"}).finish();
        return resultDataSet.select(new String[]{"id", "org", "account", "allocstatus", "baseunit", "period", "periodOrder", "costdriver", "collectamt", "qty", "billtype", "costcenter", "costcenternumber", "costcentername", "benefcostcenter", "benefcostcenternumber", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber", "targetexpenseitem", "targetexpenseitemnumber", "element", "elementnumber", "subelement", "subelementnumber", "allocamt", "unabsorbeddiff"});
    }

    private DataSet getUnAbsorbDiffDs(List<QFilter> queryFilter) {
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        HashSet<Long> subElementIds = new HashSet<Long>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)"cad_mfgfeeallocco", (String)"benefcostcenter costcenter,subelement", (QFilter[])queryFilter.toArray(new QFilter[0]), null);
        for (Object row : dataSet) {
            costCenterIds.add(row.getLong("costcenter"));
            subElementIds.add(row.getLong("subelement"));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        for (QFilter filter : queryFilter) {
            if (!filter.getProperty().equals("org") && !filter.getProperty().equals("costaccount") && !filter.getProperty().equals("period")) continue;
            filters.add(filter);
        }
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        filters.add(new QFilter("entryentity.subelement", "in", subElementIds));
        String selectField = "org,costaccount,period,costcenter,entryentity.subelement subelement,entryentity.amount unabsorbeddiff";
        DataSet result = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("query"), (String)"sca_resourceabsorb", (String)selectField, (QFilter[])filters.toArray(new QFilter[0]), null);
        return result.groupBy(new String[]{"org", "costaccount", "period", "costcenter", "subelement"}).sum("unabsorbeddiff").finish();
    }

    private DataSet mergeDs(DataSet ds1, DataSet ds2) {
        DataSet ds = null;
        ds = ds1 != null && ds2 != null ? ds1.union(ds2) : (ds1 != null ? ds1 : ds2);
        return ds;
    }

    private DataSet getAuxDsFromBillId(Set<Long> auxBillIds, Set<Long> costcenterIds) {
        QFilter qfilter = new QFilter("id", "in", auxBillIds);
        qfilter.and("parallelentity.parallelsubentity.parsubcostcenter", "in", costcenterIds);
        DataSet auxBillDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getAuxDsFromBillId"), (String)"cad_auxprodalloc", (String)("'C' type,id,parallelentity.parallelsubentity.parsubcostcenter costcenter,parallelentity.parallelsubentity.parsubexpenseitem expenseitem," + (this.isMergeBill != false ? "0L" : "parallelentity.parallelsubentity.parsubexpenseitem") + "  targetexpenseitem,parallelentity.parallelsubentity.parsubexpenseitem.number expenseitemnumber," + (this.isMergeBill != false ? "''" : "parallelentity.parallelsubentity.parsubexpenseitem.number") + " targetexpenseitemnumber,case when allocmethod ='mutual' or allocmethod='algebra' then parallelentity.parallelsubentity.parsuboutqty else parallelentity.parallelsubentity.parsubqty end qty,case when allocmethod ='mutual' or allocmethod='algebra' then parallelentity.parallelsubentity.parsuboutamt else parallelentity.parallelsubentity.parsubamt end collectamt"), (QFilter[])qfilter.toArray(), null);
        return auxBillDs;
    }

    private DataSet getBasicDsFromBillId(Set<Long> auxBasicBillIds, Set<Long> costcenterIds) {
        QFilter qfilter = new QFilter("id", "in", auxBasicBillIds);
        qfilter.and("srcbilltype", "=", (Object)"B");
        qfilter.and("parallelentity.parallelsubentity.parsubcostcenter", "in", costcenterIds);
        DataSet basicBillDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicDsFromBillId"), (String)"cad_basicalloc", (String)("'E' type,id,parallelentity.parallelsubentity.parsubcostcenter costcenter,parallelentity.parallelsubentity.parsubexpenseitem expenseitem," + (this.isMergeBill != false ? "0L" : "parallelentity.parallelsubentity.parsubexpenseitem") + " as targetexpenseitem,parallelentity.parallelsubentity.parsubexpenseitem.number expenseitemnumber," + (this.isMergeBill != false ? "''" : "parallelentity.parallelsubentity.parsubexpenseitem.number") + " targetexpenseitemnumber,parallelentity.parallelsubentity.parsubqty qty,parallelentity.parallelsubentity.parsubamt collectamt"), (QFilter[])qfilter.toArray(), null);
        return basicBillDs;
    }

    private List<QFilter> getQueryFilter(FilterInfo filter) {
        String appId = filter.getString("appnum");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject accountorg = filter.getDynamicObject("accountorg");
        qFilters.add(new QFilter("org", "=", accountorg.getPkValue()));
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", costaccount.getPkValue()));
        DynamicObject currency = filter.getDynamicObject("currency");
        qFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        DynamicObject beginperiod = filter.getDynamicObject("beginperiod");
        qFilters.add(new QFilter("period", "=", beginperiod.getPkValue()));
        DynamicObjectCollection manuorg = filter.getDynamicObjectCollection("pmanuorg");
        if (manuorg != null) {
            List collect = manuorg.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilters.add(new QFilter("manuorg", "in", collect));
        } else {
            long orgId;
            String entityId = filter.getString("entityId");
            if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)(orgId = accountorg.getLong("id")))) {
                qFilters.add(new QFilter("manuorg", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)entityId, (String)appId)));
            }
        }
        qFilters.add(new QFilter("appnum", "=", (Object)appId));
        return qFilters;
    }

    private List<Long> getMoreSelectValue(FilterInfo filter, String fileName) {
        DynamicObjectCollection dyns = filter.getDynamicObjectCollection(fileName);
        if (dyns == null) {
            return null;
        }
        return dyns.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    private DataSet getCostCenterInnerDataSet(FilterInfo filterInfo, List<QFilter> queryFilter, List<Long> costCenterId, String carryMtd, List<Long> expenseItemIds, Boolean showBenefCostCenter, boolean periodMerge) {
        List<QFilter> commonFilter = this.getCommonFilter(queryFilter);
        boolean exists = QueryServiceHelper.exists((String)"cad_mfgfeeallocco", (QFilter[])commonFilter.toArray(new QFilter[0]));
        if (exists) {
            return this.getCostCenterInnerDataSetFromAllocBill(queryFilter, costCenterId, carryMtd, expenseItemIds, showBenefCostCenter, periodMerge);
        }
        ArrayList<QFilter> basicFilters = new ArrayList<QFilter>(commonFilter);
        DataSet resultDs = this.queryMfgNonAuxBillFormBasic(commonFilter, costCenterId, expenseItemIds, false);
        long org = filterInfo.getDynamicObject("accountorg").getLong("id");
        String appNum = filterInfo.getString("appnum");
        long period = filterInfo.getDynamicObject("beginperiod").getLong("id");
        MfgFeeAllocImportParam costDriverParam = new MfgFeeAllocImportParam();
        costDriverParam.setOrg(Long.valueOf(org));
        costDriverParam.setAppnum(appNum);
        costDriverParam.setPeriod(Long.valueOf(period));
        MfgFeeBasicAllocService basicAllocService = new MfgFeeBasicAllocService();
        DataSet basicAllocStand = basicAllocService.getBasicAllocStd(costDriverParam);
        resultDs = this.replaceManuOrgFromDs(resultDs, org, "costcenter");
        resultDs = resultDs.leftJoin(basicAllocStand).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").select(resultDs.getRowMeta().getFieldNames(), new String[]{"costdriver"}).finish().filter("costdriver is null or costobject>0");
        QFilter centerIdsFilter = null;
        QFilter expenIdsFilter = null;
        if (costCenterId != null && costCenterId.size() > 0) {
            centerIdsFilter = new QFilter("entryentity.entrycostcenter", "in", costCenterId);
            basicFilters.add(centerIdsFilter);
        }
        if (expenseItemIds != null && expenseItemIds.size() > 0) {
            expenIdsFilter = new QFilter("expenseitem", "in", expenseItemIds);
            basicFilters.add(expenIdsFilter);
        }
        QFilter billTypeFilter = new QFilter("srcbilltype", "=", (Object)"A");
        basicFilters.add(billTypeFilter);
        basicFilters.add(new QFilter("allocstatus", "=", (Object)"2"));
        DataSet basicFromNoAuxDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicProdData"), (String)"cad_basicalloc", (String)"org,costaccount account,period.name period,period periodorder,entryentity.entryamount collectamt,entryentity.entrycostcenter costcenter,entryentity.entrycostcenter.number costcenternumber,entryentity.entrycostcenter.name costcentername,manuorg,manuorg.number manuorgnumber,expenseitem,expenseitem.number expenseitemnumber,0 as costobject", (QFilter[])basicFilters.toArray(new QFilter[0]), null);
        if (centerIdsFilter != null) {
            centerIdsFilter.__setProperty("comentity.comsubentity.subcostcenter");
        }
        if (expenIdsFilter != null) {
            expenIdsFilter.__setProperty("comentity.comsubentity.subcomexpenseitem");
        }
        billTypeFilter.__setValue((Object)"B");
        DataSet basicFromAuxDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicProdData"), (String)"cad_basicalloc", (String)"org,costaccount account,period.name period,period periodorder,comentity.comsubentity.subamt collectamt,comentity.comsubentity.subcostcenter costcenter,comentity.comsubentity.subcostcenter.number costcenternumber,comentity.comsubentity.subcostcenter.name costcentername,manuorg,manuorg.number manuorgnumber,comentity.comsubentity.subcomexpenseitem expenseitem,comentity.comsubentity.subcomexpenseitem.number expenseitemnumber,0 as costobject", (QFilter[])basicFilters.toArray(new QFilter[0]), null);
        DataSet basicDs = basicFromNoAuxDs.union(basicFromAuxDs);
        basicDs = this.replaceManuOrgFromDs(basicDs, org, "costcenter");
        basicDs = basicDs.addFields(new String[]{"0L"}, new String[]{"costdriver"});
        DataSet resultDataSet = basicDs.union(resultDs.select(basicDs.getRowMeta().getFieldNames()));
        resultDataSet = this.joinDriverStand(resultDataSet, org, appNum, period);
        resultDataSet = this.buildAllocDriverQty(true, "D", queryFilter, resultDataSet, filterInfo, false);
        return resultDataSet;
    }

    private DataSet getAuxProdDataSet(FilterInfo filterInfo, List<QFilter> queryFilter, List<Long> costCenterId, String carryMtd, List<Long> expenseItemIds, Boolean showBenefCostCenter, List<Long> syCostCenterIds, List<Long> costTypes, String entityType, boolean planData) {
        String fieldCostObject;
        String nonProdEntityType;
        String feeEntityType;
        List<QFilter> commonFilter = this.getCommonFilter(queryFilter);
        boolean exists = QueryServiceHelper.exists((String)entityType, (QFilter[])commonFilter.toArray(new QFilter[0]));
        if (exists) {
            return this.getAuxProdDataSetFromBill(queryFilter, costCenterId, carryMtd, expenseItemIds, showBenefCostCenter, syCostCenterIds, costTypes, entityType);
        }
        if (planData) {
            feeEntityType = "cad_planfeebill";
            nonProdEntityType = "cad_plannonprodalloc";
            fieldCostObject = "0L as costobject";
        } else {
            feeEntityType = "cad_mfgfeebill";
            nonProdEntityType = "cad_nonprodalloc";
            fieldCostObject = "costobject";
        }
        QFilter centerTypeFilter = new QFilter("costcenter.orgduty.number", "=", (Object)"5");
        commonFilter.add(centerTypeFilter);
        QFilter centerIdsFilter = null;
        QFilter expenIdsFilter = null;
        if (costCenterId != null && costCenterId.size() > 0) {
            centerIdsFilter = new QFilter("costcenter", "in", costCenterId);
            commonFilter.add(centerIdsFilter);
        }
        if (expenseItemIds != null && expenseItemIds.size() > 0) {
            expenIdsFilter = new QFilter("expenseitem", "in", expenseItemIds);
            commonFilter.add(expenIdsFilter);
        }
        DataSet mfgDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getAuxProdDataSet"), (String)feeEntityType, (String)("org,costaccount account,period.name period,period periodorder,totalamount collectamt,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,manuorg,manuorg.number manuorgnumber,expenseitem,expenseitem.number expenseitemnumber," + fieldCostObject), (QFilter[])commonFilter.toArray(new QFilter[0]), null);
        centerTypeFilter.__setProperty("entryentity.benefcostcenter.orgduty.number");
        if (centerIdsFilter != null) {
            centerIdsFilter.__setProperty("entryentity.benefcostcenter");
        }
        commonFilter.add(new QFilter("allocstatus", "=", (Object)"2"));
        DataSet nonProdDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicProdData"), (String)nonProdEntityType, (String)"org,costaccount account,period.name period,period periodorder,entryentity.allocamt collectamt,entryentity.benefcostcenter costcenter,entryentity.benefcostcenter.number costcenternumber,entryentity.benefcostcenter.name costcentername,manuorg,manuorg.number manuorgnumber,expenseitem,expenseitem.number expenseitemnumber,0L as costobject", (QFilter[])commonFilter.toArray(new QFilter[0]), null);
        DataSet resultDs = mfgDs.union(nonProdDs);
        resultDs = resultDs.groupBy(new String[]{"org", "account", "period", "periodorder", "costcenter", "costobject", "costcenternumber", "costcentername", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber"}).sum("collectamt").finish();
        resultDs = this.replaceManuOrgFromDs(resultDs, filterInfo.getDynamicObject("accountorg").getLong("id"), "costcenter");
        long org = filterInfo.getDynamicObject("accountorg").getLong("id");
        String appNum = filterInfo.getString("appnum");
        long period = filterInfo.getDynamicObject("beginperiod").getLong("id");
        MfgFeeAllocBase mfgFeeAllocBase = new MfgFeeAllocBase();
        DataSet allocStandDs = mfgFeeAllocBase.getMfgAllocStd(Long.valueOf(org), "B", appNum, Long.valueOf(period));
        resultDs = resultDs.leftJoin(allocStandDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(resultDs.getRowMeta().getFieldNames(), new String[]{"costdriver"}).finish();
        return this.buildAllocDriverQty(false, "B", queryFilter, resultDs, filterInfo, planData);
    }

    private DataSet getNonProdDataSet(FilterInfo filterInfo, List<QFilter> queryFilter, List<Long> costCenterId, List<Long> expenseItemIds, Boolean showBenefCostCenter, List<Long> syCostCenterIds, List<Long> costTypes, String entityType, boolean planData) {
        String fieldCostObject;
        String feeEntityType;
        List<QFilter> commonFilter = this.getCommonFilter(queryFilter);
        boolean exists = QueryServiceHelper.exists((String)entityType, (QFilter[])commonFilter.toArray(new QFilter[0]));
        if (exists) {
            return this.getNonProdDataSetFromAllocBill(queryFilter, costCenterId, expenseItemIds, showBenefCostCenter, syCostCenterIds, costTypes, entityType);
        }
        QFilter centerTypeFilter = new QFilter("costcenter.orgduty.number", "in", (Object)Sets.newHashSet((Object[])new String[]{"1", "2", "3", "6"}));
        commonFilter.add(centerTypeFilter);
        QFilter centerIdsFilter = null;
        QFilter expenIdsFilter = null;
        if (costCenterId != null && costCenterId.size() > 0) {
            centerIdsFilter = new QFilter("costcenter", "in", costCenterId);
            commonFilter.add(centerIdsFilter);
        }
        if (expenseItemIds != null && expenseItemIds.size() > 0) {
            expenIdsFilter = new QFilter("expenseitem", "in", expenseItemIds);
            commonFilter.add(expenIdsFilter);
        }
        if (planData) {
            feeEntityType = "cad_planfeebill";
            fieldCostObject = "0L as costobject";
        } else {
            feeEntityType = "cad_mfgfeebill";
            fieldCostObject = "costobject";
        }
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicProdData"), (String)feeEntityType, (String)("org,costaccount account,period.name period,period periodorder,totalamount collectamt,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,manuorg,manuorg.number manuorgnumber,expenseitem,expenseitem.number expenseitemnumber," + fieldCostObject), (QFilter[])commonFilter.toArray(new QFilter[0]), null);
        resultDs = resultDs.groupBy(new String[]{"org", "account", "period", "periodorder", "costcenter", "costobject", "costcenternumber", "costcentername", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber"}).sum("collectamt").finish();
        resultDs = this.replaceManuOrgFromDs(resultDs, filterInfo.getDynamicObject("accountorg").getLong("id"), "costcenter");
        long org = filterInfo.getDynamicObject("accountorg").getLong("id");
        String appNum = filterInfo.getString("appnum");
        long period = filterInfo.getDynamicObject("beginperiod").getLong("id");
        MfgFeeAllocBase mfgFeeAllocBase = new MfgFeeAllocBase();
        DataSet allocStandDs = mfgFeeAllocBase.getMfgAllocStd(Long.valueOf(org), "A", appNum, Long.valueOf(period));
        resultDs = resultDs.leftJoin(allocStandDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(resultDs.getRowMeta().getFieldNames(), new String[]{"costdriver"}).finish();
        return this.buildAllocDriverQty(false, "A", queryFilter, resultDs, filterInfo, planData);
    }

    private DataSet getBasicProdData(FilterInfo filterInfo, List<QFilter> queryFilter, List<Long> costCenterId, String carryMtd, List<Long> expenseItemIds, Boolean showBenefCostCenter, List<Long> syCostCenterIds, List<Long> costTypes, String entityType, boolean planData) {
        List<QFilter> commonFilter = this.getCommonFilter(queryFilter);
        boolean exists = QueryServiceHelper.exists((String)entityType, (QFilter[])commonFilter.toArray(new QFilter[0]));
        if (exists) {
            return this.getBasicProdDataSetFromAllocBill(queryFilter, costCenterId, carryMtd, expenseItemIds, showBenefCostCenter, syCostCenterIds, costTypes, entityType);
        }
        DataSet resultDs = this.queryMfgNonAuxBillFormBasic(commonFilter, costCenterId, expenseItemIds, planData);
        resultDs = this.replaceManuOrgFromDs(resultDs, filterInfo.getDynamicObject("accountorg").getLong("id"), "costcenter");
        resultDs = resultDs.filter("costobject=0");
        long org = filterInfo.getDynamicObject("accountorg").getLong("id");
        String appNum = filterInfo.getString("appnum");
        long period = filterInfo.getDynamicObject("beginperiod").getLong("id");
        MfgFeeAllocImportParam costDriverParam = new MfgFeeAllocImportParam();
        costDriverParam.setOrg(Long.valueOf(org));
        costDriverParam.setAppnum(appNum);
        costDriverParam.setPeriod(Long.valueOf(period));
        MfgFeeBasicAllocService basicAllocService = new MfgFeeBasicAllocService();
        DataSet basicAllocStand = basicAllocService.getBasicAllocStd(costDriverParam);
        resultDs = resultDs.join(basicAllocStand).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(resultDs.getRowMeta().getFieldNames(), new String[]{"costdriver"}).finish();
        return this.buildAllocDriverQty(false, "C", queryFilter, resultDs, filterInfo, planData);
    }

    private DataSet buildAllocDriverQty(boolean costCenterInner, String billType, List<QFilter> queryFilter, DataSet resultDs, FilterInfo filterInfo, boolean planData) {
        long orgId = filterInfo.getDynamicObject("accountorg").getLong("id");
        long costAccountId = filterInfo.getDynamicObject("costaccount").getLong("id");
        long periodId = filterInfo.getDynamicObject("beginperiod").getLong("id");
        String appNum = filterInfo.getString("appnum");
        long planSchemeId = 0L;
        DynamicObject planScheme = filterInfo.getDynamicObject("planscheme");
        if (planScheme != null) {
            planSchemeId = planScheme.getLong("id");
        }
        HashSet<Long> costDrivers = new HashSet<Long>(16);
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        costDrivers.add(0L);
        for (Row row : resultDs.copy()) {
            costDrivers.add(row.getLong("costdriver"));
            costCenterIds.add(row.getLong("costcenter"));
        }
        String costDriverEntity = planData ? "cad_plancostdriver" : "sca_diycostdriver";
        Date date = MfgCostcenterAllocRptQueryPlugin.getEndDateByPeriod(periodId);
        QFilter customFilter = new QFilter("appnum", "=", (Object)appNum);
        customFilter.and("costdriver.iscomplexcd", "=", (Object)Boolean.FALSE);
        customFilter.and("costaccount", "=", (Object)filterInfo.getDynamicObject("costaccount").getLong("id"));
        customFilter.and("costdriver", "in", costDrivers);
        customFilter.and("costcenter", "in", costCenterIds);
        if (planData) {
            customFilter.and("period", "=", (Object)periodId);
            customFilter.and("planscheme", "=", (Object)planSchemeId);
        } else {
            customFilter.and("effectperiod", "!=", (Object)0L);
            customFilter.and("effectdate", "<=", (Object)date);
            customFilter.and("expdate", ">", (Object)date);
        }
        DataSet customDriver = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicProdData"), (String)costDriverEntity, (String)"org,manuorg,costcenter,costdriver,entryentity.entryqty qty", (QFilter[])new QFilter[]{customFilter}, null);
        customDriver = customDriver.groupBy(new String[]{"org", "manuorg", "costcenter", "costdriver"}).sum("qty").finish();
        HashSet<Long> customIds = new HashSet<Long>(16);
        for (Row row : customDriver.copy()) {
            customIds.add(row.getLong("costdriver"));
        }
        costDrivers.removeAll(customIds);
        String cusIds = this.getIdWithSplitStr(customIds);
        DataSet customDs = resultDs.copy().filter(String.format("costdriver in(%s)", cusIds));
        DataSet otherDs = resultDs.filter(String.format("costdriver not in(%s)", cusIds));
        MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
        DataSet resourceDs = mfgfeeAllocHelper.getCOResourceUse(appNum, new QFilter("org", "=", (Object)orgId), this.getBookDateFilter(periodId), new QFilter("billstatus", "=", (Object)"C"), costDrivers, Long.valueOf(costAccountId), Long.valueOf(periodId), planData, Long.valueOf(planSchemeId));
        resourceDs = resourceDs.groupBy(new String[]{"org", "manuorg", "costdriver", "costcenter"}).sum("value").finish().select("org,manuorg,costdriver,costcenter,value as qty");
        customDs = customDs.leftJoin(customDriver).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("costdriver", "costdriver").select(resultDs.getRowMeta().getFieldNames(), new String[]{"qty"}).finish();
        otherDs = otherDs.leftJoin(resourceDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("costdriver", "costdriver").select(resultDs.getRowMeta().getFieldNames(), new String[]{"qty"}).finish();
        resultDs = customDs.union(otherDs);
        resultDs = resultDs.addFields(new String[]{"0L", "'0'", "0L", "0L", "''", "0L", "''", "0L", "''", "0L", "''", "'" + billType + "'", "0.00", "0.00"}, new String[]{"id", "allocstatus", "baseunit", "benefcostcenter", "benefcostcenternumber", "targetexpenseitem", "targetexpenseitemnumber", "element", "elementnumber", "subelement", "subelementnumber", "billtype", "allocamt", "unabsorbeddiff"});
        if (costCenterInner) {
            DataSet subElementDs = this.getSubElementDs(orgId);
            resultDs = resultDs.leftJoin(subElementDs).on("expenseitem", "expenseitem").select(new String[]{"id", "org", "account", "allocstatus", "baseunit", "period", "periodOrder", "costdriver", "collectamt", "qty", "billtype", "costcenter", "costcenternumber", "costcentername", "benefcostcenter", "benefcostcenternumber", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber", "targetexpenseitem", "targetexpenseitemnumber", "allocamt", "unabsorbeddiff"}, new String[]{"element", "elementnumber", "subelement", "subelementnumber"}).finish();
            DataSet unAbsorbDiffDs = this.getUnAbsorbDiffDs(queryFilter);
            resultDs = resultDs.leftJoin(unAbsorbDiffDs).on("org", "org").on("account", "costaccount").on("periodorder", "period").on("costcenter", "costcenter").on("subelement", "subelement").select(new String[]{"id", "org", "account", "allocstatus", "baseunit", "period", "periodOrder", "costdriver", "collectamt", "qty", "billtype", "costcenter", "costcenternumber", "costcentername", "benefcostcenter", "benefcostcenternumber", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber", "targetexpenseitem", "targetexpenseitemnumber", "element", "elementnumber", "subelement", "subelementnumber", "allocamt"}, new String[]{"unabsorbeddiff"}).finish();
            return resultDs;
        }
        return resultDs.select(new String[]{"id", "org", "account", "allocstatus", "baseunit", "period", "periodOrder", "costdriver", "collectamt", "qty", "billtype", "costcenter", "costcenternumber", "costcentername", "benefcostcenter", "benefcostcenternumber", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber", "targetexpenseitem", "targetexpenseitemnumber", "element", "elementnumber", "subelement", "subelementnumber", "allocamt", "unabsorbeddiff"});
    }

    private DataSet queryMfgNonAuxBillFormBasic(List<QFilter> commonFilter, List<Long> costCenterId, List<Long> expenseItemIds, Boolean planData) {
        String fieldCostObject;
        String auxProdEntityType;
        String nonProdEntityType;
        String feeEntityType;
        if (planData.booleanValue()) {
            feeEntityType = "cad_planfeebill";
            nonProdEntityType = "cad_plannonprodalloc";
            auxProdEntityType = "cad_planauxprodalloc";
            fieldCostObject = "0L as costobject";
        } else {
            feeEntityType = "cad_mfgfeebill";
            nonProdEntityType = "cad_nonprodalloc";
            auxProdEntityType = "cad_auxprodalloc";
            fieldCostObject = "costobject";
        }
        QFilter centerTypeFilter = new QFilter("costcenter.orgduty.number", "=", (Object)"4");
        commonFilter.add(centerTypeFilter);
        QFilter centerIdsFilter = null;
        QFilter expenIdsFilter = null;
        if (costCenterId != null && costCenterId.size() > 0) {
            centerIdsFilter = new QFilter("costcenter", "in", costCenterId);
            commonFilter.add(centerIdsFilter);
        }
        if (expenseItemIds != null && expenseItemIds.size() > 0) {
            expenIdsFilter = new QFilter("expenseitem", "in", expenseItemIds);
            commonFilter.add(expenIdsFilter);
        }
        DataSet mfgDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicProdData"), (String)feeEntityType, (String)("org,costaccount account,period.name period,period periodorder,totalamount collectamt,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,manuorg,manuorg.number manuorgnumber,expenseitem,expenseitem.number expenseitemnumber," + fieldCostObject), (QFilter[])commonFilter.toArray(new QFilter[0]), null);
        centerTypeFilter.__setProperty("entryentity.benefcostcenter.orgduty.number");
        if (centerIdsFilter != null) {
            centerIdsFilter.__setProperty("entryentity.benefcostcenter");
        }
        commonFilter.add(new QFilter("allocstatus", "=", (Object)"2"));
        DataSet nonProdDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicProdData"), (String)nonProdEntityType, (String)"org,costaccount account,period.name period,period periodorder,entryentity.allocamt collectamt,entryentity.benefcostcenter costcenter,entryentity.benefcostcenter.number costcenternumber,entryentity.benefcostcenter.name costcentername,manuorg,manuorg.number manuorgnumber,expenseitem,expenseitem.number expenseitemnumber,0L as costobject", (QFilter[])commonFilter.toArray(new QFilter[0]), null);
        centerTypeFilter.__setProperty("comentity.comsubentity.subcostcenter.orgduty.number");
        if (centerIdsFilter != null) {
            centerIdsFilter.__setProperty("comentity.comsubentity.subcostcenter");
        }
        if (expenIdsFilter != null) {
            expenIdsFilter.__setProperty("comentity.comsubentity.subexpenseitem");
        }
        DataSet auxProdDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getBasicProdData"), (String)auxProdEntityType, (String)"org,costaccount account,period.name period,period periodorder,case when allocmethod ='mutual' or allocmethod='algebra' then comentity.comsubentity.suboutamt else comentity.comsubentity.subamt end collectamt,comentity.comsubentity.subcostcenter costcenter,comentity.comsubentity.subcostcenter.number costcenternumber,comentity.comsubentity.subcostcenter.name costcentername,manuorg,manuorg.number manuorgnumber,comentity.comsubentity.subexpenseitem expenseitem,comentity.comsubentity.subexpenseitem.number expenseitemnumber,0L as costobject", (QFilter[])commonFilter.toArray(new QFilter[0]), null);
        DataSet resultDs = mfgDs.union(nonProdDs).union(auxProdDs);
        return resultDs.groupBy(new String[]{"org", "account", "period", "periodorder", "costcenter", "costobject", "costcenternumber", "costcentername", "manuorg", "manuorgnumber", "expenseitem", "expenseitemnumber"}).sum("collectamt").finish();
    }

    private List<QFilter> getCommonFilter(List<QFilter> queryFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        for (QFilter filter : queryFilter) {
            if (!filter.getProperty().equals("org") && !filter.getProperty().equals("costaccount") && !filter.getProperty().equals("period") && !filter.getProperty().equals("manuorg") && !filter.getProperty().equals("planscheme")) continue;
            filters.add(filter);
        }
        return filters;
    }

    private static Date getEndDateByPeriod(Long periodId) {
        QFilter qFilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,enddate", (QFilter[])qFilter.toArray());
        if (period == null) {
            return new Date();
        }
        return period.getDate("enddate");
    }

    public QFilter getBookDateFilter(Long periodId) {
        QFilter idfilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])idfilter.toArray());
        QFilter datefilter = new QFilter("bookdate", ">=", (Object)period.getDate("begindate"));
        datefilter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        return datefilter;
    }

    private DataSet joinDriverStand(DataSet ds, long org, String appNum, long period) {
        ds = ds.removeFields(new String[]{"costdriver"});
        MfgFeeAllocBase mfgFeeAllocBase = new MfgFeeAllocBase();
        DataSet standDs = mfgFeeAllocBase.getMfgAllocInnerStd(Long.valueOf(org), appNum, Long.valueOf(period));
        DataSet stdCostCenterDs = standDs.copy().filter("costcenter>0");
        DataSet stdNotCostCenterDs = standDs.filter("costcenter=0");
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        DataSet dsCopyDs = ds.copy();
        while (dsCopyDs.hasNext()) {
            costCenterIds.add(dsCopyDs.next().getLong("costcenter"));
        }
        HashSet<Long> setStdCostCenterIds = new HashSet<Long>();
        DataSet stdCostCenterCopyDs = stdCostCenterDs.copy();
        while (stdCostCenterCopyDs.hasNext()) {
            Long costCenterId = stdCostCenterCopyDs.next().getLong("costcenter");
            if (!costCenterIds.contains(costCenterId)) continue;
            setStdCostCenterIds.add(costCenterId);
        }
        if (!setStdCostCenterIds.isEmpty()) {
            String ids = this.getIdWithSplitStr(setStdCostCenterIds);
            DataSet hasStdDs = ds.copy().filter(String.format("costcenter in(%s)", ids));
            DataSet notStdDs = ds.filter(String.format("costcenter not in(%s)", ids));
            hasStdDs = hasStdDs.leftJoin(stdCostCenterDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(hasStdDs.getRowMeta().getFieldNames(), new String[]{"costdriver"}).finish();
            if (notStdDs.isEmpty()) {
                return hasStdDs;
            }
            notStdDs = notStdDs.leftJoin(stdNotCostCenterDs).on("org", "org").on("manuorg", "manuorg").on("expenseitem", "expenseitem").select(notStdDs.getRowMeta().getFieldNames(), new String[]{"costdriver"}).finish();
            return hasStdDs.union(notStdDs);
        }
        return ds.leftJoin(stdNotCostCenterDs).on("org", "org").on("manuorg", "manuorg").on("expenseitem", "expenseitem").select(ds.getRowMeta().getFieldNames(), new String[]{"costdriver"}).finish();
    }

    private String getIdWithSplitStr(Collection<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id).append(",");
        }
        if (ids.isEmpty()) {
            return "0";
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private DataSet getSubElementDs(Long orgId) {
        String algoKey = "kd.macc.cad.business.feealloc.MfgFeeAllocBase.getSubElementDs";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_subelementexpense", (String)"element,element.number elementnumber,subelement,subelement.number subelementnumber,expenseitem", (QFilter[])orgFilter.toArray(), null);
        return subElementDs;
    }

    private DataSet replaceManuOrgFromDs(DataSet ds, Long org, String costcenterField) {
        if (OrgHelper.isOrgEnableMultiFactory((Long)org)) {
            Date nowTime = new Date();
            QFilter qFilter = new QFilter("org", "=", (Object)org);
            qFilter.and("billstatus", "=", (Object)"C");
            qFilter.and("effectdate", "<=", (Object)nowTime);
            qFilter.and("expdate", ">", (Object)nowTime);
            qFilter.and("appnum", "=", (Object)"sca");
            DataSet manuOrgCostcenterDs = QueryServiceHelper.queryDataSet((String)"MfgCostcenterAllocRptQueryPlugin_replaceManuOrgFromDs", (String)"cad_centermanuorg", (String)"manuorg,entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray(), null);
            ArrayList<String> fieldNames = new ArrayList<String>();
            fieldNames.addAll(Arrays.asList(ds.getRowMeta().getFieldNames()));
            fieldNames.remove("manuorg");
            ds = ds.join(manuOrgCostcenterDs).on(costcenterField, "costcenterid").select(fieldNames.toArray(new String[0]), new String[]{"manuorg"}).finish();
        }
        return ds;
    }
}

