/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.algox.constants.MfgFeeBillLogarithmParam;
import kd.macc.cad.algox.report.MfgFeeBillLogarithmQueryAlgoxService;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgFeeBillLogarithmQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(MfgFeeBillLogarithmQueryPlugin.class);

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object paramObject) throws Throwable {
        logger.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u5f00\u59cb\uff01");
        MfgFeeBillLogarithmParam mfgParam = this.init(reportQueryParam);
        DataSet dataSet = this.getService().getQueryDataSet(mfgParam);
        logger.info("\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u7ed3\u675f\uff01");
        return dataSet;
    }

    private MfgFeeBillLogarithmQueryAlgoxService getService() {
        return new MfgFeeBillLogarithmQueryAlgoxService();
    }

    private MfgFeeBillLogarithmParam init(ReportQueryParam param) {
        DynamicObject apInit;
        Long basecurrency;
        MfgFeeBillLogarithmParam mfgParam = new MfgFeeBillLogarithmParam();
        FilterInfo filter = param.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        mfgParam.setOrg(org);
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        mfgParam.setCostAccount(costaccount);
        DynamicObject period = filter.getDynamicObject("mulperiod");
        mfgParam.setMulPeriod(period);
        DynamicObject currency = filter.getDynamicObject("currency");
        mfgParam.setCurrency(currency);
        DynamicObjectCollection mulCostCenter = filter.getDynamicObjectCollection("mulcostcenter");
        HashSet costCenterIds = new HashSet(16);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulCostCenter)) {
            mulCostCenter.forEach(s -> costCenterIds.add(s.getLong("id")));
            mfgParam.setMulCostCenterIds(costCenterIds);
        }
        DynamicObjectCollection mulExpenseItem = filter.getDynamicObjectCollection("mulexpenseitem");
        HashSet expenseItemIds = new HashSet(16);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulExpenseItem)) {
            mulExpenseItem.forEach(s -> expenseItemIds.add(s.getLong("id")));
            mfgParam.setMulExpenseItemIds(expenseItemIds);
        }
        String srcsys = filter.getString("srcsys");
        Long currencyId = currency.getLong("id");
        mfgParam.setSrcsys(srcsys);
        mfgParam.setOnlyShowDiff(Boolean.valueOf(filter.getBoolean("isonlyshowdiff")));
        if (srcsys.contains("A")) {
            DynamicObject expenseitemObj;
            DynamicObject accountBook = CostAccountHelper.getGlAccountBook((Long)org.getLong("id"), (Long)costaccount.getLong("id"));
            if (accountBook != null) {
                basecurrency = accountBook.getLong("basecurrency");
                mfgParam.setBasecurrency(basecurrency);
                mfgParam.setAccountBookId(Long.valueOf(accountBook.getLong("id")));
                mfgParam.setBooksTypeId(Long.valueOf(accountBook.getLong("bookstype")));
                Long exratetable = accountBook.getLong("exratetable");
                if (currencyId.compareTo(basecurrency) != 0) {
                    Date currDate = new Date();
                    Date enddate = period.getDate("enddate");
                    Date bizDate = currDate.compareTo(enddate) > 0 ? enddate : currDate;
                    mfgParam.setIsExchangeRate(Boolean.TRUE);
                    mfgParam.setExchangeRateMap(BaseDataServiceHelper.getExchangeRateMap((Long)basecurrency, (Long)currencyId, (Long)exratetable, (Date)bizDate));
                }
            }
            Set<Long> accountIds = filter.getDynamicObjectCollection("account").stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            Set<Long> transAccountViewIds = MfgFeeBillLogarithmQueryPlugin.tranAccountViewIds(accountIds, period.getLong("id"));
            mfgParam.setAccountViewIds(transAccountViewIds);
            List items = filter.getFlexFilterItems();
            HashMap<String, HashSet> map = new HashMap<String, HashSet>(8);
            for (FilterItemInfo item : items) {
                String propName = item.getPropName();
                map.put(propName, (HashSet)item.getValue());
            }
            mfgParam.setFlexMap(map);
            List accountFlexs = LogarithmHelper.getAccountFlex((DynamicObjectCollection)filter.getDynamicObjectCollection("account"));
            mfgParam.setAccountFlex(accountFlexs);
            DynamicObject costcenterObj = LogarithmHelper.getFlexPropertyId((String)"bos_costcenter", (List)accountFlexs);
            if (costcenterObj != null) {
                mfgParam.setCostcentStr(costcenterObj.getString("flexfield"));
            }
            if ((expenseitemObj = LogarithmHelper.getFlexPropertyId((String)"er_expenseitemedit", (List)accountFlexs)) != null) {
                mfgParam.setBizexpenseitemStr(expenseitemObj.getString("flexfield"));
            }
        }
        if (srcsys.contains("B") && (apInit = CostAccountHelper.getApInit((long)org.getLong("id"))) != null) {
            basecurrency = apInit.getLong("currency");
            mfgParam.setApBasecurrency(basecurrency);
            if (currencyId.compareTo(basecurrency) != 0) {
                mfgParam.setIsApExchangeRate(Boolean.TRUE);
            }
        }
        mfgParam.setAppnum(filter.getString("appnum"));
        return mfgParam;
    }

    private static Set<Long> tranAccountViewIds(Set<Long> origAccountViewIds, Long currPeriod) {
        Map dateByPeriod;
        HashSet<Long> accountViewIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("id", "in", origAccountViewIds);
        DynamicObject[] accountViews = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> accountViewMasterIds = new HashSet<Long>(16);
        for (DynamicObject accountView : accountViews) {
            accountViewMasterIds.add(accountView.getLong("masterid"));
        }
        if (!CadEmptyUtils.isEmpty(accountViewMasterIds) && (dateByPeriod = PeriodHelper.getDateByPeriod((Set)Sets.newHashSet((Object[])new Long[]{currPeriod}))) != null) {
            QFilter dateQFilter = new QFilter("startdate", "<=", dateByPeriod.get("enddate"));
            dateQFilter.and(new QFilter("enddate", ">", dateByPeriod.get("enddate")));
            QFilter midQFilter = new QFilter("masterid", "in", accountViewMasterIds);
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getAccountViewId", (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{dateQFilter, midQFilter}, null);
            rows.forEach(s -> accountViewIds.add(s.getLong("id")));
            logger.info("\u79d1\u76ee\u7248\u672c\u5316\u8f6c\u6362\u7ed3\u679c\uff0c\u539f\u59cb\u79d1\u76ee==>{},\u8f6c\u6362\u79d1\u76ee==>{}", origAccountViewIds, accountViewIds);
        }
        if (CadEmptyUtils.isEmpty(accountViewIds)) {
            return origAccountViewIds;
        }
        return accountViewIds;
    }
}

