/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.StandardMacRptParam;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MacRptHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class StandardMacQueryRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StandardMacQueryRptQueryPlugin.class);
    private int currencyPricePrecision;

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        long time = System.currentTimeMillis();
        StandardMacRptParam param = MacRptHelper.getRptParam((ReportQueryParam)reportQueryParam);
        String matIds = reportQueryParam.getFilter().getFilterItem("matIds").getString();
        if (!CadEmptyUtils.isEmpty((String)matIds)) {
            param.setCalcMatIds((Set)SerializationUtils.fromJsonString((String)matIds, Set.class));
        }
        this.currencyPricePrecision = param.getCostType().getInt("currency.priceprecision");
        DataSet dataSet = this.queryDataSet(param);
        dataSet = this.dealRouteDataSet(param.getCostType().getLong("id"), dataSet);
        long midTime = System.currentTimeMillis();
        logger.info("\u83b7\u53d6\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(midTime - time));
        DataSet result = this.getdealDataSet(dataSet, param);
        if (!this.isDetail()) {
            result = result.select("productgroup,material,configuredcode, tracknumber, project, lot,keycol,auxproperty,bom,elementid,elemumber,element,subelementnumber,subelement,cast (stdprice as BigDecimal) stdprice,currencyfield").groupBy(new String[]{"productgroup", "material", "keycol", "configuredcode", "tracknumber", "project", "lot", "auxproperty", "bom", "elementid", "element", "subelement", "currencyfield", "subelementnumber", "elemumber"}).sum("stdprice").finish();
        }
        result = result.orderBy(new String[]{"material desc", "keycol", "auxproperty", "bom", "elemumber asc", "subelementnumber asc"});
        logger.info("\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return result;
    }

    private DataSet dealRouteDataSet(Long costType, DataSet dataSet) {
        boolean isAnalogCost = BomRouterHelper.isAnalogCostType((Long)costType);
        if (!isAnalogCost) {
            return dataSet.addField("''", "routenumber").addField("''", "routename");
        }
        DataSet routeDataSet = dataSet.filter("submaterial is null or submaterial = 0");
        DataSet resultDataSet = dataSet.filter("submaterial is not null and submaterial != 0");
        resultDataSet = resultDataSet.addField("''", "routenumber").addField("''", "routename");
        String srcRoute = PriceHelper.getPriceRouteEntity((Long)costType);
        DataSet copy = routeDataSet.copy();
        HashSet<Long> routeIds = new HashSet<Long>(10);
        while (copy.hasNext()) {
            Row row = copy.next();
            routeIds.add(row.getLong("processroute"));
        }
        DataSet routeNumDataSet = QueryServiceHelper.queryDataSet((String)"dealRouteDataSet", (String)srcRoute, (String)"id,number routenumber,name routename", (QFilter[])new QFilter[]{new QFilter("id", "in", routeIds)}, null);
        routeDataSet = routeDataSet.join(routeNumDataSet, JoinType.LEFT).on("processroute", "id").select(routeDataSet.getRowMeta().getFieldNames(), new String[]{"routenumber", "routename"}).finish();
        return resultDataSet.union(routeDataSet);
    }

    private boolean isDetail() {
        try {
            StandardMacRptParam rptParam = MacRptHelper.getRptParam((ReportQueryParam)this.getQueryParam());
            return rptParam.isDateial();
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    protected DataSet getdealDataSet(DataSet dataSet, StandardMacRptParam param) {
        Long currencyId = param.getCostType().getLong("currency.id");
        String countStr = ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"StandardMacQueryRptQueryPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]);
        DataSet sumDataSet = dataSet.copy().groupBy(new String[]{"material", "keycol", "auxproperty", "bom", "configuredcode", "tracknumber", "project", "lot"}).sum("stdprice").finish().select(new String[]{"material", "keycol", "auxproperty", "bom", "configuredcode", "tracknumber", "project", "lot", "stdprice"}).addFields(new String[]{"''", countStr, String.valueOf(currencyId), "0L", "''", "''", "''", "''", "''", "''"}, new String[]{"subelement", "element", "currencyfield", "elementid", "elemumber", "subelementnumber", "calcbasis", "routenumber", "routename", "processseq", "operationno"});
        if (!param.getShowsum().booleanValue()) {
            Set subMatIds;
            boolean isAnalogCost = this.isAnalogCost(param);
            String selectFileds = "material,keycol,auxproperty,bom,elementid,element,elemumber,subelement,subelementnumber,calcbasis,case when resource is not null and resource>0 then 'mpdm_resources' else 'bd_material' end matandrestype,case when resource is not null and resource>0 then resource else submaterial end matandres,case when resource is not null and resource>0 then resource else submaterial end matandresname,submaterial,subkeycol,subauxproperty,datatype,routenumber,routename,processseq,operationno,resource,case when elementtype in('003','004','005') and calcbasis ='001' then qty/60 else qty end qty,case when elementtype in('003','004','005') and calcbasis ='001' and qty=0 then 0 when elementtype in('003','004','005') and calcbasis ='001' and qty!=0 then price*60 else price end price,stdprice,productgroup,materialgroup,configuredcode,tracknumber,project,lot,subconfiguredcode,subtracknumber,subproject,sublot," + currencyId + " currencyfield";
            if (!isAnalogCost) {
                selectFileds = selectFileds + ",effectdate,expdate";
            }
            DataSet subDataSet = dataSet.copy().select(selectFileds);
            DynamicObject materialgrpstd = param.getMaterialgrpstd();
            if (materialgrpstd != null && Long.compare(materialgrpstd.getLong("id"), 730148448254487552L) != 0 || !CadEmptyUtils.isEmpty((DynamicObjectCollection)param.getMulmaterialgroup())) {
                subDataSet = subDataSet.filter("materialgroup >0");
            }
            if ((subMatIds = param.getSubMatIds()) != null && !subMatIds.isEmpty()) {
                String subMatIdsStr = StringUtils.join((Object[])subMatIds.toArray(), (String)",");
                subDataSet = subDataSet.filter("submaterial in (" + subMatIdsStr + ")");
            }
            if (param.getShowgroup().booleanValue()) {
                subDataSet = subDataSet.groupBy(new String[]{"material", "keycol", "auxproperty", "bom", "elementid", "element", "elemumber", "subelement", "subelementnumber", "productgroup", "materialgroup", "configuredcode", "tracknumber", "project", "lot", "currencyfield", "calcbasis"}).sum("stdprice").finish();
            }
            sumDataSet = DataSetUtils.unionIfRowDiff((DataSet)subDataSet, (DataSet)sumDataSet);
        } else {
            sumDataSet = sumDataSet.addNullField("productgroup");
        }
        return sumDataSet;
    }

    private Set<Long> getNotMatPropElementIds(Set<Long> elementIds) {
        QFilter elementNameFilter = new QFilter("id", "in", elementIds);
        QFilter elementTypeFilter = new QFilter("type", "in", Arrays.asList("003", "004", "005"));
        DynamicObjectCollection elements = QueryServiceHelper.query((String)"cad_element", (String)"id", (QFilter[])new QFilter[]{elementNameFilter, elementTypeFilter});
        HashSet<Long> elementIsNotMatPropSet = new HashSet<Long>(16);
        elements.forEach(e -> elementIsNotMatPropSet.add(e.getLong("id")));
        return elementIsNotMatPropSet;
    }

    protected Map<String, Set<String>> getMatParent(Long costTypeId, Set<Long> isNotDownCalcMatIds) {
        String fields = "material, auxproperty, keycol,entryentity.submaterial submaterial,entryentity.subkeycol subkeycol,entryentity.subauxproperty subauxproperty";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("entryentity.submaterial", "in", isNotDownCalcMatIds));
        filters.add(new QFilter("ismaindata", "=", (Object)1));
        filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(this.getAlgoKey("getMatParent"), "cad_calcsimulationresult", fields, filters.toArray(new QFilter[0]), "", -1, null);
        HashMap<String, Set<String>> matMap = new HashMap<String, Set<String>>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String matKey = this.getMatKey(row);
            String subMatKey = this.getSubMatKey(row);
            matMap.computeIfAbsent(matKey, s -> new HashSet()).add(subMatKey);
        }
        return matMap;
    }

    protected Map<String, List<Row>> groupMatMap(Iterator<Row> rows) {
        HashMap<String, List<Row>> matMap = new HashMap<String, List<Row>>(16);
        while (rows.hasNext()) {
            Row row = rows.next();
            matMap.computeIfAbsent(this.getMatKey(row), s -> new ArrayList()).add(row);
        }
        return matMap;
    }

    protected void groupMatAndElementMap(Iterator<Row> rows, Map<String, List<Row>> matMap, Set<Long> elementIds, Boolean showgroup) {
        while (rows.hasNext()) {
            Row row = rows.next();
            String key = row.getLong("material") + "@" + row.getLong("bom") + "@" + row.getLong("configuredcode") + "@" + row.getLong("tracknumber") + "@" + row.getLong("project") + "@" + row.getString("lot");
            matMap.computeIfAbsent(key, s -> new ArrayList()).add(row);
            if (elementIds == null) continue;
            elementIds.add((Long)row.get("elementid"));
        }
    }

    protected String getMatKey(Row row) {
        return row.getString("material") + "@" + row.getString("keycol") + "@" + row.getString("auxproperty");
    }

    protected String getSubMatKey(Row row) {
        return row.getLong("submaterial") + "@" + row.getLong("subkeycol") + "@" + row.getLong("subauxproperty");
    }

    protected DataSet queryDataSet(StandardMacRptParam param) {
        Long costTypeId = Long.valueOf(param.getCostTypeId());
        boolean isAnalogCost = this.isAnalogCost(param);
        if (!isAnalogCost) {
            this.getMatInfos(param);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        ArrayList<QFilter> traFilters = new ArrayList<QFilter>(10);
        List outFilters = MacRptHelper.getOutFiltersBy((StandardMacRptParam)param);
        traFilters.add(new QFilter("entryentity.entrylevel", "=", (Object)0));
        List commonFilters = MacRptHelper.getCommonFiltersBy((StandardMacRptParam)param);
        filters.add(new QFilter("bom", ">=", (Object)0L));
        traFilters.add(new QFilter("bomid", ">=", (Object)0L));
        Set materialIds = param.getProducts();
        if (CadEmptyUtils.isEmpty((Set)materialIds) && !CadEmptyUtils.isEmpty((Set)param.getCalcMatIds())) {
            Set matIds = param.getCalcMatIds();
            commonFilters.add(new QFilter("material", "in", (Object)matIds));
            outFilters.add(new QFilter("material", "in", (Object)matIds));
        } else {
            QFilter matIdQFilter = InFilterHelper.getQFilterByBachSize((String)"material", materialIds == null ? new ArrayList() : new ArrayList(materialIds), (String)"in", (int)20000);
            commonFilters.add(matIdQFilter);
            outFilters.add(matIdQFilter);
        }
        Set<Object> mulmaterialIdSet = new HashSet(16);
        DynamicObjectCollection mulgroupmaterial = param.getMulgroupmaterial();
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulgroupmaterial)) {
            mulmaterialIdSet = mulgroupmaterial.stream().map(costObject -> costObject.getLong("id")).collect(Collectors.toSet());
            outFilters.clear();
            outFilters.add(new QFilter("1", "=", (Object)2));
        }
        if (Long.compare(param.getMaterialgrpstd().getLong("id"), 730148448254487552L) != 0) {
            Set classifiedMaterialId = MaterialGroupHelper.getClassifiedMaterialId(null, (boolean)false, (DynamicObject)param.getMaterialgrpstd(), (boolean)true);
            if (mulmaterialIdSet == null || mulmaterialIdSet.size() == 0) {
                mulmaterialIdSet = classifiedMaterialId;
            } else if (classifiedMaterialId != null) {
                mulmaterialIdSet.retainAll(classifiedMaterialId);
            }
            if (mulmaterialIdSet == null) {
                mulmaterialIdSet = new HashSet(16);
            }
        }
        filters.addAll(commonFilters);
        logger.info("\u4ea7\u54c1\u6807\u51c6\u6210\u672c\u67e5\u8be2\u6761\u4ef61\uff1a{}", filters);
        traFilters.addAll(commonFilters);
        if (!CadEmptyUtils.isEmpty(mulmaterialIdSet)) {
            filters.add(new QFilter("entryentity.submaterial", "in", mulmaterialIdSet));
            String table = isAnalogCost ? "cad_calcsimulationresult" : "cad_calceffectiveresult";
            List objects = QueryServiceHelper.queryPrimaryKeys((String)table, (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
            filters.clear();
            filters.add(new QFilter("id", "in", (Object)objects));
            if (isAnalogCost || !CadEmptyUtils.isEmpty((Set)param.getTrackKeyCols())) {
                traFilters.add(new QFilter("entryentity.subentryentity.submaterial", "in", mulmaterialIdSet));
                List traObjects = QueryServiceHelper.queryPrimaryKeys((String)"cad_trackstdcalcresult", (QFilter[])traFilters.toArray(new QFilter[0]), null, (int)-1);
                traFilters.clear();
                traFilters.add(new QFilter("costtype", "=", isAnalogCost ? param.getCostType().getPkValue() : param.getSimCosttypeId()));
                traFilters.add(new QFilter("id", "in", (Object)traObjects));
            }
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulgroupmaterial)) {
                mulmaterialIdSet.add(0L);
            }
            param.setSubMatIds(mulmaterialIdSet);
        }
        logger.info("\u4ea7\u54c1\u6807\u51c6\u6210\u672c\u67e5\u8be2\u6761\u4ef62\uff1a{}", filters);
        DataSet dataSet = null;
        dataSet = isAnalogCost ? this.queryAnalogDataSet(filters, traFilters, outFilters, param, Arrays.asList("2", "4")) : this.queryAuditDataSet(filters, traFilters, outFilters, param, Arrays.asList("2", "4"));
        dataSet = this.groupBy(dataSet, param, isAnalogCost);
        String other = ",qty,price,productgroup,materialgroup,submaterial,subkeycol,subauxproperty,processseq,operationno,resource,stdprice,subconfiguredcode,subtracknumber,subproject,sublot";
        String[] orderFields = new String[]{"material desc,keycol,resource"};
        if (!isAnalogCost) {
            other = other + ",effectdate,expdate";
            orderFields = new String[]{"expdate desc,material desc,keycol,resource"};
        }
        String fields = this.getCommonGroupFields() + other;
        dataSet = dataSet.select(fields).orderBy(orderFields);
        return dataSet.copy();
    }

    private boolean isAnalogCost(StandardMacRptParam param) {
        if (param.isAnalogCost() == null) {
            Long costTypeId = Long.valueOf(param.getCostTypeId());
            param.setAnalogCost(Boolean.valueOf(BomRouterHelper.isAnalogCostType((Long)costTypeId)));
        }
        return param.isAnalogCost();
    }

    protected DataSet queryAnalogDataSet(List<QFilter> filters, List<QFilter> traFilters, List<QFilter> outFilters, StandardMacRptParam param, List<String> dateTypeList) {
        QFilter recordFilter;
        filters.add(new QFilter("entryentity.datatype", "in", dateTypeList));
        traFilters.add(new QFilter("entryentity.subentryentity.datatype", "in", dateTypeList));
        filters.add(new QFilter("ismaindata", "=", (Object)1));
        traFilters.add(new QFilter("entryentity.entryismaindata", "=", (Object)1));
        String calcRecordname = param.getCalcRecordName();
        if (!CadEmptyUtils.isEmpty((String)calcRecordname)) {
            recordFilter = new QFilter("calcrecord.name", "=", (Object)calcRecordname);
            filters.add(recordFilter);
            outFilters.add(recordFilter);
            traFilters.add(new QFilter("1", "=", (Object)2));
        } else {
            recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
            filters.add(recordFilter);
            outFilters.add(recordFilter);
        }
        ORMImpl orm = new ORMImpl();
        DataSet analogDataSet = orm.queryDataSet(this.getAlgoKey("queryAnalogDataSet"), "cad_calcsimulationresult", this.getAnalogSelectFields(), filters.toArray(new QFilter[0]), "treepath asc", -1, null);
        DataSet trackNumberDataSet = orm.queryDataSet(this.getAlgoKey("queryAnalogDataSet"), "cad_trackstdcalcresult", this.getTraSelectFields() + ",calcdate", traFilters.toArray(new QFilter[0]), "treepath asc", -1, null);
        trackNumberDataSet = trackNumberDataSet.addField("case when expdate is null then cast(to_date('3000-01-01 23:59:59','yyyy-MM-dd hh:mm:ss') as Timestamp) else expdate end", "newcalcdate");
        DataSet dateDataSet = trackNumberDataSet.copy().groupBy(new String[]{"material", "keycol"}).max("newcalcdate", "maxcalcdate").finish();
        trackNumberDataSet = trackNumberDataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
        DataSet trackNumberDateDataSet = trackNumberDataSet.filter("newcalcdate=maxcalcdate");
        DataSet dataSet = DataSetUtils.union((DataSet)analogDataSet, (DataSet)trackNumberDateDataSet);
        DataSet outDataSet = orm.queryDataSet(this.getAlgoKey("queryAnalogDataSet"), "cad_calcpurprices", this.getOutSelectFields(), outFilters.toArray(new QFilter[0]), null, -1, null);
        dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)outDataSet);
        DataSet maxDateDataSet = dataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
        dataSet = dataSet.join(maxDateDataSet).on("material", "material").on("keycol", "keycol").select(dataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
        dataSet = dataSet.filter("calcdate=maxcalcdate");
        return dataSet;
    }

    private void getMatInfos(StandardMacRptParam param) {
        Date[] periodtime;
        String lots;
        List projectNumberIds;
        List trackNumberIds;
        Set materialIds;
        logger.info("\u67e5\u8be2\u7269\u6599\u6807\u51c6\u4fe1\u606f\u5f00\u59cb");
        List<Object> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)Long.valueOf(param.getCostTypeId())));
        List mnCostType = CostTypeHelper.getMnCostByHs((Long)Long.valueOf(param.getCostTypeId()));
        if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
            param.setSimCosttypeId((Long)mnCostType.get(0));
        }
        if (CadEmptyUtils.isEmpty((Set)(materialIds = param.getProducts())) && !CadEmptyUtils.isEmpty((Set)param.getCalcMatIds())) {
            Set matIds = param.getCalcMatIds();
            filters.add(new QFilter("material", "in", (Object)matIds));
        } else {
            QFilter matIdQFilter = InFilterHelper.getQFilterByBachSize((String)"material", materialIds == null ? new ArrayList() : new ArrayList(materialIds), (String)"in", (int)20000);
            filters.add(matIdQFilter);
        }
        List configuredCodeIds = param.getConfiguredCodeIds();
        if (!CadEmptyUtils.isEmpty((List)configuredCodeIds)) {
            filters.add(new QFilter("configuredcode", "in", (Object)configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(trackNumberIds = param.getTrackNumberIds()))) {
            filters.add(new QFilter("tracknumber", "in", (Object)trackNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(projectNumberIds = param.getProjectNumberIds()))) {
            filters.add(new QFilter("project", "in", (Object)projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = param.getLots()))) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        Date date = param.getQueryDate();
        if (param.getQueryDate() != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)date));
            filters.add(new QFilter("expdate", ">", (Object)date));
        } else if (param.getQueryPeriodId() != null && param.getQueryPeriodId() != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)param.getQueryPeriodId())) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        String queryFileds = "id,material,keycol,tracknumber";
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet("getMatInfos", "cad_matcostinfo", queryFileds, filters.toArray(new QFilter[0]), "keycol", -1, null);
        HashSet<Long> matCostInfoIds = new HashSet<Long>(16);
        HashSet<String> trackKeyCols = new HashSet<String>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long tracknumber = row.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty((Long)tracknumber)) {
                matCostInfoIds.add(row.getLong("id"));
                continue;
            }
            trackKeyCols.add(row.getString("keycol"));
        }
        param.setMatCostInfoIds(matCostInfoIds);
        param.setTrackKeyCols(trackKeyCols);
        logger.info("\u67e5\u8be2\u7269\u6599\u6807\u51c6\u4fe1\u606f\u7ed3\u675f");
    }

    protected DataSet queryAuditDataSet(List<QFilter> filters, List<QFilter> traFilters, List<QFilter> outFilters, StandardMacRptParam param, List<String> dateTypeList) {
        DataSet dataSet;
        Date[] periodtime;
        filters.add((QFilter)new QFilter("entryentity.datatype", "in", dateTypeList));
        filters.add((QFilter)new QFilter("ismaindata", "=", (Object)1));
        if (!CadEmptyUtils.isEmpty((Set)param.getMatCostInfoIds())) {
            filters.add((QFilter)new QFilter("matcostid", "in", (Object)param.getMatCostInfoIds()));
        }
        Date date = param.getQueryDate();
        if (param.getQueryDate() != null) {
            filters.add((QFilter)new QFilter("effectdate", "<=", (Object)date));
            filters.add((QFilter)new QFilter("expdate", ">", (Object)date));
        } else if (param.getQueryPeriodId() != null && param.getQueryPeriodId() != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)param.getQueryPeriodId())) != null) {
            filters = CostUpdateHelper.getPeriodQF(filters, (Date[])periodtime);
        }
        boolean isEmptyTrackNumber = CadEmptyUtils.isEmpty((Set)param.getTrackKeyCols());
        ORMImpl orm = new ORMImpl();
        if (isEmptyTrackNumber) {
            dataSet = orm.queryDataSet(this.getAlgoKey("queryAuditDataSet"), "cad_calceffectiveresult", this.getAuditSelectFields(), filters.toArray(new QFilter[0]), "level asc,treepath asc", -1, null);
            if (Boolean.TRUE.equals(CostUpdateHelper.isQueryPeriod((ReportQueryParam)this.getQueryParam()))) {
                String groupFields = "costtype,material,keycol,auxproperty";
                String selectFields = groupFields + ",effectdate";
                DataSet maxDateDataSet = dataSet.copy().select(selectFields.split(",")).groupBy(groupFields.split(",")).max("effectdate").finish();
                dataSet = dataSet.join(maxDateDataSet, JoinType.INNER).on("costtype", "costtype").on("material", "material").on("keycol", "keycol").on("effectdate", "effectdate").select(dataSet.getRowMeta().getFieldNames(), null).finish();
            }
        } else {
            Date[] periodtime2;
            traFilters.add((QFilter)new QFilter("entryentity.subentryentity.datatype", "in", dateTypeList));
            traFilters.add((QFilter)new QFilter("entryentity.entryismaindata", "=", (Object)1));
            traFilters.add((QFilter)new QFilter("keycol", "in", (Object)param.getTrackKeyCols()));
            if (param.getQueryDate() != null) {
                traFilters.add((QFilter)new QFilter("effectdate", "<=", (Object)date));
                traFilters.add((QFilter)new QFilter("expdate", ">", (Object)date));
            } else if (param.getQueryPeriodId() != null && param.getQueryPeriodId() != 0L && (periodtime2 = PeriodHelper.getPeriodStartAndEndTime((Long)param.getQueryPeriodId())) != null) {
                traFilters = CostUpdateHelper.getPeriodQF(traFilters, (Date[])periodtime2);
            }
            DataSet trackNumberDataSet = orm.queryDataSet(this.getAlgoKey("queryAuditDataSet"), "cad_trackstdcalcresult", this.getTraSelectFields(), traFilters.toArray(new QFilter[0]), "treepath asc", -1, null);
            DataSet dateDataSet = trackNumberDataSet.filter("expdate is not null");
            dataSet = dateDataSet.filter("curdate>=effectdate and curdate<=expdate");
            dataSet = dataSet.removeFields(new String[]{"curdate"});
        }
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)param.getMulgroupmaterial())) {
            if (!CadEmptyUtils.isEmpty((Set)param.getMatCostInfoIds())) {
                outFilters.add(new QFilter("matcostid", "in", (Object)param.getMatCostInfoIds()));
            }
            DataSet outDataSet = orm.queryDataSet(this.getAlgoKey("queryAuditDataSet"), "cad_purprices", this.getOutAuditSelectFields(), outFilters.toArray(new QFilter[0]), null, -1, null);
            dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)outDataSet);
        }
        return dataSet;
    }

    protected DataSet groupBy(DataSet dataSet, StandardMacRptParam param, boolean isAnalogCost) {
        String groupFields = this.getCommonGroupFields();
        HashSet<Long> allMatIds = new HashSet<Long>(32);
        for (Row row : dataSet.copy()) {
            Long materialId;
            Long subMaterialId = row.getLong("submaterial");
            if (!CadEmptyUtils.isEmpty((Long)subMaterialId)) {
                allMatIds.add(subMaterialId);
            }
            if (CadEmptyUtils.isEmpty((Long)(materialId = row.getLong("material")))) continue;
            allMatIds.add(materialId);
        }
        DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet((DynamicObjectCollection)param.getMulmaterialgroup(), (boolean)false, (DynamicObject)param.getMaterialgrpstd(), allMatIds);
        DataSet matDataSet = dataSet.filter("submaterial!=0");
        DataSet notMatDataSet = dataSet.filter("submaterial=0");
        matDataSet = matDataSet.leftJoin(materialDataSet).on("submaterial", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish();
        notMatDataSet = notMatDataSet.leftJoin(materialDataSet).on("material", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish();
        dataSet = DataSetUtils.union((DataSet)matDataSet, (DataSet)notMatDataSet);
        dataSet = dataSet.leftJoin(materialDataSet).on("material", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup as productgroup"}).finish();
        groupFields = groupFields + ",productgroup,materialgroup,submaterial,subkeycol,subauxproperty,processseq,operationno,resource,subconfiguredcode,subtracknumber,subproject,sublot";
        if (!isAnalogCost) {
            groupFields = groupFields + ",effectdate,expdate";
        }
        String selectFields = groupFields + ",qty,price,stdprice";
        GroupbyDataSet gds = dataSet.select(selectFields).groupBy(groupFields.split(","));
        gds = gds.sum("qty").avg("price");
        dataSet = gds.sum("stdprice").finish();
        return dataSet;
    }

    private String getCommonGroupFields() {
        String selectFields = "costtype,treepath,elementid,element,elemumber,elementtype,subelement,subelementnumber,material,keycol,auxproperty,bom,processroute,calcbasis,datatype,configuredcode,tracknumber,project,lot";
        return selectFields;
    }

    private String getCommonSelectFields(Boolean isAnalogCost) {
        String selectFields = "costtype,treepath,material,auxproperty,keycol,bom,processroute,configuredcode,tracknumber,project,lot,entryentity.element.name element,entryentity.element.number elemumber,entryentity.element.type elementtype,entryentity.element elementid,entryentity.subelement.name subelement,entryentity.subelement.number subelementnumber,entryentity.qty qty,entryentity.stdprice stdprice,entryentity.submaterial submaterial,entryentity.subkeycol subkeycol,entryentity.subauxproperty subauxproperty,entryentity.price price,entryentity.calcbasis calcbasis,entryentity.datatype datatype," + (isAnalogCost != false ? "entryentity.processseq processseq,entryentity.operationno operationno" : "'' processseq,'' operationno") + ",entryentity.resource resource,entryentity.subconfiguredcode subconfiguredcode,entryentity.subtracknumber subtracknumber,entryentity.subproject subproject,entryentity.sublot sublot";
        return selectFields;
    }

    protected String getOutSelectFields() {
        String selectFields = "costtype,'' treepath,material,auxpty auxproperty,keycol,0L bom,0L processroute,configuredcode,tracknumber,project,lot,entryentity.element.name element,entryentity.element.number elemumber,entryentity.element.type elementtype,entryentity.element elementid,entryentity.subelement.name subelement,entryentity.subelement.number subelementnumber,1 qty,entryentity.price stdprice,0L submaterial,'' subkeycol,0L subauxproperty,entryentity.price price,'' calcbasis,'' datatype,'' processseq,'' operationno,0L resource,0L subconfiguredcode,0L subtracknumber,0L subproject,'' sublot,calcdate";
        return selectFields;
    }

    protected String getOutAuditSelectFields() {
        String selectFields = "costtype,'' treepath,material,auxpty auxproperty,keycol,0L bom,0L processroute,configuredcode,tracknumber,project,lot,entryentity.element.name element,entryentity.element.number elemumber,entryentity.element.type elementtype,entryentity.element elementid,entryentity.subelement.name subelement,entryentity.subelement.number subelementnumber,1 qty,entryentity.price stdprice,0L submaterial,'' subkeycol,0L subauxproperty,entryentity.price price,'' calcbasis,'' datatype,'' processseq,'' operationno,0L resource,0L subconfiguredcode,0L subtracknumber,0L subproject,'' sublot,effectdate,expdate";
        return selectFields;
    }

    protected String getTraSelectFields() {
        String selectFields = "costtype,treepath,material,auxproperty,keycol,bomid bom,processrouteid processroute,configuredcode,tracknumber,project,lot,entryentity.subentryentity.element.name element,entryentity.subentryentity.element.number elemumber,entryentity.subentryentity.element.type elementtype,entryentity.subentryentity.element elementid,entryentity.subentryentity.subelement.name subelement,entryentity.subentryentity.subelement.number subelementnumber,entryentity.subentryentity.qty qty,entryentity.subentryentity.stdprice stdprice,entryentity.subentryentity.submaterial submaterial,entryentity.subentryentity.subkeycol subkeycol,entryentity.subentryentity.subauxproperty subauxproperty,entryentity.subentryentity.price price,entryentity.subentryentity.calcbasis calcbasis,entryentity.subentryentity.datatype datatype,entryentity.subentryentity.processseq processseq,entryentity.subentryentity.operationno operationno,entryentity.subentryentity.resource resource,entryentity.subentryentity.subconfiguredcode subconfiguredcode,entryentity.subentryentity.subtracknumber subtracknumber,entryentity.subentryentity.subproject subproject,entryentity.subentryentity.sublot sublot,effectdate,expdate,now() as curdate";
        return selectFields;
    }

    protected String getAnalogSelectFields() {
        String selectFields = this.getCommonSelectFields(Boolean.TRUE) + ",calcdate";
        return selectFields;
    }

    protected String getAuditSelectFields() {
        String selectFields = this.getCommonSelectFields(Boolean.FALSE) + ",effectdate,expdate";
        return selectFields;
    }
}

