/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costcomanalyze;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.report.queryplugin.costcomanalyze.CostComAnalyzeRptParam;

public class CostComAnalyzeRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"calcrecord"});
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialGrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialGrpstd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulMaterial = (MulBasedataEdit)this.getControl("mulmaterial");
        mulMaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulConfiguredCode = (MulBasedataEdit)this.getControl("mulconfiguredcode");
        mulConfiguredCode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulTrackNumber = (MulBasedataEdit)this.getControl("multracknumber");
        mulTrackNumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!"sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"querydate", "queryperiod"});
            this.getModel().setValue("querydate", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"costtype"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"costtype", "calcrecord"});
        }
        this.displayProdOrg(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        if (this.getModel().getValue("manuorg") != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"manuorg"});
            this.getPageCache().put("manuorg_mustInput", "Y");
            BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
            manuorg.setMustInput(true);
            return;
        }
        this.init();
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<Long> createOrgIds = new ArrayList<Long>(10);
        if (org != null) {
            createOrgIds.add(org.getLong("id"));
        }
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                qFilters.add(idFilter);
                break;
            }
            case "costaccount": {
                qFilters.add(this.getCostAccountF7QFilter(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
                break;
            }
            case "period": {
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostComAnalyzeRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) break;
                qFilters.add(StartCostHelper.getUsePeriodFilter((Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
                break;
            }
            case "queryperiod": {
                costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostComAnalyzeRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) break;
                qFilters.add(CostUpdateHelper.getRptPeriodQFilter((Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
                break;
            }
            case "materialgrpstd": {
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
                qFilters.add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "mulmaterial": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostComAnalyzeRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter matOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)org.getLong("id"));
                qFilters.add(matOrgFilter);
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "costtype": {
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostComAnalyzeRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
                QFilter filter = new QFilter("type", "=", (Object)"1");
                filter.and(new QFilter("currency", "=", currencyObj.get("id")));
                qFilters.add(filter);
                break;
            }
            case "manuorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostComAnalyzeRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List productOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                qFilters.add(new QFilter("id", "in", (Object)productOrgs));
                break;
            }
            case "mulconfiguredcode": {
                DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
                HashSet matIds = new HashSet(16);
                for (DynamicObject material : materials) {
                    DynamicObject matObj = (DynamicObject)material.get("fbasedataid");
                    materials.forEach(p -> matIds.add(matObj.getLong("masterid")));
                }
                if (CadEmptyUtils.isEmpty(matIds)) break;
                List configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(matIds);
                qFilters.add(new QFilter("id", "in", (Object)configCodeIds));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject costtype;
        DynamicObject currency;
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostComAnalyzeRpt_2", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject period = filter.getDynamicObject("period");
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4", (String)"CostComAnalyzeRpt_3", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulmaterial = filter.getDynamicObjectCollection("mulmaterial");
        if (CollectionUtils.isEmpty((Collection)mulmaterial)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea7\u54c1", (String)"CostComAnalyzeRpt_4", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        if ("sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))) {
            Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)org.getLong("id"), (Long)costaccount.getLong("id"));
            if (Boolean.TRUE.equals(isUpdateByPeriod) && filter.getDynamicObject("queryperiod") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u671f\u95f4\u3002", (String)"CostComAnalyzeRpt_5", (String)"macc-cad-report", (Object[])new Object[0]));
            }
            if (Boolean.FALSE.equals(isUpdateByPeriod) && filter.getDate("querydate") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65f6\u95f4\u3002", (String)"CostComAnalyzeRpt_6", (String)"macc-cad-report", (Object[])new Object[0]));
            }
        }
        if ((currency = filter.getDynamicObject("currency")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ef4\u62a4\u5e01\u79cd\u3002", (String)"CostComAnalyzeRpt_7", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject mulmanuorg = (DynamicObject)this.getModel().getValue("manuorg");
        String needPrdorgCache = this.getPageCache().get("manuorg_mustInput");
        if ("Y".equals(needPrdorgCache) && CadEmptyUtils.isEmpty((DynamicObject)mulmanuorg)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u3002", (String)"CostComAnalyzeRpt_8", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
        if (materialgrpstd == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostComAnalyzeRpt_9", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        if (!"sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())) && (costtype = (DynamicObject)this.getModel().getValue("costtype")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"CostComAnalyzeRpt_10", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        CostComAnalyzeRptParam param = this.buildParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(CostComAnalyzeRptParam.class.getName(), param);
        return super.verifyQuery(queryParam);
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "calcrecord".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showSelectPage(key);
        }
    }

    private void showSelectPage(String actionId) {
        List materialIds;
        DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
        if (costtype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"CostComAnalyzeRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
            return;
        }
        ArrayList mulmaterial = Lists.newArrayList();
        DynamicObjectCollection mulMaterial = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
        if (mulMaterial != null && mulMaterial.size() > 0 && !CadEmptyUtils.isEmpty(materialIds = mulMaterial.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            mulmaterial.addAll(materialIds);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_stdcalcrecord_text");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costTypeId", costtype.get("id"));
        fsp.setCustomParam("materialIds", (Object)mulmaterial);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        } else if (returnDataObj instanceof String) {
            String value = (String)returnDataObj;
            this.getModel().setValue(actionId, (Object)value);
        }
    }

    private CostComAnalyzeRptParam buildParam(DynamicObject dataEntity) {
        Date queryDate;
        DynamicObject queryperiod;
        DynamicObject period;
        DynamicObject materialGrpstd;
        String lots;
        DynamicObjectCollection mulConfiguredCode;
        DynamicObject manuOrg;
        DynamicObject costAccount;
        CostComAnalyzeRptParam param = new CostComAnalyzeRptParam();
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org != null) {
            param.setOrg(org.getLong("id"));
        }
        if ((costAccount = dataEntity.getDynamicObject("costaccount")) != null) {
            param.setCostAccountId(costAccount.getLong("id"));
        }
        if ((manuOrg = dataEntity.getDynamicObject("manuorg")) != null) {
            param.setManuOrg(manuOrg.getLong("id"));
            param.setManuOrgNum(manuOrg.getString("number"));
        }
        param.setCalcRecordName(dataEntity.getString("calcrecord"));
        if (!"sca".equals(appId)) {
            DynamicObject costType = dataEntity.getDynamicObject("costtype");
            if (!CadEmptyUtils.isEmpty((DynamicObject)costType)) {
                param.setCostTypeId(costType.getLong("id"));
                param.setCurrencyId(costType.getLong("currency.id"));
                param.setAmtPrecision(costType.getInt("currency.amtprecision"));
                param.setPricePrecision(costType.getInt("currency.priceprecision"));
            }
        } else {
            Long costTypeId;
            DynamicObject costType;
            Long orgId = org == null ? 0L : org.getLong("id");
            Long manuOrgId = manuOrg == null ? 0L : manuOrg.getLong("id");
            Long costAccountId = costAccount == null ? 0L : costAccount.getLong("id");
            boolean isMulFactory = false;
            if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
                orgId = manuOrgId;
                isMulFactory = true;
            }
            if ((costType = CostTypeHelper.getCostType((Long)(costTypeId = CostTypeHelper.getCostTypeByOrgAndCostAccount((Long)orgId, (Long)costAccountId, (boolean)isMulFactory)), (String)"currency,currency.amtprecision,currency.priceprecision")) != null) {
                param.setCostTypeId(costTypeId);
                param.setCurrencyId(costType.getLong("currency.id"));
                param.setAmtPrecision(costType.getInt("currency.amtprecision"));
                param.setPricePrecision(costType.getInt("currency.priceprecision"));
            }
        }
        DynamicObjectCollection mulmaterial = dataEntity.getDynamicObjectCollection("mulmaterial");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterial)) {
            Set<Long> collect = mulmaterial.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            param.setMaterialIds(collect);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulConfiguredCode = (DynamicObjectCollection)this.getModel().getValue("mulconfiguredcode")))) {
            List<Long> configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            param.setConfiguredCodeIds(configuredCodeIds);
        } else if (!CadEmptyUtils.isEmpty(param.getMaterialIds()) && "sca".equals(appId)) {
            param.setConfiguredCodeIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulTracknumber = (DynamicObjectCollection)this.getModel().getValue("multracknumber");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulTracknumber)) {
            List<Long> trackNumberIds = mulTracknumber.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            param.setTrackNumberIds(trackNumberIds);
        } else if (!CadEmptyUtils.isEmpty(param.getMaterialIds()) && "sca".equals(appId)) {
            param.setTrackNumberIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulProjectNumber = (DynamicObjectCollection)this.getModel().getValue("mulprojectnumber");
        if (mulProjectNumber != null) {
            List<Long> projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            param.setProjectNumberIds(projectNumberIds);
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = (String)this.getModel().getValue("mullot")))) {
            param.setLots(lots);
        }
        if ((materialGrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd")) != null) {
            param.setMaterialGrpStd(materialGrpstd.getLong("id"));
        }
        if ((period = dataEntity.getDynamicObject("period")) != null) {
            param.setPeriodId(period.getLong("id"));
            param.setPeriodYear(period.getInt("periodyear"));
            param.setPeriodNumber(period.getInt("periodnumber"));
        }
        if ((queryperiod = dataEntity.getDynamicObject("queryperiod")) != null) {
            long perodId = queryperiod.getLong("id");
            param.setQueryPeriodId(perodId);
            Date[] periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)perodId);
            if (periodtime != null && periodtime.length == 2) {
                param.setQueryPeriodBeginDate(periodtime[0]);
                param.setQueryPeriodEndDate(periodtime[1]);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u672a\u7ef4\u62a4\u76f8\u5e94\u7684\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostComAnalyzeRpt_11", (String)"macc-cad-report", (Object[])new Object[0]));
            }
        }
        if ((queryDate = dataEntity.getDate("querydate")) != null) {
            param.setQueryDate(queryDate);
            param.setUpdateByPeriod(Boolean.TRUE);
        }
        boolean onlyShowSum = dataEntity.getBoolean("onlyShowSum");
        param.setOnlyShowSum(onlyShowSum);
        boolean onlyShowGroup = dataEntity.getBoolean("onlyShowGroup");
        param.setOnlyShowGroup(onlyShowGroup);
        param.setAppNum(this.getView().getFormShowParameter().getAppId());
        return param;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                break;
            }
            case "costaccount": {
                this.setOrg();
                this.setCurrency();
                this.setPeriod();
                this.displayProdOrg(true);
                this.dealQueryPeriod();
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostComAnalyzeRpt_12", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"CostComAnalyzeRpt_13", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
    }

    private void init() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = this.getModel().getDataEntity().getDynamicObject("org");
        this.setCostAccount(org);
        this.displayProdOrg(true);
        this.dealQueryPeriod();
    }

    private void displayProdOrg(boolean isClearProdOrg) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (isClearProdOrg) {
            this.getModel().setValue("manuorg", null);
        }
        if (org == null) {
            return;
        }
        BasedataEdit mulmanuorg = (BasedataEdit)this.getControl("manuorg");
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("manuorg", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"manuorg"});
            mulmanuorg.setMustInput(false);
            return;
        }
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        if (isOrgEnableMultiFactory) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"manuorg"});
            this.getPageCache().put("manuorg_mustInput", "Y");
            mulmanuorg.setMustInput(true);
        } else {
            this.getModel().setValue("manuorg", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"manuorg"});
            this.getPageCache().put("manuorg_mustInput", "N");
            mulmanuorg.setMustInput(false);
        }
        this.getView().updateView("manuorg");
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
            return;
        }
        Long mainBookId = this.getCostAccountByAccoutOrg(((DynamicObject)org).getLong("id"));
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
            this.getView().updateView("costaccount");
            this.setCurrency();
            this.setPeriod();
            return;
        }
        this.getModel().setValue("org", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("period", null);
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter enable;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE), appNumQF = new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))};
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
        if (result == null || result.size() == 0) {
            return 0L;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return 0L;
    }

    private QFilter getCostAccountF7QFilter(String appNum) {
        List orgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (costAccountIds.size() > 0) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0);
    }

    public void setOrg() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("org", null);
            return;
        }
        this.getModel().setValue("org", (Object)costaccount.getLong("calorg.id"));
    }

    public void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("period", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("period", (Object)currentperiod);
            this.getView().updateView("period");
        }
    }

    private void dealQueryPeriod() {
        if (!"sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (org == null || costAccount == null) {
            this.setQueryVisible(Boolean.FALSE, null, null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)orgId, (Long)costAccountId);
        this.setQueryVisible(isUpdateByPeriod, orgId, costAccountId);
    }

    private void setQueryVisible(Boolean isShow, Long orgId, Long costAccountId) {
        this.getView().setVisible(isShow, new String[]{"queryperiod"});
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.setMustInput(isShow.booleanValue());
        if (Boolean.TRUE.equals(isShow)) {
            List periodIds = CostUpdateHelper.getPeriodIds((Long)orgId, (Long)costAccountId);
            this.getModel().setValue("queryperiod", periodIds.isEmpty() ? null : periodIds.get(0));
        } else {
            this.getModel().setValue("queryperiod", null);
        }
        this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{"querydate"});
        DateTimeEdit queryDate = (DateTimeEdit)this.getControl("querydate");
        queryDate.setMustInput(isShow == false);
        this.getModel().setValue("querydate", (Object)(Boolean.TRUE.equals(isShow == false) ? TimeServiceHelper.now() : null));
    }
}

