/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costcomanalyze;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.report.queryplugin.costcomanalyze.CostComAnalyzeRptParam;
import kd.macc.cad.report.queryplugin.costcomanalyze.CostComAnalyzeRptResultRow;
import kd.macc.cad.report.queryplugin.costcomanalyze.CostComAnalyzeRptSumRow;
import kd.macc.cad.report.queryplugin.costcomanalyze.HandleFinalRow;
import kd.macc.cad.report.queryplugin.costcomanalyze.HandleRow;

public class CostComAnalyzeRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CostComAnalyzeRptSourceCf.class);
    private CostComAnalyzeRptParam costComAnalyzeRptParam;
    private static final String CUR_PERIOD = "0";
    private static final String PRE_PERIOD = "1";
    private static final String PRE_YEAR = "2";
    private static final String CUR_ALL_PERIOD = "3";
    private static final String PRE_ALL_PERIOD = "4";
    private static final List<String> STD_GROUP = Lists.newArrayList((Object[])new String[]{"qty", "price", "stdprice"});
    private static final List<String> CUR_GROUP = Lists.newArrayList((Object[])new String[]{"curqty", "cursumqty", "curprice", "curamt", "cursumamt"});
    private static final List<String> PRE_GROUP = Lists.newArrayList((Object[])new String[]{"preqty", "presumqty", "preprice", "preamt", "presumamt"});
    private static final List<String> PREYEAR_GROUP = Lists.newArrayList((Object[])new String[]{"preyearqty", "preyearsumqty", "preyearprice", "preyearamt", "preyearsumamt"});
    private static final List<String> CURYEARSUM_GROUP = Lists.newArrayList((Object[])new String[]{"curyearallqty", "curyearallsumqty", "curyearallprice", "curyearallamt", "curyearallsumamt"});
    private static final List<String> PREYEARSUM_GROUP = Lists.newArrayList((Object[])new String[]{"preyearallqty", "preyearallsumqty", "preyearallprice", "preyearallamt", "preyearallsumamt"});
    private static final List<String> qtyProps = Lists.newArrayList((Object[])new String[]{"qty", "curqty", "cursumqty", "preqty", "presumqty", "preyearqty", "preyearsumqty", "curyearallqty", "curyearallsumqty", "preyearallqty", "preyearallsumqty"});
    private static final List<String> amtProps = Lists.newArrayList((Object[])new String[]{"curamt", "cursumamt", "preamt", "presumamt", "preyearamt", "preyearsumamt", "curyearallamt", "curyearallsumamt", "preyearallamt", "preyearallsumamt"});
    private static final List<String> priceProps = Lists.newArrayList((Object[])new String[]{"curprice", "preprice", "preyearprice", "curyearallprice", "preyearallprice"});
    private static final List<String> manuOrgHideProps = Lists.newArrayList((Object[])new String[]{"manuorg", "manuorgnum"});
    private static final List<String> hideProps = Lists.newArrayList((Object[])new String[]{"datatype", "element", "subelement"});
    private static final List<String> hideMatProps = Lists.newArrayList((Object[])new String[]{"submaterial", "submaterialnum", "subconfiguredcode", "subtracknumber", "subauxpty", "submatunit"});

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.costComAnalyzeRptParam = (CostComAnalyzeRptParam)ctx.getParam(CostComAnalyzeRptParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        this.logger.info("\u4fee\u6539\u56fa\u5b9a\u6570\u636e\u5757");
        Iterator<SrcBlockConf> selectBlockOr = blockCollector.iterator();
        String appNum = this.costComAnalyzeRptParam.getAppNum();
        while (selectBlockOr.hasNext()) {
            QFilter periodFilter;
            SrcBlockConf blockConf = selectBlockOr.next();
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            if (dataFs == null) {
                dataFs = new QFilter(PRE_PERIOD, "=", (Object)1);
            }
            if ("sca".equals(appNum)) {
                if ("cad_calcsimulationresult".equals(srcEntity) || "aca_calcresult".equals(srcEntity)) {
                    selectBlockOr.remove();
                    continue;
                }
                if ("cad_calceffectiveresult".equals(srcEntity)) {
                    dataFs.and(new QFilter("costtype", "=", (Object)this.costComAnalyzeRptParam.getCostTypeId()));
                    dataFs.and(new QFilter("ismaindata", "=", (Object)1));
                    dataFs.and(new QFilter("entryentity.datatype", "in", (Object)new String[]{PRE_PERIOD, PRE_YEAR, PRE_ALL_PERIOD}));
                    if (this.costComAnalyzeRptParam.isUpdateByPeriod().booleanValue()) {
                        dataFs.and(new QFilter("effectdate", "<=", (Object)this.costComAnalyzeRptParam.getQueryDate()));
                        dataFs.and(new QFilter("expdate", ">", (Object)this.costComAnalyzeRptParam.getQueryDate()));
                    } else {
                        dataFs.and(new QFilter("effectdate", "<=", (Object)this.costComAnalyzeRptParam.getQueryPeriodEndDate()));
                        dataFs.and(new QFilter("expdate", ">", (Object)this.costComAnalyzeRptParam.getQueryPeriodEndDate()));
                    }
                }
                if ("sca_diffcalcresult".equals(srcEntity)) {
                    dataFs.and(new QFilter("org", "=", (Object)this.costComAnalyzeRptParam.getOrg()));
                    dataFs.and(new QFilter("costaccount", "=", (Object)this.costComAnalyzeRptParam.getCostAccountId()));
                    if (!CadEmptyUtils.isEmpty((Long)this.costComAnalyzeRptParam.getManuOrg())) {
                        dataFs.and(new QFilter("costobject.manuorg", "=", (Object)this.costComAnalyzeRptParam.getManuOrg()));
                    }
                    periodFilter = this.getPeriodFilter(CUR_ALL_PERIOD);
                    periodFilter.or(this.getPeriodFilter(PRE_ALL_PERIOD));
                    dataFs.and(periodFilter);
                }
            } else {
                if ("cad_calceffectiveresult".equals(srcEntity) || "sca_diffcalcresult".equals(srcEntity)) {
                    selectBlockOr.remove();
                    continue;
                }
                if ("cad_calcsimulationresult".equals(srcEntity)) {
                    dataFs.and(new QFilter("costtype", "=", (Object)this.costComAnalyzeRptParam.getCostTypeId()));
                    dataFs.and(new QFilter("ismaindata", "=", (Object)1));
                    String calcRecordName = this.costComAnalyzeRptParam.getCalcRecordName();
                    if (!CadEmptyUtils.isEmpty((String)calcRecordName)) {
                        dataFs.and(new QFilter("calcrecord.name", "=", (Object)calcRecordName));
                    } else {
                        QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
                        dataFs.and(recordFilter);
                    }
                    dataFs.and(new QFilter("entryentity.datatype", "in", (Object)new String[]{PRE_PERIOD, PRE_YEAR, PRE_ALL_PERIOD}));
                }
                if ("aca_calcresult".equals(srcEntity)) {
                    dataFs.and(new QFilter("org", "=", (Object)this.costComAnalyzeRptParam.getOrg()));
                    dataFs.and(new QFilter("costaccount", "=", (Object)this.costComAnalyzeRptParam.getCostAccountId()));
                    if (!CadEmptyUtils.isEmpty((Long)this.costComAnalyzeRptParam.getManuOrg())) {
                        dataFs.and(new QFilter("costobject.manuorg", "=", (Object)this.costComAnalyzeRptParam.getManuOrg()));
                    }
                    periodFilter = this.getPeriodFilter(CUR_ALL_PERIOD);
                    periodFilter.or(this.getPeriodFilter(PRE_ALL_PERIOD));
                    dataFs.and(periodFilter);
                }
            }
            if (blockConf.getDataFs() != null) continue;
            blockConf.setDataFs(dataFs);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterUnion\u591a\u4e2a\u6570\u636e\u5757union\u5b8c\u6210\u540e\u6267\u884c\uff0c\u5904\u7406\u6570\u636e\u5757");
        transCollector.add(new HandleRow(this.costComAnalyzeRptParam, ctx));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterGroup\uff0c\u6570\u636e\u5206\u7ec4\u540e\u5904\u7406");
        this.logger.info("\u6210\u672c\u5206\u6790\u7efc\u5408\u8868\u5206\u7ec4\u5b57\u6bb5\uff1a{}", (Object)ctx.getShowKeyCols());
        transCollector.add(new HandleFinalRow(this.costComAnalyzeRptParam, ctx));
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterAddSumRow\uff0c\u5408\u8ba1\u884c\u5904\u7406");
        transCollector.add(new CostComAnalyzeRptSumRow(this.costComAnalyzeRptParam));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CostComAnalyzeRptResultRow(this.costComAnalyzeRptParam, ctx));
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        super.handleBigtableCols(repoColFilter, ctx);
        repoColFilter.add("datasrc");
        repoColFilter.add("sourcebill");
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u5c55\u793a\u5217\u8c03\u6574\u5f00\u59cb");
        ReportColumnGroup stdGroup = new ReportColumnGroup();
        stdGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c", (String)"CostComAnalyzeRptSourceCf_0", (String)"macc-cad-report", (Object[])new Object[0])));
        stdGroup.setFieldKey("stdgroup");
        ReportColumnGroup curGroup = new ReportColumnGroup();
        curGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645", (String)"CostComAnalyzeRptSourceCf_1", (String)"macc-cad-report", (Object[])new Object[0])));
        curGroup.setFieldKey("curgroup");
        ReportColumnGroup preGroup = new ReportColumnGroup();
        preGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u671f\u5b9e\u9645", (String)"CostComAnalyzeRptSourceCf_2", (String)"macc-cad-report", (Object[])new Object[0])));
        preGroup.setFieldKey("pregroup");
        ReportColumnGroup preYearGroup = new ReportColumnGroup();
        preYearGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u5b9e\u9645", (String)"CostComAnalyzeRptSourceCf_3", (String)"macc-cad-report", (Object[])new Object[0])));
        preYearGroup.setFieldKey("preyeargroup");
        ReportColumnGroup curYearSumGroup = new ReportColumnGroup();
        curYearSumGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u5b9e\u9645", (String)"CostComAnalyzeRptSourceCf_4", (String)"macc-cad-report", (Object[])new Object[0])));
        curYearSumGroup.setFieldKey("curyearsumgroup");
        ReportColumnGroup preYearSumGroup = new ReportColumnGroup();
        preYearSumGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u5e74\u7d2f\u8ba1\u5b9e\u9645", (String)"CostComAnalyzeRptSourceCf_5", (String)"macc-cad-report", (Object[])new Object[0])));
        preYearSumGroup.setFieldKey("preyearsumgroup");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (CadEmptyUtils.isEmpty((Long)this.costComAnalyzeRptParam.getManuOrg()) && manuOrgHideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (hideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (this.costComAnalyzeRptParam.isOnlyShowGroup().booleanValue() && hideMatProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (qtyProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                repCol.setFieldType("qty");
                repCol.setMeasureUnitField("submatunit");
                repCol.setNoDisplayScaleZero(false);
            }
            if (amtProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setFieldType("amount");
                repCol.setHideSingleColumnRow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setCurrencyField("currency");
            }
            if (priceProps.contains(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setFieldType("price");
                repCol.setHideSingleColumnRow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setCurrencyField("currency");
            }
            if (STD_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                stdGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (CUR_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                curGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (PRE_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                preGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (PREYEAR_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                preYearGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (CURYEARSUM_GROUP.contains(fieldKey)) {
                repCol.setNoDisplayScaleZero(false);
                repCol.setZeroShow(false);
                repCol.setHideSingleColumnRow(false);
                curYearSumGroup.getChildren().add(repCol);
                iterator.remove();
            }
            if (!PREYEARSUM_GROUP.contains(fieldKey)) continue;
            repCol.setNoDisplayScaleZero(false);
            repCol.setZeroShow(false);
            repCol.setHideSingleColumnRow(false);
            preYearSumGroup.getChildren().add(repCol);
            iterator.remove();
        }
        cols.add((AbstractReportColumn)stdGroup);
        cols.add((AbstractReportColumn)curGroup);
        cols.add((AbstractReportColumn)preGroup);
        cols.add((AbstractReportColumn)preYearGroup);
        cols.add((AbstractReportColumn)curYearSumGroup);
        cols.add((AbstractReportColumn)preYearSumGroup);
        return cols;
    }

    private List<QFilter> getFixedFilter() {
        String lots;
        List<Long> projectNumberIds;
        List<Long> trackNumberIds;
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>();
        Set<Long> mulMaterialIds = this.costComAnalyzeRptParam.getMaterialIds();
        QFilter matQf = new QFilter("material", "in", mulMaterialIds);
        commonFilters.add(matQf);
        List<Long> configuredCodeIds = this.costComAnalyzeRptParam.getConfiguredCodeIds();
        if (!CadEmptyUtils.isEmpty(configuredCodeIds)) {
            commonFilters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty(trackNumberIds = this.costComAnalyzeRptParam.getTrackNumberIds())) {
            commonFilters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(projectNumberIds = this.costComAnalyzeRptParam.getProjectNumberIds())) {
            commonFilters.add(new QFilter("projectnumber", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = this.costComAnalyzeRptParam.getLots()))) {
            commonFilters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        return commonFilters;
    }

    private QFilter getPeriodFilter(String gainType) {
        if (CUR_PERIOD.equals(gainType)) {
            return new QFilter("period", "=", (Object)this.costComAnalyzeRptParam.getPeriodId());
        }
        QFilter periodFilter = StartCostHelper.getPeriodTypeFilter((String)"sca", (Long)this.costComAnalyzeRptParam.getOrg(), (Long)this.costComAnalyzeRptParam.getCostAccountId());
        int periodyear = this.costComAnalyzeRptParam.getPeriodYear();
        int periodnumber = this.costComAnalyzeRptParam.getPeriodNumber();
        if (PRE_PERIOD.equals(gainType)) {
            DynamicObject previousPeriod = PeriodHelper.getPreviousPeriod((Object)this.costComAnalyzeRptParam.getPeriodId());
            periodFilter.and(new QFilter("id", "=", (Object)(previousPeriod == null ? -1L : previousPeriod.getLong("id"))));
        }
        if (PRE_YEAR.equals(gainType)) {
            periodFilter.and(new QFilter("periodyear", "=", (Object)(periodyear - 1 < 0 ? -1 : periodyear - 1)));
            periodFilter.and(new QFilter("periodnumber", "=", (Object)periodnumber));
        }
        if (CUR_ALL_PERIOD.equals(gainType)) {
            ArrayList<Integer> periodnums = new ArrayList<Integer>(10);
            for (int i = 1; i <= periodnumber; ++i) {
                periodnums.add(i);
            }
            periodFilter.and(new QFilter("periodyear", "=", (Object)periodyear));
            periodFilter.and(new QFilter("periodnumber", "in", periodnums));
        }
        if (PRE_ALL_PERIOD.equals(gainType)) {
            periodFilter.and(new QFilter("periodyear", "=", (Object)(periodyear - 1)));
        }
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray());
        HashSet set = new HashSet();
        periods.forEach(p -> set.add(p.getLong("id")));
        return new QFilter("period", "in", set);
    }
}

