/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costcomanalyze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.report.queryplugin.costcomanalyze.CostComAnalyzeRptParam;

public class DealMaterialGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8889163174115271632L;
    private RowMeta srcMeta;
    private CostComAnalyzeRptParam costComAnalyzeRptParam;

    public DealMaterialGroupFunction(RowMeta rowMeta, CostComAnalyzeRptParam costComAnalyzeRptParam) {
        this.srcMeta = rowMeta;
        this.costComAnalyzeRptParam = costComAnalyzeRptParam;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        String key;
        Long auxpty;
        Long tracknumber;
        Long configuredcode;
        Long material;
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        ArrayList<RowX> resultRows = new ArrayList<RowX>(10);
        HashSet<Long> matIds = new HashSet<Long>(16);
        int materialIndex = this.srcMeta.getFieldIndex("material");
        int materialnumIndex = this.srcMeta.getFieldIndex("materialnum");
        int configuredcodeIndex = this.srcMeta.getFieldIndex("configuredcode");
        int tracknumberIndex = this.srcMeta.getFieldIndex("tracknumber");
        int auxptyIndex = this.srcMeta.getFieldIndex("auxpty");
        int submaterialIndex = this.srcMeta.getFieldIndex("submaterial");
        int groupIndex = this.srcMeta.getFieldIndex("group");
        int groupnumIndex = this.srcMeta.getFieldIndex("groupnum");
        HashSet<String> existGroupMats = new HashSet<String>(200);
        for (RowX rowX : iterable) {
            targetRows.add(rowX);
            Long subMatId = rowX.getLong(submaterialIndex);
            if (CadEmptyUtils.isEmpty((Long)subMatId)) continue;
            matIds.add(subMatId);
        }
        Map<String, String> matGroupInfo = this.getMatGroupInfo(this.costComAnalyzeRptParam.getMaterialGrpStd(), matIds);
        for (RowX rowX : targetRows) {
            Long group;
            material = rowX.getLong(materialIndex);
            configuredcode = rowX.getLong(configuredcodeIndex);
            tracknumber = rowX.getLong(tracknumberIndex);
            auxpty = rowX.getLong(auxptyIndex);
            key = material + "@" + configuredcode + "@" + tracknumber + "@" + auxpty;
            Long subMaterial = rowX.getLong(submaterialIndex);
            if (!CadEmptyUtils.isEmpty((Long)subMaterial)) {
                String groupInfo = matGroupInfo.get(String.valueOf(subMaterial));
                if (!CadEmptyUtils.isEmpty((String)groupInfo)) {
                    String[] split = groupInfo.split("@");
                    rowX.set(groupIndex, (Object)split[0]);
                    rowX.set(groupnumIndex, (Object)split[1]);
                } else {
                    rowX.set(groupIndex, (Object)0L);
                    rowX.set(groupnumIndex, (Object)"");
                }
            }
            if (!CadEmptyUtils.isEmpty((Long)(group = rowX.getLong(groupIndex)))) {
                existGroupMats.add(key);
            }
            resultRows.add(rowX);
        }
        for (RowX rowX : resultRows) {
            material = rowX.getLong(materialIndex);
            configuredcode = rowX.getLong(configuredcodeIndex);
            tracknumber = rowX.getLong(tracknumberIndex);
            auxpty = rowX.getLong(auxptyIndex);
            key = material + "@" + configuredcode + "@" + tracknumber + "@" + auxpty;
            if (!existGroupMats.contains(key)) continue;
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    private Map<String, String> getMatGroupInfo(Long group, Set<Long> matIds) {
        HashMap<String, String> mainMatGroupMap = new HashMap<String, String>(16);
        if (CadEmptyUtils.isEmpty(matIds)) {
            return mainMatGroupMap;
        }
        QFilter filter = new QFilter("standard", "=", (Object)group);
        filter.and(new QFilter("material", "in", matIds));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"material,group as materialgroup,group.number as materialgroupnumber", (QFilter[])filter.toArray(), (String)"group desc");
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            String material = row.getString("material");
            Long materialGroup = row.getLong("materialgroup");
            String materialGroupNumber = row.getString("materialgroupnumber");
            if (mainMatGroupMap.containsKey(material)) continue;
            mainMatGroupMap.put(material, materialGroup + "@" + materialGroupNumber);
        }
        return mainMatGroupMap;
    }
}

