/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costcomanalyze;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.report.queryplugin.costcomanalyze.CostComAnalyzeRptParam;

public class DealQtyPriceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8889163174115273970L;
    private RowMeta srcMeta;
    private CostComAnalyzeRptParam costComAnalyzeRptParam;

    public DealQtyPriceFunction(RowMeta rowMeta, CostComAnalyzeRptParam costComAnalyzeRptParam) {
        this.srcMeta = rowMeta;
        this.costComAnalyzeRptParam = costComAnalyzeRptParam;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        int materialIndex = this.srcMeta.getFieldIndex("material");
        int configuredcodeIndex = this.srcMeta.getFieldIndex("configuredcode");
        int tracknumberIndex = this.srcMeta.getFieldIndex("tracknumber");
        int auxptyIndex = this.srcMeta.getFieldIndex("auxpty");
        int curqtyIndex = this.srcMeta.getFieldIndex("curqty");
        int cursumqtyIndex = this.srcMeta.getFieldIndex("cursumqty");
        int curpriceIndex = this.srcMeta.getFieldIndex("curprice");
        int curamtIndex = this.srcMeta.getFieldIndex("curamt");
        int cursumamtIndex = this.srcMeta.getFieldIndex("cursumamt");
        int preqtyIndex = this.srcMeta.getFieldIndex("preqty");
        int presumqtyIndex = this.srcMeta.getFieldIndex("presumqty");
        int prepriceIndex = this.srcMeta.getFieldIndex("preprice");
        int preamtIndex = this.srcMeta.getFieldIndex("preamt");
        int presumamtIndex = this.srcMeta.getFieldIndex("presumamt");
        int preyearqtyIndex = this.srcMeta.getFieldIndex("preyearqty");
        int preyearsumqtyIndex = this.srcMeta.getFieldIndex("preyearsumqty");
        int preyearpriceIndex = this.srcMeta.getFieldIndex("preyearprice");
        int preyearamtIndex = this.srcMeta.getFieldIndex("preyearamt");
        int preyearsumamtIndex = this.srcMeta.getFieldIndex("preyearsumamt");
        int curyearallqtyIndex = this.srcMeta.getFieldIndex("curyearallqty");
        int curyearallsumqtyIndex = this.srcMeta.getFieldIndex("curyearallsumqty");
        int curyearallpriceIndex = this.srcMeta.getFieldIndex("curyearallprice");
        int curyearallamtIndex = this.srcMeta.getFieldIndex("curyearallamt");
        int curyearallsumamtIndex = this.srcMeta.getFieldIndex("curyearallsumamt");
        int preyearallqtyIndex = this.srcMeta.getFieldIndex("preyearallqty");
        int preyearallsumqtyIndex = this.srcMeta.getFieldIndex("preyearallsumqty");
        int preyearallpriceIndex = this.srcMeta.getFieldIndex("preyearallprice");
        int preyearallamtIndex = this.srcMeta.getFieldIndex("preyearallamt");
        int preyearallsumamtIndex = this.srcMeta.getFieldIndex("preyearallsumamt");
        int datatypeIndex = this.srcMeta.getFieldIndex("datatype");
        HashMap<String, BigDecimal> mainMateialCurQtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> mainMateialPreQtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> mainMateialPreYearQtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> mainMateialCurYearAllQtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> mainMateialPreYearAllQtyMap = new HashMap<String, BigDecimal>(16);
        int submaterialIndex = -1;
        if (!this.costComAnalyzeRptParam.isOnlyShowGroup().booleanValue()) {
            submaterialIndex = this.srcMeta.getFieldIndex("submaterial");
        }
        HashSet<Long> matIds = new HashSet<Long>(10);
        for (RowX rowX : iterable) {
            String datatype = rowX.getString(datatypeIndex);
            targetRows.add(rowX);
            if (!this.costComAnalyzeRptParam.isOnlyShowGroup().booleanValue()) {
                matIds.add(rowX.getLong(submaterialIndex));
            }
            if (!"1".equals(datatype)) continue;
            Long material = rowX.getLong(materialIndex);
            Long configuredcode = rowX.getLong(configuredcodeIndex);
            Long tracknumber = rowX.getLong(tracknumberIndex);
            Long auxpty = rowX.getLong(auxptyIndex);
            String key = material + "@" + configuredcode + "@" + tracknumber + "@" + auxpty;
            mainMateialCurQtyMap.put(key, this.getBigDcimalNotnull(rowX, cursumqtyIndex));
            mainMateialPreQtyMap.put(key, this.getBigDcimalNotnull(rowX, presumqtyIndex));
            mainMateialPreYearQtyMap.put(key, this.getBigDcimalNotnull(rowX, preyearsumqtyIndex));
            mainMateialCurYearAllQtyMap.put(key, this.getBigDcimalNotnull(rowX, curyearallsumqtyIndex));
            mainMateialPreYearAllQtyMap.put(key, this.getBigDcimalNotnull(rowX, preyearallsumqtyIndex));
        }
        HashMap<Long, Long> matAndBaseUnitMap = new HashMap<Long, Long>(16);
        Map<Long, Integer> matAndPrecision = this.getMatAndPrecision(matIds, matAndBaseUnitMap);
        for (RowX targetRow : targetRows) {
            String datatype = targetRow.getString(datatypeIndex);
            int precision = 10;
            if (!this.costComAnalyzeRptParam.isOnlyShowGroup().booleanValue()) {
                long subMaterial = targetRow.get(submaterialIndex) == null ? 0L : targetRow.getLong(submaterialIndex);
                int n = precision = !CadEmptyUtils.isEmpty((Integer)matAndPrecision.get(subMaterial)) ? matAndPrecision.get(subMaterial) : 10;
            }
            if ("1".equals(datatype)) {
                BigDecimal curSumQty = targetRow.getBigDecimal(cursumqtyIndex);
                BigDecimal curSumAmt = targetRow.getBigDecimal(cursumamtIndex);
                targetRow.set(curqtyIndex, (Object)this.divide(curSumQty, curSumQty, precision));
                targetRow.set(curamtIndex, (Object)this.divide(curSumQty, curSumAmt, precision));
                targetRow.set(curpriceIndex, (Object)this.divide(targetRow.getBigDecimal(curqtyIndex), targetRow.getBigDecimal(curamtIndex), precision));
                BigDecimal preSumQty = targetRow.getBigDecimal(presumqtyIndex);
                BigDecimal preSumAmt = targetRow.getBigDecimal(presumamtIndex);
                targetRow.set(preqtyIndex, (Object)this.divide(preSumQty, preSumQty, precision));
                targetRow.set(preamtIndex, (Object)this.divide(preSumQty, preSumAmt, precision));
                targetRow.set(prepriceIndex, (Object)this.divide(targetRow.getBigDecimal(preqtyIndex), targetRow.getBigDecimal(preamtIndex), precision));
                BigDecimal preYearSumQty = targetRow.getBigDecimal(preyearsumqtyIndex);
                BigDecimal preYearSumAmt = targetRow.getBigDecimal(preyearsumamtIndex);
                targetRow.set(preyearqtyIndex, (Object)this.divide(preYearSumQty, preYearSumQty, precision));
                targetRow.set(preyearamtIndex, (Object)this.divide(preYearSumQty, preYearSumAmt, precision));
                targetRow.set(preyearpriceIndex, (Object)this.divide(targetRow.getBigDecimal(preyearqtyIndex), targetRow.getBigDecimal(preyearamtIndex), precision));
                BigDecimal curYearAllSumQty = targetRow.getBigDecimal(curyearallsumqtyIndex);
                BigDecimal curYearAllSumAmt = targetRow.getBigDecimal(curyearallsumamtIndex);
                targetRow.set(curyearallqtyIndex, (Object)this.divide(curYearAllSumQty, curYearAllSumQty, precision));
                targetRow.set(curyearallamtIndex, (Object)this.divide(curYearAllSumQty, curYearAllSumAmt, precision));
                targetRow.set(curyearallpriceIndex, (Object)this.divide(targetRow.getBigDecimal(curyearallqtyIndex), targetRow.getBigDecimal(curyearallamtIndex), precision));
                BigDecimal preYearAllSumQty = targetRow.getBigDecimal(preyearallsumqtyIndex);
                BigDecimal preYearAllSumAmt = targetRow.getBigDecimal(preyearallsumamtIndex);
                targetRow.set(preyearallqtyIndex, (Object)this.divide(preYearAllSumQty, preYearAllSumQty, precision));
                targetRow.set(preyearallamtIndex, (Object)this.divide(preYearAllSumQty, preYearAllSumAmt, precision));
                targetRow.set(preyearallpriceIndex, (Object)this.divide(targetRow.getBigDecimal(preyearallqtyIndex), targetRow.getBigDecimal(preyearallamtIndex), precision));
                if (!this.costComAnalyzeRptParam.isOnlyShowGroup().booleanValue()) {
                    targetRow.set(this.srcMeta.getFieldIndex("submatunit"), matAndBaseUnitMap.get(targetRow.getLong(materialIndex)));
                }
            } else {
                Long material = targetRow.getLong(materialIndex);
                Long configuredcode = targetRow.getLong(configuredcodeIndex);
                Long tracknumber = targetRow.getLong(tracknumberIndex);
                Long auxpty = targetRow.getLong(auxptyIndex);
                String key = material + "@" + configuredcode + "@" + tracknumber + "@" + auxpty;
                BigDecimal curSumQty = targetRow.getBigDecimal(cursumqtyIndex);
                BigDecimal curSumAmt = targetRow.getBigDecimal(cursumamtIndex);
                targetRow.set(curqtyIndex, (Object)this.divide((BigDecimal)mainMateialCurQtyMap.get(key), curSumQty, precision));
                targetRow.set(curamtIndex, (Object)this.divide((BigDecimal)mainMateialCurQtyMap.get(key), curSumAmt, precision));
                targetRow.set(curpriceIndex, (Object)this.divide(targetRow.getBigDecimal(curqtyIndex), targetRow.getBigDecimal(curamtIndex), precision));
                BigDecimal preSumQty = targetRow.getBigDecimal(presumqtyIndex);
                BigDecimal preSumAmt = targetRow.getBigDecimal(presumamtIndex);
                targetRow.set(preqtyIndex, (Object)this.divide((BigDecimal)mainMateialPreQtyMap.get(key), preSumQty, precision));
                targetRow.set(preamtIndex, (Object)this.divide((BigDecimal)mainMateialPreQtyMap.get(key), preSumAmt, precision));
                targetRow.set(prepriceIndex, (Object)this.divide(targetRow.getBigDecimal(preqtyIndex), targetRow.getBigDecimal(preamtIndex), precision));
                BigDecimal preYearSumQty = targetRow.getBigDecimal(preyearsumqtyIndex);
                BigDecimal preYearSumAmt = targetRow.getBigDecimal(preyearsumamtIndex);
                targetRow.set(preyearqtyIndex, (Object)this.divide((BigDecimal)mainMateialPreYearQtyMap.get(key), preYearSumQty, precision));
                targetRow.set(preyearamtIndex, (Object)this.divide((BigDecimal)mainMateialPreYearQtyMap.get(key), preYearSumAmt, precision));
                targetRow.set(preyearpriceIndex, (Object)this.divide(targetRow.getBigDecimal(preyearqtyIndex), targetRow.getBigDecimal(preyearamtIndex), precision));
                BigDecimal curYearAllSumQty = targetRow.getBigDecimal(curyearallsumqtyIndex);
                BigDecimal curYearAllSumAmt = targetRow.getBigDecimal(curyearallsumamtIndex);
                targetRow.set(curyearallqtyIndex, (Object)this.divide((BigDecimal)mainMateialCurYearAllQtyMap.get(key), curYearAllSumQty, precision));
                targetRow.set(curyearallamtIndex, (Object)this.divide((BigDecimal)mainMateialCurYearAllQtyMap.get(key), curYearAllSumAmt, precision));
                targetRow.set(curyearallpriceIndex, (Object)this.divide(targetRow.getBigDecimal(curyearallqtyIndex), targetRow.getBigDecimal(curyearallamtIndex), precision));
                BigDecimal preYearAllSumQty = targetRow.getBigDecimal(preyearallsumqtyIndex);
                BigDecimal preYearAllSumAmt = targetRow.getBigDecimal(preyearallsumamtIndex);
                targetRow.set(preyearallqtyIndex, (Object)this.divide((BigDecimal)mainMateialPreYearAllQtyMap.get(key), preYearAllSumQty, precision));
                targetRow.set(preyearallamtIndex, (Object)this.divide((BigDecimal)mainMateialPreYearAllQtyMap.get(key), preYearAllSumAmt, precision));
                targetRow.set(preyearallpriceIndex, (Object)this.divide(targetRow.getBigDecimal(preyearallqtyIndex), targetRow.getBigDecimal(preyearallamtIndex), precision));
                if (!this.costComAnalyzeRptParam.isOnlyShowGroup().booleanValue()) {
                    if (!CadEmptyUtils.isEmpty((Long)targetRow.getLong(submaterialIndex))) {
                        targetRow.set(this.srcMeta.getFieldIndex("submatunit"), matAndBaseUnitMap.get(targetRow.getLong(submaterialIndex)));
                    } else {
                        targetRow.set(this.srcMeta.getFieldIndex("submatunit"), matAndBaseUnitMap.get(targetRow.getLong(materialIndex)));
                    }
                }
            }
            collector.collect(targetRow);
        }
    }

    private BigDecimal getBigDcimalNotnull(RowX rowx, int qtyindex) {
        BigDecimal bigDecimal = rowx.getBigDecimal(qtyindex);
        if (bigDecimal == null) {
            bigDecimal = BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    private BigDecimal divide(BigDecimal value1, BigDecimal value2, int precision) {
        if (value1 == null) {
            value1 = BigDecimal.ZERO;
        }
        if (value2 == null) {
            value2 = BigDecimal.ZERO;
        }
        if (value1.compareTo(BigDecimal.ZERO) == 0) {
            return value1;
        }
        return value2.divide(value1, precision, 4);
    }

    private Map<Long, Integer> getMatAndPrecision(Set<Long> matIds, Map<Long, Long> matAndBaseUnitMap) {
        QFilter matFilter = new QFilter("masterid", "in", matIds);
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)"macc.sca.rpt", (String)"bd_material", (String)"masterid as materialid,baseunit as unitid,baseunit.name as unit", (QFilter[])new QFilter[]{matFilter}, null);
        DataSet unitDataSet = QueryServiceHelper.queryDataSet((String)"macc.sca.rpt", (String)"bd_measureunits", (String)"id as unitid,precision", null, null);
        DataSet dataSet = materialDataSet.join(unitDataSet, JoinType.INNER).on("unitid", "unitid").select(new String[]{"materialid", "unitid", "precision"}).finish();
        HashMap<Long, Integer> matAndPrecision = new HashMap<Long, Integer>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            if (!matAndPrecision.containsKey(row.getLong("materialid"))) {
                matAndPrecision.put(row.getLong("materialid"), row.getInteger("precision"));
            }
            if (matAndBaseUnitMap.containsKey(row.getLong("materialid"))) continue;
            matAndBaseUnitMap.put(row.getLong("materialid"), row.getLong("unitid"));
        }
        return matAndPrecision;
    }
}

