/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costcomanalyze;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.report.queryplugin.costcomanalyze.CostComAnalyzeRptParam;

public class DealUnionFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8889163174115273908L;
    private RowMeta srcMeta;
    private CostComAnalyzeRptParam costComAnalyzeRptParam;

    public DealUnionFunction(RowMeta rowMeta, CostComAnalyzeRptParam costComAnalyzeRptParam) {
        this.srcMeta = rowMeta;
        this.costComAnalyzeRptParam = costComAnalyzeRptParam;
    }

    public RowMeta getResultRowMeta() {
        return this.srcMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        String key;
        Long auxpty;
        Long tracknumber;
        Long configuredcode;
        Long material;
        String sourcebill;
        String datasrc;
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        int sourcebillIndex = this.srcMeta.getFieldIndex("sourcebill");
        int datasrcIndex = this.srcMeta.getFieldIndex("datasrc");
        int datatypeIndex = this.srcMeta.getFieldIndex("datatype");
        int manuorgIndex = this.srcMeta.getFieldIndex("manuorg");
        int manuorgnumIndex = this.srcMeta.getFieldIndex("manuorgnum");
        int elementnameIndex = this.srcMeta.getFieldIndex("elementname");
        int subelementnameIndex = this.srcMeta.getFieldIndex("subelementname");
        int groupIndex = this.srcMeta.getFieldIndex("group");
        int groupnumIndex = this.srcMeta.getFieldIndex("groupnum");
        int materialIndex = this.srcMeta.getFieldIndex("material");
        int materialnumIndex = this.srcMeta.getFieldIndex("materialnum");
        int configuredcodeIndex = this.srcMeta.getFieldIndex("configuredcode");
        int tracknumberIndex = this.srcMeta.getFieldIndex("tracknumber");
        int auxptyIndex = this.srcMeta.getFieldIndex("auxpty");
        HashMap<String, String> mainMatGroupMap = new HashMap<String, String>(16);
        HashSet<Long> mainMats = new HashSet<Long>(200);
        HashSet<String> existActualCostMats = new HashSet<String>(200);
        for (RowX rowX : iterable) {
            BigDecimal sumAmt;
            datasrc = rowX.getString(datasrcIndex);
            sourcebill = rowX.getString(sourcebillIndex);
            material = rowX.getLong(materialIndex);
            configuredcode = rowX.getLong(configuredcodeIndex);
            tracknumber = rowX.getLong(tracknumberIndex);
            auxpty = rowX.getLong(auxptyIndex);
            key = material + "@" + configuredcode + "@" + tracknumber + "@" + auxpty;
            if (("cad_calcsimulationresult".equals(sourcebill) || "cad_calceffectiveresult".equals(sourcebill)) && "1".equals(datasrc)) {
                mainMats.add(material);
            }
            if ("sca_diffcalcresult".equals(sourcebill)) {
                if ("5".equals(datasrc)) {
                    if (!mainMatGroupMap.containsKey(key)) {
                        mainMatGroupMap.put(key, rowX.getLong(groupIndex) + "@" + rowX.getString(groupnumIndex));
                    }
                    mainMats.remove(material);
                }
            } else if ("aca_calcresult".equals(sourcebill) && "finalResult".equals(datasrc)) {
                mainMats.add(material);
            }
            if ((sumAmt = rowX.getBigDecimal(this.srcMeta.getFieldIndex("cursumamt"))) != null && sumAmt.compareTo(BigDecimal.ZERO) != 0) {
                existActualCostMats.add(key);
            }
            targetRows.add(rowX);
        }
        if (!CadEmptyUtils.isEmpty(mainMats) && this.costComAnalyzeRptParam.getMaterialGrpStd() == 730148448254487552L) {
            mainMatGroupMap.putAll(this.getMatGroupInfo(this.costComAnalyzeRptParam.getMaterialGrpStd(), mainMats));
        }
        for (RowX rowX : targetRows) {
            datasrc = rowX.getString(datasrcIndex);
            sourcebill = rowX.getString(sourcebillIndex);
            material = rowX.getLong(materialIndex);
            configuredcode = rowX.getLong(configuredcodeIndex);
            tracknumber = rowX.getLong(tracknumberIndex);
            auxpty = rowX.getLong(auxptyIndex);
            key = material + "@" + configuredcode + "@" + tracknumber + "@" + auxpty;
            if (!existActualCostMats.contains(key)) continue;
            if ("cad_calcsimulationresult".equals(sourcebill) || "cad_calceffectiveresult".equals(sourcebill)) {
                if ("1".equals(datasrc)) {
                    rowX.set(datatypeIndex, (Object)"1");
                    rowX.set(elementnameIndex, (Object)ResManager.loadKDString((String)"\u7269\u6599", (String)"DealUnionFunction_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    rowX.set(subelementnameIndex, (Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"DealUnionFunction_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    this.setMainMaterialInfo(rowX, mainMatGroupMap);
                } else {
                    rowX.set(datatypeIndex, (Object)"2");
                }
            }
            if ("sca_diffcalcresult".equals(sourcebill)) {
                if ("5".equals(datasrc)) {
                    rowX.set(datatypeIndex, (Object)"1");
                    rowX.set(elementnameIndex, (Object)ResManager.loadKDString((String)"\u7269\u6599", (String)"DealUnionFunction_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    rowX.set(subelementnameIndex, (Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"DealUnionFunction_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    this.setMainMaterialInfo(rowX, mainMatGroupMap);
                } else {
                    rowX.set(datatypeIndex, (Object)"2");
                }
            }
            if ("aca_calcresult".equals(sourcebill)) {
                if ("finalResult".equals(datasrc)) {
                    rowX.set(datatypeIndex, (Object)"1");
                    rowX.set(elementnameIndex, (Object)ResManager.loadKDString((String)"\u7269\u6599", (String)"DealUnionFunction_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    rowX.set(subelementnameIndex, (Object)ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"DealUnionFunction_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    this.setMainMaterialInfo(rowX, mainMatGroupMap);
                } else {
                    rowX.set(datatypeIndex, (Object)"2");
                }
            }
            rowX.set(manuorgIndex, (Object)this.costComAnalyzeRptParam.getManuOrg());
            rowX.set(manuorgnumIndex, (Object)this.costComAnalyzeRptParam.getManuOrgNum());
            collector.collect(rowX);
        }
    }

    private Map<String, String> getMatGroupInfo(Long group, Set<Long> matIds) {
        HashMap<String, String> mainMatGroupMap = new HashMap<String, String>(16);
        if (CadEmptyUtils.isEmpty(matIds)) {
            return mainMatGroupMap;
        }
        QFilter filter = new QFilter("standard", "=", (Object)group);
        filter.and(new QFilter("material", "in", matIds));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"material,group as materialgroup,group.number as materialgroupnumber", (QFilter[])filter.toArray(), (String)"group desc");
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            String material = row.getString("material");
            Long materialGroup = row.getLong("materialgroup");
            String materialGroupNumber = row.getString("materialgroupnumber");
            if (mainMatGroupMap.containsKey(material)) continue;
            mainMatGroupMap.put(material, materialGroup + "@" + materialGroupNumber);
        }
        return mainMatGroupMap;
    }

    private void setMainMaterialInfo(RowX rowX, Map<String, String> mainMatGroupMap) {
        int materialIndex = this.srcMeta.getFieldIndex("material");
        int materialnumIndex = this.srcMeta.getFieldIndex("materialnum");
        int configuredcodeIndex = this.srcMeta.getFieldIndex("configuredcode");
        int tracknumberIndex = this.srcMeta.getFieldIndex("tracknumber");
        int auxptyIndex = this.srcMeta.getFieldIndex("auxpty");
        int submaterialIndex = this.srcMeta.getFieldIndex("submaterial");
        int submaterialnumIndex = this.srcMeta.getFieldIndex("submaterialnum");
        int subconfiguredcodeIndex = this.srcMeta.getFieldIndex("subconfiguredcode");
        int subtracknumberIndex = this.srcMeta.getFieldIndex("subtracknumber");
        int subauxptyIndex = this.srcMeta.getFieldIndex("subauxpty");
        int groupIndex = this.srcMeta.getFieldIndex("group");
        int groupnumIndex = this.srcMeta.getFieldIndex("groupnum");
        Long material = rowX.getLong(materialIndex);
        String materialNum = rowX.getString(materialnumIndex);
        Long configuredcode = rowX.getLong(configuredcodeIndex);
        Long tracknumber = rowX.getLong(tracknumberIndex);
        Long auxpty = rowX.getLong(auxptyIndex);
        String key = material + "@" + configuredcode + "@" + tracknumber + "@" + auxpty;
        String strs = mainMatGroupMap.get(key);
        if (CadEmptyUtils.isEmpty((String)strs)) {
            key = String.valueOf(material);
            strs = mainMatGroupMap.get(key);
        }
        if (!CadEmptyUtils.isEmpty((String)strs)) {
            String[] split = strs.split("@");
            if (!"null".equals(split[0])) {
                rowX.set(groupIndex, (Object)Long.parseLong(split[0]));
            }
            if (!"null".equals(split[1])) {
                rowX.set(groupnumIndex, (Object)split[1]);
            }
        }
        rowX.set(submaterialIndex, (Object)material);
        rowX.set(submaterialnumIndex, (Object)materialNum);
        rowX.set(subconfiguredcodeIndex, (Object)configuredcode);
        rowX.set(subtracknumberIndex, (Object)tracknumber);
        rowX.set(subauxptyIndex, (Object)auxpty);
    }
}

