/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costcomanalyze;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.costcomanalyze.CostComAnalyzeRptParam;
import kd.macc.cad.report.queryplugin.costcomanalyze.DealMaterialGroupFunction;
import kd.macc.cad.report.queryplugin.costcomanalyze.DealUnionFunction;

public class HandleRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private CostComAnalyzeRptParam costComAnalyzeRptParam;
    private static final String CUR_PERIOD = "0";
    private static final String PRE_PERIOD = "1";
    private static final String PRE_YEAR = "2";
    private static final String CUR_ALL_PERIOD = "3";
    private static final String PRE_ALL_PERIOD = "4";

    public HandleRow(CostComAnalyzeRptParam costComAnalyzeRptParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.costComAnalyzeRptParam = costComAnalyzeRptParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.reduceGroup((GroupReduceFunction)new DealUnionFunction(srcData.getRowMeta(), this.costComAnalyzeRptParam));
        if (this.costComAnalyzeRptParam.isOnlyShowSum().booleanValue()) {
            srcData = srcData.filter("datatype='1'");
        }
        Set groupCols = this.ctx.getShowKeyCols();
        groupCols.remove("period");
        if (this.costComAnalyzeRptParam.isOnlyShowGroup().booleanValue()) {
            groupCols.removeAll(Sets.newHashSet((Object[])new String[]{"submaterial", "submaterialnum", "subconfiguredcode", "subtracknumber", "subauxpty", "submatunit"}));
        }
        DataSetX stdDataSet = srcData.filter("period = 0").groupBy(groupCols.toArray(new String[0])).sum("qty").sum("price").sum("stdprice").addFields(new Field[]{new Field("curqty", (DataType)DataType.BigDecimalType), new Field("cursumqty", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curamt", (DataType)DataType.BigDecimalType), new Field("cursumamt", (DataType)DataType.BigDecimalType), new Field("preqty", (DataType)DataType.BigDecimalType), new Field("presumqty", (DataType)DataType.BigDecimalType), new Field("preprice", (DataType)DataType.BigDecimalType), new Field("preamt", (DataType)DataType.BigDecimalType), new Field("presumamt", (DataType)DataType.BigDecimalType), new Field("preyearqty", (DataType)DataType.BigDecimalType), new Field("preyearsumqty", (DataType)DataType.BigDecimalType), new Field("preyearprice", (DataType)DataType.BigDecimalType), new Field("preyearamt", (DataType)DataType.BigDecimalType), new Field("preyearsumamt", (DataType)DataType.BigDecimalType), new Field("curyearallqty", (DataType)DataType.BigDecimalType), new Field("curyearallsumqty", (DataType)DataType.BigDecimalType), new Field("curyearallprice", (DataType)DataType.BigDecimalType), new Field("curyearallamt", (DataType)DataType.BigDecimalType), new Field("curyearallsumamt", (DataType)DataType.BigDecimalType), new Field("preyearallqty", (DataType)DataType.BigDecimalType), new Field("preyearallsumqty", (DataType)DataType.BigDecimalType), new Field("preyearallprice", (DataType)DataType.BigDecimalType), new Field("preyearallamt", (DataType)DataType.BigDecimalType), new Field("preyearallsumamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX curDataSet = srcData.filter("period = " + this.costComAnalyzeRptParam.getPeriodId()).groupBy(groupCols.toArray(new String[0])).sum("curqty").sum("cursumqty").sum("curprice").sum("curamt").sum("cursumamt").addFields(new Field[]{new Field("qty", (DataType)DataType.BigDecimalType), new Field("price", (DataType)DataType.BigDecimalType), new Field("stdprice", (DataType)DataType.BigDecimalType), new Field("preqty", (DataType)DataType.BigDecimalType), new Field("presumqty", (DataType)DataType.BigDecimalType), new Field("preprice", (DataType)DataType.BigDecimalType), new Field("preamt", (DataType)DataType.BigDecimalType), new Field("presumamt", (DataType)DataType.BigDecimalType), new Field("preyearqty", (DataType)DataType.BigDecimalType), new Field("preyearsumqty", (DataType)DataType.BigDecimalType), new Field("preyearprice", (DataType)DataType.BigDecimalType), new Field("preyearamt", (DataType)DataType.BigDecimalType), new Field("preyearsumamt", (DataType)DataType.BigDecimalType), new Field("curyearallqty", (DataType)DataType.BigDecimalType), new Field("curyearallsumqty", (DataType)DataType.BigDecimalType), new Field("curyearallprice", (DataType)DataType.BigDecimalType), new Field("curyearallamt", (DataType)DataType.BigDecimalType), new Field("curyearallsumamt", (DataType)DataType.BigDecimalType), new Field("preyearallqty", (DataType)DataType.BigDecimalType), new Field("preyearallsumqty", (DataType)DataType.BigDecimalType), new Field("preyearallprice", (DataType)DataType.BigDecimalType), new Field("preyearallamt", (DataType)DataType.BigDecimalType), new Field("preyearallsumamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX preDataSet = srcData.filter("period in (" + String.join((CharSequence)",", this.getPeriodFilter(PRE_PERIOD)) + ")").groupBy(groupCols.toArray(new String[0])).sum("curqty", "preqty").sum("cursumqty", "presumqty").sum("curprice", "preprice").sum("curamt", "preamt").sum("cursumamt", "presumamt").addFields(new Field[]{new Field("qty", (DataType)DataType.BigDecimalType), new Field("price", (DataType)DataType.BigDecimalType), new Field("stdprice", (DataType)DataType.BigDecimalType), new Field("curqty", (DataType)DataType.BigDecimalType), new Field("cursumqty", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curamt", (DataType)DataType.BigDecimalType), new Field("cursumamt", (DataType)DataType.BigDecimalType), new Field("preyearqty", (DataType)DataType.BigDecimalType), new Field("preyearsumqty", (DataType)DataType.BigDecimalType), new Field("preyearprice", (DataType)DataType.BigDecimalType), new Field("preyearamt", (DataType)DataType.BigDecimalType), new Field("preyearsumamt", (DataType)DataType.BigDecimalType), new Field("curyearallqty", (DataType)DataType.BigDecimalType), new Field("curyearallsumqty", (DataType)DataType.BigDecimalType), new Field("curyearallprice", (DataType)DataType.BigDecimalType), new Field("curyearallamt", (DataType)DataType.BigDecimalType), new Field("curyearallsumamt", (DataType)DataType.BigDecimalType), new Field("preyearallqty", (DataType)DataType.BigDecimalType), new Field("preyearallsumqty", (DataType)DataType.BigDecimalType), new Field("preyearallprice", (DataType)DataType.BigDecimalType), new Field("preyearallamt", (DataType)DataType.BigDecimalType), new Field("preyearallsumamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX preYearDataSet = srcData.filter("period in (" + String.join((CharSequence)",", this.getPeriodFilter(PRE_YEAR)) + ")").groupBy(groupCols.toArray(new String[0])).sum("curqty", "preyearqty").sum("cursumqty", "preyearsumqty").sum("curprice", "preyearprice").sum("curamt", "preyearamt").sum("cursumamt", "preyearsumamt").addFields(new Field[]{new Field("qty", (DataType)DataType.BigDecimalType), new Field("price", (DataType)DataType.BigDecimalType), new Field("stdprice", (DataType)DataType.BigDecimalType), new Field("curqty", (DataType)DataType.BigDecimalType), new Field("cursumqty", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curamt", (DataType)DataType.BigDecimalType), new Field("cursumamt", (DataType)DataType.BigDecimalType), new Field("preqty", (DataType)DataType.BigDecimalType), new Field("presumqty", (DataType)DataType.BigDecimalType), new Field("preprice", (DataType)DataType.BigDecimalType), new Field("preamt", (DataType)DataType.BigDecimalType), new Field("presumamt", (DataType)DataType.BigDecimalType), new Field("curyearallqty", (DataType)DataType.BigDecimalType), new Field("curyearallsumqty", (DataType)DataType.BigDecimalType), new Field("curyearallprice", (DataType)DataType.BigDecimalType), new Field("curyearallamt", (DataType)DataType.BigDecimalType), new Field("curyearallsumamt", (DataType)DataType.BigDecimalType), new Field("preyearallqty", (DataType)DataType.BigDecimalType), new Field("preyearallsumqty", (DataType)DataType.BigDecimalType), new Field("preyearallprice", (DataType)DataType.BigDecimalType), new Field("preyearallamt", (DataType)DataType.BigDecimalType), new Field("preyearallsumamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX curYearAllDataSet = srcData.filter("period in (" + String.join((CharSequence)",", this.getPeriodFilter(CUR_ALL_PERIOD)) + ")").groupBy(groupCols.toArray(new String[0])).sum("curqty", "curyearallqty").sum("cursumqty", "curyearallsumqty").sum("curprice", "curyearallprice").sum("curamt", "curyearallamt").sum("cursumamt", "curyearallsumamt").addFields(new Field[]{new Field("qty", (DataType)DataType.BigDecimalType), new Field("price", (DataType)DataType.BigDecimalType), new Field("stdprice", (DataType)DataType.BigDecimalType), new Field("curqty", (DataType)DataType.BigDecimalType), new Field("cursumqty", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curamt", (DataType)DataType.BigDecimalType), new Field("cursumamt", (DataType)DataType.BigDecimalType), new Field("preqty", (DataType)DataType.BigDecimalType), new Field("presumqty", (DataType)DataType.BigDecimalType), new Field("preprice", (DataType)DataType.BigDecimalType), new Field("preamt", (DataType)DataType.BigDecimalType), new Field("presumamt", (DataType)DataType.BigDecimalType), new Field("preyearqty", (DataType)DataType.BigDecimalType), new Field("preyearsumqty", (DataType)DataType.BigDecimalType), new Field("preyearprice", (DataType)DataType.BigDecimalType), new Field("preyearamt", (DataType)DataType.BigDecimalType), new Field("preyearsumamt", (DataType)DataType.BigDecimalType), new Field("preyearallqty", (DataType)DataType.BigDecimalType), new Field("preyearallsumqty", (DataType)DataType.BigDecimalType), new Field("preyearallprice", (DataType)DataType.BigDecimalType), new Field("preyearallamt", (DataType)DataType.BigDecimalType), new Field("preyearallsumamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX preYearAllDataSet = srcData.filter("period in (" + String.join((CharSequence)",", this.getPeriodFilter(PRE_ALL_PERIOD)) + ")").groupBy(groupCols.toArray(new String[0])).sum("curqty", "preyearallqty").sum("cursumqty", "preyearallsumqty").sum("curprice", "preyearallprice").sum("curamt", "preyearallamt").sum("cursumamt", "preyearallsumamt").addFields(new Field[]{new Field("qty", (DataType)DataType.BigDecimalType), new Field("price", (DataType)DataType.BigDecimalType), new Field("stdprice", (DataType)DataType.BigDecimalType), new Field("curqty", (DataType)DataType.BigDecimalType), new Field("cursumqty", (DataType)DataType.BigDecimalType), new Field("curprice", (DataType)DataType.BigDecimalType), new Field("curamt", (DataType)DataType.BigDecimalType), new Field("cursumamt", (DataType)DataType.BigDecimalType), new Field("preqty", (DataType)DataType.BigDecimalType), new Field("presumqty", (DataType)DataType.BigDecimalType), new Field("preprice", (DataType)DataType.BigDecimalType), new Field("preamt", (DataType)DataType.BigDecimalType), new Field("presumamt", (DataType)DataType.BigDecimalType), new Field("preyearqty", (DataType)DataType.BigDecimalType), new Field("preyearsumqty", (DataType)DataType.BigDecimalType), new Field("preyearprice", (DataType)DataType.BigDecimalType), new Field("preyearamt", (DataType)DataType.BigDecimalType), new Field("preyearsumamt", (DataType)DataType.BigDecimalType), new Field("curyearallqty", (DataType)DataType.BigDecimalType), new Field("curyearallsumqty", (DataType)DataType.BigDecimalType), new Field("curyearallprice", (DataType)DataType.BigDecimalType), new Field("curyearallamt", (DataType)DataType.BigDecimalType), new Field("curyearallsumamt", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        DataSetX dataSetX1 = DataSetXHelper.union((DataSetX)stdDataSet, (DataSetX)curDataSet);
        DataSetX dataSetX2 = DataSetXHelper.union((DataSetX)dataSetX1, (DataSetX)preDataSet);
        DataSetX dataSetX3 = DataSetXHelper.union((DataSetX)dataSetX2, (DataSetX)preYearDataSet);
        DataSetX dataSetX4 = DataSetXHelper.union((DataSetX)dataSetX3, (DataSetX)curYearAllDataSet);
        srcData = DataSetXHelper.union((DataSetX)dataSetX4, (DataSetX)preYearAllDataSet);
        if (!CadEmptyUtils.isEmpty((Long)this.costComAnalyzeRptParam.getMaterialGrpStd()) && this.costComAnalyzeRptParam.getMaterialGrpStd() != 730148448254487552L) {
            srcData = srcData.reduceGroup((GroupReduceFunction)new DealMaterialGroupFunction(srcData.getRowMeta(), this.costComAnalyzeRptParam));
        }
        return srcData;
    }

    private Set<String> getPeriodFilter(String gainType) {
        if (CUR_PERIOD.equals(gainType)) {
            return Sets.newHashSet((Object[])new String[]{String.valueOf(this.costComAnalyzeRptParam.getPeriodId())});
        }
        QFilter periodFilter = StartCostHelper.getPeriodTypeFilter((String)"sca", (Long)this.costComAnalyzeRptParam.getOrg(), (Long)this.costComAnalyzeRptParam.getCostAccountId());
        int periodyear = this.costComAnalyzeRptParam.getPeriodYear();
        int periodnumber = this.costComAnalyzeRptParam.getPeriodNumber();
        if (PRE_PERIOD.equals(gainType)) {
            DynamicObject previousPeriod = PeriodHelper.getPreviousPeriod((Object)this.costComAnalyzeRptParam.getPeriodId());
            periodFilter.and(new QFilter("id", "=", (Object)(previousPeriod == null ? -1L : previousPeriod.getLong("id"))));
        }
        if (PRE_YEAR.equals(gainType)) {
            periodFilter.and(new QFilter("periodyear", "=", (Object)(periodyear - 1 < 0 ? -1 : periodyear - 1)));
            periodFilter.and(new QFilter("periodnumber", "=", (Object)periodnumber));
        }
        if (CUR_ALL_PERIOD.equals(gainType)) {
            ArrayList<Integer> periodnums = new ArrayList<Integer>(10);
            for (int i = 1; i <= periodnumber; ++i) {
                periodnums.add(i);
            }
            periodFilter.and(new QFilter("periodyear", "=", (Object)periodyear));
            periodFilter.and(new QFilter("periodnumber", "in", periodnums));
        }
        if (PRE_ALL_PERIOD.equals(gainType)) {
            periodFilter.and(new QFilter("periodyear", "=", (Object)(periodyear - 1)));
        }
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray());
        HashSet<String> set = new HashSet<String>(10);
        periods.forEach(p -> set.add(p.getString("id")));
        if (CadEmptyUtils.isEmpty(set)) {
            set.add(CUR_PERIOD);
        }
        return set;
    }
}

