/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costdetail;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.macc.cad.report.queryplugin.costdetail.CostDetailRptParam;

public class CostCenterTotalFunction
extends GroupReduceFunction {
    private CostDetailRptParam costDetailRptParam;
    private Set<String> showKeyCols;

    public CostCenterTotalFunction(CostDetailRptParam costDetailRptParam, ReportDataCtx ctx) {
        this.costDetailRptParam = costDetailRptParam;
        this.showKeyCols = ctx.getShowKeyCols();
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int amountIndex = this.getSourceRowMeta().getFieldIndex("amount");
        int periodIndex = this.getSourceRowMeta().getFieldIndex("period");
        int costobjectIndex = -1;
        if (this.showKeyCols.contains("costobjectname")) {
            costobjectIndex = this.getSourceRowMeta().getFieldIndex("costobject");
        }
        int costcenterIndex = this.getSourceRowMeta().getFieldIndex("costcenter");
        int costcenternameIndex = this.getSourceRowMeta().getFieldIndex("costcentername");
        int orderbyIndex = this.getSourceRowMeta().getFieldIndex("orderby");
        int currencyIndex = this.getSourceRowMeta().getFieldIndex("currency");
        int linetypeIndex = this.getSourceRowMeta().getFieldIndex("linetype");
        BigDecimal sumAmount = BigDecimal.ZERO;
        RowX smallDiyTotalRow = null;
        for (RowX rowX : iterable) {
            BigDecimal amount = rowX.getBigDecimal(amountIndex);
            if (amount != null) {
                sumAmount = sumAmount.add(amount);
            }
            if (smallDiyTotalRow != null) continue;
            smallDiyTotalRow = new RowX(new Object[this.getResultRowMeta().getFieldCount()]);
            smallDiyTotalRow.set(periodIndex, (Object)rowX.getLong(periodIndex));
            if (this.showKeyCols.contains("costobjectname")) {
                smallDiyTotalRow.set(costobjectIndex, (Object)rowX.getLong(costobjectIndex));
            }
            smallDiyTotalRow.set(costcenterIndex, (Object)rowX.getLong(costcenterIndex));
            smallDiyTotalRow.set(currencyIndex, (Object)this.costDetailRptParam.getCurrencyId());
            smallDiyTotalRow.set(linetypeIndex, (Object)"1");
            smallDiyTotalRow.set(costcenternameIndex, (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CostCenterTotalFunction_0", (String)"macc-cad-report", (Object[])new Object[0]));
            smallDiyTotalRow.set(orderbyIndex, (Object)"1");
        }
        if (smallDiyTotalRow != null) {
            smallDiyTotalRow.set(amountIndex, (Object)sumAmount);
            collector.collect(smallDiyTotalRow);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }
}

