/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costdetail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.report.queryplugin.costdetail.CostDetailRptParam;

public class CostDetailRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulMaterial = (MulBasedataEdit)this.getControl("mulmaterial");
        mulMaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mulCostCenter = (BasedataEdit)this.getControl("mulcostcenter");
        mulCostCenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String selectKeyVal = this.getModel().getDataEntity().getString("showkeycols");
        this.showColSet(selectKeyVal);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<Long> createOrgIds = new ArrayList<Long>(10);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (org != null) {
            createOrgIds.add(org.getLong("id"));
            orgIds.add(org.getLong("id"));
        }
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                qFilters.add(idFilter);
                break;
            }
            case "costaccount": {
                if (CadEmptyUtils.isEmpty(orgIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDetailRpt_2", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter filter = StartCostHelper.getEnabledFilter(orgIds, (String)(this.getView().getFormShowParameter().getAppId() == null ? "sca" : this.getView().getFormShowParameter().getAppId()));
                QFilter isEnabledFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                qFilters.add(filter);
                qFilters.add(isEnabledFilter);
                break;
            }
            case "startperiod": {
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostDetailRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) break;
                QFilter qFilter = this.getPeriodFilter(costAccount);
                qFilters.add(qFilter);
                break;
            }
            case "endperiod": {
                DynamicObject startPer = (DynamicObject)this.getModel().getValue("startperiod");
                if (CadEmptyUtils.isEmpty((DynamicObject)startPer)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u59cb\u671f\u95f4\u201d\u3002", (String)"CostDetailRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter periodFilter = this.getPeriodFilter(costAccount);
                if (periodFilter == null) break;
                periodFilter.and(new QFilter("id", ">=", startPer.get("id")));
                qFilters.add(periodFilter);
                break;
            }
            case "mulcostcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDetailRpt_2", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter[] costCenterFilter = this.getCostCenterFilter();
                qFilters.addAll(Arrays.asList(costCenterFilter));
                break;
            }
            case "mulmaterial": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostDetailRpt_2", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter matOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)org.getLong("id"));
                qFilters.add(matOrgFilter);
                listShowParameter.setF7ClickByFilter(false);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CostDetailRpt_3", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject startPeriod = filter.getDynamicObject("startperiod");
        if (startPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d77\u59cb\u671f\u95f4\u3002", (String)"CostDetailRpt_4", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject endPeriod = filter.getDynamicObject("endperiod");
        if (endPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u622a\u6b62\u671f\u95f4\u3002", (String)"CostDetailRpt_5", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject currency = filter.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ef4\u62a4\u5e01\u79cd\u3002", (String)"CostDetailRpt_6", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        CostDetailRptParam param = this.buildParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(CostDetailRptParam.class.getName(), param);
        return super.verifyQuery(queryParam);
    }

    private CostDetailRptParam buildParam(DynamicObject dataEntity) {
        DynamicObject costAccount;
        CostDetailRptParam param = new CostDetailRptParam();
        String appId = this.getView().getFormShowParameter().getAppId();
        param.setAppNum(appId);
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org != null) {
            param.setOrg(org.getLong("id"));
        }
        if ((costAccount = dataEntity.getDynamicObject("costaccount")) != null) {
            DynamicObject result;
            param.setCostAccountId(costAccount.getLong("id"));
            DynamicObject calpolicy = costAccount.getDynamicObject("calpolicy");
            if (!CadEmptyUtils.isEmpty((DynamicObject)calpolicy) && (result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))})) != null) {
                param.setCurrencyId(result.getLong("currency"));
            }
        }
        DynamicObjectCollection mulcostcenters = dataEntity.getDynamicObjectCollection("mulcostcenter");
        HashSet<Long> costCenterSet = new HashSet<Long>(16);
        for (DynamicObject material : mulcostcenters) {
            DynamicObject matObj = (DynamicObject)material.get("fbasedataid");
            costCenterSet.add(matObj.getLong("masterid"));
        }
        param.setCostCenterIds(costCenterSet);
        DynamicObjectCollection mulmaterials = dataEntity.getDynamicObjectCollection("mulmaterial");
        HashSet<Long> materialSet = new HashSet<Long>(16);
        for (DynamicObject material : mulmaterials) {
            DynamicObject matObj = (DynamicObject)material.get("fbasedataid");
            materialSet.add(matObj.getLong("masterid"));
        }
        param.setMaterialIds(materialSet);
        DynamicObject startPeriod = dataEntity.getDynamicObject("startperiod");
        DynamicObject endPeriod = dataEntity.getDynamicObject("endperiod");
        QFilter periodFilter = this.getPeriodFilter(costAccount);
        if (periodFilter != null) {
            periodFilter.and(new QFilter("id", ">=", startPeriod.get("id")));
            periodFilter.and(new QFilter("id", "<=", endPeriod.get("id")));
            List periodIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])periodFilter.toArray(), (String)"id asc", (int)-1);
            Set periodIdSet = periodIds.stream().map(e -> Long.parseLong(e.toString())).collect(Collectors.toSet());
            param.setPeriodIdSet(new HashSet<Long>(periodIdSet));
        }
        return param;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount(newValue);
                break;
            }
            case "costaccount": {
                this.setOrg();
                this.setCurrency();
                this.setPeriod();
                break;
            }
            case "showkeycols": {
                this.showColSet(newValue);
            }
        }
    }

    private void showColSet(Object newValue) {
        String selectKey = (String)newValue;
        Set<String> selectSet = this.getSelectKeyHashSet(selectKey);
        boolean isneedSelMaterial = false;
        if (!selectSet.contains("materialname") && selectSet.contains("auxpty")) {
            isneedSelMaterial = true;
        }
        if (isneedSelMaterial) {
            selectSet.add("materialname");
            this.setShowCol(selectSet);
        }
        boolean isNeedSelSubMaterial = false;
        if (!selectSet.contains("submaterialname") && selectSet.contains("subauxpty")) {
            isNeedSelSubMaterial = true;
        }
        if (isNeedSelSubMaterial) {
            selectSet.add("submaterialname");
            this.setShowCol(selectSet);
        }
    }

    private void setShowCol(Set<String> selectSet) {
        StringBuilder sb = new StringBuilder();
        for (String field : selectSet) {
            sb.append(field).append(",");
        }
        this.getModel().setValue("showkeycols", (Object)sb.toString());
        this.getView().updateView("showkeycols");
    }

    private Set<String> getSelectKeyHashSet(String selectKey) {
        HashSet<String> selectSet = null;
        if (!StringUtils.isEmpty((String)selectKey)) {
            selectSet = new HashSet<String>(Arrays.asList(selectKey.split(",")));
            selectSet.remove("");
        } else {
            selectSet = new HashSet<String>(10);
        }
        return selectSet;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostDetailRpt_7", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"CostDetailRpt_8", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
    }

    private void init() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = this.getModel().getDataEntity().getDynamicObject("org");
        this.setCostAccount(org);
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("currency", null);
            return;
        }
        Long mainBookId = this.getCostAccountByAccoutOrg(((DynamicObject)org).getLong("id"));
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
            this.getView().updateView("costaccount");
            this.setCurrency();
            this.setPeriod();
            return;
        }
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("startperiod", null);
        this.getModel().setValue("endperiod", null);
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter enable;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE), appNumQF = new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))};
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
        if (result == null || result.size() == 0) {
            return 0L;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return 0L;
    }

    private QFilter getCostAccountF7QFilter(String appNum) {
        List orgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (costAccountIds.size() > 0) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0);
    }

    public void setOrg() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("org", null);
            return;
        }
        this.getModel().setValue("org", (Object)costaccount.getLong("calorg.id"));
    }

    public void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("startperiod", (Object)currentperiod);
            this.getView().updateView("startperiod");
            this.getModel().setValue("endperiod", (Object)currentperiod);
            this.getView().updateView("endperiod");
        }
    }

    protected QFilter getPeriodFilter(DynamicObject costAccount) {
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
            return new QFilter("periodtype", ">", (Object)0L);
        }
        Long costAccountId = costAccount.getLong("id");
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        QFilter qfCostAccount = new QFilter("entryentity.costaccount", "=", (Object)costAccountId);
        DynamicObjectCollection stdCost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype, entryentity.startperiod startperiod", (QFilter[])new QFilter[]{qfAppNum, qfCostAccount});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)stdCost)) {
            return new QFilter("periodtype", ">", (Object)0L);
        }
        Long startperiod = ((DynamicObject)stdCost.get(0)).getLong("startperiod");
        return new QFilter("periodtype", "=", (Object)((DynamicObject)stdCost.get(0)).getLong("periodtype")).and(new QFilter("id", ">=", (Object)startperiod)).and(new QFilter("isadjustperiod", "=", (Object)false));
    }

    private QFilter[] getCostCenterFilter() {
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CollectionUtils.isEmpty((Collection)orgIds)) {
                orgdutyFilter.and(new QFilter("accountorg", "in", (Object)orgIds));
            }
        } else {
            orgdutyFilter.and(new QFilter("accountorg", "=", org.getPkValue()));
        }
        orgdutyFilter.and("enable", "=", (Object)"1");
        return new QFilter[]{orgdutyFilter};
    }
}

