/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costdetail;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.report.queryplugin.costdetail.CostDetailRptParam;
import kd.macc.cad.report.queryplugin.costdetail.DealResultRow;
import kd.macc.cad.report.queryplugin.costdetail.DiyTotalRow;
import kd.macc.cad.report.queryplugin.costdetail.HandleRow;

public class CostDetailRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CostDetailRptSourceCf.class);
    private CostDetailRptParam costDetailRptParam;
    private static final List<String> hideProps = Lists.newArrayList((Object[])new String[]{"period", "costobject", "costcenter", "submaterial", "material", "orderby", "currency", "linetype"});

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.costDetailRptParam = (CostDetailRptParam)ctx.getParam(CostDetailRptParam.class.getName());
        ctx.setShowBlockEntity(false);
        this.configKeyCols(ctx);
    }

    private void configKeyCols(ReportDataCtx ctx) {
        ArrayList groupCols = Lists.newArrayList((Object[])new String[]{"period", "periodname", "orderby", "currency", "linetype"});
        Set showKeyCols = ctx.getShowKeyCols();
        showKeyCols.addAll(groupCols);
        if (showKeyCols.contains("costcentername")) {
            showKeyCols.add("costcenter");
        }
        if (showKeyCols.contains("costobjectname") || showKeyCols.contains("auxpty")) {
            showKeyCols.add("costobject");
            showKeyCols.add("material");
        }
        if (showKeyCols.contains("subauxpty")) {
            showKeyCols.add("submaterial");
        }
        ctx.setShowKeyCols(showKeyCols);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        this.logger.info("\u4fee\u6539\u56fa\u5b9a\u6570\u636e\u5757");
        Iterator<SrcBlockConf> selectBlockOr = blockCollector.iterator();
        String appNum = this.costDetailRptParam.getAppNum();
        while (selectBlockOr.hasNext()) {
            QFilter qtyOrAmountFilter;
            SrcBlockConf blockConf = selectBlockOr.next();
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            if (dataFs == null) {
                dataFs = new QFilter("costaccount", "=", (Object)this.costDetailRptParam.getCostAccountId());
                dataFs.and(new QFilter("period", "in", this.costDetailRptParam.getPeriodIdSet()));
            }
            if ("sca_matalloc".equals(srcEntity)) {
                qtyOrAmountFilter = new QFilter("entryentity.qty", "!=", (Object)0).or(new QFilter("entryentity.amount", "!=", (Object)0));
                dataFs.and(qtyOrAmountFilter);
                if ("sca".equals(appNum)) {
                    if (!CadEmptyUtils.isEmpty(this.costDetailRptParam.getCostCenterIds())) {
                        dataFs.and(new QFilter("costcenter", "in", this.costDetailRptParam.getCostCenterIds()));
                    }
                    if (!CadEmptyUtils.isEmpty(this.costDetailRptParam.getMaterialIds())) {
                        dataFs.and(new QFilter("entryentity.costobejctentry.material", "in", this.costDetailRptParam.getMaterialIds()));
                    }
                } else {
                    selectBlockOr.remove();
                    continue;
                }
            }
            if ("aca_matalloc".equals(srcEntity)) {
                qtyOrAmountFilter = new QFilter("entryentity.qty", "!=", (Object)0).or(new QFilter("entryentity.amount", "!=", (Object)0));
                dataFs.and(qtyOrAmountFilter);
                if ("sca".equals(appNum)) {
                    selectBlockOr.remove();
                    continue;
                }
                if (!CadEmptyUtils.isEmpty(this.costDetailRptParam.getCostCenterIds())) {
                    dataFs.and(new QFilter("costcenter", "in", this.costDetailRptParam.getCostCenterIds()));
                }
                if (!CadEmptyUtils.isEmpty(this.costDetailRptParam.getMaterialIds())) {
                    dataFs.and(new QFilter("entryentity.costobejctentry.material", "in", this.costDetailRptParam.getMaterialIds()));
                }
            }
            if ("cad_mfgfeeallocco".equals(srcEntity)) {
                dataFs.and(new QFilter("entryentity.allocamt", "!=", (Object)0));
                if (!CadEmptyUtils.isEmpty(this.costDetailRptParam.getCostCenterIds())) {
                    dataFs.and(new QFilter("benefcostcenter", "in", this.costDetailRptParam.getCostCenterIds()));
                }
                if (!CadEmptyUtils.isEmpty(this.costDetailRptParam.getMaterialIds())) {
                    dataFs.and(new QFilter("entryentity.material", "in", this.costDetailRptParam.getMaterialIds()));
                }
            }
            if (blockConf.getDataFs() != null) continue;
            blockConf.setDataFs(dataFs);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterUnion\u591a\u4e2a\u6570\u636e\u5757union\u5b8c\u6210\u540e\u6267\u884c\uff0c\u5904\u7406\u6570\u636e\u5757");
        transCollector.add(new HandleRow(ctx));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterAddSumRow\uff0c\u5408\u8ba1\u884c\u5904\u7406");
        transCollector.add(new DiyTotalRow(this.costDetailRptParam, ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new DealResultRow(ctx));
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        super.handleBigtableCols(repoColFilter, ctx);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u5c55\u793a\u5217\u8c03\u6574\u5f00\u59cb");
        for (ReportColumn reportColumn : cols) {
            String fieldKey = reportColumn.getFieldKey();
            if (hideProps.contains(fieldKey)) {
                reportColumn.setHide(true);
            }
            if ("qty".equals(fieldKey)) {
                reportColumn.setZeroShow(false);
                reportColumn.setHideSingleColumnRow(false);
                reportColumn.setFieldType("qty");
                reportColumn.setMeasureUnitField("subunit");
                reportColumn.setNoDisplayScaleZero(false);
            }
            if (!"amount".equals(fieldKey)) continue;
            reportColumn.setZeroShow(false);
            reportColumn.setFieldType("amount");
            reportColumn.setHideSingleColumnRow(false);
            reportColumn.setNoDisplayScaleZero(false);
            reportColumn.setCurrencyField("currency");
        }
        return cols;
    }
}

