/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costdetail;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.report.queryplugin.costdetail.CostCenterTotalFunction;
import kd.macc.cad.report.queryplugin.costdetail.CostDetailRptParam;
import kd.macc.cad.report.queryplugin.costdetail.CostObjectTotalFunction;
import kd.macc.cad.report.queryplugin.costdetail.PeriodTotalFunction;

public class DiyTotalRow
implements IDataXTransform {
    private CostDetailRptParam costDetailRptParam;
    private ReportDataCtx ctx;
    private static final String[] costCenterFields = new String[]{"period", "costcenter"};
    private static final String[] costCenterAndObjectFields = new String[]{"period", "costobject", "costcenter"};

    public DiyTotalRow(CostDetailRptParam costDetailRptParam, ReportDataCtx ctx) {
        this.costDetailRptParam = costDetailRptParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        JobSession currentJob = this.ctx.getCurrentJob();
        DataSetOutput dataSetOutput = new DataSetOutput(srcData.getRowMeta());
        String resultId = dataSetOutput.getId();
        srcData.output((Output)dataSetOutput);
        currentJob.commit(60, TimeUnit.MINUTES);
        DataSet resultDs = currentJob.readDataSet(resultId);
        DataSetInput resultDsInput = new DataSetInput(resultDs);
        srcData = currentJob.fromInput((Input)resultDsInput);
        Set showKeyCols = this.ctx.getShowKeyCols();
        DataSetX costCenterTotalDataSetX = null;
        DataSetX costObjectTotalDataSetX = null;
        if (showKeyCols.contains("costcentername")) {
            costCenterTotalDataSetX = showKeyCols.contains("costobjectname") ? srcData.groupBy(costCenterAndObjectFields).reduceGroup((GroupReduceFunction)new CostCenterTotalFunction(this.costDetailRptParam, this.ctx)) : srcData.groupBy(costCenterFields).reduceGroup((GroupReduceFunction)new CostCenterTotalFunction(this.costDetailRptParam, this.ctx));
        }
        if (showKeyCols.contains("costobjectname")) {
            costObjectTotalDataSetX = srcData.groupBy(new String[]{"period", "costobject"}).reduceGroup((GroupReduceFunction)new CostObjectTotalFunction(this.costDetailRptParam));
        }
        DataSetX periodTotalDataSetX = srcData.groupBy(new String[]{"period"}).reduceGroup((GroupReduceFunction)new PeriodTotalFunction(this.costDetailRptParam));
        srcData = srcData.union(periodTotalDataSetX);
        if (showKeyCols.contains("costcentername")) {
            srcData = srcData.union(costCenterTotalDataSetX);
        }
        if (showKeyCols.contains("costobjectname")) {
            srcData = srcData.union(costObjectTotalDataSetX);
        }
        return srcData;
    }
}

