/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costupdate;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.constants.CostInfoRptParam;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class CostInfoRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mulTargetCostType = (BasedataEdit)this.getControl("multargetcosttype");
        mulTargetCostType.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filterParameter.getQFilters().add(baseDataFilter);
            }
        });
        MulBasedataEdit updateBillNo = (MulBasedataEdit)this.getControl("mulupdatebillno");
        updateBillNo.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = new QFilter("updatestatus", "=", (Object)"Y");
            DynamicObjectCollection mulTarCostType = (DynamicObjectCollection)this.getModel().getValue("multargetcosttype");
            if (mulTarCostType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u6210\u672c\u7c7b\u578b\u3002", (String)"CostInfoRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            HashSet targetIds = new HashSet(mulTarCostType.size());
            mulTarCostType.forEach(s -> targetIds.add(s.getDynamicObject("fbasedataid").getLong("masterid")));
            filter.and("targetcosttype", "in", targetIds);
            DynamicObject srcCostType = (DynamicObject)this.getModel().getValue("srccosttype");
            if (!CadEmptyUtils.isEmpty((DynamicObject)srcCostType)) {
                filter.and("srccosttype", "in", (Object)srcCostType.getLong("id"));
            }
            filterParameter.getQFilters().add(filter);
            filterParameter.setOrderBy("updatetime desc");
        });
        MulBasedataEdit element = (MulBasedataEdit)this.getControl("mulelement");
        element.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = this.getElementQFilter();
            if (filter != null) {
                filterParameter.getQFilters().add(filter);
            }
        });
        MulBasedataEdit subelement = (MulBasedataEdit)this.getControl("mulsubelement");
        subelement.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = this.getSubElementQFilter();
            if (filter != null) {
                filterParameter.getQFilters().add(filter);
            }
        });
        MulBasedataEdit mulconfiguredcode = (MulBasedataEdit)this.getControl("mulconfiguredcode");
        mulconfiguredcode.addBeforeF7SelectListener(evt -> {
            List configCodeIds;
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
            HashSet matIds = new HashSet(16);
            for (DynamicObject material : materials) {
                DynamicObject matObj = (DynamicObject)material.get("fbasedataid");
                materials.forEach(p -> matIds.add(matObj.getLong("masterid")));
            }
            if (!CadEmptyUtils.isEmpty(matIds) && !CadEmptyUtils.isEmpty((List)(configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(matIds)))) {
                filterParameter.getQFilters().add(new QFilter("id", "in", (Object)configCodeIds));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "multargetcosttype": {
                this.setCurrency();
                this.setEffectTime();
                break;
            }
            case "mulupdatebillno": {
                this.setEffectTime();
                break;
            }
            case "mulsubelement": {
                this.setElement();
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection mulTarCostType = (DynamicObjectCollection)this.getModel().getValue("multargetcosttype");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulTarCostType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u76ee\u6807\u6210\u672c\u7c7b\u578b\u3002", (String)"CostInfoRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        CostInfoRptParam param = this.buildParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(CostInfoRptParam.class.getName(), param);
        return super.verifyQuery(queryParam);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.fillHyperLinkData() != null) {
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostInfoRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"CostInfoRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getView().getModel().getDataEntityType().getName(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    private CostInfoRptParam fillHyperLinkData() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam(CostInfoRptParam.class.getName());
        if (!CadEmptyUtils.isEmpty((String)openParamStr)) {
            CostInfoRptParam param = (CostInfoRptParam)SerializationUtils.fromJsonString((String)openParamStr, CostInfoRptParam.class);
            if (!CadEmptyUtils.isEmpty((List)param.getTargetCostTypeIds())) {
                this.getModel().setValue("multargetcosttype", (Object)param.getTargetCostTypeIds().toArray());
                this.getView().updateView("multargetcosttype");
            }
            Object[] basedataIds = param.getUpdateBillIds().toArray();
            this.getModel().setValue("mulupdatebillno", (Object)basedataIds);
            this.getView().updateView("mulupdatebillno");
            return param;
        }
        return null;
    }

    private CostInfoRptParam buildParam(DynamicObject dataEntity) {
        Date endTime;
        DynamicObject srcCostType;
        CostInfoRptParam param = new CostInfoRptParam();
        DynamicObjectCollection mulTarCostType = (DynamicObjectCollection)this.getModel().getValue("multargetcosttype");
        HashSet targetIds = new HashSet(16);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulTarCostType)) {
            mulTarCostType.forEach(s -> targetIds.add(s.getDynamicObject("fbasedataid").getLong("id")));
        }
        this.setMulBaseDataValue(dataEntity, param, "multargetcosttype");
        param.setUpdateIds(CostUpdateHelper.getUpdateIds(targetIds));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            param.setCurrencyPricePrecision(currency.getInt("priceprecision"));
            param.setCurrencyId(Long.valueOf(currency.getLong("id")));
        }
        if ((srcCostType = dataEntity.getDynamicObject("srccosttype")) != null) {
            param.setSrcCostTypeId(Long.valueOf(srcCostType.getLong("id")));
        }
        this.setMulBaseDataValue(dataEntity, param, "mulupdatebillno");
        this.setMulBaseDataValue(dataEntity, param, "mulmaterial");
        this.setMulBaseDataValue(dataEntity, param, "mulconfiguredcode");
        this.setMulBaseDataValue(dataEntity, param, "multracknumber");
        this.setMulBaseDataValue(dataEntity, param, "mulelement");
        this.setMulBaseDataValue(dataEntity, param, "mulsubelement");
        Date startTime = dataEntity.getDate("starttime");
        if (startTime != null) {
            param.setStartTime(startTime);
        }
        if ((endTime = dataEntity.getDate("endtime")) != null) {
            param.setEndTime(DateUtils.getDayEndTime((Date)endTime));
        }
        boolean isShowDetail = dataEntity.getBoolean("isshowdetail");
        param.setShowDetail(isShowDetail);
        boolean isShowDiff = dataEntity.getBoolean("isshowdiff");
        param.setIsShowDiff(isShowDiff);
        boolean isShowLast = dataEntity.getBoolean("isshowlast");
        param.setShowLast(isShowLast);
        return param;
    }

    private void setMulBaseDataValue(DynamicObject dataEntity, CostInfoRptParam param, String propertyName) {
        DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection(propertyName);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)dys)) {
            ArrayList ids = new ArrayList(dys.size());
            dys.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
            switch (propertyName) {
                case "multargetcosttype": {
                    param.setTargetCostTypeIds(ids);
                    break;
                }
                case "mulupdatebillno": {
                    param.setUpdateBillIds(ids);
                    break;
                }
                case "mulmaterial": {
                    param.setMatIds(ids);
                    break;
                }
                case "mulconfiguredcode": {
                    param.setConfiguredCodes(ids);
                    break;
                }
                case "multracknumber": {
                    param.setTrackNumbers(ids);
                    break;
                }
                case "mulelement": {
                    param.setElementIds(ids);
                    break;
                }
                case "mulsubelement": {
                    param.setSubElementIds(ids);
                    break;
                }
            }
        }
    }

    private void setCurrency() {
        DynamicObjectCollection mulTarCostType = (DynamicObjectCollection)this.getModel().getValue("multargetcosttype");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulTarCostType)) {
            return;
        }
        DynamicObject tarCostType = ((DynamicObject)mulTarCostType.get(0)).getDynamicObject("fbasedataid");
        this.getModel().setValue("currency", (Object)tarCostType.getLong("currency.id"));
    }

    private void setElement() {
        QFilter filter = this.getElementQFilter();
        if (filter == null) {
            return;
        }
        Map elementDatas = BusinessDataServiceHelper.loadFromCache((String)"cad_element", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection elements = (DynamicObjectCollection)this.getModel().getValue("mulelement");
        for (Map.Entry elementData : elementDatas.entrySet()) {
            DynamicObject element = elements.addNew();
            element.set("fbasedataid", elementData.getValue());
        }
    }

    private void setEffectTime() {
        DynamicObjectCollection mulTarCostType = (DynamicObjectCollection)this.getModel().getValue("multargetcosttype");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulTarCostType)) {
            return;
        }
        DynamicObjectCollection billnos = (DynamicObjectCollection)this.getModel().getValue("mulupdatebillno");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)billnos)) {
            this.getModel().setValue("starttime", null);
            this.getModel().setValue("endtime", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"effectdate"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"effectdate"});
        DynamicObject tarCostType = ((DynamicObject)mulTarCostType.get(0)).getDynamicObject("fbasedataid");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)tarCostType.getLong("id"));
        if (Boolean.TRUE.equals(isUpdateByPeriod)) {
            List periodIds = CostUpdateHelper.getPeriodIds((Long)tarCostType.getLong("id"));
            if (CadEmptyUtils.isEmpty((List)periodIds) || periodIds.size() < 2) {
                return;
            }
            Long nextPeriodId = (Long)periodIds.get(1);
            Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)nextPeriodId);
            if (dates == null || dates.length != 2) {
                return;
            }
            this.getModel().setValue("starttime", (Object)dates[0]);
            this.getModel().setValue("endtime", (Object)dates[0]);
        } else {
            Date date = TimeServiceHelper.now();
            this.getModel().setValue("starttime", (Object)date);
            this.getModel().setValue("endtime", (Object)date);
        }
    }

    private QFilter getElementQFilter() {
        DynamicObjectCollection subElements = (DynamicObjectCollection)this.getModel().getValue("mulsubelement");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)subElements)) {
            return null;
        }
        HashSet subElementIds = new HashSet(subElements.size());
        subElements.forEach(p -> subElementIds.add(p.getDynamicObject("fbasedataid").getLong("masterid")));
        QFilter[] filters = new QFilter[]{new QFilter("subelement", "in", subElementIds)};
        DynamicObjectCollection elements = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)elements)) {
            return null;
        }
        HashSet elementIds = new HashSet(elements.size());
        elements.forEach(p -> elementIds.add(p.getLong("element")));
        return new QFilter("id", "in", elementIds);
    }

    private QFilter getSubElementQFilter() {
        DynamicObjectCollection elements = (DynamicObjectCollection)this.getModel().getValue("mulelement");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)elements)) {
            return null;
        }
        HashSet types = new HashSet(elements.size());
        elements.forEach(p -> types.add(p.getDynamicObject("fbasedataid").getString("type")));
        if (CadEmptyUtils.isEmpty(types)) {
            return null;
        }
        return new QFilter("type", "in", types);
    }
}

