/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costupdate;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.constants.CostInfoRptParam;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.report.queryplugin.costupdate.CostInfoResultRow;
import kd.macc.cad.report.queryplugin.costupdate.CostInfoRptSumRow;

public class CostInfoRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CostInfoRptSourceCf.class);
    private CostInfoRptParam param;

    public void setupCtx(ReportDataCtx ctx) {
        this.setTarCostType();
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.param = (CostInfoRptParam)ctx.getParam(CostInfoRptParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        block16: for (ReportColumn reportColumn : cols) {
            String caption = reportColumn.getCaption().getLocaleValue();
            if (ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20.\u7f16\u7801", (String)"CostInfoRptSourceCf_0", (String)"macc-cad-report", (Object[])new Object[0]).equals(caption)) {
                reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u7f16\u7801", (String)"CostInfoRptSourceCf_1", (String)"macc-cad-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20.\u7f16\u7801", (String)"CostInfoRptSourceCf_2", (String)"macc-cad-report", (Object[])new Object[0]).equals(caption)) {
                reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7f16\u7801", (String)"CostInfoRptSourceCf_10", (String)"macc-cad-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20.\u540d\u79f0", (String)"CostInfoRptSourceCf_4", (String)"macc-cad-report", (Object[])new Object[0]).equals(caption)) {
                reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u8981\u7d20\u540d\u79f0", (String)"CostInfoRptSourceCf_5", (String)"macc-cad-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20.\u540d\u79f0", (String)"CostInfoRptSourceCf_6", (String)"macc-cad-report", (Object[])new Object[0]).equals(caption)) {
                reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u540d\u79f0", (String)"CostInfoRptSourceCf_7", (String)"macc-cad-report", (Object[])new Object[0])));
            }
            if (ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u5355\u5355\u636e\u7f16\u53f7", (String)"CostInfoRptSourceCf_8", (String)"macc-cad-report", (Object[])new Object[0]).equals(caption)) {
                reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u66f4\u65b0\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7", (String)"CostInfoRptSourceCf_9", (String)"macc-cad-report", (Object[])new Object[0])));
            }
            switch (reportColumn.getFieldKey()) {
                case "oldprice": 
                case "newprice": 
                case "diffprice": {
                    reportColumn.setFieldType("price");
                    reportColumn.setZeroShow(true);
                    reportColumn.setNoDisplayScaleZero(false);
                    reportColumn.setCurrencyField("currency");
                    reportColumn.setScale(this.param.getCurrencyPricePrecision());
                    continue block16;
                }
                case "linetype": {
                    reportColumn.setHide(Boolean.TRUE.booleanValue());
                    continue block16;
                }
                case "establishednumber": {
                    reportColumn.setHide(Boolean.TRUE.booleanValue());
                    continue block16;
                }
                case "element": {
                    reportColumn.setHide(Boolean.TRUE.booleanValue());
                    continue block16;
                }
                case "subelement": {
                    reportColumn.setHide(Boolean.TRUE.booleanValue());
                    continue block16;
                }
            }
            if (this.param.isShowDetail() || !reportColumn.getFieldKey().contains("subelement") && !reportColumn.getFieldKey().contains("element")) continue;
            reportColumn.setHide(true);
        }
        return cols;
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CostInfoRptSumRow(this.param));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new CostInfoResultRow(this.param));
    }

    private List<QFilter> getFixedFilter() {
        Date endTime;
        Date startTime;
        List subElementIds;
        List elementIds;
        List configuredCodes;
        List trackNumbers;
        List matIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        if (!CadEmptyUtils.isEmpty((Long)this.param.getSrcCostTypeId())) {
            filters.add(new QFilter("srccosttype", "=", (Object)this.param.getSrcCostTypeId()));
        }
        ArrayList establishedNumbers = new ArrayList(16);
        List updateBillIds = this.param.getUpdateBillIds();
        if (!CadEmptyUtils.isEmpty((List)updateBillIds)) {
            ArrayList<Long> ids = new ArrayList<Long>(updateBillIds.size());
            DynamicObjectCollection updateBills = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"updatebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)updateBillIds)});
            for (DynamicObject updateBill : updateBills) {
                Long updateBillId = updateBill.getLong("updatebillid");
                if (CadEmptyUtils.isEmpty((Long)updateBillId)) continue;
                ids.add(updateBillId);
            }
            if (!CadEmptyUtils.isEmpty(ids)) {
                DynamicObjectCollection establisheds = QueryServiceHelper.query((String)"cad_costupdateestablished", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                establisheds.forEach(p -> establishedNumbers.add(p.getString("billno")));
                filters.add(new QFilter("establishednumber", "in", establishedNumbers));
            } else {
                filters.add(new QFilter("establishednumber", "=", (Object)"0"));
            }
        }
        if (CadEmptyUtils.isEmpty(establishedNumbers)) {
            filters.add(new QFilter("targetcosttype", "in", (Object)this.param.getTargetCostTypeIds()));
        }
        if (!CadEmptyUtils.isEmpty((List)(matIds = this.param.getMatIds()))) {
            filters.add(new QFilter("material", "in", (Object)matIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(trackNumbers = this.param.getTrackNumbers()))) {
            filters.add(new QFilter("tracknumber", "in", (Object)CostUpdateHelper.getNumberByIds((String)"bd_tracknumber", (List)trackNumbers)));
        }
        if (!CadEmptyUtils.isEmpty((List)(configuredCodes = this.param.getConfiguredCodes()))) {
            filters.add(new QFilter("configuredcode", "in", (Object)CostUpdateHelper.getNumberByIds((String)"bd_configuredcode", (List)configuredCodes)));
        }
        if (!CadEmptyUtils.isEmpty((List)(elementIds = this.param.getElementIds()))) {
            filters.add(new QFilter("element", "in", (Object)elementIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(subElementIds = this.param.getSubElementIds()))) {
            filters.add(new QFilter("subelement", "in", (Object)subElementIds));
        }
        if ((startTime = this.param.getStartTime()) != null) {
            filters.add(new QFilter("effecttime", ">=", (Object)startTime));
        }
        if ((endTime = this.param.getEndTime()) != null) {
            filters.add(new QFilter("effecttime", "<=", (Object)endTime));
        }
        return filters;
    }

    private void setTarCostType() {
        QFilter[] filters = new QFilter[]{new QFilter("targetcosttype", "=", (Object)0L)};
        Object[] establishs = BusinessDataServiceHelper.load((String)"cad_costupdateestablished", (String)"id,targetcosttype", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((Object[])establishs)) {
            return;
        }
        HashSet<Long> establishIds = new HashSet<Long>(establishs.length);
        for (Object establish : establishs) {
            establishIds.add(establish.getLong("id"));
        }
        filters = new QFilter[]{new QFilter("updatestatus", "=", (Object)"Y"), new QFilter("updatebillid", "in", establishIds)};
        DynamicObjectCollection costUpdates = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"targetcosttype,updatebillid", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costUpdates)) {
            return;
        }
        HashMap<Long, Long> idAndCostType = new HashMap<Long, Long>(costUpdates.size());
        for (DynamicObject costUpdate : costUpdates) {
            idAndCostType.put(costUpdate.getLong("updatebillid"), costUpdate.getLong("targetcosttype"));
        }
        ArrayList<Object> establisheds = new ArrayList<Object>(establishs.length);
        for (Object establish : establishs) {
            Long tarCostTypeId = (Long)idAndCostType.get(establish.getLong("id"));
            if (CadEmptyUtils.isEmpty((Long)tarCostTypeId)) continue;
            establish.set("targetcosttype", (Object)tarCostTypeId);
            establisheds.add(establish);
        }
        if (!CadEmptyUtils.isEmpty(establisheds)) {
            SaveServiceHelper.update((DynamicObject[])establisheds.toArray(new DynamicObject[0]));
        }
    }
}

