/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costupdate;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.constants.CostInfoRptParam;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.costupdate.CostInfoRptSumRowFunction;

public class CostInfoRptSumRow
implements IDataXTransform {
    private CostInfoRptParam param;

    public CostInfoRptSumRow(CostInfoRptParam param) {
        this.param = param;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (!CadEmptyUtils.isEmpty((List)this.param.getMatIds())) {
            if (CadEmptyUtils.isEmpty((List)this.param.getConfiguredCodes())) {
                srcData = srcData.filter("configuredcode is null or configuredcode = ''");
            }
            if (CadEmptyUtils.isEmpty((List)this.param.getTrackNumbers())) {
                srcData = srcData.filter("tracknumber is null or tracknumber = ''");
            }
        }
        final Map updateIds = this.param.getUpdateIds();
        srcData = srcData.addFields(new Field[]{new Field("linetype", (DataType)DataType.StringType)}, new Object[]{"0"});
        srcData = srcData.map(new MapFunction(){
            private static final long serialVersionUID = 2708640135576193479L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX rowX) {
                String establishedNo = rowX.getString(this.getSourceRowMeta().getFieldIndex("establishednumber"));
                rowX.set(this.getSourceRowMeta().getFieldIndex("updatebillno"), updateIds.get(establishedNo));
                return rowX;
            }
        });
        DataSetX periodSrcData = srcData.groupBy(new String[]{"targetcosttype", "updatebillno", "material", "configuredcode", "tracknumber", "auxpty"}).reduceGroup((GroupReduceFunction)new CostInfoRptSumRowFunction(srcData.getRowMeta()));
        srcData = DataSetXHelper.union((DataSetX)srcData, (DataSetX)periodSrcData);
        srcData = srcData.orderBy(new String[]{"updatebillno desc", "targetcosttype asc", "srccosttype asc", "material asc", "auxpty asc", "configuredcode asc", "tracknumber asc", "element asc", "subelement asc", "effecttime desc", "linetype desc"});
        return srcData;
    }
}

