/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costupdate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.constants.ProductInfoRptParam;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class ProductInfoRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(evt -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ProductInfoRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = this.getCostAccountQFilter(org.getLong("id"));
            filterParameter.getQFilters().add(filter);
        });
        MulBasedataEdit mulmanuorg = (MulBasedataEdit)this.getControl("mulmanuorg");
        mulmanuorg.addBeforeF7SelectListener(evt -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ProductInfoRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId());
            QFilter filter = new QFilter("id", "in", (Object)manuOrg);
            filterParameter.getQFilters().add(filter);
        });
        MulBasedataEdit mulcostcenter = (MulBasedataEdit)this.getControl("mulcostcenter");
        mulcostcenter.addBeforeF7SelectListener(evt -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ProductInfoRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List permProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId());
            if (OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
                DynamicObjectCollection manuDyCol = this.getModel().getDataEntity().getDynamicObjectCollection("mulmanuorg");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)manuDyCol)) {
                    if (CadEmptyUtils.isEmpty((List)permProOrgsByAccOrg)) {
                        QFilter qf = new QFilter("accountorg", "=", (Object)-1L);
                        filterParameter.getQFilters().add(qf);
                    } else {
                        QFilter costCenterQf = CostCenterHelper.getCostCenterByMultFactory((long)org.getLong("id"), (List)permProOrgsByAccOrg, (String)this.getView().getFormShowParameter().getAppId());
                        filterParameter.getQFilters().add(costCenterQf);
                    }
                } else {
                    List manuOrgIds = manuDyCol.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    QFilter costCenterQf = CostCenterHelper.getCostCenterByMultFactory((long)org.getLong("id"), manuOrgIds, (String)this.getView().getFormShowParameter().getAppId());
                    filterParameter.getQFilters().add(costCenterQf);
                }
            } else {
                QFilter orgQf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                orgQf.and("orgduty", "=", (Object)4L);
                filterParameter.getQFilters().add(orgQf);
            }
        });
        BasedataEdit startperiod = (BasedataEdit)this.getControl("startperiod");
        startperiod.addBeforeF7SelectListener(evt -> {
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (costaccount == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"ProductInfoRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            QFilter filter = this.getPeriodQFilter(costaccount);
            if (filter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u201c\u6210\u672c\u8d26\u7c3f\u201d\u7684\u201c\u6838\u7b97\u653f\u7b56\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"ProductInfoRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObject ePeriod = (DynamicObject)this.getModel().getValue("endperiod");
            if (ePeriod != null) {
                filter.and("id", "<=", (Object)ePeriod.getLong("id"));
            }
            filterParameter.getQFilters().add(filter);
        });
        BasedataEdit endperiod = (BasedataEdit)this.getControl("endperiod");
        endperiod.addBeforeF7SelectListener(evt -> {
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (costaccount == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"ProductInfoRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            QFilter filter = this.getPeriodQFilter(costaccount);
            if (filter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u201c\u6210\u672c\u8d26\u7c3f\u201d\u7684\u201c\u6838\u7b97\u653f\u7b56\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"ProductInfoRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObject sPeriod = (DynamicObject)this.getModel().getValue("startperiod");
            if (sPeriod != null) {
                filter.and("id", ">=", (Object)sPeriod.getLong("id"));
            }
            filterParameter.getQFilters().add(filter);
        });
        MulBasedataEdit mulcostobject = (MulBasedataEdit)this.getControl("mulcostobject");
        mulcostobject.addBeforeF7SelectListener(evt -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"ProductInfoRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = new QFilter("org", "=", org.getPkValue());
            filterParameter.getQFilters().add(filter);
            DynamicObjectCollection costcenters = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostcenter");
            if (!CollectionUtils.isEmpty((Collection)costcenters)) {
                List ids = costcenters.stream().map(p -> p.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter costcenterFilter = new QFilter("costcenter", "in", ids);
                filterParameter.getQFilters().add(costcenterFilter);
            }
        });
        MulBasedataEdit element = (MulBasedataEdit)this.getControl("mulelement");
        element.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = this.getElementQFilter();
            if (filter != null) {
                filterParameter.getQFilters().add(filter);
            }
        });
        MulBasedataEdit subelement = (MulBasedataEdit)this.getControl("mulsubelement");
        subelement.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = this.getSubElementQFilter();
            if (filter != null) {
                filterParameter.getQFilters().add(filter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setOrg();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.fillHyperLinkData() != null) {
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "org": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                this.setCostAccount(org);
                break;
            }
            case "costaccount": {
                DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
                this.changeCostAccount(costAccount);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ProductInfoRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"ProductInfoRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e01\u79cd\u3002", (String)"ProductInfoRptPlugin_6", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject sPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        if (sPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u671f\u95f4\u3002", (String)"ProductInfoRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject ePeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (ePeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ed3\u675f\u671f\u95f4", (String)"ProductInfoRptPlugin_8", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        ProductInfoRptParam param = this.buildParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(ProductInfoRptParam.class.getName(), param);
        return super.verifyQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ProductInfoRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]);
        String caption = this.getView().getFormShowParameter().getCaption();
        String checkType = String.format(ResManager.loadKDString((String)"%s\u67e5\u8be2", (String)"ProductInfoRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]), caption);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getView().getModel().getDataEntityType().getName(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    private ProductInfoRptParam fillHyperLinkData() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam(ProductInfoRptParam.class.getName());
        if (!CadEmptyUtils.isEmpty((String)openParamStr)) {
            ProductInfoRptParam param = (ProductInfoRptParam)SerializationUtils.fromJsonString((String)openParamStr, ProductInfoRptParam.class);
            this.getModel().setValue("org", (Object)param.getOrgId());
            this.getView().updateView("org");
            this.getModel().setValue("costaccount", (Object)param.getCostAccountId());
            this.getView().updateView("costaccount");
            this.changeCostAccount((DynamicObject)this.getModel().getValue("costaccount"));
            this.getModel().setValue("startperiod", (Object)param.getStartPeriodId());
            this.getView().updateView("startperiod");
            this.getModel().setValue("endperiod", (Object)param.getEndPeriodId());
            this.getView().updateView("endperiod");
            Object[] basedataIds = param.getUpdateBillIds().toArray();
            this.getModel().setValue("mulupdatebillno", (Object)basedataIds);
            this.getView().updateView("mulupdatebillno");
            return param;
        }
        return null;
    }

    private ProductInfoRptParam buildParam(DynamicObject dataEntity) {
        ProductInfoRptParam param = new ProductInfoRptParam();
        DynamicObject org = dataEntity.getDynamicObject("org");
        param.setOrgId(Long.valueOf(org.getLong("id")));
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        param.setCostAccountId(Long.valueOf(costAccount.getLong("id")));
        this.setMulBaseDataValue(dataEntity, param, "mulmanuorg");
        this.setMulBaseDataValue(dataEntity, param, "mulcostcenter");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        param.setCurrencyId(Long.valueOf(currency.getLong("id")));
        param.setAmtPrecision(currency.getInt("amtprecision"));
        DynamicObject sPeriod = dataEntity.getDynamicObject("startperiod");
        param.setStartPeriodId(Long.valueOf(sPeriod.getLong("id")));
        DynamicObject ePeriod = dataEntity.getDynamicObject("endperiod");
        param.setEndPeriodId(Long.valueOf(ePeriod.getLong("id")));
        param.setBookDate(dataEntity.getDate("bookdate"));
        this.setMulBaseDataValue(dataEntity, param, "mulupdatebillno");
        param.setBizStatus(dataEntity.getString("bizstatus"));
        this.setMulBaseDataValue(dataEntity, param, "mulcostobject");
        this.setMulBaseDataValue(dataEntity, param, "mulconfiguredcode");
        this.setMulBaseDataValue(dataEntity, param, "multracknumber");
        this.setMulBaseDataValue(dataEntity, param, "mulelement");
        this.setMulBaseDataValue(dataEntity, param, "mulsubelement");
        param.setIsShowDiff(dataEntity.getBoolean("isshowdiff"));
        return param;
    }

    private void setMulBaseDataValue(DynamicObject dataEntity, ProductInfoRptParam param, String propertyName) {
        DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection(propertyName);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)dys)) {
            ArrayList ids = new ArrayList(dys.size());
            dys.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
            switch (propertyName) {
                case "mulmanuorg": {
                    param.setManuOrgIds(ids);
                    break;
                }
                case "mulcostcenter": {
                    param.setCostCenterIds(ids);
                    break;
                }
                case "mulupdatebillno": {
                    param.setUpdateBillIds(ids);
                    break;
                }
                case "mulcostobject": {
                    param.setCostObjectIds(ids);
                    break;
                }
                case "mulconfiguredcode": {
                    param.setConfiguredCodes(ids);
                    break;
                }
                case "multracknumber": {
                    param.setTrackNumbers(ids);
                    break;
                }
                case "mulelement": {
                    param.setElementIds(ids);
                    break;
                }
                case "mulsubelement": {
                    param.setSubElementIds(ids);
                    break;
                }
            }
        }
    }

    private QFilter getPeriodQFilter(DynamicObject costAccount) {
        Long calPolicyId = costAccount.getLong("calpolicy.id");
        if (CadEmptyUtils.isEmpty((Long)calPolicyId)) {
            return null;
        }
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((Object)calPolicyId, (String)"cal_bd_calpolicy");
        if (calPolicy == null) {
            return null;
        }
        return new QFilter("periodtype", "=", (Object)calPolicy.getLong("periodtype.id"));
    }

    private String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void setOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = (DynamicObject)this.getModel().getValue("org");
        this.configManuOrg();
        this.setCostAccount(org);
    }

    private void configManuOrg() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulmanuorg"});
        } else {
            boolean enableMul = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
            if (!enableMul) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulmanuorg"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulmanuorg"});
                this.getModel().setValue("mulmanuorg", null);
            }
        }
    }

    private void setCostAccount(DynamicObject org) {
        if (org == null) {
            return;
        }
        Long mainBookId = OrgHelper.getCostAccountByOrg((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (!CadEmptyUtils.isEmpty((Long)mainBookId)) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getView().updateView("startperiod");
            this.getView().updateView("endperiod");
        }
        this.getView().updateView("costaccount");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.changeCostAccount(costAccount);
    }

    private void changeCostAccount(DynamicObject costAccount) {
        if (costAccount != null) {
            this.getModel().setValue("currency", (Object)CalcRptHelper.getCurrency((DynamicObject)costAccount));
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period != null) {
                this.getModel().setValue("startperiod", (Object)period.getLong("id"));
                this.getModel().setValue("endperiod", (Object)period.getLong("id"));
            }
        } else {
            this.getModel().setValue("currency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
        }
        this.getView().updateView("currency");
        this.getView().updateView("startperiod");
        this.getView().updateView("endperiod");
    }

    private QFilter getCostAccountQFilter(Long orgId) {
        QFilter filter = new QFilter("calorg", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            filter.and(StartCostHelper.getEnabledCostAccountIdsFilter((Long)orgId, (String)this.getView().getFormShowParameter().getAppId()));
        }
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, null);
        HashSet costAccountIds = new HashSet(costAccounts.size());
        costAccounts.forEach(p -> costAccountIds.add(p.getLong("id")));
        if (CadEmptyUtils.isEmpty(costAccountIds)) {
            return new QFilter("id", "=", (Object)0L);
        }
        return new QFilter("id", "in", costAccountIds);
    }

    private QFilter getElementQFilter() {
        DynamicObjectCollection subElements = (DynamicObjectCollection)this.getModel().getValue("mulsubelement");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)subElements)) {
            return null;
        }
        HashSet subElementIds = new HashSet(subElements.size());
        subElements.forEach(p -> subElementIds.add(p.getDynamicObject("fbasedataid").getLong("masterid")));
        QFilter[] filters = new QFilter[]{new QFilter("subelement", "in", subElementIds)};
        DynamicObjectCollection elements = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)elements)) {
            return null;
        }
        HashSet elementIds = new HashSet(elements.size());
        elements.forEach(p -> elementIds.add(p.getLong("element")));
        return new QFilter("id", "in", elementIds);
    }

    private QFilter getSubElementQFilter() {
        DynamicObjectCollection elements = (DynamicObjectCollection)this.getModel().getValue("mulelement");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)elements)) {
            return null;
        }
        HashSet types = new HashSet(elements.size());
        elements.forEach(p -> types.add(p.getDynamicObject("fbasedataid").getString("type")));
        if (CadEmptyUtils.isEmpty(types)) {
            return null;
        }
        return new QFilter("type", "in", types);
    }
}

