/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costupdate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.constants.ProductInfoRptParam;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.report.queryplugin.costupdate.ProductInfoRptSumRow;

public class ProductInfoRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(ProductInfoRptSourceCf.class);
    private ProductInfoRptParam param;

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.param = (ProductInfoRptParam)ctx.getParam(ProductInfoRptParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        for (ReportColumn reportColumn : cols) {
            String fieldKey;
            switch (fieldKey = reportColumn.getFieldKey()) {
                case "oldstdcost": 
                case "newstdcost": 
                case "diff": {
                    reportColumn.setFieldType("amount");
                    reportColumn.setZeroShow(true);
                    reportColumn.setNoDisplayScaleZero(false);
                    reportColumn.setCurrencyField("currency");
                    reportColumn.setScale(this.param.getAmtPrecision());
                    break;
                }
                case "establishednumber": {
                    reportColumn.setHide(Boolean.TRUE.booleanValue());
                    break;
                }
            }
        }
        return cols;
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ProductInfoRptSumRow());
    }

    private List<QFilter> getFixedFilter() {
        List subElementIds;
        List elementIds;
        List configuredCodes;
        List trackNumbers;
        List costObjectIds;
        String bizStatus;
        List updateBillIds;
        List costCenterIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("org", "=", (Object)this.param.getOrgId()));
        filters.add(new QFilter("costaccount", "=", (Object)this.param.getCostAccountId()));
        List manuOrgIds = this.param.getManuOrgIds();
        if (!CadEmptyUtils.isEmpty((List)manuOrgIds)) {
            filters.add(new QFilter("manuorg", "in", (Object)manuOrgIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(costCenterIds = this.param.getCostCenterIds()))) {
            filters.add(new QFilter("costcenter", "in", (Object)costCenterIds));
        }
        filters.add(new QFilter("period", ">=", (Object)this.param.getStartPeriodId()));
        filters.add(new QFilter("period", "<=", (Object)this.param.getEndPeriodId()));
        Date bookDate = this.param.getBookDate();
        if (bookDate != null) {
            filters.add(new QFilter("period.begindate", ">=", (Object)bookDate));
            filters.add(new QFilter("period.enddate", "<=", (Object)bookDate));
        }
        if (!CadEmptyUtils.isEmpty((List)(updateBillIds = this.param.getUpdateBillIds()))) {
            ArrayList<Long> ids = new ArrayList<Long>(updateBillIds.size());
            DynamicObjectCollection updateBills = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"updatebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)updateBillIds)});
            for (DynamicObject updateBill : updateBills) {
                Long updateBillId = updateBill.getLong("updatebillid");
                if (CadEmptyUtils.isEmpty((Long)updateBillId)) continue;
                ids.add(updateBillId);
            }
            if (!CadEmptyUtils.isEmpty(ids)) {
                DynamicObjectCollection establisheds = QueryServiceHelper.query((String)"cad_costupdateestablished", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                ArrayList establishedNumbers = new ArrayList(establisheds.size());
                establisheds.forEach(p -> establishedNumbers.add(p.getString("billno")));
                filters.add(new QFilter("establishednumber", "in", establishedNumbers));
            } else {
                filters.add(new QFilter("establishednumber", "=", (Object)"0"));
            }
        }
        if (!"ALL".equals(bizStatus = this.param.getBizStatus())) {
            filters.add(new QFilter("costobject.bizstatus", "=", (Object)bizStatus));
        }
        if (!CadEmptyUtils.isEmpty((List)(costObjectIds = this.param.getCostObjectIds()))) {
            filters.add(new QFilter("costobject", "in", (Object)costObjectIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(trackNumbers = this.param.getTrackNumbers()))) {
            filters.add(new QFilter("tracknumber", "in", (Object)CostUpdateHelper.getNumberByIds((String)"bd_tracknumber", (List)trackNumbers)));
        }
        if (!CadEmptyUtils.isEmpty((List)(configuredCodes = this.param.getConfiguredCodes()))) {
            filters.add(new QFilter("configuredcode", "in", (Object)CostUpdateHelper.getNumberByIds((String)"bd_configuredcode", (List)configuredCodes)));
        }
        if (!CadEmptyUtils.isEmpty((List)(elementIds = this.param.getElementIds()))) {
            filters.add(new QFilter("element", "in", (Object)elementIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(subElementIds = this.param.getSubElementIds()))) {
            filters.add(new QFilter("subelement", "in", (Object)subElementIds));
        }
        return filters;
    }
}

