/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costupdate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.constants.StorageInfoRptParam;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class StorageInfoRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(evt -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"StorageInfoRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = this.getCostAccountQFilter(org.getLong("id"));
            filterParameter.getQFilters().add(filter);
        });
        MulBasedataEdit mulcalrange = (MulBasedataEdit)this.getControl("mulcalrange");
        mulcalrange.addBeforeF7SelectListener(evt -> {
            DynamicObject account = (DynamicObject)this.getModel().getValue("costaccount");
            if (account == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"StorageInfoRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = new QFilter("costaccount", "=", (Object)account.getLong("id"));
            filterParameter.getQFilters().add(filter);
        });
        BasedataEdit startperiod = (BasedataEdit)this.getControl("startperiod");
        startperiod.addBeforeF7SelectListener(evt -> {
            DynamicObject calpolicy = (DynamicObject)this.getModel().getValue("calpolicy");
            if (calpolicy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"StorageInfoRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            Long periodTypeId = calpolicy.getLong("periodtype.id");
            QFilter filter = new QFilter("periodtype", "=", (Object)periodTypeId);
            DynamicObject ePeriod = (DynamicObject)this.getModel().getValue("endperiod");
            if (ePeriod != null) {
                filter.and("id", "<=", (Object)ePeriod.getLong("id"));
            }
            filterParameter.getQFilters().add(filter);
            filterParameter.getQFilters().add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        BasedataEdit endperiod = (BasedataEdit)this.getControl("endperiod");
        endperiod.addBeforeF7SelectListener(evt -> {
            DynamicObject calpolicy = (DynamicObject)this.getModel().getValue("calpolicy");
            if (calpolicy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"StorageInfoRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            Long periodTypeId = calpolicy.getLong("periodtype.id");
            QFilter filter = new QFilter("periodtype", "=", (Object)periodTypeId);
            DynamicObject sPeriod = (DynamicObject)this.getModel().getValue("startperiod");
            if (sPeriod != null) {
                filter.and("id", ">=", (Object)sPeriod.getLong("id"));
            }
            filterParameter.getQFilters().add(filter);
            filterParameter.getQFilters().add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        MulBasedataEdit mulupdatebillno = (MulBasedataEdit)this.getControl("mulupdatebillno");
        mulupdatebillno.addBeforeF7SelectListener(evt -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"StorageInfoRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            DynamicObject account = (DynamicObject)this.getModel().getValue("costaccount");
            if (account == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"StorageInfoRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            Date date = TimeServiceHelper.now();
            QFilter[] filters = new QFilter[]{new QFilter("calorg", "=", (Object)org.getLong("id")), new QFilter("costaccount", "=", (Object)account.getLong("id")), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filters);
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costTypeOrgs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\u3002", (String)"StorageInfoRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            HashSet tarCostTypeIds = new HashSet(costTypeOrgs.size());
            costTypeOrgs.forEach(p -> tarCostTypeIds.add(p.getLong("costtype")));
            QFilter filter = new QFilter("targetcosttype", "in", tarCostTypeIds);
            DynamicObject sPeriod = (DynamicObject)this.getModel().getValue("startperiod");
            if (sPeriod == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u59cb\u671f\u95f4\u201d\u3002", (String)"StorageInfoRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            filter.and("updatetime", ">=", (Object)sPeriod.getDate("begindate"));
            DynamicObject ePeriod = (DynamicObject)this.getModel().getValue("endperiod");
            if (ePeriod == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u671f\u95f4\u3002", (String)"StorageInfoRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            filter.and("updatetime", "<=", (Object)ePeriod.getDate("enddate"));
            Date bookDate = (Date)this.getModel().getValue("bookdate");
            if (bookDate != null) {
                filter.and("updatetime", ">=", (Object)bookDate);
                filter.and("updatetime", "<=", (Object)DateUtils.getLastSeveralDay((Date)bookDate, (int)1));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setOrg();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.fillHyperLinkData() != null) {
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"StorageInfoRptPlugin_5", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"StorageInfoRptPlugin_12", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getView().getModel().getDataEntityType().getName(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "org": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                this.setCostAccount(org);
                break;
            }
            case "costaccount": {
                DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
                this.changeCostAccount(costAccount);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"StorageInfoRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"StorageInfoRptPlugin_8", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e01\u79cd\u3002", (String)"StorageInfoRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject sPeriod = (DynamicObject)this.getModel().getValue("startperiod");
        if (sPeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u671f\u95f4\u3002", (String)"StorageInfoRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject ePeriod = (DynamicObject)this.getModel().getValue("endperiod");
        if (ePeriod == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7ed3\u675f\u671f\u95f4\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StorageInfoRptPlugin_11", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        StorageInfoRptParam param = this.buildParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(StorageInfoRptParam.class.getName(), param);
        return super.verifyQuery(queryParam);
    }

    private StorageInfoRptParam fillHyperLinkData() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam(StorageInfoRptParam.class.getName());
        if (!CadEmptyUtils.isEmpty((String)openParamStr)) {
            StorageInfoRptParam param = (StorageInfoRptParam)SerializationUtils.fromJsonString((String)openParamStr, StorageInfoRptParam.class);
            this.getModel().setValue("org", (Object)param.getOrgId());
            this.getView().updateView("org");
            this.getModel().setValue("costaccount", (Object)param.getCostAccountId());
            this.getView().updateView("costaccount");
            this.changeCostAccount((DynamicObject)this.getModel().getValue("costaccount"));
            this.getModel().setValue("startperiod", (Object)param.getStartPeriodId());
            this.getView().updateView("startperiod");
            this.getModel().setValue("endperiod", (Object)param.getEndPeriodId());
            this.getView().updateView("endperiod");
            Object[] basedataIds = param.getUpdateBillIds().toArray();
            this.getModel().setValue("mulupdatebillno", (Object)basedataIds);
            this.getView().updateView("mulupdatebillno");
            return param;
        }
        StorageInfoRptParam param = this.getCalcParam(fsp);
        if (param == null) {
            return null;
        }
        this.getModel().setValue("org", (Object)param.getOrgId());
        this.getView().updateView("org");
        this.getModel().setValue("costaccount", (Object)param.getCostAccountId());
        this.getView().updateView("costaccount");
        this.changeCostAccount((DynamicObject)this.getModel().getValue("costaccount"));
        this.getModel().setValue("startperiod", (Object)param.getStartPeriodId());
        this.getView().updateView("startperiod");
        this.getModel().setValue("endperiod", (Object)param.getEndPeriodId());
        this.getView().updateView("endperiod");
        Object[] basedataIds = param.getUpdateBillIds().toArray();
        this.getModel().setValue("mulupdatebillno", (Object)basedataIds);
        this.getView().updateView("mulupdatebillno");
        return param;
    }

    private StorageInfoRptParam getCalcParam(FormShowParameter fsp) {
        Map paramMap = (Map)fsp.getCustomParam("parammap");
        if (CadEmptyUtils.isEmpty((Map)paramMap)) {
            return null;
        }
        Object org = paramMap.get("org");
        Object costAccount = paramMap.get("costaccount");
        Object startPeriod = paramMap.get("startperiod");
        Object endPeriod = paramMap.get("endperiod");
        Object mulUpdateBillno = paramMap.get("mulupdatebillno");
        StorageInfoRptParam param = new StorageInfoRptParam();
        param.setOrgId(Long.valueOf(Long.parseLong(String.valueOf(org))));
        param.setCostAccountId(Long.valueOf(Long.parseLong(String.valueOf(costAccount))));
        param.setStartPeriodId(Long.valueOf(Long.parseLong(String.valueOf(startPeriod))));
        param.setEndPeriodId(Long.valueOf(Long.parseLong(String.valueOf(endPeriod))));
        param.setUpdateBillIds(Collections.singletonList(Long.parseLong(String.valueOf(mulUpdateBillno))));
        return param;
    }

    private StorageInfoRptParam buildParam(DynamicObject dataEntity) {
        StorageInfoRptParam param = new StorageInfoRptParam();
        DynamicObject org = dataEntity.getDynamicObject("org");
        param.setOrgId(Long.valueOf(org.getLong("id")));
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        param.setCostAccountId(Long.valueOf(costAccount.getLong("id")));
        this.setMulBaseDataValue(dataEntity, param, "mulcalrange");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        param.setCurrencyId(Long.valueOf(currency.getLong("id")));
        param.setAmtPrecision(currency.getInt("amtprecision"));
        param.setPricePrecision(currency.getInt("priceprecision"));
        DynamicObject sPeriod = dataEntity.getDynamicObject("startperiod");
        param.setStartDate(sPeriod.getDate("begindate"));
        DynamicObject ePeriod = dataEntity.getDynamicObject("endperiod");
        param.setEndDate(ePeriod.getDate("enddate"));
        param.setBookDate(dataEntity.getDate("bookdate"));
        this.setMulBaseDataValue(dataEntity, param, "mulstorageorgunit");
        this.setMulBaseDataValue(dataEntity, param, "mulwarehousegroup");
        this.setMulBaseDataValue(dataEntity, param, "mulwarehouse");
        this.setMulBaseDataValue(dataEntity, param, "mullocation");
        this.setMulBaseDataValue(dataEntity, param, "mulupdatebillno");
        this.setMulBaseDataValue(dataEntity, param, "mulmaterial");
        this.setMulBaseDataValue(dataEntity, param, "mulconfiguredcode");
        this.setMulBaseDataValue(dataEntity, param, "multracknumber");
        return param;
    }

    private void setMulBaseDataValue(DynamicObject dataEntity, StorageInfoRptParam param, String propertyName) {
        DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection(propertyName);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)dys)) {
            ArrayList ids = new ArrayList(dys.size());
            dys.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
            switch (propertyName) {
                case "mulcalrange": {
                    param.setCalRangeIds(ids);
                    break;
                }
                case "mulstorageorgunit": {
                    param.setStorageOrgUnitIds(ids);
                    break;
                }
                case "mulwarehousegroup": {
                    param.setWarehouseGroupIds(ids);
                    break;
                }
                case "mulwarehouse": {
                    param.setWarehouseIds(ids);
                    break;
                }
                case "mullocation": {
                    param.setLocationIds(ids);
                    break;
                }
                case "mulupdatebillno": {
                    param.setUpdateBillIds(ids);
                    break;
                }
                case "mulmaterial": {
                    param.setMaterialIds(ids);
                    break;
                }
                case "mulconfiguredcode": {
                    param.setConfiguredCodes(ids);
                    break;
                }
                case "multracknumber": {
                    param.setTrackNumbers(ids);
                    break;
                }
            }
        }
    }

    private QFilter getCostAccountQFilter(Long orgId) {
        QFilter filter = new QFilter("calorg", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            filter.and(StartCostHelper.getEnabledCostAccountIdsFilter((Long)orgId, (String)this.getView().getFormShowParameter().getAppId()));
        }
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, null);
        HashSet costAccountIds = new HashSet(costAccounts.size());
        costAccounts.forEach(p -> costAccountIds.add(p.getLong("id")));
        if (CadEmptyUtils.isEmpty(costAccountIds)) {
            return new QFilter("id", "=", (Object)0L);
        }
        return new QFilter("id", "in", costAccountIds);
    }

    private void setOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = (DynamicObject)this.getModel().getValue("org");
        this.setCostAccount(org);
    }

    private void setCostAccount(DynamicObject org) {
        if (org == null) {
            return;
        }
        Long mainBookId = OrgHelper.getCostAccountByOrg((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (!CadEmptyUtils.isEmpty((Long)mainBookId)) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("calsystem", null);
            this.getModel().setValue("calpolicy", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getView().updateView("calsystem");
            this.getView().updateView("calpolicy");
            this.getView().updateView("startperiod");
            this.getView().updateView("endperiod");
        }
        this.getView().updateView("costaccount");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        this.changeCostAccount(costAccount);
    }

    private void changeCostAccount(DynamicObject costAccount) {
        if (costAccount != null) {
            this.getModel().setValue("calsystem", (Object)costAccount.getLong("calsystem.id"));
            this.getModel().setValue("calpolicy", (Object)costAccount.getLong("calpolicy.id"));
            this.getModel().setValue("currency", (Object)CalcRptHelper.getCurrency((DynamicObject)costAccount));
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period != null) {
                this.getModel().setValue("startperiod", (Object)period.getLong("id"));
                this.getModel().setValue("endperiod", (Object)period.getLong("id"));
            }
        } else {
            this.getModel().setValue("calsystem", null);
            this.getModel().setValue("calpolicy", null);
            this.getModel().setValue("currency", null);
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
        }
        this.getView().updateView("calsystem");
        this.getView().updateView("calpolicy");
        this.getView().updateView("currency");
        this.getView().updateView("startperiod");
        this.getView().updateView("endperiod");
    }
}

