/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costupdate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.constants.StorageInfoRptParam;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.report.queryplugin.costupdate.StorageInfoRptSumRow;

public class StorageInfoRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(StorageInfoRptSourceCf.class);
    private StorageInfoRptParam param;

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.param = (StorageInfoRptParam)ctx.getParam(StorageInfoRptParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        for (ReportColumn reportColumn : cols) {
            String fieldKey;
            switch (fieldKey = reportColumn.getFieldKey()) {
                case "oldprice": 
                case "newprice": {
                    reportColumn.setFieldType("price");
                    reportColumn.setZeroShow(true);
                    reportColumn.setNoDisplayScaleZero(false);
                    reportColumn.setCurrencyField("currency");
                    reportColumn.setScale(this.param.getPricePrecision());
                    break;
                }
                case "oldamount": 
                case "newamount": 
                case "costdiff": {
                    reportColumn.setFieldType("amount");
                    reportColumn.setZeroShow(true);
                    reportColumn.setNoDisplayScaleZero(false);
                    reportColumn.setCurrencyField("currency");
                    reportColumn.setScale(this.param.getAmtPrecision());
                    break;
                }
                case "updatebillid": {
                    reportColumn.setHide(Boolean.TRUE.booleanValue());
                    break;
                }
            }
        }
        return cols;
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new StorageInfoRptSumRow());
    }

    private List<QFilter> getFixedFilter() {
        List configuredCodes;
        List trackNumbers;
        List materialIds;
        List updateBillIds;
        List locationIds;
        List warehouseIds;
        List warehouseGroupIds;
        List storageOrgUnitIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("org", "=", (Object)this.param.getOrgId()));
        filters.add(new QFilter("costaccount", "=", (Object)this.param.getCostAccountId()));
        filters.add(new QFilter("currency", "=", (Object)this.param.getCurrencyId()));
        filters.add(new QFilter("entrybookdate", ">=", (Object)this.param.getStartDate()));
        filters.add(new QFilter("entrybookdate", "<=", (Object)this.param.getEndDate()));
        Date bookDate = this.param.getBookDate();
        if (bookDate != null) {
            filters.add(new QFilter("entrybookdate", "=", (Object)bookDate));
        }
        if (!CadEmptyUtils.isEmpty((List)(storageOrgUnitIds = this.param.getStorageOrgUnitIds()))) {
            filters.add(new QFilter("storageorgunit", "in", (Object)storageOrgUnitIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(warehouseGroupIds = this.param.getWarehouseGroupIds()))) {
            filters.add(new QFilter("warehouse.group", "in", (Object)warehouseGroupIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(warehouseIds = this.param.getWarehouseIds()))) {
            filters.add(new QFilter("warehouse", "in", (Object)warehouseIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(locationIds = this.param.getLocationIds()))) {
            filters.add(new QFilter("location", "in", (Object)locationIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(updateBillIds = this.param.getUpdateBillIds()))) {
            filters.add(new QFilter("updatebillid", "in", (Object)updateBillIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(materialIds = this.param.getMaterialIds()))) {
            filters.add(new QFilter("material", "in", (Object)materialIds));
        }
        if (!CadEmptyUtils.isEmpty((List)(trackNumbers = this.param.getTrackNumbers()))) {
            filters.add(new QFilter("tracknumber", "in", (Object)CostUpdateHelper.getNumberByIds((String)"bd_tracknumber", (List)trackNumbers)));
        }
        if (!CadEmptyUtils.isEmpty((List)(configuredCodes = this.param.getConfiguredCodes()))) {
            filters.add(new QFilter("configuredcode", "in", (Object)CostUpdateHelper.getNumberByIds((String)"bd_configuredcode", (List)configuredCodes)));
        }
        return filters;
    }
}

