/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.costupdate;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.costupdate.StorageInfoRptSumRowFunction;

public class StorageInfoRptSumRow
implements IDataXTransform {
    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.addFields(new Field[]{new Field("linetype", (DataType)DataType.StringType)}, new Object[]{"0"});
        srcData = srcData.map(new MapFunction(){
            private static final long serialVersionUID = 9141043308883719186L;
            private Map<Long, Long> warehouseGroup = new HashMap<Long, Long>(16);

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX rowX) {
                rowX.set(this.getSourceRowMeta().getFieldIndex("updatebillno"), (Object)rowX.getLong(this.getSourceRowMeta().getFieldIndex("updatebillid")));
                rowX.set(this.getSourceRowMeta().getFieldIndex("warehousegroup"), (Object)this.getWarehousegroupId(rowX.getLong(this.getSourceRowMeta().getFieldIndex("warehouse"))));
                return rowX;
            }

            private Long getWarehousegroupId(Long warehouseId) {
                Long wareGroupId = 0L;
                if (CadEmptyUtils.isEmpty((Long)warehouseId)) {
                    return wareGroupId;
                }
                wareGroupId = this.warehouseGroup.get(warehouseId);
                if (!CadEmptyUtils.isEmpty((Long)wareGroupId)) {
                    return wareGroupId;
                }
                Map warehouses = BusinessDataServiceHelper.loadFromCache((Object[])new Long[]{warehouseId}, (String)"bd_warehouse");
                if (CadEmptyUtils.isEmpty((Map)warehouses)) {
                    return wareGroupId;
                }
                for (Map.Entry warehouse : warehouses.entrySet()) {
                    DynamicObject warehouseDy = (DynamicObject)warehouse.getValue();
                    if (warehouseDy == null) continue;
                    wareGroupId = warehouseDy.getLong("group.id");
                    this.warehouseGroup.put(warehouseId, wareGroupId);
                    return wareGroupId;
                }
                return wareGroupId;
            }
        });
        DataSetX periodSrcData = srcData.groupBy(new String[]{"calperiod", "calrange"}).reduceGroup((GroupReduceFunction)new StorageInfoRptSumRowFunction(srcData.getRowMeta()));
        srcData = DataSetXHelper.union((DataSetX)srcData, (DataSetX)periodSrcData);
        srcData = srcData.orderBy(new String[]{"calperiod", "calrange", "entrybookdate desc", "storageorgunit", "warehousegroup", "warehouse", "location", "updatebillno desc", "material", "element", "subelement"});
        return srcData;
    }
}

