/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.planresourceratecal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.report.queryplugin.planresourceratecal.PlanResourceRateCalRptParam;

public class PlanResourceRateCalRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private Boolean isChangeSubEle = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit planstartperiod = (BasedataEdit)this.getControl("planstartperiod");
        planstartperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit planendperiod = (BasedataEdit)this.getControl("planendperiod");
        planendperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startperiod = (BasedataEdit)this.getControl("startperiod");
        startperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endperiod = (BasedataEdit)this.getControl("endperiod");
        endperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmanuorg = (MulBasedataEdit)this.getControl("mulmanuorg");
        mulmanuorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulcostcentergroup = (MulBasedataEdit)this.getControl("mulcostcentergroup");
        mulcostcentergroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulelement = (MulBasedataEdit)this.getControl("mulelement");
        mulelement.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulcostcenter = (MulBasedataEdit)this.getControl("mulcostcenter");
        mulcostcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulsubelement = (MulBasedataEdit)this.getControl("mulsubelement");
        mulsubelement.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit planscheme = (BasedataEdit)this.getControl("planscheme");
        planscheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ComboEdit calcmethod = (ComboEdit)this.getControl("calcmethod");
        calcmethod.addItemClickListener((ItemClickListener)this);
        ComboEdit planperiodyear = (ComboEdit)this.getControl("planperiodyear");
        planperiodyear.addClickListener((ClickListener)this);
        ComboEdit periodyear = (ComboEdit)this.getControl("periodyear");
        periodyear.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        this.setVisible();
        String calcMethod = this.getModel().getValue("calcmethod").toString();
        boolean periodEnable = "SUMMARY".equals(calcMethod);
        this.getView().setEnable(Boolean.valueOf(periodEnable), new String[]{"startperiod", "endperiod"});
    }

    private void setVisible() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            if (!OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulmanuorg"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulmanuorg"});
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        boolean enableMultiFactory = true;
        if (org != null) {
            enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        }
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                String key = reportColumn.getFieldKey();
                if (enableMultiFactory || !"manuorgnumber".equals(key) && !"manuorgname".equals(key)) continue;
                reportColumn.setHide(true);
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
        }
        this.getView().updateView("reportlistap");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
        this.initPlanScheme();
        this.initPeriodYear();
    }

    private void initPlanScheme() {
        List planSchemeIds;
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (costAccount != null && !CadEmptyUtils.isEmpty((List)(planSchemeIds = PlanFeeAllocHelper.getPlanEnableSchemeList((Long)costAccount.getLong("id"))))) {
            this.getModel().setValue("planscheme", planSchemeIds.get(0));
        }
    }

    private void initPeriodYear() {
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        DynamicObject planScheme = this.getModel().getDataEntity().getDynamicObject("planscheme");
        ComboEdit planYearComboEdit = (ComboEdit)this.getControl("planperiodyear");
        ComboEdit actualYearComboEdit = (ComboEdit)this.getControl("periodyear");
        if (costAccount != null) {
            Set yearSetActual = PeriodHelper.getYearByCostAccount((long)costAccount.getLong("id"));
            if (!CadEmptyUtils.isEmpty((Set)yearSetActual)) {
                ArrayList<Object> items = new ArrayList<Object>(10);
                ArrayList<ValueMapItem> valueItems = new ArrayList<ValueMapItem>(10);
                for (Long year : yearSetActual) {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString(year + ""));
                    comboItem.setValue(year + "");
                    items.add(comboItem);
                    ValueMapItem valueMapItem = new ValueMapItem();
                    valueMapItem.setName(new LocaleString(year + ""));
                    valueMapItem.setValue(year + "");
                    valueItems.add(valueMapItem);
                }
                List comboItems = items.stream().sorted(Comparator.comparing(x -> Integer.parseInt(x.getValue()))).collect(Collectors.toList());
                actualYearComboEdit.setComboItems(comboItems);
                ComboProp actualYearProp = (ComboProp)actualYearComboEdit.getProperty();
                actualYearProp.setComboItems(valueItems);
            } else {
                actualYearComboEdit.setComboItems(null);
            }
            if (planScheme != null) {
                List periodIds = PlanFeeAllocHelper.getAllPeriodsNoSummaryHandle((Long)planScheme.getLong("id"));
                Set yearSet = PeriodHelper.getYearByPeriod((List)periodIds);
                if (!CadEmptyUtils.isEmpty((Set)yearSet)) {
                    ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
                    ArrayList<ValueMapItem> valueItems = new ArrayList<ValueMapItem>(10);
                    for (Long year : yearSet) {
                        ComboItem comboItem = new ComboItem();
                        comboItem.setCaption(new LocaleString(year + ""));
                        comboItem.setValue(year + "");
                        items.add(comboItem);
                        ValueMapItem valueMapItem = new ValueMapItem();
                        valueMapItem.setName(new LocaleString(year + ""));
                        valueMapItem.setValue(year + "");
                        valueItems.add(valueMapItem);
                    }
                    List comboItems = items.stream().sorted(Comparator.comparing(x -> Integer.parseInt(x.getValue()))).collect(Collectors.toList());
                    planYearComboEdit.setComboItems(comboItems);
                    ComboProp planYearProp = (ComboProp)planYearComboEdit.getProperty();
                    planYearProp.setComboItems(valueItems);
                } else {
                    planYearComboEdit.setComboItems(null);
                }
            } else {
                planYearComboEdit.setComboItems(null);
            }
        } else {
            planYearComboEdit.setComboItems(null);
            actualYearComboEdit.setComboItems(null);
        }
    }

    private void changePeriod(String propertyName) {
        DynamicObject planEndPeriod;
        DynamicObject planStartPeriod = this.getModel().getDataEntity().getDynamicObject("planstartperiod");
        if (!this.checkPeriodStartLessEnd(planStartPeriod, planEndPeriod = this.getModel().getDataEntity().getDynamicObject("planendperiod"))) {
            this.getModel().setValue(propertyName, null);
            String errorMsg = ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7ed3\u675f\u671f\u95f4\u3002", (String)"PlanResourceRateCalRpt_7", (String)"macc-cad-report", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        String periodYear = this.getModel().getDataEntity().getString("periodyear");
        if (!CadEmptyUtils.isEmpty((String)periodYear)) {
            DynamicObject period;
            QFilter qFilter;
            Long periodType;
            Long periodnumber;
            if (planStartPeriod != null) {
                periodnumber = planStartPeriod.getLong("periodnumber");
                periodType = planStartPeriod.getLong("periodtype_id");
                qFilter = new QFilter("periodtype", "=", (Object)periodType);
                qFilter.and(new QFilter("periodyear", "=", (Object)Long.parseLong(periodYear)));
                qFilter.and(new QFilter("periodnumber", "=", (Object)periodnumber));
                period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,name", (QFilter[])qFilter.toArray());
                if (period != null) {
                    this.getModel().setValue("startperiod", (Object)period.getLong("id"));
                }
            } else {
                this.getModel().setValue("startperiod", null);
            }
            if (planEndPeriod != null) {
                periodnumber = planEndPeriod.getLong("periodnumber");
                periodType = planEndPeriod.getLong("periodtype_id");
                qFilter = new QFilter("periodtype", "=", (Object)periodType);
                qFilter.and(new QFilter("periodyear", "=", (Object)Long.parseLong(periodYear)));
                qFilter.and(new QFilter("periodnumber", "=", (Object)periodnumber));
                period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,name", (QFilter[])qFilter.toArray());
                if (period != null) {
                    this.getModel().setValue("endperiod", (Object)period.getLong("id"));
                }
            } else {
                this.getModel().setValue("endperiod", null);
            }
        }
    }

    private void initPeriodComboItem(ComboEdit periodComboEdit, Set<Long> monthSet) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (Long month : monthSet) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(month + ""));
            comboItem.setValue(month + "");
            items.add(comboItem);
        }
        List comboItems = items.stream().sorted(Comparator.comparing(x -> Integer.parseInt(x.getValue()))).collect(Collectors.toList());
        periodComboEdit.setComboItems(comboItems);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        String planPeriodYear = this.getModel().getDataEntity().getString("planperiodyear");
        String periodYear = this.getModel().getDataEntity().getString("periodyear");
        switch (itemKey = ((Control)evt.getSource()).getKey()) {
            case "planperiodyear": 
            case "actualperiodyear": {
                if (costAccount != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanResourceRateCalRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "planstartperiod": 
            case "planendperiod": {
                if (!CadEmptyUtils.isEmpty((String)planPeriodYear)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u5e74\u5ea6\uff08\u8ba1\u5212\uff09\u3002", (String)"PlanResourceRateCalRpt_8", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "startperiod": 
            case "endperiod": {
                if (!CadEmptyUtils.isEmpty((String)periodYear)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u5e74\u5ea6\uff08\u5b9e\u9645\uff09\u3002", (String)"PlanResourceRateCalRpt_9", (String)"macc-cad-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<Long> createOrgIds = new ArrayList<Long>(10);
        if (org != null) {
            createOrgIds.add(org.getLong("id"));
        }
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        DynamicObject periodType = null;
        if (costAccount != null) {
            periodType = PeriodHelper.getCurrentPeriodType((Long)costAccount.getLong("id"));
        }
        DynamicObject planScheme = this.getModel().getDataEntity().getDynamicObject("planscheme");
        DynamicObjectCollection mulmanuorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulmanuorg");
        DynamicObjectCollection mulCostCenterGroup = this.getModel().getDataEntity().getDynamicObjectCollection("mulcostcentergroup");
        DynamicObjectCollection mulElement = this.getModel().getDataEntity().getDynamicObjectCollection("mulelement");
        String planPeriodYear = this.getModel().getDataEntity().getString("planperiodyear");
        String planstartperiod = this.getModel().getDataEntity().getString("planstartperiod");
        String periodYear = this.getModel().getDataEntity().getString("periodyear");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                qFilters.add(idFilter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanResourceRateCalRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                qFilters.add(this.getCostAccountF7QFilter(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
                break;
            }
            case "mulmanuorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanResourceRateCalRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
                break;
            }
            case "mulcostcentergroup": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanResourceRateCalRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Long acctOrgId = org.getLong("id");
                qFilters.add(new QFilter("org", "=", (Object)acctOrgId));
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmanuorg)) {
                    List manuOrgIds = mulmanuorg.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
                    QFilter manuOrgFilter = new QFilter("manuorg", "in", manuOrgIds);
                    qFilters.add(manuOrgFilter);
                }
                Date date = new Date();
                QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
                dateFilter.and("expdate", ">", (Object)date);
                qFilters.add(dateFilter);
                break;
            }
            case "mulcostcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanResourceRateCalRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                qFilters.add(calorgsFilter);
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmanuorg)) {
                    List manuOrgList = mulmanuorg.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
                    Iterator costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)org.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
                    qFilters.add(costCenterIdFilter);
                }
                if (mulCostCenterGroup != null && mulCostCenterGroup.size() > 0) {
                    ArrayList<Long> costCenterGroupIds = new ArrayList<Long>(10);
                    for (DynamicObject dynamicObject2 : mulCostCenterGroup) {
                        costCenterGroupIds.add(dynamicObject2.getLong("fbasedataid_id"));
                    }
                    QFilter costGroupFilter = new QFilter("id", "in", costCenterGroupIds);
                    DynamicObjectCollection cosCenter = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"entryentity.costcenter coscenterid", (QFilter[])new QFilter[]{costGroupFilter});
                    if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)cosCenter)) {
                        Set cosCenterId = cosCenter.stream().map(dynamicObject -> dynamicObject.getLong("coscenterid")).collect(Collectors.toSet());
                        QFilter manuOrgFilter = new QFilter("id", "in", cosCenterId);
                        qFilters.add(manuOrgFilter);
                    } else {
                        qFilters.add(QFilter.of((String)"1=0", (Object[])new Object[0]));
                    }
                }
                qFilters.add(new QFilter("orgduty", "=", (Object)4));
                break;
            }
            case "mulelement": {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("type", "in", (Object)new String[]{"001", "002", "003", "004"}));
                break;
            }
            case "mulsubelement": {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulElement)) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("type", "in", (Object)new String[]{"001", "002", "003", "004"}));
                    return;
                }
                if (mulElement == null || mulElement.size() <= 0) break;
                ArrayList<String> elementTypes = new ArrayList<String>(10);
                for (DynamicObject dynamicObject3 : mulElement) {
                    elementTypes.add(dynamicObject3.getString("fbasedataid.type"));
                }
                QFilter elementTypeFilter = new QFilter("type", "in", elementTypes);
                qFilters.add(elementTypeFilter);
                break;
            }
            case "planscheme": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"PlanResourceRateCalRpt_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (costAccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanResourceRateCalRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                orgFilter.and(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
                listShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
                break;
            }
            case "planstartperiod": 
            case "planendperiod": {
                if (CadEmptyUtils.isEmpty((String)planPeriodYear)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u5e74\u5ea6\uff08\u8ba1\u5212\uff09\u3002", (String)"PlanResourceRateCalRpt_8", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (costAccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanResourceRateCalRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter("periodtype", "=", (Object)periodType.getLong("id")));
                qFilters.add(new QFilter("periodyear", "=", (Object)Long.parseLong(planPeriodYear)));
                QFilter idQf = new QFilter("id", "in", (Object)PlanFeeAllocHelper.getAllPeriodsNoSummaryHandle((Long)planScheme.getLong("id")));
                qFilters.add(idQf);
                break;
            }
            case "startperiod": 
            case "endperiod": {
                if (CadEmptyUtils.isEmpty((String)periodYear)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u5e74\u5ea6\uff08\u5b9e\u9645\uff09\u3002", (String)"PlanResourceRateCalRpt_9", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (costAccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanResourceRateCalRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                qFilters.add(new QFilter("periodtype", "=", (Object)periodType.getLong("id")));
                qFilters.add(new QFilter("periodyear", "=", (Object)Long.parseLong(periodYear)));
                qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"PlanResourceRateCalRpt_1", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        DynamicObject currency = filter.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ef4\u62a4\u5e01\u522b\u3002", (String)"PlanResourceRateCalRpt_10", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        String planperiodyear = filter.getString("planperiodyear");
        if (CadEmptyUtils.isEmpty((String)planperiodyear)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u5e74\u5ea6\uff08\u8ba1\u5212\uff09\u3002", (String)"PlanResourceRateCalRpt_8", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        String periodyear = filter.getString("periodyear");
        if (CadEmptyUtils.isEmpty((String)periodyear)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u5e74\u5ea6\uff08\u5b9e\u9645\uff09\u3002", (String)"PlanResourceRateCalRpt_9", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        PlanResourceRateCalRptParam param = this.buildParam(this.getModel().getDataEntity());
        this.getQueryParam().getCustomParam().put(PlanResourceRateCalRptParam.class.getName(), param);
        return super.verifyQuery(queryParam);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        } else if (returnDataObj instanceof String) {
            String value = (String)returnDataObj;
            this.getModel().setValue(actionId, (Object)value);
        }
    }

    private PlanResourceRateCalRptParam buildParam(DynamicObject dataEntity) {
        List periods;
        List planPeriods;
        QFilter costGroupFilter;
        DynamicObjectCollection cosCenterCollection;
        DynamicObject planScheme;
        DynamicObject costAccount;
        PlanResourceRateCalRptParam param = new PlanResourceRateCalRptParam();
        String appId = this.getView().getFormShowParameter().getAppId();
        param.setAppNum(appId);
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org != null) {
            param.setOrg(org.getLong("id"));
        }
        if ((costAccount = dataEntity.getDynamicObject("costaccount")) != null) {
            param.setCostAccountId(costAccount.getLong("id"));
        }
        if ((planScheme = dataEntity.getDynamicObject("planscheme")) != null) {
            param.setPlanScheme(planScheme.getLong("id"));
        }
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        param.setCurrencyId(currency.getLong("id"));
        param.setAmtPrecision(currency.getInt("amtprecision"));
        param.setPricePrecision(currency.getInt("priceprecision"));
        DynamicObjectCollection mulmanuorg = this.getModel().getDataEntity().getDynamicObjectCollection("mulmanuorg");
        HashSet<Long> manuOrgSet = new HashSet<Long>(16);
        for (DynamicObject manuOrg : mulmanuorg) {
            Long id = manuOrg.getLong("fbasedataid_id");
            manuOrgSet.add(id);
        }
        param.setManuOrgIds(manuOrgSet);
        DynamicObjectCollection costcentergroup = dataEntity.getDynamicObjectCollection("mulcostcentergroup");
        HashSet<Long> costCenterGroupSet = new HashSet<Long>(16);
        for (DynamicObject group : costcentergroup) {
            Long id = group.getLong("fbasedataid_id");
            costCenterGroupSet.add(id);
        }
        DynamicObjectCollection mulcostcenters = dataEntity.getDynamicObjectCollection("mulcostcenter");
        HashSet<Long> costCenterSet = new HashSet<Long>(10);
        for (DynamicObject material : mulcostcenters) {
            Long id = material.getLong("fbasedataid_id");
            costCenterSet.add(id);
        }
        if (costCenterSet != null && costCenterSet.size() > 0) {
            param.setCostCenterIds(costCenterSet);
        } else if (costCenterGroupSet != null && costCenterGroupSet.size() > 0 && !CadEmptyUtils.isEmpty((DynamicObjectCollection)(cosCenterCollection = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"entryentity.costcenter coscenterid", (QFilter[])new QFilter[]{costGroupFilter = new QFilter("id", "in", costCenterGroupSet)})))) {
            Set<Long> cosCenterId = cosCenterCollection.stream().map(dynamicObject -> dynamicObject.getLong("coscenterid")).collect(Collectors.toSet());
            param.setCostCenterIds(cosCenterId);
        }
        String planPeriodYear = dataEntity.getString("planperiodyear");
        param.setPlanPeriodYear(Integer.parseInt(planPeriodYear));
        DynamicObject planStartPeriod = dataEntity.getDynamicObject("planstartperiod");
        DynamicObject planEndPeriod = dataEntity.getDynamicObject("planendperiod");
        HashSet<Long> planPeriodIds = new HashSet<Long>(10);
        if (planStartPeriod != null && planEndPeriod != null) {
            planPeriods = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)planStartPeriod, (DynamicObject)planEndPeriod);
            planPeriods.forEach(e -> planPeriodIds.add((Long)e));
        } else {
            planPeriods = PeriodHelper.getPeriodByYear((long)costAccount.getLong("id"), (int)Integer.parseInt(planPeriodYear));
            planPeriods.forEach(e -> planPeriodIds.add((Long)e));
        }
        param.setPlanPeriodIds(planPeriodIds);
        String periodYear = dataEntity.getString("periodyear");
        param.setPeriodYear(Integer.parseInt(periodYear));
        DynamicObject startPeriod = dataEntity.getDynamicObject("startperiod");
        DynamicObject endPeriod = dataEntity.getDynamicObject("endperiod");
        HashSet<Long> periodIds = new HashSet<Long>(10);
        if (startPeriod != null && endPeriod != null) {
            periods = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
            periods.forEach(e -> periodIds.add((Long)e));
        } else {
            periods = PeriodHelper.getPeriodByYear((long)costAccount.getLong("id"), (int)Integer.parseInt(periodYear));
            periods.forEach(e -> periodIds.add((Long)e));
        }
        param.setPeriodIds(periodIds);
        DynamicObjectCollection mulsubelement = dataEntity.getDynamicObjectCollection("mulsubelement");
        DynamicObjectCollection mulelement = dataEntity.getDynamicObjectCollection("mulelement");
        HashSet<Long> subElementIds = new HashSet<Long>(10);
        if (mulsubelement != null && mulsubelement.size() > 0) {
            for (DynamicObject subElement : mulsubelement) {
                Long id = subElement.getLong("fbasedataid_id");
                subElementIds.add(id);
            }
        } else if (mulelement != null && mulelement.size() > 0) {
            ArrayList<String> elementTypes = new ArrayList<String>(10);
            for (DynamicObject dynamicObject2 : mulelement) {
                elementTypes.add(dynamicObject2.getString("fbasedataid.type"));
            }
            QFilter elementTypeFilter = new QFilter("type", "in", elementTypes);
            DynamicObjectCollection subElement = QueryServiceHelper.query((String)"cad_subelement", (String)"id,number", (QFilter[])elementTypeFilter.toArray());
            if (subElement != null) {
                subElement.forEach(e -> subElementIds.add(e.getLong("id")));
            }
        }
        param.setSubElementIds(subElementIds);
        String calcMethod = dataEntity.getString("calcmethod");
        param.setCalcMethod(calcMethod);
        return param;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "org": {
                this.setVisible();
                this.getModel().setValue("mulmanuorg", null);
                this.getModel().setValue("mulcostcentergroup", null);
                this.getModel().setValue("mulcostcenter", null);
                this.getModel().setValue("planscheme", null);
                this.setCostAccount(newValue);
                this.initPeriodYear();
                break;
            }
            case "costaccount": {
                this.clearTime();
                this.setCurrency();
                this.initPlanScheme();
                this.initPeriodYear();
                break;
            }
            case "planscheme": {
                this.clearTime();
                this.initPeriodYear();
                break;
            }
            case "mulmanuorg": {
                this.getModel().setValue("mulcostcentergroup", null);
                this.getModel().setValue("mulcostcenter", null);
                break;
            }
            case "mulcostcentergroup": {
                this.getModel().setValue("mulcostcenter", null);
                break;
            }
            case "mulelement": {
                if (this.isChangeSubEle.booleanValue()) break;
                this.getModel().setValue("mulsubelement", null);
                break;
            }
            case "mulsubelement": {
                this.isChangeSubEle = Boolean.TRUE;
                this.setElement(newValue);
                break;
            }
            case "planperiodyear": {
                this.getModel().setValue("planstartperiod", null);
                this.getModel().setValue("planendperiod", null);
                break;
            }
            case "planstartperiod": 
            case "planendperiod": 
            case "periodyear": {
                this.changePeriod(propertyName);
                break;
            }
            case "startperiod": 
            case "endperiod": {
                DynamicObject startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod");
                DynamicObject endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod");
                if (this.checkPeriodStartLessEnd(startPeriod, endPeriod)) break;
                this.getModel().setValue(propertyName, null);
                String errorMsg = ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7ed3\u675f\u671f\u95f4\u3002", (String)"PlanResourceRateCalRpt_7", (String)"macc-cad-report", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            case "calcmethod": {
                String calcMethod = this.getModel().getValue("calcmethod").toString();
                boolean periodEnable = "SUMMARY".equals(calcMethod);
                this.getView().setEnable(Boolean.valueOf(periodEnable), new String[]{"startperiod", "endperiod"});
                this.getView().updateView();
            }
        }
    }

    private void setElement(Object subelement) {
        DynamicObjectCollection mulelement = (DynamicObjectCollection)this.getModel().getValue("mulelement");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulelement)) {
            return;
        }
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)((DynamicObjectCollection)subelement))) {
            return;
        }
        DynamicObjectCollection subelements = (DynamicObjectCollection)subelement;
        HashSet subeleids = new HashSet(16);
        subelements.forEach(p -> subeleids.add(p.getLong("fbasedataid.id")));
        DynamicObjectCollection elments = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element.id element", (QFilter[])new QFilter[]{new QFilter("subelement", "in", subeleids)});
        subeleids.clear();
        elments.forEach(p -> subeleids.add(p.getLong("element")));
        this.getModel().setValue("mulelement", (Object)subeleids.toArray());
        this.getView().updateView("mulelement");
    }

    private void clearTime() {
        this.getModel().setValue("planperiodyear", null);
        this.getModel().setValue("periodyear", null);
        this.getModel().setValue("planstartperiod", null);
        this.getModel().setValue("planendperiod", null);
        this.getModel().setValue("startperiod", null);
        this.getModel().setValue("endperiod", null);
    }

    private boolean checkPeriodStartLessEnd(DynamicObject start, DynamicObject end) {
        return start == null || end == null || PeriodHelper.compare2period((DynamicObject)start, (DynamicObject)end) <= 0;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"PlanResourceRateCalRpt_5", (String)"macc-cad-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"PlanResourceRateCalRpt_6", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
    }

    private void init() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            this.getModel().setValue("org", (Object)currentOrgId);
        }
        org = this.getModel().getDataEntity().getDynamicObject("org");
        this.setCostAccount(org);
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("currency", null);
            this.getModel().setValue("mulmanuorg", null);
            this.getModel().setValue("mulcostcentergroup", null);
            this.getModel().setValue("mulcostcenter", null);
            return;
        }
        Long mainBookId = this.getCostAccountByAccoutOrg(((DynamicObject)org).getLong("id"));
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
            this.getView().updateView("costaccount");
            this.setCurrency();
            return;
        }
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("mulmanuorg", null);
        this.getModel().setValue("mulcostcentergroup", null);
        this.getModel().setValue("mulcostcenter", null);
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter enable;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE), appNumQF = new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))};
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
        if (result == null || result.size() == 0) {
            return 0L;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return 0L;
    }

    private QFilter getCostAccountF7QFilter(String appNum) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (costAccountIds.size() > 0) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0);
    }

    public void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setQueryVisible(Boolean isShow, Long orgId, Long costAccountId) {
        this.getView().setVisible(isShow, new String[]{"queryperiod"});
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.setMustInput(isShow.booleanValue());
        if (Boolean.TRUE.equals(isShow)) {
            List periodIds = CostUpdateHelper.getPeriodIds((Long)orgId, (Long)costAccountId);
            this.getModel().setValue("queryperiod", periodIds.isEmpty() ? null : periodIds.get(0));
        } else {
            this.getModel().setValue("queryperiod", null);
        }
        this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{"querydate"});
        DateTimeEdit queryDate = (DateTimeEdit)this.getControl("querydate");
        queryDate.setMustInput(isShow == false);
        this.getModel().setValue("querydate", (Object)(Boolean.TRUE.equals(isShow == false) ? TimeServiceHelper.now() : null));
    }
}

