/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.planresourceratecal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.report.queryplugin.planresourceratecal.PlanResourceRateCalRptParam;
import kd.macc.cad.report.queryplugin.planresourceratecal.PlanResourceResultRow;
import kd.macc.cad.report.queryplugin.planresourceratecal.PlanResourceRptHandleRow;

public class PlanResourceRateCalRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(PlanResourceRateCalRptSourceCf.class);
    private PlanResourceRateCalRptParam rptParam;
    private static final List<String> hideProps = Lists.newArrayList((Object[])new String[]{"periodnumber", "planperiodnumber"});

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.rptParam = (PlanResourceRateCalRptParam)ctx.getParam(PlanResourceRateCalRptParam.class.getName());
        this.setShowKeys(ctx);
        ctx.setShowBlockEntity(false);
    }

    private void setShowKeys(ReportDataCtx ctx) {
        Set showKeyCols = ctx.getShowKeyCols();
        showKeyCols.add("costcenter");
        showKeyCols.add("costcenternumber");
        showKeyCols.add("costcentername");
        showKeyCols.add("planperiod");
        showKeyCols.add("period");
        showKeyCols.add("costdriver");
        showKeyCols.add("manuorg");
        showKeyCols.add("manuorgnumber");
        showKeyCols.add("manuorgname");
        showKeyCols.add("element");
        showKeyCols.add("elementnumber");
        showKeyCols.add("elementname");
        showKeyCols.add("subelement");
        showKeyCols.add("subelementnumber");
        showKeyCols.add("subelementname");
        showKeyCols.add("resource");
        showKeyCols.add("resourcenumber");
        showKeyCols.add("resourcename");
        showKeyCols.add("mulresource");
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        this.logger.info("\u4fee\u6539\u56fa\u5b9a\u6570\u636e\u5757");
        for (SrcBlockConf blockConf : blockCollector) {
            String srcEntity;
            QFilter dataFs = blockConf.getDataFs();
            if (dataFs == null) {
                dataFs = new QFilter("1", "=", (Object)1);
            }
            dataFs.and(new QFilter("org", "=", (Object)this.rptParam.getOrg()));
            dataFs.and(new QFilter("costaccount", "=", (Object)this.rptParam.getCostAccountId()));
            if (this.rptParam.getManuOrgIds() != null && this.rptParam.getManuOrgIds().size() > 0) {
                dataFs.and(new QFilter("manuorg", "in", this.rptParam.getManuOrgIds()));
            }
            if (this.rptParam.getSubElementIds() != null && this.rptParam.getSubElementIds().size() > 0) {
                dataFs.and(new QFilter("subelement", "in", this.rptParam.getSubElementIds()));
            }
            if ("cad_resourcplanrate".equals(srcEntity = blockConf.getSrcEntity())) {
                if (this.rptParam.getCostCenterIds() != null && this.rptParam.getCostCenterIds().size() > 0) {
                    dataFs.and(new QFilter("costcenter", "in", this.rptParam.getCostCenterIds()));
                }
                dataFs.and(new QFilter("period", "in", this.rptParam.getPlanPeriodIds()));
                dataFs.and(new QFilter("planscheme", "=", (Object)this.rptParam.getPlanScheme()));
            } else {
                if (this.rptParam.getCostCenterIds() != null && this.rptParam.getCostCenterIds().size() > 0) {
                    dataFs.and(new QFilter("benefcostcenter", "in", this.rptParam.getCostCenterIds()));
                }
                dataFs.and(new QFilter("period", "in", this.rptParam.getPeriodIds()));
            }
            if (blockConf.getDataFs() != null) continue;
            blockConf.setDataFs(dataFs);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PlanResourceRptHandleRow(this.rptParam, ctx));
        this.logger.info("transFormAfterUnion\u591a\u4e2a\u6570\u636e\u5757union\u5b8c\u6210\u540e\u6267\u884c\uff0c\u5904\u7406\u6570\u636e\u5757");
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterGroup\uff0c\u6570\u636e\u5206\u7ec4\u540e\u5904\u7406");
        this.logger.info("\u6210\u672c\u5206\u6790\u7efc\u5408\u8868\u5206\u7ec4\u5b57\u6bb5\uff1a{}", (Object)ctx.getShowKeyCols());
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("transFormAfterAddSumRow\uff0c\u5408\u8ba1\u884c\u5904\u7406");
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new PlanResourceResultRow(this.rptParam));
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        super.handleBigtableCols(repoColFilter, ctx);
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u5c55\u793a\u5217\u8c03\u6574\u5f00\u59cb");
        ArrayList removeProps = Lists.newArrayList((Object[])new String[]{"costcenter", "manuorg", "element", "subelement", "resource", "planperiod", "period", "amount", "qty", "costdriver", "mulresource"});
        Set showKeyCols = ctx.getShowKeyCols();
        removeProps.forEach(showKeyCols::remove);
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (this.rptParam.getCalcMethod().equals("SUMMARY") && hideProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (removeProps.contains(fieldKey)) {
                iterator.remove();
            }
            if (!"planrate".equals(fieldKey) && !"rate".equals(fieldKey)) continue;
            repCol.setZeroShow(false);
            repCol.setFieldType("qty");
            repCol.setNoDisplayScaleZero(false);
        }
        return cols;
    }
}

