/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.planresourceratecal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.planresourceratecal.PlanResourceRateCalRptParam;

public class PlanResourceRptHandleRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private PlanResourceRateCalRptParam reportParam;
    private static final String[] SELECTFIELD_HANDEL_RESOURCE = new String[]{"org", "costaccount", "planperiod", "planperiodyear", "planperiodnumber", "manuorg", "manuorgnumber", "manuorgname", "costcenter", "costcenternumber", "costcentername", "element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "mulresource", "planrate", "amount", "qty"};
    private static final String[] SELECTFIELD_HANDEL_RESOURCE_TRANSFORM = new String[]{"org", "costaccount", "planperiod", "planperiodyear", "planperiodnumber", "manuorg", "manuorgnumber", "manuorgname", "costcenter", "costcenternumber", "costcentername", "element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "planrate", "amount", "qty", "resourceid resource"};
    private static final String[] SELECTFIELD_DIRECT = new String[]{"org2 org", "costaccount2 costaccount", "planperiod", "planperiodyear", "planperiodnumber", "manuorg2 manuorg", "manuorgnumber2 manuorgnumber", "manuorgname2 manuorgname", "costcenter2 costcenter", "costcenternumber2 costcenternumber", "costcentername2 costcentername", "element2 element", "elementnumber2 elementnumber", "elementname2 elementname", "subelement2 subelement", "subelementnumber2 subelementnumber", "subelementname2 subelementname", "resource2 resource", "resourcenumber2 resourcenumber", "resourcename2 resourcename", "planrate"};
    private static final String[] LEFTFIELD_DIRECT = new String[]{"planperiod", "planperiodyear", "planperiodnumber", "planrate"};
    private static final String[] RIGHTFIELD_DIRECT = new String[]{"period", "periodyear", "periodnumber", "rate"};
    private static final String[] SELECTFIELD_SUMMARY = new String[]{"org2 org", "costaccount2 costaccount", "planperiodyear", "manuorg2 manuorg", "manuorgnumber2 manuorgnumber", "manuorgname2 manuorgname", "costcenter2 costcenter", "costcenternumber2 costcenternumber", "costcentername2 costcentername", "element2 element", "elementnumber2 elementnumber", "elementname2 elementname", "subelement2 subelement", "subelementnumber2 subelementnumber", "subelementname2 subelementname", "resource2 resource", "resourcenumber2 resourcenumber", "resourcename2 resourcename", "planrate"};
    private static final String[] LEFTFIELD_SUMMARY = new String[]{"planperiodyear", "planrate"};
    private static final String[] RIGHTFIELD_SUMMARY = new String[]{"periodyear", "rate"};
    private static final String[] SELECTFIELD_DIRECT_ACT = new String[]{"org", "costaccount", "period", "periodyear", "periodnumber", "manuorg", "manuorgnumber", "manuorgname", "costcenter", "costcenternumber", "costcentername", "element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "resource", "resourcenumber", "resourcename", "rate"};
    private static final String[] SELECTFIELD_SUMMARY_ACT = new String[]{"org", "costaccount", "periodyear", "manuorg", "manuorgnumber", "manuorgname", "costcenter", "costcenternumber", "costcentername", "element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "resource", "resourcenumber", "resourcename", "rate"};
    private static final String[] SELECTFIELD_DIRECT_PLAN = new String[]{"org org2", "costaccount costaccount2", "planperiod", "planperiodyear", "planperiodnumber", "manuorg manuorg2", "manuorgnumber manuorgnumber2", "manuorgname manuorgname2", "costcenter costcenter2", "costcenternumber costcenternumber2", "costcentername costcentername2", "element element2", "elementnumber elementnumber2", "elementname elementname2", "subelement subelement2", "subelementnumber subelementnumber2", "subelementname subelementname2", "resource resource2", "resourcenumber resourcenumber2", "resourcename resourcename2", "planrate"};
    private static final String[] SELECTFIELD_SUMMARY_PLAN = new String[]{"org org2", "costaccount costaccount2", "planperiodyear", "manuorg manuorg2", "manuorgnumber manuorgnumber2", "manuorgname manuorgname2", "costcenter costcenter2", "costcenternumber costcenternumber2", "costcentername costcentername2", "element element2", "elementnumber elementnumber2", "elementname elementname2", "subelement subelement2", "subelementnumber subelementnumber2", "subelementname subelementname2", "resource resource2", "resourcenumber resourcenumber2", "resourcename resourcename2", "planrate"};

    public PlanResourceRptHandleRow(PlanResourceRateCalRptParam calcResultParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = calcResultParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.map(new MapFunction(){

            public RowX map(RowX rowX) {
                String mulResource = rowX.getString(this.sourceRowMeta.getFieldIndex("mulresource"));
                if (!StringUtils.isEmpty((String)mulResource)) {
                    rowX.set(this.sourceRowMeta.getFieldIndex("resource"), (Object)Long.parseLong(mulResource));
                }
                return rowX;
            }

            public RowMeta getResultRowMeta() {
                return this.getSourceRowMeta();
            }
        });
        JobSession currentJob = this.ctx.getCurrentJob();
        DataSetOutput dataSetOutput = new DataSetOutput(srcData.getRowMeta());
        String resultId = dataSetOutput.getId();
        srcData.output((Output)dataSetOutput);
        currentJob.commit(60, TimeUnit.MINUTES);
        DataSet resultDs = currentJob.readDataSet(resultId);
        DataSetX planDataSetX = this.getPlanData(resultDs.copy(), this.reportParam);
        DataSetX dataSetX = this.getActualData(resultDs, this.reportParam);
        planDataSetX = this.dealPlanDataSetX(planDataSetX);
        dataSetX = this.dealDataSetX(dataSetX);
        DataSetX finalDataSetX = this.joinData(planDataSetX, dataSetX);
        DataSetX result = this.calcDiff(finalDataSetX, this.reportParam);
        result = "DIRECT".equals(this.reportParam.getCalcMethod()) ? result.addFields(new Field[]{new Field("amount", (DataType)DataType.BigDecimalType), new Field("qty", (DataType)DataType.BigDecimalType), new Field("costdriver", (DataType)DataType.LongType), new Field("mulresource", (DataType)DataType.StringType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, 0, " "}) : result.addFields(new Field[]{new Field("amount", (DataType)DataType.BigDecimalType), new Field("qty", (DataType)DataType.BigDecimalType), new Field("costdriver", (DataType)DataType.LongType), new Field("planperiod", (DataType)DataType.LongType), new Field("planperiodnumber", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType), new Field("periodnumber", (DataType)DataType.LongType), new Field("mulresource", (DataType)DataType.StringType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, 0, 0, 0, 0, 0, " "});
        return result;
    }

    private DataSetX calcDiff(DataSetX finalDataSetX, final PlanResourceRateCalRptParam reportParam) {
        return finalDataSetX.addFields(new Field[]{new Field("diff", (DataType)DataType.BigDecimalType), new Field("diffrate", (DataType)DataType.StringType)}, new Object[]{BigDecimal.ZERO, ""}).map(new MapFunction(){
            private static final long serialVersionUID = 7619786258948767554L;

            public RowX map(RowX rowX) {
                Integer periodNumberValue;
                int periodNumber;
                Integer planPeriodNumberValue;
                BigDecimal planRate = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("planrate"));
                BigDecimal rate = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("rate"));
                if (planRate != null && rate != null) {
                    BigDecimal diff = rate.subtract(planRate);
                    rowX.set(this.sourceRowMeta.getFieldIndex("diff"), (Object)diff);
                    if (planRate.compareTo(BigDecimal.ZERO) > 0 && rate.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal diffRate = diff.multiply(new BigDecimal(100)).divide(planRate, 2, RoundingMode.HALF_UP);
                        rowX.set(this.sourceRowMeta.getFieldIndex("diffrate"), (Object)(diffRate + "%"));
                    }
                }
                rowX.set(this.sourceRowMeta.getFieldIndex("planperiodyear"), (Object)reportParam.getPlanPeriodYear());
                rowX.set(this.sourceRowMeta.getFieldIndex("periodyear"), (Object)reportParam.getPeriodYear());
                int planPeriodNumber = this.sourceRowMeta.getFieldIndex("planperiodnumber", false);
                if (planPeriodNumber > 0 && (planPeriodNumberValue = rowX.getInteger(this.sourceRowMeta.getFieldIndex("planperiodnumber"))) != null && planPeriodNumberValue > 0) {
                    rowX.set(this.sourceRowMeta.getFieldIndex("periodnumber"), (Object)planPeriodNumberValue);
                }
                if ((periodNumber = this.sourceRowMeta.getFieldIndex("periodnumber", false)) > 0 && (periodNumberValue = rowX.getInteger(this.sourceRowMeta.getFieldIndex("periodnumber"))) != null && periodNumberValue > 0) {
                    rowX.set(this.sourceRowMeta.getFieldIndex("planperiodnumber"), (Object)periodNumberValue);
                }
                return rowX;
            }

            public RowMeta getResultRowMeta() {
                return this.getSourceRowMeta();
            }
        });
    }

    private DataSetX joinData(DataSetX planDataSetX, DataSetX dataSetX) {
        DataSetX right;
        JoinDataSetX left;
        String calcMethod = this.reportParam.getCalcMethod();
        if ("DIRECT".equals(calcMethod)) {
            left = planDataSetX.leftJoin(dataSetX).on("manuorg2", "manuorg").on("costcenter2", "costcenter").on("planperiodnumber", "periodnumber").on("element2", "element").on("subelement2", "subelement").on("resource2", "resource").select(SELECTFIELD_DIRECT, RIGHTFIELD_DIRECT);
            right = planDataSetX.rightJoin(dataSetX).on("manuorg2", "manuorg").on("costcenter2", "costcenter").on("planperiodnumber", "periodnumber").on("element2", "element").on("subelement2", "subelement").on("resource2", "resource").select(LEFTFIELD_DIRECT, dataSetX.getRowMeta().getFieldNames()).filter("planrate is null");
        } else {
            left = planDataSetX.leftJoin(dataSetX).on("manuorg2", "manuorg").on("costcenter2", "costcenter").on("element2", "element").on("subelement2", "subelement").on("resource2", "resource").select(SELECTFIELD_SUMMARY, RIGHTFIELD_SUMMARY);
            right = planDataSetX.rightJoin(dataSetX).on("manuorg2", "manuorg").on("costcenter2", "costcenter").on("element2", "element").on("subelement2", "subelement").on("resource2", "resource").select(LEFTFIELD_SUMMARY, dataSetX.getRowMeta().getFieldNames()).filter("planrate  is null");
        }
        return DataSetXHelper.union((DataSetX)left, (DataSetX)right);
    }

    private DataSetX dealDataSetX(DataSetX dataSetX) {
        String calcMethod = this.reportParam.getCalcMethod();
        if ("DIRECT".equals(calcMethod)) {
            dataSetX = dataSetX.groupBy(new String[]{"org", "costaccount", "period", "periodyear", "periodnumber", "manuorg", "manuorgnumber", "manuorgname", "costcenter", "costcenternumber", "costcentername", "element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "costdriver", "qty"}).sum("amount").addFields(new Field[]{new Field("rate", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO}).map(new MapFunction(){

                public RowX map(RowX rowX) {
                    BigDecimal rate = BigDecimal.ZERO;
                    BigDecimal amount = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("amount"));
                    BigDecimal qty = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty"));
                    if (qty.compareTo(BigDecimal.ZERO) != 0) {
                        rate = amount.divide(qty, 10, RoundingMode.HALF_UP);
                    }
                    rowX.set(this.sourceRowMeta.getFieldIndex("rate"), (Object)rate);
                    return rowX;
                }

                public RowMeta getResultRowMeta() {
                    return this.getSourceRowMeta();
                }
            });
            dataSetX = this.matchResource(dataSetX);
        } else {
            dataSetX = dataSetX.groupBy(new String[]{"org", "costaccount", "period", "periodyear", "periodnumber", "manuorg", "manuorgnumber", "manuorgname", "costcenter", "costcenternumber", "costcentername", "element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "costdriver", "qty"}).sum("amount");
            dataSetX = dataSetX.groupBy(new String[]{"org", "costaccount", "periodyear", "manuorg", "manuorgnumber", "manuorgname", "costcenter", "costcenternumber", "costcentername", "element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "costdriver"}).sum("amount").sum("qty").addFields(new Field[]{new Field("rate", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO}).map(new MapFunction(){

                public RowX map(RowX rowX) {
                    BigDecimal rate = BigDecimal.ZERO;
                    BigDecimal amount = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("amount"));
                    BigDecimal qty = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty"));
                    if (qty.compareTo(BigDecimal.ZERO) != 0) {
                        rate = amount.divide(qty, 10, RoundingMode.HALF_UP);
                    }
                    rowX.set(this.sourceRowMeta.getFieldIndex("rate"), (Object)rate);
                    return rowX;
                }

                public RowMeta getResultRowMeta() {
                    return this.getSourceRowMeta();
                }
            });
            dataSetX = this.matchResource(dataSetX);
        }
        return dataSetX;
    }

    private DataSetX matchResource(DataSetX dataSetX) {
        DataSet costDriverResDataSet = this.getCostDriverResDataSet();
        JobSession currentJob = this.ctx.getCurrentJob();
        DataSetInput resultDsInput = new DataSetInput(costDriverResDataSet);
        DataSetX costDriverResDataSetX = currentJob.fromInput((Input)resultDsInput);
        dataSetX = dataSetX.join(costDriverResDataSetX).on("costdriver", "costdriver").select(dataSetX.getRowMeta().getFieldNames(), new String[]{"resource", "resourcenumber", "resourcename"});
        return dataSetX;
    }

    private DataSet getCostDriverResDataSet() {
        ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
        filter.add(new QFilter("status", "=", (Object)"C"));
        filter.add(new QFilter("enable", "=", (Object)"1"));
        filter.add(new QFilter("islinkresource", "=", (Object)Boolean.TRUE));
        DataSet resourceInfoWithDetailType = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid,number resourcenumber,name resourcename,resourcesentryentity.itemclasstype resourcetypeid", null, null);
        DataSet resourceInfo = resourceInfoWithDetailType.copy().groupBy(new String[]{"resourceid", "resourcenumber", "resourcename"}).finish();
        QFilter resTypeFilter = new QFilter("matchpattern", "=", (Object)"resource");
        filter.add(resTypeFilter);
        DataSet resourceDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getCostDriverDataSet", (String)"cad_costdriver", (String)"id as costdriver,matchpattern,resource.fbasedataid as resource,resourcetype", (QFilter[])filter.toArray(new QFilter[0]), null);
        resourceDataSet = resourceDataSet.select("costdriver,matchpattern,resource,resourcetype");
        resourceDataSet = resourceDataSet.join(resourceInfo).on("resource", "resourceid").select(new String[]{"costdriver", "matchpattern", "resource", "resourcetype"}, new String[]{"resourcenumber", "resourcename"}).finish();
        filter.remove(resTypeFilter);
        resTypeFilter = new QFilter("matchpattern", "=", (Object)"resourcetype");
        filter.add(resTypeFilter);
        DataSet resourceTypeDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.report.queryplugin.ActualRateRptQuery#getCostDriverDataSet", (String)"cad_costdriver", (String)"id as costdriver,matchpattern,resource.fbasedataid as resource,resourcetype", (QFilter[])filter.toArray(new QFilter[0]), null);
        resourceTypeDataSet = resourceTypeDataSet.select("costdriver,matchpattern,resource,resourcetype");
        resourceTypeDataSet = this.dealMulSourceType(resourceTypeDataSet, resourceInfoWithDetailType);
        return resourceDataSet.union(resourceTypeDataSet);
    }

    private DataSet dealMulSourceType(DataSet resourceTypeDataSet, DataSet resourceInfo) {
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        resourceTypeDataSet = resourceTypeDataSet.addField("resourcetype", "realresourcetype");
        RowMeta rowMeta = resourceTypeDataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        for (Row row : resourceTypeDataSet) {
            String resourcetype = row.getString("resourcetype");
            if (resourcetype.charAt(0) == ',') {
                resourcetype = resourcetype.substring(1);
            }
            String[] types = resourcetype.split(",");
            String realResourceType = this.getResTypeName(types);
            for (String str : types) {
                if (CadEmptyUtils.isEmpty((String)str)) continue;
                Object[] rowData = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object val;
                    rowData[i] = val = row.get(i);
                }
                rowData[3] = str;
                rowData[4] = realResourceType;
                datasetlist.add(rowData);
            }
        }
        resourceTypeDataSet = Algo.create((String)"resourcetype").createDataSet(datasetlist.iterator(), rowMeta).select("costdriver,matchpattern,resource,case when resourcetype='A' then 'mpdm_equipment' when resourcetype='B' then 'mpdm_toolsresource' when resourcetype='C' then 'mpdm_toolequip' when resourcetype='D' then 'mpdm_mould' when resourcetype='E' then 'mpdm_manuperson' end resourcetype,realresourcetype");
        resourceTypeDataSet = resourceTypeDataSet.join(resourceInfo, JoinType.INNER).on("resourcetype", "resourcetypeid").select(resourceTypeDataSet.getRowMeta().getFieldNames(), new String[]{"resourceid", "resourcenumber", "resourcename"}).finish();
        resourceTypeDataSet = resourceTypeDataSet.groupBy(new String[]{"costdriver", "matchpattern", "resourceid", "realresourcetype", "resourcenumber", "resourcename"}).finish().select("costdriver,matchpattern,resourceid resource,realresourcetype resourcetype,resourcenumber,resourcename");
        return resourceTypeDataSet;
    }

    private String getResTypeName(String[] types) {
        StringBuilder realType = new StringBuilder();
        block14: for (String str : types) {
            realType.append("\uff0c");
            switch (str) {
                case "A": {
                    realType.append(ResManager.loadKDString((String)"\u8bbe\u5907\u8d44\u6e90", (String)"PlanResourceRptHandleRow_0", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "B": {
                    realType.append(ResManager.loadKDString((String)"\u5de5\u5177\u8d44\u6e90", (String)"PlanResourceRptHandleRow_1", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "C": {
                    realType.append(ResManager.loadKDString((String)"\u5de5\u88c5\u8d44\u6e90", (String)"PlanResourceRptHandleRow_2", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "D": {
                    realType.append(ResManager.loadKDString((String)"\u6a21\u5177\u8d44\u6e90", (String)"PlanResourceRptHandleRow_3", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
                case "E": {
                    realType.append(ResManager.loadKDString((String)"\u5236\u9020\u4eba\u5458", (String)"PlanResourceRptHandleRow_4", (String)"macc-cad-report", (Object[])new Object[0]));
                    continue block14;
                }
            }
        }
        return realType.substring(1);
    }

    private DataSetX dealPlanDataSetX(DataSetX planDataSetX) {
        String calcMethod = this.reportParam.getCalcMethod();
        if ("DIRECT".equals(calcMethod)) {
            planDataSetX = planDataSetX.select(SELECTFIELD_DIRECT_PLAN);
        } else {
            planDataSetX = planDataSetX.groupBy(new String[]{"org", "costaccount", "planperiodyear", "manuorg", "manuorgnumber", "manuorgname", "costcenter", "costcenternumber", "costcentername", "element", "elementnumber", "elementname", "subelement", "subelementnumber", "subelementname", "resource", "resourcenumber", "resourcename"}).sum("amount").sum("qty").addFields(new Field[]{new Field("planrate", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO}).map(new MapFunction(){

                public RowX map(RowX rowX) {
                    BigDecimal planRate = BigDecimal.ZERO;
                    BigDecimal amount = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("amount"));
                    BigDecimal qty = rowX.getBigDecimal(this.sourceRowMeta.getFieldIndex("qty"));
                    if (amount != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                        planRate = amount.divide(qty, 10, RoundingMode.HALF_UP);
                    }
                    rowX.set(this.sourceRowMeta.getFieldIndex("planrate"), (Object)planRate);
                    return rowX;
                }

                public RowMeta getResultRowMeta() {
                    return this.getSourceRowMeta();
                }
            });
            planDataSetX = planDataSetX.select(SELECTFIELD_SUMMARY_PLAN);
        }
        return planDataSetX;
    }

    private DataSetX getPlanData(DataSet srcData, final PlanResourceRateCalRptParam reportParam) {
        JobSession currentJob = this.ctx.getCurrentJob();
        DataSet resourcePlanRateRes = QueryServiceHelper.queryDataSet((String)"rprr", (String)"cad_resourcplanrate", (String)"id,mulresource.fbasedataid resourceid", null, null);
        srcData = srcData.join(resourcePlanRateRes).on("resource", "id").select(SELECTFIELD_HANDEL_RESOURCE, new String[]{"resourceid"}).finish();
        DataSet resourceInfo = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid2,number resourcenumber,name resourcename", null, null);
        srcData = srcData.join(resourceInfo).on("resourceid", "resourceid2").select(SELECTFIELD_HANDEL_RESOURCE_TRANSFORM, new String[]{"resourcenumber", "resourcename"}).finish();
        DataSetInput resultDsInput = new DataSetInput(srcData);
        DataSetX planDataSetX = currentJob.fromInput((Input)resultDsInput);
        planDataSetX = planDataSetX.filter("planperiod>0");
        planDataSetX = planDataSetX.map(new MapFunction(){

            public RowX map(RowX rowX) {
                rowX.set(this.sourceRowMeta.getFieldIndex("planperiodyear"), (Object)reportParam.getPlanPeriodYear());
                return rowX;
            }

            public RowMeta getResultRowMeta() {
                return this.getSourceRowMeta();
            }
        });
        return planDataSetX;
    }

    private DataSetX getActualData(DataSet srcData, final PlanResourceRateCalRptParam reportParam) {
        JobSession currentJob = this.ctx.getCurrentJob();
        DataSetInput resultDsInput = new DataSetInput(srcData);
        DataSetX dataSetX = currentJob.fromInput((Input)resultDsInput);
        dataSetX = dataSetX.filter("period > 0");
        dataSetX = dataSetX.map(new MapFunction(){

            public RowX map(RowX rowX) {
                rowX.set(this.sourceRowMeta.getFieldIndex("periodyear"), (Object)reportParam.getPeriodYear());
                return rowX;
            }

            public RowMeta getResultRowMeta() {
                return this.getSourceRowMeta();
            }
        });
        return dataSetX;
    }
}

