/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;

public class CalCostLevelGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8889163174115273970L;
    private RowMeta srcMeta;
    private StdCostLevelRptParam stdCostLevelRptParam;
    private String[] groupOrderbyStr = new String[]{"level", "datatype desc", "elementnum", "subelementnum", "materialgroupnumber", "submaterialnum", "resourcenum", "auxpty"};
    private String[] orderbyStr = new String[]{"level", "datatype desc", "elementnum", "subelementnum", "submaterialnum", "resourcenum", "auxpty"};

    public CalCostLevelGroupFunction(RowMeta rowMeta, StdCostLevelRptParam stdCostLevelRptParam) {
        this.srcMeta = rowMeta;
        this.stdCostLevelRptParam = stdCostLevelRptParam;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    /*
     * WARNING - void declaration
     */
    public void reduce(Iterable<RowX> iterable, Collector collector) {
        String[] useOrderbyStr = this.stdCostLevelRptParam.getShowgroup() != false ? this.groupOrderbyStr : this.orderbyStr;
        DataSet dataset = DataSetXHelper.getDsFromAlgoxRows(iterable, (String[])useOrderbyStr, (RowMeta)this.srcMeta).orderBy(new String[]{"level", "datatype", "element desc"});
        ArrayList<RowX> rowxs = new ArrayList<RowX>(64);
        int count = 1000000000;
        Integer preLevel = 0;
        String preOrderKey = "";
        LinkedHashMap<String, Integer> orderMap = new LinkedHashMap<String, Integer>();
        Boolean isAddSmallLine = false;
        while (dataset.hasNext()) {
            String key;
            Row row = dataset.next();
            RowX rowx = new RowX(this.srcMeta.getFieldCount());
            for (int i = 0; i < this.srcMeta.getFieldCount(); ++i) {
                rowx.set(i, row.get(i));
                Long materialgroup = row.getLong("group");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)this.stdCostLevelRptParam.getMulMaterialGroups())) {
                    isAddSmallLine = true;
                    continue;
                }
                if (CadEmptyUtils.isEmpty((Long)materialgroup)) continue;
                isAddSmallLine = true;
            }
            rowxs.add(rowx);
            Long levelmatId = row.getLong("submaterial");
            Long resourceId = row.getLong("resource");
            Integer level = row.getInteger("level");
            String string = key = CadEmptyUtils.isEmpty((Long)levelmatId) ? resourceId + "" + level : levelmatId + "" + level;
            if (level != null && preLevel != null && Integer.compare(preLevel, level) == 0) {
                if (key.equals(preOrderKey)) continue;
                orderMap.put(key, count);
                ++count;
            } else {
                count = 1000000000;
                orderMap.put(key, count);
                ++count;
            }
            preLevel = level;
            preOrderKey = key;
        }
        if (!isAddSmallLine.booleanValue()) {
            return;
        }
        int orderbyindex = this.srcMeta.getFieldIndex("orderby");
        int levelindex = this.getSourceRowMeta().getFieldIndex("level");
        int qtyindex = this.getSourceRowMeta().getFieldIndex("qty");
        int baseQtyIndex = this.getSourceRowMeta().getFieldIndex("baseqty");
        int priceindex = this.getSourceRowMeta().getFieldIndex("price");
        int stdpriceindex = this.getSourceRowMeta().getFieldIndex("stdprice");
        int currencyindex = this.getSourceRowMeta().getFieldIndex("currency");
        int submaterialindex = this.getSourceRowMeta().getFieldIndex("submaterial");
        int groupindex = this.getSourceRowMeta().getFieldIndex("group");
        int resourceindex = this.getSourceRowMeta().getFieldIndex("resource");
        int resourcenumindex = this.getSourceRowMeta().getFieldIndex("resourcenum");
        int resourcenameindex = this.getSourceRowMeta().getFieldIndex("resourcename");
        int submatnumindex = this.getSourceRowMeta().getFieldIndex("submatnum");
        int submatnameindex = this.getSourceRowMeta().getFieldIndex("submatname");
        int subelementindex = this.getSourceRowMeta().getFieldIndex("subelement");
        int calcbasisindex = this.getSourceRowMeta().getFieldIndex("calcbasis");
        int submatunitindex = this.getSourceRowMeta().getFieldIndex("submatunit");
        Iterator it = rowxs.iterator();
        count = 1;
        preLevel = null;
        RowX maxQtyDataRow = null;
        RowX maxStdPriceDataRow = null;
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal sumStdPrice = BigDecimal.ZERO;
        BigDecimal adjustQty = BigDecimal.ZERO;
        BigDecimal adjustStdPrice = BigDecimal.ZERO;
        StringBuilder keyBuilder = new StringBuilder();
        String preGroupKey = "";
        Boolean hasSameLevel = true;
        BigDecimal sumGroupQty = BigDecimal.ZERO;
        BigDecimal sumGroupStdPrice = BigDecimal.ZERO;
        RowX groupDataRow = null;
        while (it.hasNext()) {
            RowX rowx = (RowX)it.next();
            String orderBy = rowx.getString(orderbyindex);
            Integer level = rowx.getInteger(levelindex);
            BigDecimal qty = this.getBigDcimalNotnull(rowx, qtyindex);
            BigDecimal baseQty = this.getBigDcimalNotnull(rowx, baseQtyIndex);
            BigDecimal stdprice = this.getBigDcimalNotnull(rowx, stdpriceindex);
            Long submaterialId = rowx.getLong(submaterialindex);
            Long resource = rowx.getLong(resourceindex);
            if (!CadEmptyUtils.isEmpty((Long)resource)) {
                rowx.set(submatnumindex, rowx.get(resourcenumindex));
                rowx.set(submatnameindex, rowx.get(resourcenameindex));
            }
            rowx.set(currencyindex, (Object)this.stdCostLevelRptParam.getCurrencyId());
            if (!CadEmptyUtils.isEmpty((Long)resource) && "001".equals(rowx.getString(calcbasisindex))) {
                qty = qty.divide(new BigDecimal(60), 10, RoundingMode.HALF_UP);
                baseQty = baseQty.divide(new BigDecimal(60), 10, RoundingMode.HALF_UP);
                rowx.set(baseQtyIndex, (Object)baseQty);
                rowx.set(qtyindex, (Object)qty);
                BigDecimal price = this.getBigDcimalNotnull(rowx, priceindex);
                rowx.set(priceindex, (Object)price.multiply(new BigDecimal(60)));
                rowx.set(submatunitindex, (Object)10L);
            } else if (!CadEmptyUtils.isEmpty((Long)resource) && ("002".equals(rowx.getString(calcbasisindex)) || "003".equals(rowx.getString(calcbasisindex)))) {
                rowx.set(submatunitindex, (Object)11L);
            } else if (!CadEmptyUtils.isEmpty((Long)resource)) {
                rowx.set(submatunitindex, (Object)9L);
            }
            if (!"C".equals(rowx.getString(this.getSourceRowMeta().getFieldIndex("srctype")))) {
                if ("1".equals(orderBy)) {
                    Long orderKey = CadEmptyUtils.isEmpty((Long)submaterialId) ? resource : submaterialId;
                    Integer n = (Integer)orderMap.get(orderKey + "" + level);
                    if (n != null) {
                        rowx.set(orderbyindex, (Object)String.valueOf(n));
                    }
                } else if (orderBy != null && orderBy.length() > 0) {
                    int countindex = 1;
                    for (String orderId : orderBy.split("-")) {
                        if ("1".equals(orderId)) {
                            keyBuilder.append(orderId);
                        } else {
                            Integer integer = (Integer)orderMap.get(orderId);
                            if (countindex == 1) {
                                keyBuilder.append(integer);
                            } else {
                                keyBuilder.append('-').append(integer);
                            }
                        }
                        ++countindex;
                    }
                    rowx.set(orderbyindex, (Object)keyBuilder.toString());
                    keyBuilder.setLength(0);
                }
            }
            if (level != null && level == 1) {
                Set<Long> mulSubMaterialIds = this.stdCostLevelRptParam.getMulSubMaterialIds();
                if (mulSubMaterialIds == null || mulSubMaterialIds.contains(submaterialId)) {
                    sumQty = sumQty.add(qty);
                    sumStdPrice = sumStdPrice.add(sumStdPrice);
                }
                adjustQty = sumQty;
                adjustStdPrice = sumStdPrice;
            }
            if (preLevel == null || level != null && Integer.compare(preLevel, level) == 0) {
                hasSameLevel = true;
                ++count;
                if (maxQtyDataRow == null) {
                    maxQtyDataRow = rowx;
                } else {
                    BigDecimal maxQty = this.getBigDcimalNotnull(maxQtyDataRow, qtyindex);
                    if (maxQty.compareTo(qty) < 0) {
                        maxQtyDataRow = rowx;
                    }
                }
                if (maxStdPriceDataRow == null) {
                    maxStdPriceDataRow = rowx;
                } else {
                    BigDecimal maxStdPrice = this.getBigDcimalNotnull(maxStdPriceDataRow, stdpriceindex);
                    if (maxStdPrice.compareTo(stdprice) < 0) {
                        maxStdPriceDataRow = rowx;
                    }
                }
            } else {
                this.AdjustQty(qtyindex, priceindex, stdpriceindex, maxQtyDataRow, adjustQty);
                this.AdjustStdPrice(qtyindex, priceindex, stdpriceindex, maxStdPriceDataRow, adjustStdPrice);
                count = 1;
                adjustQty = sumQty;
                adjustStdPrice = sumStdPrice;
                hasSameLevel = false;
            }
            preLevel = level;
            adjustQty = adjustQty.subtract(qty);
            adjustStdPrice = adjustStdPrice.subtract(stdprice);
            if (this.stdCostLevelRptParam.getShowgroup().booleanValue()) {
                void var50_67;
                Long l;
                Long groupId = rowx.getLong(groupindex);
                if (groupId == null) {
                    groupId = 0L;
                }
                if ((l = rowx.getLong(subelementindex)) == null) {
                    Long l2 = 0L;
                }
                String key = groupId + "/" + var50_67;
                if (!(groupDataRow == null || hasSameLevel.booleanValue() && key.equals(preGroupKey))) {
                    groupDataRow.set(qtyindex, (Object)sumGroupQty);
                    groupDataRow.set(stdpriceindex, (Object)sumGroupStdPrice);
                    collector.collect(groupDataRow);
                    sumGroupQty = BigDecimal.ZERO;
                    sumGroupStdPrice = BigDecimal.ZERO;
                }
                groupDataRow = rowx;
                preGroupKey = key;
                sumGroupQty = sumGroupQty.add(qty);
                sumGroupStdPrice = sumGroupStdPrice.add(stdprice);
                continue;
            }
            collector.collect(rowx);
        }
        this.AdjustQty(qtyindex, priceindex, stdpriceindex, maxQtyDataRow, adjustQty);
        this.AdjustStdPrice(qtyindex, priceindex, stdpriceindex, maxStdPriceDataRow, adjustStdPrice);
        if (this.stdCostLevelRptParam.getShowgroup().booleanValue() && groupDataRow != null) {
            groupDataRow.set(qtyindex, (Object)sumGroupQty);
            groupDataRow.set(stdpriceindex, (Object)sumGroupStdPrice);
            collector.collect(groupDataRow);
        }
    }

    private void AdjustStdPrice(int qtyindex, int priceindex, int stdpriceindex, RowX maxStdPriceDataRow, BigDecimal adjustStdPrice) {
        if (!CadEmptyUtils.isEmpty((BigDecimal)adjustStdPrice) && maxStdPriceDataRow != null) {
            BigDecimal sourceStdPrice = this.getBigDcimalNotnull(maxStdPriceDataRow, stdpriceindex);
            BigDecimal stdPrice = sourceStdPrice.add(adjustStdPrice);
            maxStdPriceDataRow.set(stdpriceindex, (Object)stdPrice);
            BigDecimal bigDecimal = this.getBigDcimalNotnull(maxStdPriceDataRow, qtyindex);
        }
    }

    private void AdjustQty(int qtyindex, int priceindex, int stdpriceindex, RowX maxQtyDataRow, BigDecimal adjustQty) {
        if (!CadEmptyUtils.isEmpty((BigDecimal)adjustQty) && maxQtyDataRow != null) {
            BigDecimal sourceQty = this.getBigDcimalNotnull(maxQtyDataRow, qtyindex);
            sourceQty = sourceQty.add(adjustQty);
            maxQtyDataRow.set(qtyindex, (Object)sourceQty);
        }
    }

    private BigDecimal getBigDcimalNotnull(RowX rowx, int qtyindex) {
        BigDecimal bigDecimal = rowx.getBigDecimal(qtyindex);
        if (bigDecimal == null) {
            bigDecimal = BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    private Long getLongNotnull(RowX rowx, int index) {
        Long id = rowx.getLong(index);
        if (id == null) {
            id = 0L;
        }
        return id;
    }
}

