/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import java.util.Date;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;

public class CalCostLevelMaxEffectdateFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -6641840430608334843L;
    private RowMeta srcMeta;
    private Set<String> matKeyStrSet;

    public CalCostLevelMaxEffectdateFunction(RowMeta rowMeta, StdCostLevelRptParam stdCostLevelRptParam, Set<String> matKeyStrSet) {
        this.srcMeta = rowMeta;
        this.matKeyStrSet = matKeyStrSet;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Date maxDate = null;
        DataSet dataset = DataSetXHelper.getDsFromAlgoxRows(iterable, (String[])new String[]{"effectdate desc"}, (RowMeta)this.srcMeta);
        StringBuilder keyBuilder = new StringBuilder();
        while (dataset.hasNext()) {
            Row row = dataset.next();
            if (this.matKeyStrSet != null) {
                Long material = row.getLong("material");
                String keycol = row.getString("keycol");
                Long auxpty = row.getLong("auxpty");
                String key = keyBuilder.append(material).append("@").append(keycol).append("@").append(auxpty).toString();
                keyBuilder.setLength(0);
                if (!this.matKeyStrSet.contains(key)) continue;
            }
            Date effectdate = row.getDate("effectdate");
            if (maxDate != null && maxDate.compareTo(effectdate) != 0) continue;
            maxDate = effectdate;
            RowX rowx = new RowX(this.srcMeta.getFieldCount());
            for (int i = 0; i < this.srcMeta.getFieldCount(); ++i) {
                rowx.set(i, row.get(i));
            }
            collector.collect(rowx);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }
}

