/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.report.queryplugin.stdcostlevel.HandleRow;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;

public class CalNextLevelGroupFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 8889163174115273970L;
    private RowMeta srcMeta;
    private StdCostLevelRptParam stdCostLevelRptParam;
    private String entityName = "cad_calcsimulationresult";
    private int level;

    public CalNextLevelGroupFunction(RowMeta rowMeta, StdCostLevelRptParam stdCostLevelRptParam, int level) {
        this.srcMeta = rowMeta;
        this.stdCostLevelRptParam = stdCostLevelRptParam;
        this.level = level;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        StringBuilder keyBuilder = new StringBuilder();
        HashSet<Long> subMatIds = new HashSet<Long>(16);
        HashMap<String[], ArrayList<RowX>> preRowDataMap = new HashMap<String[], ArrayList<RowX>>();
        int submaterialindex = this.srcMeta.getFieldIndex("submaterial");
        int materialindex = this.srcMeta.getFieldIndex("material");
        int subkeycolindex = this.srcMeta.getFieldIndex("subkeycol");
        int subauxptyindex = this.srcMeta.getFieldIndex("subauxpty");
        int qtyindex = this.srcMeta.getFieldIndex("qty");
        int orderbyindex = this.srcMeta.getFieldIndex("orderby");
        int levelindex = this.getSourceRowMeta().getFieldIndex("level");
        int priceindex = this.getSourceRowMeta().getFieldIndex("price");
        int stdpriceindex = this.getSourceRowMeta().getFieldIndex("stdprice");
        int qtyprecisionindex = this.getSourceRowMeta().getFieldIndex("qtyprecision");
        int resourceindex = this.getSourceRowMeta().getFieldIndex("resource");
        int levelmatindex = this.getSourceRowMeta().getFieldIndex("levelmat");
        int levelauxptyindex = this.getSourceRowMeta().getFieldIndex("levelauxpty");
        int patchIndex = this.srcMeta.getFieldIndex("path");
        int parentMatLindex = this.getSourceRowMeta().getFieldIndex("parentmat");
        HashSet<String> subKeyCols = new HashSet<String>(16);
        for (RowX rowX : iterable) {
            String datatype = rowX.getString(this.getSourceRowMeta().getFieldIndex("datatype"));
            if (!"4".equals(datatype)) continue;
            Long material = rowX.getLong(submaterialindex);
            Long mat = rowX.getLong(materialindex);
            if (Long.compare(mat, material) == 0) continue;
            String subkeycol = rowX.getString(subkeycolindex);
            Long subauxpty = rowX.getLong(subauxptyindex);
            String[] key = keyBuilder.append(material).append("@").append(subkeycol).append("@").append(subauxpty).toString();
            keyBuilder.setLength(0);
            if (CadEmptyUtils.isEmpty((Long)material)) continue;
            subKeyCols.add(subkeycol);
            subMatIds.add(material);
            ArrayList<RowX> rowXES = (ArrayList<RowX>)preRowDataMap.get(key);
            if (rowXES == null) {
                rowXES = new ArrayList<RowX>();
            }
            rowXES.add(rowX);
            preRowDataMap.put(key, rowXES);
        }
        if (subMatIds.size() < 1) {
            return;
        }
        QFilter subMatQf = new QFilter("material", "in", subMatIds);
        subMatQf.and(new QFilter("keycol", "in", subKeyCols));
        List<QFilter> levelDataQFilter = this.getLevelDataQFilter(subMatQf);
        String select = "material as materialId,auxproperty as auxptyId,keycol keycolstr,entryentity.element as element,entryentity.element.number as elementnum,entryentity.subelement as subelement,entryentity.subelement.number as subelementnum,treepath path,entryentity.submaterial as submaterial,entryentity.submaterial.number as submatnum,entryentity.submaterial.name as submatname,entryentity.submaterial.baseunit as submatunit,entryentity.submaterial.baseunit.precision as qtyprecision,entryentity.submaterial.modelnum as submodelnum,processroute,entryentity.subkeycol as subkeycol,entryentity.subauxproperty as subauxpty,entryentity.resource as resource,entryentity.resource.number as resourcenum,entryentity.resource.name as resourcename,entryentity.qty as qty,entryentity.qty as baseqty,entryentity.price as price,entryentity.stdprice as stdprice,entryentity.calcbasis as calcbasis,entryentity.datatype as datatype,entryentity.subconfiguredcode subconfiguredcode";
        String queryType = this.stdCostLevelRptParam.getQueryType();
        String orderbyStr = "material,keycol,auxproperty";
        if (!CostTypePtyEnum.SIMULATED.getValue().equals(queryType)) {
            this.entityName = "cad_calceffectiveresult";
            select = select + ",effectdate,expdate";
            orderbyStr = "material,keycol,auxproperty,expdate desc";
        } else {
            String calcRecordIdName = this.stdCostLevelRptParam.getCalcRecordName();
            if (!CadEmptyUtils.isEmpty((String)calcRecordIdName)) {
                levelDataQFilter.add(new QFilter("calcrecord.name", "=", (Object)calcRecordIdName));
            } else {
                QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
                levelDataQFilter.add(recordFilter);
            }
            select = select + ",entryentity.operation operation,entryentity.operation.number operationnum,entryentity.operationdesc operationdesc,entryentity.workcenter workcenter,entryentity.workcenter.number workcenternum,bom,entryentity.priceid priceid";
        }
        DataSet dataset = QueryServiceHelper.queryDataSet((String)HandleRow.class.getName(), (String)this.entityName, (String)select, (QFilter[])levelDataQFilter.toArray(new QFilter[0]), (String)orderbyStr);
        HashSet<String> dataFileSet = new HashSet<String>();
        for (String fieldName : dataset.getRowMeta().getFieldNames()) {
            dataFileSet.add(fieldName);
        }
        String preKey = "";
        Date maxDate = null;
        while (dataset.hasNext()) {
            Row row = dataset.next();
            Long submaterial = row.getLong("materialId");
            String subkeycol = row.getString("keycolstr");
            Long subauxpty = row.getLong("auxptyId");
            String key = keyBuilder.append(submaterial).append("@").append(subkeycol).append("@").append(subauxpty).toString();
            keyBuilder.setLength(0);
            if (!preRowDataMap.containsKey(key)) continue;
            List rowXES = (List)preRowDataMap.get(key);
            if (!CostTypePtyEnum.SIMULATED.getValue().equals(queryType)) {
                Date effectdate = row.getDate("expdate");
                if (preKey.equals(key) && maxDate != null && maxDate.compareTo(effectdate) != 0) continue;
                maxDate = effectdate;
                preKey = key;
            }
            for (RowX stdCostLevelRow : rowXES) {
                int currencyPricePrecision;
                RowX rowx = new RowX(this.srcMeta.getFieldCount());
                for (int i = 0; i < this.srcMeta.getFieldCount(); ++i) {
                    String fieldName = this.srcMeta.getFieldName(i);
                    if (dataFileSet.contains(fieldName)) {
                        rowx.set(i, row.get(fieldName));
                        continue;
                    }
                    rowx.set(i, stdCostLevelRow.get(i));
                }
                rowx.set(parentMatLindex, stdCostLevelRow.get(submaterialindex));
                Integer qtyprecision = rowx.getInteger(qtyprecisionindex);
                if (qtyprecision == null || qtyprecision == 0) {
                    qtyprecision = 10;
                }
                if ((currencyPricePrecision = this.stdCostLevelRptParam.getCurrencyPricePrecision()) == 0) {
                    currencyPricePrecision = 10;
                }
                rowx.set(levelindex, (Object)this.level);
                BigDecimal levelQty = stdCostLevelRow.getBigDecimal(qtyindex);
                if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((BigDecimal)levelQty)) {
                    levelQty = BigDecimal.ZERO;
                }
                BigDecimal subqty = this.getBigDcimalNotnull(rowx, qtyindex);
                BigDecimal stdprice = this.getBigDcimalNotnull(rowx, stdpriceindex);
                BigDecimal qty = levelQty.multiply(subqty).setScale((int)qtyprecision, RoundingMode.HALF_UP);
                rowx.set(qtyindex, (Object)qty);
                stdprice = levelQty.multiply(stdprice).setScale(currencyPricePrecision, RoundingMode.HALF_UP);
                rowx.set(stdpriceindex, (Object)stdprice);
                if (BigDecimal.ZERO.compareTo(qty) != 0) {
                    rowx.set(priceindex, (Object)stdprice.divide(qty, currencyPricePrecision, RoundingMode.HALF_UP));
                }
                Boolean isresource = kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Long)rowx.getLong(submaterialindex));
                String order = stdCostLevelRow.getString(orderbyindex);
                if ("1".equals(order)) {
                    order = stdCostLevelRow.getString(submaterialindex) + (this.level - 1);
                }
                Long keyId = 0L;
                keyId = isresource != false ? rowx.getLong(resourceindex) : rowx.getLong(submaterialindex);
                rowx.set(patchIndex, (Object)(stdCostLevelRow.getString(patchIndex) + "@" + row.getString("path")));
                rowx.set(orderbyindex, (Object)(order + "-" + keyId + this.level));
                if (!isresource.booleanValue()) {
                    rowx.set(levelmatindex, rowx.get(submaterialindex));
                    rowx.set(levelauxptyindex, rowx.get(subauxptyindex));
                }
                collector.collect(rowx);
            }
        }
    }

    private List<QFilter> getLevelDataQFilter(QFilter subMaterialFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getCostTypeId()));
        filters.add(new QFilter("ismaindata", "=", (Object)1L));
        if (subMaterialFilter != null) {
            filters.add(subMaterialFilter);
        }
        filters.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{"2", "4"}));
        String queryType = this.stdCostLevelRptParam.getQueryType();
        if ("period".equals(queryType) && this.stdCostLevelRptParam.getQueryPeriodId() != null) {
            filters.add(new QFilter("effectdate", "<=", (Object)this.stdCostLevelRptParam.getQueryPeriodendDate()));
            filters.add(new QFilter("expdate", ">=", (Object)this.stdCostLevelRptParam.getQueryPeriodBeginDate()));
        } else if ("date".equals(queryType) && this.stdCostLevelRptParam.getQueryDate() != null) {
            Date queryDate = this.stdCostLevelRptParam.getQueryDate();
            filters.add(new QFilter("effectdate", "<=", (Object)queryDate));
            filters.add(new QFilter("expdate", ">", (Object)queryDate));
        }
        return filters;
    }

    private BigDecimal getBigDcimalNotnull(RowX rowx, int qtyindex) {
        BigDecimal bigDecimal = rowx.getBigDecimal(qtyindex);
        if (bigDecimal == null) {
            bigDecimal = BigDecimal.ZERO;
        }
        return bigDecimal;
    }
}

