/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.algox.utils.DatSetXUtils;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.stdcostlevel.CalCostLevelGroupFunction;
import kd.macc.cad.report.queryplugin.stdcostlevel.CalCostLevelMaxEffectdateFunction;
import kd.macc.cad.report.queryplugin.stdcostlevel.HandleRow;
import kd.macc.cad.report.queryplugin.stdcostlevel.SmallDiyTotalFunction;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;
import kd.macc.cad.report.queryplugin.stdcostlevel.SupplierDataDetalMap;
import kd.macc.cad.report.queryplugin.stdcostlevel.WorkCenterDataDealFunction;

public class DiyTotalRow
implements IDataXTransform {
    private final Log logger = LogFactory.getLog(DiyTotalRow.class);
    private StdCostLevelRptParam stdCostLevelRptParam;
    private ReportDataCtx ctx;
    private String entityName = "cad_calcsimulationresult";
    private String[] groupFields = new String[]{"costtype", "material", "keycol", "auxpty"};
    private String[] rightFileNames = new String[]{"group", "materialgroupnumber", "groupname"};
    private Set<String> groupHideProps = Sets.newHashSet((Object[])new String[]{"submatname", "submatnum", "submatversion", "subauxpty", "submaterial", "submaterialname", "resource", "unit", "submatunit", "levelmatver", "levelauxpty", "levelmat", "qtyprecision", "calcbasis", "resourcenum", "resourcename", "qty", "price", "submaterialnum", "submaterialname", "path", "effectdate", "expdate", "suppliername", "supplier", "quotaratio", "unitprice", "calcdate", "subkeycol", "processroute", "processroutenum", "processroutename", "processseq", "operationno", "bom", "bomnum", "operation", "operationnum", "operationdesc", "workcenter", "workcenternum"});

    public DiyTotalRow(StdCostLevelRptParam stdCostLevelRptParam, ReportDataCtx ctx) {
        this.stdCostLevelRptParam = stdCostLevelRptParam;
        this.ctx = ctx;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSetX outSumDataSetX;
        List<String> fields;
        List<String> outList;
        List<String> srcList;
        DataSetX outDataSetX;
        String queryType = this.stdCostLevelRptParam.getQueryType();
        boolean isSimulated = CostTypePtyEnum.SIMULATED.getValue().equals(queryType);
        JobSession currentJob = this.ctx.getCurrentJob();
        DataSetOutput dataSetOutput = new DataSetOutput(srcData.getRowMeta());
        String resultId = dataSetOutput.getId();
        srcData.output((Output)dataSetOutput);
        currentJob.commit(60, TimeUnit.MINUTES);
        DataSet resultDs = currentJob.readDataSet(resultId);
        DataSet copy = resultDs.copy();
        HashSet<String> matKeyStrSet = new HashSet<String>(16);
        HashSet<Long> priceids = new HashSet<Long>(16);
        StringBuilder keyBuilder = new StringBuilder();
        HashSet<String> keycols = new HashSet<String>(16);
        HashSet<Long> groupMatId = new HashSet<Long>(16);
        while (copy.hasNext()) {
            Row next = copy.next();
            Integer level = next.getInteger("level");
            Long submaterial = next.getLong("submaterial");
            if (level == null) {
                this.logger.info("DiyTotalRow \u6811path\uff1a" + next.getString("path"));
            }
            if (level != null && level == 1) {
                Long material = next.getLong("material");
                String keyCol = next.getString("keycol");
                Long auxpty = next.getLong("auxpty");
                String key = keyBuilder.append(material).append("@").append(keyCol).append("@").append(auxpty).toString();
                String srctype = next.getString("srctype");
                if ("A".equals(srctype) || "B".equals(srctype)) {
                    keycols.add(keyCol);
                }
                matKeyStrSet.add(key);
                keyBuilder.setLength(0);
                groupMatId.add(material);
            }
            if (!CadEmptyUtils.isEmpty((Long)submaterial)) {
                groupMatId.add(submaterial);
            }
            if (!isSimulated || CadEmptyUtils.isEmpty((Long)next.getLong("priceid"))) continue;
            priceids.add(next.getLong("priceid"));
        }
        DataSetInput resultDsInput = new DataSetInput(resultDs);
        srcData = currentJob.fromInput((Input)resultDsInput);
        srcData = srcData.addFields(new Field[]{new Field("datadealtype", (DataType)DataType.IntegerType)}, new Object[]{0});
        if (isSimulated && this.stdCostLevelRptParam.getShowSuppier().booleanValue()) {
            DataSetX supplierDataSetX = this.getSupplierDataSetX(priceids);
            srcData = srcData.removeFields(new String[]{"supplier", "suppliername", "quotaratio", "unitprice"});
            String[] fields2 = srcData.getRowMeta().getFieldNames();
            srcData = srcData.leftJoin(supplierDataSetX).on("priceid", "id").select(fields2, new String[]{"supplier", "suppliername", "quotaratio", "unitprice"}).addFields(new Field[]{new Field("suplierorder", (DataType)DataType.StringType)}, new Object[]{"0"});
            srcData = srcData.groupBy(fields2).reduceGroup((GroupReduceFunction)new SupplierDataDetalMap(srcData.getRowMeta(), this.stdCostLevelRptParam));
        }
        if (!this.stdCostLevelRptParam.getShowWorkCenter().booleanValue()) {
            Set showKeyCols = this.ctx.getShowKeyCols();
            showKeyCols.remove("priceid");
            showKeyCols.remove("price");
            if (isSimulated && this.stdCostLevelRptParam.getShowSuppier().booleanValue()) {
                showKeyCols.add("suplierorder");
                showKeyCols.add("datadealtype");
            }
            String[] keyCols = showKeyCols.toArray(new String[showKeyCols.size()]);
            srcData = srcData.groupBy(keyCols).sum("baseqty").sum("qty").sum("stdprice").addFields(new Field[]{new Field("priceid", (DataType)DataType.LongType), new Field("price", (DataType)DataType.BigDecimalType)}, new Object[]{0L, BigDecimal.ZERO});
            srcData = srcData.map((MapFunction)new WorkCenterDataDealFunction());
        }
        DataSetX smallDataSetX = this.getSmallHandData(keycols, matKeyStrSet);
        if (isSimulated) {
            outDataSetX = srcData.filter("srctype='D'");
            srcList = Arrays.asList(srcData.getRowMeta().getFieldNames());
            outList = Arrays.asList("srctype", "costtype", "material", "materialnum", "materialname", "modelnum", "keycol", "auxpty", "configuredcode", "tracknumber", "projectnumber", "lot");
            fields = outList.stream().filter(s -> srcList.contains(s)).collect(Collectors.toList());
            outSumDataSetX = isSimulated && this.stdCostLevelRptParam.getShowSuppier() != false ? outDataSetX.filter("datadealtype != 1").groupBy(fields.toArray(new String[0])).sum("stdprice") : outDataSetX.groupBy(fields.toArray(new String[0])).sum("stdprice");
            smallDataSetX = DatSetXUtils.unionIfRowDiff((DataSetX)smallDataSetX, (DataSetX)outSumDataSetX);
            DataSetX srcDataMax = smallDataSetX.groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate");
            smallDataSetX = smallDataSetX.join(srcDataMax).on("material", "material").on("keycol", "keycol").select(smallDataSetX.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).filter("calcdate=maxcalcdate");
        } else {
            outDataSetX = srcData.filter("srctype='F'");
            srcList = Arrays.asList(srcData.getRowMeta().getFieldNames());
            outList = Arrays.asList("srctype", "costtype", "material", "materialnum", "materialname", "modelnum", "keycol", "auxpty", "configuredcode", "tracknumber", "projectnumber", "lot");
            fields = outList.stream().filter(s -> srcList.contains(s)).collect(Collectors.toList());
            outSumDataSetX = outDataSetX.groupBy(fields.toArray(new String[0])).sum("stdprice");
            smallDataSetX = DatSetXUtils.unionIfRowDiff((DataSetX)smallDataSetX, (DataSetX)outSumDataSetX);
        }
        smallDataSetX = smallDataSetX.addFields(new Field[]{new Field("orderby", (DataType)DataType.StringType), new Field("currency", (DataType)DataType.LongType), new Field("mylinetype", (DataType)DataType.StringType), new Field("level", (DataType)DataType.IntegerType)}, new Object[]{"0", 0L, ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"DiyTotalRow_0", (String)"macc-cad-report", (Object[])new Object[0]), 0});
        smallDataSetX = smallDataSetX.groupBy(new String[]{"material", "keycol", "auxpty", "bom", "processroute"}).reduceGroup((GroupReduceFunction)new SmallDiyTotalFunction(this.stdCostLevelRptParam, true, matKeyStrSet));
        if (this.stdCostLevelRptParam.getShowsum().booleanValue()) {
            srcData = DatSetXUtils.addIfRowDiff((DataSetX)srcData, (DataSetX)smallDataSetX);
        } else {
            OrmInput materialgroup;
            Long materialGrpStd = this.stdCostLevelRptParam.getMaterialGrpStd() == null ? 0L : this.stdCostLevelRptParam.getMaterialGrpStd().getLong("id");
            ArrayList mulMaterialGroupIds = new ArrayList(10);
            DynamicObjectCollection mulMaterialGroups = this.stdCostLevelRptParam.getMulMaterialGroups();
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulMaterialGroups)) {
                mulMaterialGroups.forEach(materialGroup -> mulMaterialGroupIds.add(materialGroup.getDynamicObject("fbasedataid").getLong("id")));
            }
            QFilter filter = new QFilter("standard", "=", (Object)materialGrpStd);
            filter.and(new QFilter("material", "in", groupMatId));
            if (!CadEmptyUtils.isEmpty(mulMaterialGroupIds)) {
                materialgroup = QueryServiceHelper.query((String)"bd_materialgroup", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", mulMaterialGroupIds)});
                filter.and(MaterialGroupHelper.getGroupFilter((DynamicObjectCollection)materialgroup, (boolean)true, (String)"group.longnumber"));
            }
            materialgroup = new OrmInput(HandleRow.class.getName(), "bd_materialgroupdetail", "group,group.number as materialgroupnumber,group.name as groupname,material,material.number as materialnumber,material.materialtype as materialtype", filter.toArray());
            DataSetX materialGroupDataSetX = this.ctx.getCurrentJob().fromInput((Input)materialgroup);
            List<String> leftSelectFileList = this.getLeftSelectFileName(srcData.getRowMeta().getFieldNames(), this.rightFileNames);
            DataSetX matSrcData = srcData.filter("submaterial!=0 or level!=1");
            DataSetX firstResourceSrcData = srcData.filter("submaterial=0 and level=1");
            matSrcData = matSrcData.leftJoin(materialGroupDataSetX).on("levelmat", "material").select(leftSelectFileList.toArray(new String[0]), this.rightFileNames);
            firstResourceSrcData = firstResourceSrcData.filter("level=1").leftJoin(materialGroupDataSetX).on("material", "material").select(leftSelectFileList.toArray(new String[0]), this.rightFileNames);
            srcData = matSrcData.union(firstResourceSrcData);
            srcData = srcData.groupBy(new String[]{"material", "keycol", "auxpty"}).reduceGroup((GroupReduceFunction)new CalCostLevelGroupFunction(srcData.getRowMeta(), this.stdCostLevelRptParam));
            Set<Long> mulSubMaterialIds = this.stdCostLevelRptParam.getMulSubMaterialIds();
            if (!CadEmptyUtils.isEmpty(mulSubMaterialIds)) {
                keyBuilder = new StringBuilder("submaterial in (");
                for (Long mulSubMaterialId : mulSubMaterialIds) {
                    keyBuilder.append(mulSubMaterialId).append(",");
                }
                keyBuilder.setLength(keyBuilder.length() - 1);
                keyBuilder.append(")");
                DataSetX firstLevel = srcData.filter("level=1").filter(keyBuilder.toString());
                srcData = srcData.filter("level != 1");
                srcData = srcData.union(firstLevel);
            }
            if (Long.compare(materialGrpStd, 730148448254487552L) != 0 || !CadEmptyUtils.isEmpty(mulMaterialGroupIds)) {
                srcData = srcData.filter("group !=0 and group is not null");
            }
            if (this.stdCostLevelRptParam.getShowgroup().booleanValue()) {
                Set groupKeys = this.ctx.getShowKeyCols();
                groupKeys.removeAll(this.groupHideProps);
                srcData = srcData.groupBy(groupKeys.toArray(new String[groupKeys.size()])).sum("stdprice");
            }
            srcData = DatSetXUtils.unionIfRowDiff((DataSetX)srcData, (DataSetX)smallDataSetX);
        }
        srcData = srcData.orderBy(new String[]{"materialnum", "material", "keycol", "auxpty", "orderby"});
        return srcData;
    }

    private DataSetX getSupplierDataSetX(Set<Long> priceids) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("id", "in", priceids));
        filters.add(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getCostTypeId()));
        String queryOutFileds = "id,outsupentry.supplier supplier,outsupentry.supplier.name suppliername,outsupentry.quotaratio quotaratio,outsupentry.unitprice unitprice";
        DataSet supplierDataSet = QueryServiceHelper.queryDataSet((String)"getSupplierDataSetX#1", (String)"cad_outsourceprice", (String)queryOutFileds, (QFilter[])filters.toArray(new QFilter[0]), null);
        String queryFileds = "id,pursupentry.supplier supplier,pursupentry.supplier.name suppliername,pursupentry.quotaratio quotaratio,pursupentry.unitprice unitprice";
        DataSet supplierBaseDataSet = QueryServiceHelper.queryDataSet((String)"getSupplierDataSetX#2", (String)"cad_purprices", (String)queryFileds, (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet dataSet = DataSetUtils.union((DataSet)supplierDataSet, (DataSet)supplierBaseDataSet).distinct().filter("supplier>0");
        if (this.stdCostLevelRptParam.getShowProcessInfo().booleanValue()) {
            String queryOutResFileds = "id,ressupentry.supplier supplier,ressupentry.supplier.name suppliername,ressupentry.quotaratio quotaratio,ressupentry.unitprice unitprice";
            DataSet supplierOutResDataSet = QueryServiceHelper.queryDataSet((String)"getSupplierDataSetX#3", (String)"cad_resourceout", (String)queryOutResFileds, (QFilter[])filters.toArray(new QFilter[0]), null);
            dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)supplierOutResDataSet).distinct().filter("supplier>0");
        }
        DataSetX supplierDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(dataSet));
        return supplierDataSetX;
    }

    private DataSetX getSmallHandData(Set<String> keycols, HashSet<String> matKeyStrSet) {
        DataSetX otherTrackDataSetX;
        DataSet otherTrackDataSet;
        String queryFileds;
        ArrayList<QFilter> filters;
        String queryType = this.stdCostLevelRptParam.getQueryType();
        String effectFileName = ",calcdate";
        QFilter costTypeQf = new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getCostTypeId());
        if (!CostTypePtyEnum.SIMULATED.getValue().equals(queryType)) {
            this.entityName = "cad_calceffectiveresult";
            effectFileName = ",effectdate,expdate";
            if (queryType != null) {
                if ("period".equals(queryType)) {
                    costTypeQf.and(new QFilter("effectdate", "<=", (Object)this.stdCostLevelRptParam.getQueryPeriodendDate()));
                    costTypeQf.and(new QFilter("expdate", ">=", (Object)this.stdCostLevelRptParam.getQueryPeriodBeginDate()));
                } else {
                    Date queryDate = this.stdCostLevelRptParam.getQueryDate();
                    if (queryDate != null) {
                        costTypeQf.and(new QFilter("effectdate", "<=", (Object)queryDate));
                        costTypeQf.and(new QFilter("expdate", ">", (Object)queryDate));
                    }
                }
            }
        }
        QFilter matQf = new QFilter("keycol", "in", keycols);
        QFilter ismaindataQf = new QFilter("ismaindata", "=", (Object)1);
        QFilter datatypeQf = new QFilter("entryentity.datatype", "=", (Object)"1");
        OrmInput smallData = new OrmInput(DiyTotalRow.class.getName(), this.entityName, "costtype,material,material.number as materialnum,material.name as materialname,material.modelnum as modelnum,keycol,auxproperty as auxpty,bom,processroute,entryentity.qty as qty,entryentity.price as price,entryentity.stdprice as stdprice,configuredcode,tracknumber,project projectnumber,lot,entryentity.subkeycol as subkeycol" + effectFileName, new QFilter[]{costTypeQf, matQf, ismaindataQf, datatypeQf});
        DataSetX smallDataDataSetX = this.ctx.getCurrentJob().fromInput((Input)smallData);
        if (!CostTypePtyEnum.SIMULATED.getValue().equals(queryType)) {
            smallDataDataSetX = smallDataDataSetX.groupBy(this.groupFields).reduceGroup((GroupReduceFunction)new CalCostLevelMaxEffectdateFunction(smallDataDataSetX.getRowMeta(), this.stdCostLevelRptParam, matKeyStrSet));
        }
        if (!CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getTrackIds())) {
            filters = new ArrayList<QFilter>(10);
            filters.add(new QFilter("id", "in", this.stdCostLevelRptParam.getTrackIds()));
            filters.add(new QFilter("origentryentity.origsubentryentity.origdatatype", "=", (Object)"1"));
            filters.add(new QFilter("origentryentity.origentrylevel", "=", (Object)0));
            queryFileds = "costtype,material,material.number as materialnum,material.name as materialname,material.modelnum as modelnum,keycol,auxproperty as auxpty,bomid bom,processrouteid processroute,origentryentity.origsubentryentity.origqty as qty,origentryentity.origsubentryentity.origprice as price,origentryentity.origsubentryentity.origstdprice as stdprice,configuredcode,tracknumber,project as projectnumber,lot,origentryentity.origsubentryentity.origsubkeycol as subkeycol" + effectFileName;
            otherTrackDataSet = QueryServiceHelper.queryDataSet((String)"getOtherTrackDataSetX", (String)"cad_trackstdcalcresult", (String)queryFileds, (QFilter[])filters.toArray(new QFilter[0]), null);
            otherTrackDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(otherTrackDataSet));
            smallDataDataSetX = DataSetXHelper.union((DataSetX)smallDataDataSetX, (DataSetX)otherTrackDataSetX);
        }
        smallDataDataSetX = smallDataDataSetX.addFields(new Field[]{new Field("srctype", (DataType)DataType.StringType)}, new Object[]{""});
        if (!CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getSrcTrackIds())) {
            filters = new ArrayList(10);
            filters.add(new QFilter("id", "in", this.stdCostLevelRptParam.getSrcTrackIds()));
            filters.add(new QFilter("origentryentity.origsubentryentity.origdatatype", "=", (Object)"1"));
            filters.add(new QFilter("origentryentity.origentrylevel", "=", (Object)0));
            queryFileds = "'S' as srctype,costtype,material,material.number as materialnum,material.name as materialname,material.modelnum as modelnum,keycol,auxproperty as auxpty,bomid bom,processrouteid processroute,origentryentity.origsubentryentity.origqty as qty,origentryentity.origsubentryentity.origprice as price,origentryentity.origsubentryentity.origstdprice as stdprice,configuredcode,tracknumber,project as projectnumber,lot,origentryentity.origsubentryentity.origsubkeycol as subkeycol" + effectFileName;
            otherTrackDataSet = QueryServiceHelper.queryDataSet((String)"getOtherTrackDataSetX", (String)"cad_trackstdcalcresult", (String)queryFileds, (QFilter[])filters.toArray(new QFilter[0]), null);
            otherTrackDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(otherTrackDataSet));
            smallDataDataSetX = DataSetXHelper.union((DataSetX)otherTrackDataSetX, (DataSetX)smallDataDataSetX);
        }
        return smallDataDataSetX;
    }

    private List<String> getLeftSelectFileName(String[] leftFieldNames, String[] rightFileNames) {
        Boolean containFlag = false;
        ArrayList<String> selectFileNameList = new ArrayList<String>();
        for (String leftFieldName : leftFieldNames) {
            containFlag = false;
            for (String rightFileName : rightFileNames) {
                if (!rightFileName.equals(leftFieldName)) continue;
                containFlag = true;
                break;
            }
            if (containFlag.booleanValue()) continue;
            selectFileNameList.add(leftFieldName);
        }
        return selectFileNameList;
    }
}

