/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.stdcostlevel.CalNextLevelGroupFunction;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;
import kd.macc.cad.report.queryplugin.stdcostlevel.TrackDataDealFunction;

public class HandleRow
implements IDataXTransform {
    private final Log logger = LogFactory.getLog(HandleRow.class);
    private ReportDataCtx ctx;
    private StdCostLevelRptParam stdCostLevelRptParam;

    public HandleRow(StdCostLevelRptParam stdCostLevelRptParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.stdCostLevelRptParam = stdCostLevelRptParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        Set<Long> srcTrackIds;
        String queryType = this.stdCostLevelRptParam.getQueryType();
        boolean isSimulated = CostTypePtyEnum.SIMULATED.getValue().equals(queryType);
        if (isSimulated) {
            DataSetX srcDataMax = srcData.groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate");
            srcData = srcData.join(srcDataMax).on("material", "material").on("keycol", "keycol").select(srcData.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).filter("calcdate=maxcalcdate");
        }
        DataSetX calDataSetX = srcData.filter("srctype in ('A','B')");
        DataSetX outDataSetX = srcData.filter("srctype in ('D','F')");
        calDataSetX = calDataSetX.addFields(new Field[]{new Field("analogmaterial", (DataType)DataType.LongType)}, new Object[]{1L});
        DataSetX filterOutDataSetX = outDataSetX.leftJoin(calDataSetX).on("material", "material").on("keycol", "keycol").select(outDataSetX.getRowMeta().getFieldNames(), new String[]{"analogmaterial"}).filter("analogmaterial is null or analogmaterial == 0");
        filterOutDataSetX = filterOutDataSetX.filter("analogmaterial is null or analogmaterial == 0");
        filterOutDataSetX = filterOutDataSetX.removeFields(new String[]{"analogmaterial"});
        DataSetX dataSetResult = calDataSetX = calDataSetX.removeFields(new String[]{"analogmaterial"});
        int level = 1;
        while (level < 15) {
            calDataSetX = this.getNextSubMatFee(calDataSetX, ++level);
            dataSetResult = DataSetXHelper.union((DataSetX)dataSetResult, (DataSetX)calDataSetX);
        }
        dataSetResult = DataSetXHelper.union((DataSetX)dataSetResult, (DataSetX)filterOutDataSetX);
        Set<Long> trackIds = this.stdCostLevelRptParam.getTrackIds();
        if (!CadEmptyUtils.isEmpty(trackIds)) {
            this.logger.info("HandleRow doTransform size:" + trackIds.size());
            DataSetX calTrackDataSetX = srcData.filter("srctype = 'C'");
            calTrackDataSetX = calTrackDataSetX.removeFields(new String[]{"bom", "level", "qtyprecision", "orderby", "processroute"});
            DataSetX otherTrackDataSetX = this.getOtherTrackDataSetX(isSimulated, false);
            calTrackDataSetX = calTrackDataSetX.leftJoin(otherTrackDataSetX).on("keycol", "keycol").on("path", "path").on("subkeycol", "subkeycol").on("element", "element").on("subelement", "subelement").on("datatype", "datatype").on("resource", "resid").select(calTrackDataSetX.getRowMeta().getFieldNames(), new String[]{"level", "bom", "qtyprecision", "orderby", "origentrystdqty", "processroute"}).filter("1=1");
            calTrackDataSetX = calTrackDataSetX.map((MapFunction)new TrackDataDealFunction());
            calTrackDataSetX = calTrackDataSetX.removeFields(new String[]{"origentrystdqty"});
            dataSetResult = DataSetXHelper.union((DataSetX)dataSetResult, (DataSetX)calTrackDataSetX);
        }
        if (!CadEmptyUtils.isEmpty(srcTrackIds = this.stdCostLevelRptParam.getSrcTrackIds())) {
            DataSetX calSrcTrackDataSetX = srcData.filter("srctype = 'S'");
            calSrcTrackDataSetX = calSrcTrackDataSetX.removeFields(new String[]{"bom", "level", "qtyprecision", "orderby", "processroute"});
            DataSetX otherTrackDataSetX = this.getOtherTrackDataSetX(isSimulated, true);
            calSrcTrackDataSetX = calSrcTrackDataSetX.leftJoin(otherTrackDataSetX).on("keycol", "keycol").on("path", "path").on("subkeycol", "subkeycol").on("element", "element").on("subelement", "subelement").on("datatype", "datatype").on("resource", "resid").select(calSrcTrackDataSetX.getRowMeta().getFieldNames(), new String[]{"level", "bom", "qtyprecision", "orderby", "origentrystdqty", "processroute"}).filter("1=1");
            calSrcTrackDataSetX = calSrcTrackDataSetX.map((MapFunction)new TrackDataDealFunction());
            calSrcTrackDataSetX = calSrcTrackDataSetX.removeFields(new String[]{"origentrystdqty"});
            dataSetResult = DataSetXHelper.union((DataSetX)dataSetResult, (DataSetX)calSrcTrackDataSetX);
        }
        if (!this.stdCostLevelRptParam.getShowWorkCenter().booleanValue()) {
            dataSetResult = dataSetResult.removeFields(new String[]{"workcenternum", "workcenter"});
            dataSetResult = dataSetResult.addFields(new Field[]{new Field("workcenternum", (DataType)DataType.StringType), new Field("workcenter", (DataType)DataType.LongType)}, new Object[]{"", 0L});
        }
        if (!this.stdCostLevelRptParam.getShowProcessInfo().booleanValue()) {
            dataSetResult = dataSetResult.removeFields(new String[]{"processroutenum", "processroutename", "processseq", "operationno", "operationnum", "operationdesc", "operation"});
            dataSetResult = dataSetResult.addFields(new Field[]{new Field("processroutenum", (DataType)DataType.StringType), new Field("processroutename", (DataType)DataType.StringType), new Field("processseq", (DataType)DataType.StringType), new Field("operationno", (DataType)DataType.StringType), new Field("operationnum", (DataType)DataType.StringType), new Field("operationdesc", (DataType)DataType.StringType), new Field("operation", (DataType)DataType.LongType)}, new Object[]{"", "", "", "", "", "", 0L});
        }
        return dataSetResult;
    }

    private DataSetX getOtherTrackDataSetX(boolean isSimulated, boolean isSrcKeyCol) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (isSrcKeyCol) {
            filters.add(new QFilter("id", "in", this.stdCostLevelRptParam.getSrcTrackIds()));
        } else {
            filters.add(new QFilter("id", "in", this.stdCostLevelRptParam.getTrackIds()));
        }
        if (isSimulated) {
            filters.add(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getCostTypeId()));
        } else {
            filters.add(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getSimCosttypeId()));
        }
        filters.add(new QFilter("origentryentity.origsubentryentity.origdatatype", "in", (Object)new String[]{"2", "4"}));
        String queryFileds = "id,material,keycol,origentryentity.origentrybomid bom,origentryentity.origentrylevel+1 entrylevel,origentryentity.origentrykeycol entrykeycol,origentryentity.origentrytreepath path,origentryentity.origentrystdqty origentrystdqty,origentryentity.origsubentryentity.origsubkeycol subkeycol,origentryentity.origsubentryentity.origelement element,origentryentity.origsubentryentity.origsubelement subelement,origentryentity.origsubentryentity.origdatatype datatype,origentryentity.origentryprocessrouteid processroute,origentryentity.origsubentryentity.origresource resid,origentryentity.origsubentryentity.origsubmaterial subid,'' orderby";
        DataSet otherTrackDataSet = QueryServiceHelper.queryDataSet((String)"getOtherTrackDataSetX", (String)"cad_trackstdcalcresult", (String)queryFileds, (QFilter[])filters.toArray(new QFilter[0]), null).select(new String[]{"id", "material", "keycol", "bom", "cast(entrylevel as Integer) level", "path", "origentrystdqty", "entrykeycol", "subkeycol", "element", "subelement", "datatype", "resid", "subid", "orderby", "processroute"}).distinct();
        DataSet matDataSet = this.getMatDataSet(otherTrackDataSet.filter("datatype='4'"), otherTrackDataSet);
        DataSet unMatDataSet = otherTrackDataSet.filter("datatype='2'");
        DataSet dataSet = DataSetUtils.union((DataSet)matDataSet, (DataSet)unMatDataSet).select("id,material,keycol,bom,level,0 qtyprecision,path,subkeycol,element,subelement,datatype,resid,case when datatype= '2' then concat(concat(path,'@'),resid) else orderby end orderby,origentrystdqty,processroute");
        DataSetX otherTrackDataSetX = this.ctx.getCurrentJob().fromInput((Input)new DataSetInput(dataSet));
        return otherTrackDataSetX;
    }

    private DataSet getMatDataSet(DataSet matDataSet, DataSet otherTrackDataSet) {
        DataSet subData = otherTrackDataSet.select("id,level-1 entrylevel,entrykeycol,path orderby").distinct();
        DataSet matDataSetNext = matDataSet.select("id,material,keycol,bom,level,path,origentrystdqty,entrykeycol,subkeycol,element,subelement,datatype,resid,subid,processroute").distinct();
        matDataSetNext = matDataSetNext.join(subData).on("id", "id").on("subkeycol", "entrykeycol").on("level", "entrylevel").select(matDataSetNext.getRowMeta().getFieldNames(), new String[]{"orderby", "contains(orderby,path) as issame"}).finish().distinct();
        matDataSetNext = matDataSetNext.filter("issame = true");
        matDataSetNext = matDataSetNext.removeFields(new String[]{"issame"});
        return matDataSetNext;
    }

    private DataSetX getNextSubMatFee(DataSetX srcData, int level) {
        DataSetX costTypeAllMatDataSetX = srcData.reduceGroup((GroupReduceFunction)new CalNextLevelGroupFunction(srcData.getRowMeta(), this.stdCostLevelRptParam, level));
        return costTypeAllMatDataSetX;
    }
}

