/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.resource.ResManager;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;

public class SmallDiyTotalFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = -520289732544126957L;
    private StdCostLevelRptParam stdCostLevelRptParam;
    private Boolean isSmallFlag;
    private Set<String> matKeyStrSet;

    public SmallDiyTotalFunction(StdCostLevelRptParam stdCostLevelRptParam, boolean isSmallFlag, Set<String> matKeyStrSet) {
        this.stdCostLevelRptParam = stdCostLevelRptParam;
        this.isSmallFlag = isSmallFlag;
        this.matKeyStrSet = matKeyStrSet;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        int srcTypeIndex = this.getSourceRowMeta().getFieldIndex("srctype");
        int qtyindex = this.getSourceRowMeta().getFieldIndex("qty");
        int stdpriceindex = this.getSourceRowMeta().getFieldIndex("stdprice");
        int orderby = this.getSourceRowMeta().getFieldIndex("orderby");
        int currencyindex = this.getSourceRowMeta().getFieldIndex("currency");
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal sumStdPrice = BigDecimal.ZERO;
        int materialindex = this.getSourceRowMeta().getFieldIndex("material");
        int materialnumindex = this.getSourceRowMeta().getFieldIndex("materialnum");
        int materialname = this.getSourceRowMeta().getFieldIndex("materialname");
        int modelnum = this.getSourceRowMeta().getFieldIndex("modelnum");
        int keycolindex = this.getSourceRowMeta().getFieldIndex("keycol");
        int auxptyindex = this.getSourceRowMeta().getFieldIndex("auxpty");
        int configuredcodeindex = this.getSourceRowMeta().getFieldIndex("configuredcode");
        int tracknumberindex = this.getSourceRowMeta().getFieldIndex("tracknumber");
        int bomindex = this.getSourceRowMeta().getFieldIndex("bom");
        int processrouteindex = this.getSourceRowMeta().getFieldIndex("processroute");
        RowX smallDiyTotalRow = null;
        for (RowX rowX : iterable) {
            Long material = rowX.getLong(materialindex);
            String keycol = rowX.getString(keycolindex);
            Long auxpty = rowX.getLong(auxptyindex);
            String key = material + "@" + keycol + "@" + auxpty;
            if (!this.matKeyStrSet.contains(key)) continue;
            BigDecimal qty = rowX.getBigDecimal(qtyindex);
            BigDecimal stdprice = rowX.getBigDecimal(stdpriceindex);
            sumQty = sumQty.add(qty);
            sumStdPrice = sumStdPrice.add(stdprice);
            if (smallDiyTotalRow != null) continue;
            smallDiyTotalRow = new RowX(new Object[this.getResultRowMeta().getFieldCount()]);
            int linetypeindex = this.getSourceRowMeta().getFieldIndex("mylinetype");
            if (this.isSmallFlag.booleanValue()) {
                smallDiyTotalRow.set(srcTypeIndex, (Object)rowX.getString(srcTypeIndex));
                smallDiyTotalRow.set(configuredcodeindex, (Object)rowX.getLong(configuredcodeindex));
                smallDiyTotalRow.set(tracknumberindex, (Object)rowX.getLong(tracknumberindex));
                smallDiyTotalRow.set(materialindex, (Object)material);
                smallDiyTotalRow.set(keycolindex, (Object)keycol);
                smallDiyTotalRow.set(auxptyindex, (Object)auxpty);
                smallDiyTotalRow.set(materialname, rowX.get(materialname));
                smallDiyTotalRow.set(modelnum, rowX.get(modelnum));
                smallDiyTotalRow.set(bomindex, rowX.get(bomindex));
                smallDiyTotalRow.set(processrouteindex, rowX.get(processrouteindex));
                smallDiyTotalRow.set(materialnumindex, rowX.get(materialnumindex));
                smallDiyTotalRow.set(orderby, (Object)"0");
                smallDiyTotalRow.set(linetypeindex, (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"SmallDiyTotalFunction_0", (String)"macc-cad-report", (Object[])new Object[0]));
                continue;
            }
            smallDiyTotalRow.set(orderby, (Object)"99999");
            smallDiyTotalRow.set(linetypeindex, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SmallDiyTotalFunction_1", (String)"macc-cad-report", (Object[])new Object[0]));
        }
        if (smallDiyTotalRow != null) {
            smallDiyTotalRow.set(stdpriceindex, (Object)sumStdPrice);
            smallDiyTotalRow.set(currencyindex, (Object)this.stdCostLevelRptParam.getCurrencyId());
            collector.collect(smallDiyTotalRow);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }
}

