/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;

public class StdCostLevelRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log logger = LogFactory.getLog(StdCostLevelRptPlugin.class);
    private static final Integer SINGLE_MAX_FILTER_STR = 2000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mullot", "qcalcrecord"});
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter filter = CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView());
            filter.and("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
            }
            filterParameter.getQFilters().add(filter);
        });
        BasedataEdit mat = (BasedataEdit)this.getControl("mulmaterial");
        mat.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            DynamicObject ct = this.getModel().getDataEntity().getDynamicObject("costtype");
            List filters = ElementRelationHelper.getMatFiltersBy((DynamicObject)ct, null);
            filterParameter.getQFilters().addAll(filters);
        });
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            DynamicObject dyCostType = (DynamicObject)this.getModel().getValue("costtype");
            if (dyCostType == null) {
                evt.setCancel(true);
                return;
            }
            filterParameter.getQFilters().clear();
            filterParameter.getQFilters().add(new QFilter("isadjustperiod", "=", (Object)false));
            filterParameter.getQFilters().add(CostUpdateHelper.getRptPeriodQFilter((Long)dyCostType.getLong("id")));
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u7c7b\u578b\u3002", (String)"StdCostLevelRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"StdCostLevelRptPlugin_1", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u7c7b\u578b\u3002", (String)"StdCostLevelRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit products = (BasedataEdit)this.getControl("mulgroupmaterial");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u7c7b\u578b\u3002", (String)"StdCostLevelRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(costtype.getLong("createorg.id"));
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (!CollectionUtils.isEmpty((Collection)mulmaterialGroup) || materialgrpstd != null && materialGroupStandard.getLong("id") != 730148448254487552L) {
                QFilter classifiedMaterialIdFilter = new QFilter("id", "in", (Object)InFilterHelper.getQFilterByBachSize((String)"id", new ArrayList(MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulmaterialGroup, (boolean)false, (DynamicObject)materialGroupStandard)), (String)"in", (int)20000));
                qFilters.add(classifiedMaterialIdFilter);
            }
        });
        BasedataEdit configuredCodeEdit = (BasedataEdit)this.getControl("mulconfiguredcode");
        configuredCodeEdit.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection materials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
            HashSet<Long> matIds = new HashSet<Long>(16);
            for (DynamicObject material : materials) {
                DynamicObject matObj = (DynamicObject)material.get("fbasedataid");
                matIds.add(matObj.getLong("masterid"));
            }
            if (!CadEmptyUtils.isEmpty(matIds)) {
                List configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(matIds);
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(new QFilter("id", "in", (Object)configCodeIds));
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String key = textEdit.getKey();
            if ("mullot".equalsIgnoreCase(key)) {
                this.showStoragebillnos(key);
            } else if ("qcalcrecord".equalsIgnoreCase(key)) {
                this.showSelectPage(key);
            }
        }
    }

    private void showSelectPage(String actionId) {
        List materialIds;
        DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
        if (costtype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6210\u672c\u7c7b\u578b\u3002", (String)"StdCostLevelRptPlugin_0", (String)"macc-cad-report", (Object[])new Object[0]));
            return;
        }
        ArrayList mulmaterial = Lists.newArrayList();
        DynamicObjectCollection mulMaterial = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
        if (mulMaterial != null && mulMaterial.size() > 0 && !CadEmptyUtils.isEmpty(materialIds = mulMaterial.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            mulmaterial.addAll(materialIds);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_stdcalcrecord_text");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costTypeId", costtype.get("id"));
        fsp.setCustomParam("materialIds", (Object)mulmaterial);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    private void showStoragebillnos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sca_billnos");
        parameter.setCaption(ResManager.loadKDString((String)"\u6279\u53f7", (String)"StdCostLevelRptPlugin_10", (String)"macc-cad-report", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        } else if (returnDataObj instanceof String) {
            String value = (String)returnDataObj;
            this.getModel().setValue(actionId, (Object)value);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("costtype");
        if (costType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"StdCostLevelRptPlugin_2", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection mulmaterial = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterial)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4ea7\u54c1\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StdCostLevelRptPlugin_3", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject materialgrpstd = this.getModel().getDataEntity().getDynamicObject("materialgrpstd");
        if (materialgrpstd == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"StdCostLevelRptPlugin_4", (String)"macc-cad-report", (Object[])new Object[0]));
            return false;
        }
        String queryType = CostTypePtyEnum.SIMULATED.getValue();
        if (CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type"))) {
            Long costTypeId = costType.getLong("id");
            Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)costTypeId);
            queryType = isUpdateByPeriod != false ? "period" : "date";
        }
        StdCostLevelRptParam StdCostLevelRptParam2 = this.buildStdCostLevelRptParam(this.getModel().getDataEntity(), queryType);
        this.getQueryParam().getCustomParam().put(StdCostLevelRptParam.class.getName(), StdCostLevelRptParam2);
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.updateCurrency();
        this.cleanQueryDate(queryParam);
    }

    private void cleanQueryDate(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject costType = filter.getDynamicObject("costtype");
        if (costType == null) {
            return;
        }
        boolean isAnalog = BomRouterHelper.isAnalogCostType((Long)Long.valueOf(costType.getString("id")));
        if (isAnalog) {
            this.getModel().setValue("querydate", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "costtype": {
                this.updateCurrency();
                this.getModel().setValue("qcalcrecord", null);
                this.dealQueryPeriod();
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
            case "showworkcenter": {
                if (Boolean.TRUE == newValue) {
                    this.getModel().setValue("showgroup", (Object)Boolean.FALSE);
                }
                if (Boolean.FALSE != newValue) break;
                this.getModel().setValue("showprocessinfo", (Object)Boolean.FALSE);
                break;
            }
            case "showprocessinfo": {
                if (Boolean.TRUE != newValue) break;
                this.getModel().setValue("showworkcenter", (Object)Boolean.TRUE);
                this.getModel().setValue("showgroup", (Object)Boolean.FALSE);
                break;
            }
            case "mulmaterial": {
                DynamicObjectCollection mulmaterials = this.getModel().getDataEntity().getDynamicObjectCollection("mulmaterial");
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterials)) break;
                this.getModel().setValue("mulconfiguredcode", null);
                this.getModel().setValue("multracknumber", null);
                break;
            }
            case "showgroup": {
                if (Boolean.TRUE != newValue) break;
                this.getModel().setValue("showsuppier", (Object)Boolean.FALSE);
                this.getModel().setValue("showworkcenter", (Object)Boolean.FALSE);
                this.getModel().setValue("showprocessinfo", (Object)Boolean.FALSE);
                break;
            }
            case "showsuppier": {
                if (Boolean.TRUE != newValue) break;
                this.getModel().setValue("showgroup", (Object)Boolean.FALSE);
                break;
            }
        }
    }

    private void updateCurrency() {
        DynamicObject costType = this.getModel().getDataEntity().getDynamicObject("costtype");
        DynamicObject currency = Optional.ofNullable(costType).map(s -> s.getDynamicObject("currency")).orElse(null);
        this.getModel().setValue("currency", (Object)currency);
    }

    private void dealQueryPeriod() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        boolean isSimulated = costType == null || CostTypePtyEnum.SIMULATED.getValue().equals(costType.getString("type"));
        this.getView().setVisible(Boolean.valueOf(isSimulated), new String[]{"qcalcrecord"});
        this.getView().setVisible(Boolean.valueOf(isSimulated), new String[]{"showsuppier", "showworkcenter", "showprocessinfo"});
        if (isSimulated) {
            this.setQueryVisible(Boolean.FALSE, Boolean.FALSE, null);
            return;
        }
        Long costTypeId = costType.getLong("id");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)costTypeId);
        this.setQueryVisible(isUpdateByPeriod == false, isUpdateByPeriod, costTypeId);
    }

    private void setQueryVisible(Boolean isDateShow, Boolean isPeriodShow, Long costTypeId) {
        this.getView().setVisible(isPeriodShow, new String[]{"queryperiod"});
        if (Boolean.TRUE.equals(isPeriodShow)) {
            this.getModel().setValue("queryperiod", (Object)CostUpdateHelper.getCurPeriodId((Long)costTypeId));
        } else {
            this.getModel().setValue("queryperiod", null);
        }
        this.getView().setVisible(isDateShow, new String[]{"querydate"});
        this.getModel().setValue("querydate", (Object)(Boolean.TRUE.equals(isDateShow) ? TimeServiceHelper.now() : null));
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        HashSet<String> hideDateFieldSet = new HashSet<String>(Arrays.asList("effectdate", "expdate"));
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        Boolean isShowDate = CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type")) && this.getModel().getValue("queryperiod") == null && this.getModel().getValue("querydate") == null;
        boolean isAca = "aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()));
        HashSet<String> hideFieldSetInAca = new HashSet<String>(Arrays.asList("configuredcode", "tracknumber"));
        while (it.hasNext()) {
            ReportColumn reportColumn = (ReportColumn)it.next();
            String key = reportColumn.getFieldKey();
            boolean isRemove = false;
            if (!isShowDate.booleanValue() && hideDateFieldSet.contains(key)) {
                isRemove = true;
            } else if (isAca && hideFieldSetInAca.contains(key)) {
                isRemove = true;
            }
            if (!isRemove) continue;
            it.remove();
        }
        super.afterCreateColumn(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.fillHyperLinkData().booleanValue()) {
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.search();
        } else {
            this.updateCurrency();
            this.dealQueryPeriod();
        }
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulconfiguredcode", "multracknumber"});
            this.getModel().setValue("mulconfiguredcode", null);
            this.getModel().setValue("multracknumber", null);
        }
    }

    private Boolean fillHyperLinkData() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String paramStr = (String)fsp.getCustomParam("param");
        if (CadEmptyUtils.isEmpty((String)paramStr)) {
            return false;
        }
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
        this.getModel().setValue("costtype", paramMap.get("costtype"));
        this.getModel().setValue("querydate", paramMap.get("querydate"));
        this.getModel().setValue("materialgrpstd", paramMap.get("materialgrpstd"));
        List mulMaterials = new ArrayList(10);
        List mulConfiguredcodes = new ArrayList(10);
        List mulTracknumbers = new ArrayList(10);
        if (paramMap.get("mulmaterial") != null) {
            mulMaterials = (List)paramMap.get("mulmaterial");
        }
        if (paramMap.get("mulconfiguredcode") != null) {
            mulConfiguredcodes = (List)paramMap.get("mulconfiguredcode");
        }
        if (paramMap.get("multracknumber") != null) {
            mulTracknumbers = (List)paramMap.get("multracknumber");
        }
        logger.info("\u4ea7\u54c1\u6807\u51c6\u6210\u672c\u5206\u7ea7\u8868\u67e5\u8be2\u3002mulmaterial size:{},mulconfiguredcode size:{},multracknumber size:{}", new Object[]{mulMaterials.size(), mulConfiguredcodes.size(), mulTracknumbers.size()});
        this.getModel().setValue("mulmaterial", (Object)mulMaterials.toArray(new Object[0]));
        this.getModel().setValue("mulconfiguredcode", (Object)mulConfiguredcodes.toArray(new Object[0]));
        this.getModel().setValue("multracknumber", (Object)mulTracknumbers.toArray(new Object[0]));
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getModel().setValue("mulconfiguredcode", null);
            this.getModel().setValue("multracknumber", null);
        }
        this.getView().updateView("costtype");
        this.getView().updateView("querydate");
        this.getView().updateView("materialgrpstd");
        this.getView().updateView("mulmaterial");
        this.getView().updateView("mulconfiguredcode");
        this.getView().updateView("multracknumber");
        if (fsp.getCustomParam("calcrecord") != null) {
            String calcRecord = (String)fsp.getCustomParam("calcrecord");
            this.getModel().setValue("qcalcrecord", (Object)calcRecord);
        }
        this.getView().updateView("qcalcrecord");
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"StdCostLevelRptPlugin_7", (String)"macc-cad-report", (Object[])new Object[0]);
        String caption = this.getView().getFormShowParameter().getCaption();
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"StdCostLevelRptPlugin_11", (String)"macc-cad-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private StdCostLevelRptParam buildStdCostLevelRptParam(DynamicObject dataEntity, String queryType) {
        String lots;
        DynamicObjectCollection mulConfiguredCode;
        StdCostLevelRptParam stdCostLevelRptParam = new StdCostLevelRptParam();
        DynamicObject costType = dataEntity.getDynamicObject("costtype");
        if (!CadEmptyUtils.isEmpty((DynamicObject)costType)) {
            stdCostLevelRptParam.setCostTypeId(costType.getLong("id"));
            stdCostLevelRptParam.setCurrencyId(costType.getLong("currency.id"));
            stdCostLevelRptParam.setCurrencyAmtPrecision(costType.getInt("currency.amtprecision"));
            stdCostLevelRptParam.setCurrencyPricePrecision(costType.getInt("currency.priceprecision"));
        }
        boolean isSimulated = costType == null || CostTypePtyEnum.SIMULATED.getValue().equals(costType.getString("type"));
        stdCostLevelRptParam.setIsSimulated(isSimulated);
        DynamicObjectCollection mulmaterial = dataEntity.getDynamicObjectCollection("mulmaterial");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterial)) {
            Set<Long> collect = mulmaterial.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            stdCostLevelRptParam.setMulMaterialIds(collect);
        }
        DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
        stdCostLevelRptParam.setMaterialGrpStd(materialgrpstd);
        DynamicObjectCollection mulmaterialgroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterialgroup)) {
            stdCostLevelRptParam.setMulMaterialGroups(mulmaterialgroup);
        }
        DynamicObjectCollection mulSubMaterial = (DynamicObjectCollection)this.getModel().getValue("mulgroupmaterial");
        Set mulmaterialIdList = null;
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulSubMaterial)) {
            mulmaterialIdList = mulSubMaterial.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        }
        stdCostLevelRptParam.setMulSubMaterialIds(mulmaterialIdList);
        if (!CostTypePtyEnum.SIMULATED.getValue().equals(queryType)) {
            DynamicObject queryperiod = dataEntity.getDynamicObject("queryperiod");
            if (queryperiod != null) {
                long perodId = queryperiod.getLong("id");
                stdCostLevelRptParam.setQueryPeriodId(perodId);
                Date[] periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)perodId);
                if (periodtime != null && periodtime.length == 2) {
                    stdCostLevelRptParam.setQueryPeriodBeginDate(periodtime[0]);
                    stdCostLevelRptParam.setQueryPeriodendDate(periodtime[1]);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u672a\u7ef4\u62a4\u76f8\u5e94\u7684\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"StdCostLevelRptPlugin_9", (String)"macc-cad-report", (Object[])new Object[0]));
                }
            }
            Date querydate = dataEntity.getDate("querydate");
            stdCostLevelRptParam.setQueryDate(querydate);
            List mnCostType = CostTypeHelper.getMnCostByHs((Long)costType.getLong("id"));
            if (!CadEmptyUtils.isEmpty((List)mnCostType)) {
                stdCostLevelRptParam.setSimCosttypeId((Long)mnCostType.get(0));
            }
        }
        stdCostLevelRptParam.setQueryType(queryType);
        boolean showsum = dataEntity.getBoolean("showsum");
        stdCostLevelRptParam.setShowsum(showsum);
        boolean showgroup = dataEntity.getBoolean("showgroup");
        stdCostLevelRptParam.setShowgroup(showgroup);
        String calcRecord = (String)this.getModel().getValue("qcalcrecord");
        if (!CadEmptyUtils.isEmpty((String)calcRecord)) {
            stdCostLevelRptParam.setCalcRecordName(calcRecord);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(mulConfiguredCode = (DynamicObjectCollection)this.getModel().getValue("mulconfiguredcode")))) {
            List<Long> configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            stdCostLevelRptParam.setConfiguredCodeIds(configuredCodeIds);
        } else if (!CadEmptyUtils.isEmpty(stdCostLevelRptParam.getMulMaterialIds())) {
            stdCostLevelRptParam.setConfiguredCodeIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulTracknumber = (DynamicObjectCollection)this.getModel().getValue("multracknumber");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulTracknumber)) {
            List<Long> trackNumberIds = mulTracknumber.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            stdCostLevelRptParam.setTrackNumberIds(trackNumberIds);
        } else if (!CadEmptyUtils.isEmpty(stdCostLevelRptParam.getMulMaterialIds())) {
            stdCostLevelRptParam.setTrackNumberIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulProjectNumber = (DynamicObjectCollection)this.getModel().getValue("mulprojectnumber");
        if (mulProjectNumber != null) {
            List<Long> projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            stdCostLevelRptParam.setProjectNumberIds(projectNumberIds);
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = (String)this.getModel().getValue("mullot")))) {
            stdCostLevelRptParam.setLots(lots);
        }
        stdCostLevelRptParam.setAppNum(this.getView().getFormShowParameter().getAppId());
        boolean showSuppier = dataEntity.getBoolean("showsuppier");
        stdCostLevelRptParam.setShowSuppier(showSuppier);
        boolean showWorkCenter = dataEntity.getBoolean("showworkcenter");
        stdCostLevelRptParam.setShowWorkCenter(showWorkCenter);
        boolean showProcessInfo = dataEntity.getBoolean("showprocessinfo");
        stdCostLevelRptParam.setShowProcessInfo(showProcessInfo);
        return stdCostLevelRptParam;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        String formatedFilterString = evt.getFormatedFilterString();
        int costObjIndex = formatedFilterString.indexOf(ResManager.loadKDString((String)"\u4ea7\u54c1\uff1a", (String)"StdCostLevelRptPlugin_12", (String)"macc-cad-report", (Object[])new Object[0]));
        if (costObjIndex != -1 && formatedFilterString.length() > SINGLE_MAX_FILTER_STR) {
            formatedFilterString = formatedFilterString.substring(0, SINGLE_MAX_FILTER_STR - 6);
            formatedFilterString = formatedFilterString + "\u2026\u2026";
            evt.setFormatedFilterString(formatedFilterString);
        }
    }
}

